package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.landedestate.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发票操作履历表Request
 */
@ApiModel(description = "发票操作履历表Request")

@JsonInclude(NON_NULL)
public class GetLogInvoiceListRequest extends PageRequest {
  @JsonProperty("invoiceId")
  private Long invoiceId = null;

  @JsonIgnore
  public GetLogInvoiceListRequest invoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
    return this;
  }

   /**
   * 发票id
   * @return invoiceId
  **/
  @ApiModelProperty(value = "发票id")
  public Long getInvoiceId() {
    return invoiceId;
  }

  public void setInvoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetLogInvoiceListRequest getLogInvoiceListRequest = (GetLogInvoiceListRequest) o;
    return Objects.equals(this.invoiceId, getLogInvoiceListRequest.invoiceId) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceId, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetLogInvoiceListRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    invoiceId: ").append(toIndentedString(invoiceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
