package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.landedestate.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取业务单状态生命周期Request
 */
@ApiModel(description = "获取业务单状态生命周期Request")

@JsonInclude(NON_NULL)
public class GetOrderStatusLifeCycleRequest extends PageRequest {
  @JsonProperty("systemOrig")
  private List<String> systemOrig = new ArrayList<String>();

  @JsonProperty("isCooperate")
  private List<Integer> isCooperate = new ArrayList<Integer>();

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("salesbillNo")
  private String salesbillNo = null;

  @JsonProperty("ifAuthFlag")
  private List<Integer> ifAuthFlag = new ArrayList<Integer>();

  @JsonProperty("signTime")
  private List<Long> signTime = new ArrayList<Long>();

  @JsonProperty("smSyncTime")
  private List<Long> smSyncTime = new ArrayList<Long>();

  @JsonProperty("auditUpdateTime")
  private List<Long> auditUpdateTime = new ArrayList<Long>();

  @JsonProperty("authUpdateTime")
  private List<Long> authUpdateTime = new ArrayList<Long>();

  @JsonProperty("createTime")
  private List<Long> createTime = new ArrayList<Long>();

  @JsonIgnore
  public GetOrderStatusLifeCycleRequest systemOrig(List<String> systemOrig) {
    this.systemOrig = systemOrig;
    return this;
  }

  public GetOrderStatusLifeCycleRequest addSystemOrigItem(String systemOrigItem) {
    this.systemOrig.add(systemOrigItem);
    return this;
  }

   /**
   * 系统来源
   * @return systemOrig
  **/
  @ApiModelProperty(value = "系统来源")
  public List<String> getSystemOrig() {
    return systemOrig;
  }

  public void setSystemOrig(List<String> systemOrig) {
    this.systemOrig = systemOrig;
  }

  @JsonIgnore
  public GetOrderStatusLifeCycleRequest isCooperate(List<Integer> isCooperate) {
    this.isCooperate = isCooperate;
    return this;
  }

  public GetOrderStatusLifeCycleRequest addIsCooperateItem(Integer isCooperateItem) {
    this.isCooperate.add(isCooperateItem);
    return this;
  }

   /**
   * 是否协同
   * @return isCooperate
  **/
  @ApiModelProperty(value = "是否协同")
  public List<Integer> getIsCooperate() {
    return isCooperate;
  }

  public void setIsCooperate(List<Integer> isCooperate) {
    this.isCooperate = isCooperate;
  }

  @JsonIgnore
  public GetOrderStatusLifeCycleRequest purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方公司
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方公司")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public GetOrderStatusLifeCycleRequest salesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
    return this;
  }

   /**
   * 业务单号
   * @return salesbillNo
  **/
  @ApiModelProperty(value = "业务单号")
  public String getSalesbillNo() {
    return salesbillNo;
  }

  public void setSalesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
  }

  @JsonIgnore
  public GetOrderStatusLifeCycleRequest ifAuthFlag(List<Integer> ifAuthFlag) {
    this.ifAuthFlag = ifAuthFlag;
    return this;
  }

  public GetOrderStatusLifeCycleRequest addIfAuthFlagItem(Integer ifAuthFlagItem) {
    this.ifAuthFlag.add(ifAuthFlagItem);
    return this;
  }

   /**
   * 是否需要认证
   * @return ifAuthFlag
  **/
  @ApiModelProperty(value = "是否需要认证")
  public List<Integer> getIfAuthFlag() {
    return ifAuthFlag;
  }

  public void setIfAuthFlag(List<Integer> ifAuthFlag) {
    this.ifAuthFlag = ifAuthFlag;
  }

  @JsonIgnore
  public GetOrderStatusLifeCycleRequest signTime(List<Long> signTime) {
    this.signTime = signTime;
    return this;
  }

  public GetOrderStatusLifeCycleRequest addSignTimeItem(Long signTimeItem) {
    this.signTime.add(signTimeItem);
    return this;
  }

   /**
   * 签收时间
   * @return signTime
  **/
  @ApiModelProperty(value = "签收时间")
  public List<Long> getSignTime() {
    return signTime;
  }

  public void setSignTime(List<Long> signTime) {
    this.signTime = signTime;
  }

  @JsonIgnore
  public GetOrderStatusLifeCycleRequest smSyncTime(List<Long> smSyncTime) {
    this.smSyncTime = smSyncTime;
    return this;
  }

  public GetOrderStatusLifeCycleRequest addSmSyncTimeItem(Long smSyncTimeItem) {
    this.smSyncTime.add(smSyncTimeItem);
    return this;
  }

   /**
   * 影像上传时间
   * @return smSyncTime
  **/
  @ApiModelProperty(value = "影像上传时间")
  public List<Long> getSmSyncTime() {
    return smSyncTime;
  }

  public void setSmSyncTime(List<Long> smSyncTime) {
    this.smSyncTime = smSyncTime;
  }

  @JsonIgnore
  public GetOrderStatusLifeCycleRequest auditUpdateTime(List<Long> auditUpdateTime) {
    this.auditUpdateTime = auditUpdateTime;
    return this;
  }

  public GetOrderStatusLifeCycleRequest addAuditUpdateTimeItem(Long auditUpdateTimeItem) {
    this.auditUpdateTime.add(auditUpdateTimeItem);
    return this;
  }

   /**
   * 审核时间
   * @return auditUpdateTime
  **/
  @ApiModelProperty(value = "审核时间")
  public List<Long> getAuditUpdateTime() {
    return auditUpdateTime;
  }

  public void setAuditUpdateTime(List<Long> auditUpdateTime) {
    this.auditUpdateTime = auditUpdateTime;
  }

  @JsonIgnore
  public GetOrderStatusLifeCycleRequest authUpdateTime(List<Long> authUpdateTime) {
    this.authUpdateTime = authUpdateTime;
    return this;
  }

  public GetOrderStatusLifeCycleRequest addAuthUpdateTimeItem(Long authUpdateTimeItem) {
    this.authUpdateTime.add(authUpdateTimeItem);
    return this;
  }

   /**
   * 认证时间
   * @return authUpdateTime
  **/
  @ApiModelProperty(value = "认证时间")
  public List<Long> getAuthUpdateTime() {
    return authUpdateTime;
  }

  public void setAuthUpdateTime(List<Long> authUpdateTime) {
    this.authUpdateTime = authUpdateTime;
  }

  @JsonIgnore
  public GetOrderStatusLifeCycleRequest createTime(List<Long> createTime) {
    this.createTime = createTime;
    return this;
  }

  public GetOrderStatusLifeCycleRequest addCreateTimeItem(Long createTimeItem) {
    this.createTime.add(createTimeItem);
    return this;
  }

   /**
   * 认证时间
   * @return createTime
  **/
  @ApiModelProperty(value = "认证时间")
  public List<Long> getCreateTime() {
    return createTime;
  }

  public void setCreateTime(List<Long> createTime) {
    this.createTime = createTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetOrderStatusLifeCycleRequest getOrderStatusLifeCycleRequest = (GetOrderStatusLifeCycleRequest) o;
    return Objects.equals(this.systemOrig, getOrderStatusLifeCycleRequest.systemOrig) &&
        Objects.equals(this.isCooperate, getOrderStatusLifeCycleRequest.isCooperate) &&
        Objects.equals(this.purchaserName, getOrderStatusLifeCycleRequest.purchaserName) &&
        Objects.equals(this.salesbillNo, getOrderStatusLifeCycleRequest.salesbillNo) &&
        Objects.equals(this.ifAuthFlag, getOrderStatusLifeCycleRequest.ifAuthFlag) &&
        Objects.equals(this.signTime, getOrderStatusLifeCycleRequest.signTime) &&
        Objects.equals(this.smSyncTime, getOrderStatusLifeCycleRequest.smSyncTime) &&
        Objects.equals(this.auditUpdateTime, getOrderStatusLifeCycleRequest.auditUpdateTime) &&
        Objects.equals(this.authUpdateTime, getOrderStatusLifeCycleRequest.authUpdateTime) &&
        Objects.equals(this.createTime, getOrderStatusLifeCycleRequest.createTime) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(systemOrig, isCooperate, purchaserName, salesbillNo, ifAuthFlag, signTime, smSyncTime, auditUpdateTime, authUpdateTime, createTime, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetOrderStatusLifeCycleRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    systemOrig: ").append(toIndentedString(systemOrig)).append("\n");
    sb.append("    isCooperate: ").append(toIndentedString(isCooperate)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    salesbillNo: ").append(toIndentedString(salesbillNo)).append("\n");
    sb.append("    ifAuthFlag: ").append(toIndentedString(ifAuthFlag)).append("\n");
    sb.append("    signTime: ").append(toIndentedString(signTime)).append("\n");
    sb.append("    smSyncTime: ").append(toIndentedString(smSyncTime)).append("\n");
    sb.append("    auditUpdateTime: ").append(toIndentedString(auditUpdateTime)).append("\n");
    sb.append("    authUpdateTime: ").append(toIndentedString(authUpdateTime)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
