package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.landedestate.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 待寄送Request
 */
@ApiModel(description = "待寄送Request")

@JsonInclude(NON_NULL)
public class GetParcelDetailsListRequest extends PageRequest {
  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("paperDrewDate")
  private List<String> paperDrewDate = new ArrayList<String>();

  @JsonProperty("amountWithTaxStart")
  private BigDecimal amountWithTaxStart = null;

  @JsonProperty("amountWithTaxEnd")
  private BigDecimal amountWithTaxEnd = null;

  @JsonProperty("orderNum")
  private Integer orderNum = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("bussinessNo")
  private String bussinessNo = null;

  @JsonProperty("createTime")
  private List<Long> createTime = new ArrayList<Long>();

  @JsonProperty("goodsOrig")
  private Integer goodsOrig = null;

  @JsonProperty("senderRole")
  private Integer senderRole = null;

  @JsonProperty("businessLgtStatus")
  private Integer businessLgtStatus = null;

  @JsonIgnore
  public GetParcelDetailsListRequest invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public GetParcelDetailsListRequest paperDrewDate(List<String> paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
    return this;
  }

  public GetParcelDetailsListRequest addPaperDrewDateItem(String paperDrewDateItem) {
    this.paperDrewDate.add(paperDrewDateItem);
    return this;
  }

   /**
   * 发票开票日期（例：20161027）
   * @return paperDrewDate
  **/
  @ApiModelProperty(value = "发票开票日期（例：20161027）")
  public List<String> getPaperDrewDate() {
    return paperDrewDate;
  }

  public void setPaperDrewDate(List<String> paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
  }

  @JsonIgnore
  public GetParcelDetailsListRequest amountWithTaxStart(BigDecimal amountWithTaxStart) {
    this.amountWithTaxStart = amountWithTaxStart;
    return this;
  }

   /**
   * 价税合计范围 - 起始值
   * @return amountWithTaxStart
  **/
  @ApiModelProperty(value = "价税合计范围 - 起始值")
  public BigDecimal getAmountWithTaxStart() {
    return amountWithTaxStart;
  }

  public void setAmountWithTaxStart(BigDecimal amountWithTaxStart) {
    this.amountWithTaxStart = amountWithTaxStart;
  }

  @JsonIgnore
  public GetParcelDetailsListRequest amountWithTaxEnd(BigDecimal amountWithTaxEnd) {
    this.amountWithTaxEnd = amountWithTaxEnd;
    return this;
  }

   /**
   * 价税合计范围 - 结束值
   * @return amountWithTaxEnd
  **/
  @ApiModelProperty(value = "价税合计范围 - 结束值")
  public BigDecimal getAmountWithTaxEnd() {
    return amountWithTaxEnd;
  }

  public void setAmountWithTaxEnd(BigDecimal amountWithTaxEnd) {
    this.amountWithTaxEnd = amountWithTaxEnd;
  }

  @JsonIgnore
  public GetParcelDetailsListRequest orderNum(Integer orderNum) {
    this.orderNum = orderNum;
    return this;
  }

   /**
   * 排序 0-创建时间升序，1-创建时间降序，2-开票日期升序，3-开票日期降序
   * @return orderNum
  **/
  @ApiModelProperty(value = "排序 0-创建时间升序，1-创建时间降序，2-开票日期升序，3-开票日期降序")
  public Integer getOrderNum() {
    return orderNum;
  }

  public void setOrderNum(Integer orderNum) {
    this.orderNum = orderNum;
  }

  @JsonIgnore
  public GetParcelDetailsListRequest invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public GetParcelDetailsListRequest bussinessNo(String bussinessNo) {
    this.bussinessNo = bussinessNo;
    return this;
  }

   /**
   * 业务单号
   * @return bussinessNo
  **/
  @ApiModelProperty(value = "业务单号")
  public String getBussinessNo() {
    return bussinessNo;
  }

  public void setBussinessNo(String bussinessNo) {
    this.bussinessNo = bussinessNo;
  }

  @JsonIgnore
  public GetParcelDetailsListRequest createTime(List<Long> createTime) {
    this.createTime = createTime;
    return this;
  }

  public GetParcelDetailsListRequest addCreateTimeItem(Long createTimeItem) {
    this.createTime.add(createTimeItem);
    return this;
  }

   /**
   * 退票时间
   * @return createTime
  **/
  @ApiModelProperty(value = "退票时间")
  public List<Long> getCreateTime() {
    return createTime;
  }

  public void setCreateTime(List<Long> createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public GetParcelDetailsListRequest goodsOrig(Integer goodsOrig) {
    this.goodsOrig = goodsOrig;
    return this;
  }

   /**
   * 物品来源：1-销项业务单，2-开票，3-退票，4-物流退件,5-补发件
   * @return goodsOrig
  **/
  @ApiModelProperty(value = "物品来源：1-销项业务单，2-开票，3-退票，4-物流退件,5-补发件")
  public Integer getGoodsOrig() {
    return goodsOrig;
  }

  public void setGoodsOrig(Integer goodsOrig) {
    this.goodsOrig = goodsOrig;
  }

  @JsonIgnore
  public GetParcelDetailsListRequest senderRole(Integer senderRole) {
    this.senderRole = senderRole;
    return this;
  }

   /**
   * 寄件角色：1-销方寄件，2-购方寄件
   * @return senderRole
  **/
  @ApiModelProperty(value = "寄件角色：1-销方寄件，2-购方寄件")
  public Integer getSenderRole() {
    return senderRole;
  }

  public void setSenderRole(Integer senderRole) {
    this.senderRole = senderRole;
  }

  @JsonIgnore
  public GetParcelDetailsListRequest businessLgtStatus(Integer businessLgtStatus) {
    this.businessLgtStatus = businessLgtStatus;
    return this;
  }

   /**
   * 业务物流状态1-待寄送，2-无需寄送，3-寄送中，4-异常，5-已签收
   * @return businessLgtStatus
  **/
  @ApiModelProperty(value = "业务物流状态1-待寄送，2-无需寄送，3-寄送中，4-异常，5-已签收")
  public Integer getBusinessLgtStatus() {
    return businessLgtStatus;
  }

  public void setBusinessLgtStatus(Integer businessLgtStatus) {
    this.businessLgtStatus = businessLgtStatus;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetParcelDetailsListRequest getParcelDetailsListRequest = (GetParcelDetailsListRequest) o;
    return Objects.equals(this.invoiceNo, getParcelDetailsListRequest.invoiceNo) &&
        Objects.equals(this.paperDrewDate, getParcelDetailsListRequest.paperDrewDate) &&
        Objects.equals(this.amountWithTaxStart, getParcelDetailsListRequest.amountWithTaxStart) &&
        Objects.equals(this.amountWithTaxEnd, getParcelDetailsListRequest.amountWithTaxEnd) &&
        Objects.equals(this.orderNum, getParcelDetailsListRequest.orderNum) &&
        Objects.equals(this.invoiceCode, getParcelDetailsListRequest.invoiceCode) &&
        Objects.equals(this.bussinessNo, getParcelDetailsListRequest.bussinessNo) &&
        Objects.equals(this.createTime, getParcelDetailsListRequest.createTime) &&
        Objects.equals(this.goodsOrig, getParcelDetailsListRequest.goodsOrig) &&
        Objects.equals(this.senderRole, getParcelDetailsListRequest.senderRole) &&
        Objects.equals(this.businessLgtStatus, getParcelDetailsListRequest.businessLgtStatus) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceNo, paperDrewDate, amountWithTaxStart, amountWithTaxEnd, orderNum, invoiceCode, bussinessNo, createTime, goodsOrig, senderRole, businessLgtStatus, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetParcelDetailsListRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    paperDrewDate: ").append(toIndentedString(paperDrewDate)).append("\n");
    sb.append("    amountWithTaxStart: ").append(toIndentedString(amountWithTaxStart)).append("\n");
    sb.append("    amountWithTaxEnd: ").append(toIndentedString(amountWithTaxEnd)).append("\n");
    sb.append("    orderNum: ").append(toIndentedString(orderNum)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    bussinessNo: ").append(toIndentedString(bussinessNo)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    goodsOrig: ").append(toIndentedString(goodsOrig)).append("\n");
    sb.append("    senderRole: ").append(toIndentedString(senderRole)).append("\n");
    sb.append("    businessLgtStatus: ").append(toIndentedString(businessLgtStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
