package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.landedestate.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 签收管理表Request
 */
@ApiModel(description = "签收管理表Request")

@JsonInclude(NON_NULL)
public class GetPostcodeListRequest extends PageRequest {
  @JsonProperty("packageCode")
  private String packageCode = null;

  @JsonProperty("isUnpacking")
  private Integer isUnpacking = null;

  @JsonProperty("recieveTime")
  private List<Long> recieveTime = new ArrayList<Long>();

  @JsonProperty("reciever")
  private List<String> reciever = new ArrayList<String>();

  @JsonIgnore
  public GetPostcodeListRequest packageCode(String packageCode) {
    this.packageCode = packageCode;
    return this;
  }

   /**
   * 邮包的快递单号
   * @return packageCode
  **/
  @ApiModelProperty(value = "邮包的快递单号")
  public String getPackageCode() {
    return packageCode;
  }

  public void setPackageCode(String packageCode) {
    this.packageCode = packageCode;
  }

  @JsonIgnore
  public GetPostcodeListRequest isUnpacking(Integer isUnpacking) {
    this.isUnpacking = isUnpacking;
    return this;
  }

   /**
   * 是否已拆包：0-否，1-是
   * @return isUnpacking
  **/
  @ApiModelProperty(value = "是否已拆包：0-否，1-是")
  public Integer getIsUnpacking() {
    return isUnpacking;
  }

  public void setIsUnpacking(Integer isUnpacking) {
    this.isUnpacking = isUnpacking;
  }

  @JsonIgnore
  public GetPostcodeListRequest recieveTime(List<Long> recieveTime) {
    this.recieveTime = recieveTime;
    return this;
  }

  public GetPostcodeListRequest addRecieveTimeItem(Long recieveTimeItem) {
    this.recieveTime.add(recieveTimeItem);
    return this;
  }

   /**
   * 签收时间
   * @return recieveTime
  **/
  @ApiModelProperty(value = "签收时间")
  public List<Long> getRecieveTime() {
    return recieveTime;
  }

  public void setRecieveTime(List<Long> recieveTime) {
    this.recieveTime = recieveTime;
  }

  @JsonIgnore
  public GetPostcodeListRequest reciever(List<String> reciever) {
    this.reciever = reciever;
    return this;
  }

  public GetPostcodeListRequest addRecieverItem(String recieverItem) {
    this.reciever.add(recieverItem);
    return this;
  }

   /**
   * 签收人
   * @return reciever
  **/
  @ApiModelProperty(value = "签收人")
  public List<String> getReciever() {
    return reciever;
  }

  public void setReciever(List<String> reciever) {
    this.reciever = reciever;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetPostcodeListRequest getPostcodeListRequest = (GetPostcodeListRequest) o;
    return Objects.equals(this.packageCode, getPostcodeListRequest.packageCode) &&
        Objects.equals(this.isUnpacking, getPostcodeListRequest.isUnpacking) &&
        Objects.equals(this.recieveTime, getPostcodeListRequest.recieveTime) &&
        Objects.equals(this.reciever, getPostcodeListRequest.reciever) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(packageCode, isUnpacking, recieveTime, reciever, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetPostcodeListRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    packageCode: ").append(toIndentedString(packageCode)).append("\n");
    sb.append("    isUnpacking: ").append(toIndentedString(isUnpacking)).append("\n");
    sb.append("    recieveTime: ").append(toIndentedString(recieveTime)).append("\n");
    sb.append("    reciever: ").append(toIndentedString(reciever)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
