package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.landedestate.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 邮包-业务单请求Request
 */
@ApiModel(description = "邮包-业务单请求Request")

@JsonInclude(NON_NULL)
public class GetPostcodeOrdersListRequest extends PageRequest {
  @JsonProperty("packageCode")
  private String packageCode = null;

  @JsonProperty("salesbillNo")
  private String salesbillNo = null;

  @JsonProperty("recieveTime")
  private List<Long> recieveTime = new ArrayList<Long>();

  @JsonProperty("signStatus")
  private Integer signStatus = null;

  @JsonProperty("signFailType")
  private List<Integer> signFailType = new ArrayList<Integer>();

  @JsonProperty("signPerson")
  private List<String> signPerson = new ArrayList<String>();

  @JsonIgnore
  public GetPostcodeOrdersListRequest packageCode(String packageCode) {
    this.packageCode = packageCode;
    return this;
  }

   /**
   * 邮包的快递单号
   * @return packageCode
  **/
  @ApiModelProperty(value = "邮包的快递单号")
  public String getPackageCode() {
    return packageCode;
  }

  public void setPackageCode(String packageCode) {
    this.packageCode = packageCode;
  }

  @JsonIgnore
  public GetPostcodeOrdersListRequest salesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
    return this;
  }

   /**
   * 单据编号
   * @return salesbillNo
  **/
  @ApiModelProperty(value = "单据编号")
  public String getSalesbillNo() {
    return salesbillNo;
  }

  public void setSalesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
  }

  @JsonIgnore
  public GetPostcodeOrdersListRequest recieveTime(List<Long> recieveTime) {
    this.recieveTime = recieveTime;
    return this;
  }

  public GetPostcodeOrdersListRequest addRecieveTimeItem(Long recieveTimeItem) {
    this.recieveTime.add(recieveTimeItem);
    return this;
  }

   /**
   * 签收时间
   * @return recieveTime
  **/
  @ApiModelProperty(value = "签收时间")
  public List<Long> getRecieveTime() {
    return recieveTime;
  }

  public void setRecieveTime(List<Long> recieveTime) {
    this.recieveTime = recieveTime;
  }

  @JsonIgnore
  public GetPostcodeOrdersListRequest signStatus(Integer signStatus) {
    this.signStatus = signStatus;
    return this;
  }

   /**
   * 签收状态 ：10-成功 20-失败
   * @return signStatus
  **/
  @ApiModelProperty(value = "签收状态 ：10-成功 20-失败")
  public Integer getSignStatus() {
    return signStatus;
  }

  public void setSignStatus(Integer signStatus) {
    this.signStatus = signStatus;
  }

  @JsonIgnore
  public GetPostcodeOrdersListRequest signFailType(List<Integer> signFailType) {
    this.signFailType = signFailType;
    return this;
  }

  public GetPostcodeOrdersListRequest addSignFailTypeItem(Integer signFailTypeItem) {
    this.signFailType.add(signFailTypeItem);
    return this;
  }

   /**
   * 异常原因分类：1-发票未盖章，2-发票污损，3-发票打印错位，4-发票无結算单，5-报支单，6-其他，7-审核不通过，8-发送认证失败，9-认证不通过
   * @return signFailType
  **/
  @ApiModelProperty(value = "异常原因分类：1-发票未盖章，2-发票污损，3-发票打印错位，4-发票无結算单，5-报支单，6-其他，7-审核不通过，8-发送认证失败，9-认证不通过")
  public List<Integer> getSignFailType() {
    return signFailType;
  }

  public void setSignFailType(List<Integer> signFailType) {
    this.signFailType = signFailType;
  }

  @JsonIgnore
  public GetPostcodeOrdersListRequest signPerson(List<String> signPerson) {
    this.signPerson = signPerson;
    return this;
  }

  public GetPostcodeOrdersListRequest addSignPersonItem(String signPersonItem) {
    this.signPerson.add(signPersonItem);
    return this;
  }

   /**
   * null
   * @return signPerson
  **/
  @ApiModelProperty(value = "null")
  public List<String> getSignPerson() {
    return signPerson;
  }

  public void setSignPerson(List<String> signPerson) {
    this.signPerson = signPerson;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetPostcodeOrdersListRequest getPostcodeOrdersListRequest = (GetPostcodeOrdersListRequest) o;
    return Objects.equals(this.packageCode, getPostcodeOrdersListRequest.packageCode) &&
        Objects.equals(this.salesbillNo, getPostcodeOrdersListRequest.salesbillNo) &&
        Objects.equals(this.recieveTime, getPostcodeOrdersListRequest.recieveTime) &&
        Objects.equals(this.signStatus, getPostcodeOrdersListRequest.signStatus) &&
        Objects.equals(this.signFailType, getPostcodeOrdersListRequest.signFailType) &&
        Objects.equals(this.signPerson, getPostcodeOrdersListRequest.signPerson) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(packageCode, salesbillNo, recieveTime, signStatus, signFailType, signPerson, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetPostcodeOrdersListRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    packageCode: ").append(toIndentedString(packageCode)).append("\n");
    sb.append("    salesbillNo: ").append(toIndentedString(salesbillNo)).append("\n");
    sb.append("    recieveTime: ").append(toIndentedString(recieveTime)).append("\n");
    sb.append("    signStatus: ").append(toIndentedString(signStatus)).append("\n");
    sb.append("    signFailType: ").append(toIndentedString(signFailType)).append("\n");
    sb.append("    signPerson: ").append(toIndentedString(signPerson)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
