package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.landedestate.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 扫描发票表Request
 */
@ApiModel(description = "扫描发票表Request")

@JsonInclude(NON_NULL)
public class GetSmInvoiceListRequest extends PageRequest {
  @JsonProperty("orderCode")
  private String orderCode = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("deleteUser")
  private String deleteUser = null;

  @JsonProperty("deleteType")
  private Integer deleteType = null;

  @JsonProperty("deleteTime")
  private List<Long> deleteTime = new ArrayList<Long>();

  @JsonProperty("createTime")
  private List<Long> createTime = new ArrayList<Long>();

  @JsonProperty("fpzt")
  private Integer fpzt = null;

  @JsonIgnore
  public GetSmInvoiceListRequest orderCode(String orderCode) {
    this.orderCode = orderCode;
    return this;
  }

   /**
   * 业务单号
   * @return orderCode
  **/
  @ApiModelProperty(value = "业务单号")
  public String getOrderCode() {
    return orderCode;
  }

  public void setOrderCode(String orderCode) {
    this.orderCode = orderCode;
  }

  @JsonIgnore
  public GetSmInvoiceListRequest invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public GetSmInvoiceListRequest invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public GetSmInvoiceListRequest deleteUser(String deleteUser) {
    this.deleteUser = deleteUser;
    return this;
  }

   /**
   * 删除人
   * @return deleteUser
  **/
  @ApiModelProperty(value = "删除人")
  public String getDeleteUser() {
    return deleteUser;
  }

  public void setDeleteUser(String deleteUser) {
    this.deleteUser = deleteUser;
  }

  @JsonIgnore
  public GetSmInvoiceListRequest deleteType(Integer deleteType) {
    this.deleteType = deleteType;
    return this;
  }

   /**
   * 删除原因
   * @return deleteType
  **/
  @ApiModelProperty(value = "删除原因")
  public Integer getDeleteType() {
    return deleteType;
  }

  public void setDeleteType(Integer deleteType) {
    this.deleteType = deleteType;
  }

  @JsonIgnore
  public GetSmInvoiceListRequest deleteTime(List<Long> deleteTime) {
    this.deleteTime = deleteTime;
    return this;
  }

  public GetSmInvoiceListRequest addDeleteTimeItem(Long deleteTimeItem) {
    this.deleteTime.add(deleteTimeItem);
    return this;
  }

   /**
   * 删除时间
   * @return deleteTime
  **/
  @ApiModelProperty(value = "删除时间")
  public List<Long> getDeleteTime() {
    return deleteTime;
  }

  public void setDeleteTime(List<Long> deleteTime) {
    this.deleteTime = deleteTime;
  }

  @JsonIgnore
  public GetSmInvoiceListRequest createTime(List<Long> createTime) {
    this.createTime = createTime;
    return this;
  }

  public GetSmInvoiceListRequest addCreateTimeItem(Long createTimeItem) {
    this.createTime.add(createTimeItem);
    return this;
  }

   /**
   * 上传时间
   * @return createTime
  **/
  @ApiModelProperty(value = "上传时间")
  public List<Long> getCreateTime() {
    return createTime;
  }

  public void setCreateTime(List<Long> createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public GetSmInvoiceListRequest fpzt(Integer fpzt) {
    this.fpzt = fpzt;
    return this;
  }

   /**
   * 发票状态
   * @return fpzt
  **/
  @ApiModelProperty(value = "发票状态")
  public Integer getFpzt() {
    return fpzt;
  }

  public void setFpzt(Integer fpzt) {
    this.fpzt = fpzt;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetSmInvoiceListRequest getSmInvoiceListRequest = (GetSmInvoiceListRequest) o;
    return Objects.equals(this.orderCode, getSmInvoiceListRequest.orderCode) &&
        Objects.equals(this.invoiceCode, getSmInvoiceListRequest.invoiceCode) &&
        Objects.equals(this.invoiceNo, getSmInvoiceListRequest.invoiceNo) &&
        Objects.equals(this.deleteUser, getSmInvoiceListRequest.deleteUser) &&
        Objects.equals(this.deleteType, getSmInvoiceListRequest.deleteType) &&
        Objects.equals(this.deleteTime, getSmInvoiceListRequest.deleteTime) &&
        Objects.equals(this.createTime, getSmInvoiceListRequest.createTime) &&
        Objects.equals(this.fpzt, getSmInvoiceListRequest.fpzt) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(orderCode, invoiceCode, invoiceNo, deleteUser, deleteType, deleteTime, createTime, fpzt, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetSmInvoiceListRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    orderCode: ").append(toIndentedString(orderCode)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    deleteUser: ").append(toIndentedString(deleteUser)).append("\n");
    sb.append("    deleteType: ").append(toIndentedString(deleteType)).append("\n");
    sb.append("    deleteTime: ").append(toIndentedString(deleteTime)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    fpzt: ").append(toIndentedString(fpzt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
