package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 员工绩效请求
 */
@ApiModel(description = "员工绩效请求")

@JsonInclude(NON_NULL)
public class GetWorkDifferenceRequest extends BaseRequest {
  @JsonProperty("workTime")
  private Long workTime = null;

  @JsonIgnore
  public GetWorkDifferenceRequest workTime(Long workTime) {
    this.workTime = workTime;
    return this;
  }

   /**
   * 工作时间
   * @return workTime
  **/
  @ApiModelProperty(value = "工作时间")
  public Long getWorkTime() {
    return workTime;
  }

  public void setWorkTime(Long workTime) {
    this.workTime = workTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetWorkDifferenceRequest getWorkDifferenceRequest = (GetWorkDifferenceRequest) o;
    return Objects.equals(this.workTime, getWorkDifferenceRequest.workTime) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(workTime, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetWorkDifferenceRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    workTime: ").append(toIndentedString(workTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
