package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 业务单审核查询
 */
@ApiModel(description = "业务单审核查询")

@JsonInclude(NON_NULL)
public class InvoiceAuditRequest extends BaseRequest {
  @JsonProperty("orderCode")
  private String orderCode = null;

  @JsonProperty("invoiceId")
  private Long invoiceId = null;

  @JsonIgnore
  public InvoiceAuditRequest orderCode(String orderCode) {
    this.orderCode = orderCode;
    return this;
  }

   /**
   * 业务单号
   * @return orderCode
  **/
  @ApiModelProperty(value = "业务单号")
  public String getOrderCode() {
    return orderCode;
  }

  public void setOrderCode(String orderCode) {
    this.orderCode = orderCode;
  }

  @JsonIgnore
  public InvoiceAuditRequest invoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
    return this;
  }

   /**
   * 发票id
   * @return invoiceId
  **/
  @ApiModelProperty(value = "发票id")
  public Long getInvoiceId() {
    return invoiceId;
  }

  public void setInvoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceAuditRequest invoiceAuditRequest = (InvoiceAuditRequest) o;
    return Objects.equals(this.orderCode, invoiceAuditRequest.orderCode) &&
        Objects.equals(this.invoiceId, invoiceAuditRequest.invoiceId) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(orderCode, invoiceId, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceAuditRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    orderCode: ").append(toIndentedString(orderCode)).append("\n");
    sb.append("    invoiceId: ").append(toIndentedString(invoiceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
