package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.vanke.in.client.model.GetInvoiceListRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发票认证查询
 */
@ApiModel(description = "发票认证查询")

@JsonInclude(NON_NULL)
public class InvoiceAuthRequest extends GetInvoiceListRequest {
  @JsonProperty("authTab")
  private Integer authTab = null;

  @JsonProperty("onlineStatus")
  private Integer onlineStatus = null;

  @JsonProperty("authDuration")
  private Integer authDuration = null;

  @JsonIgnore
  public InvoiceAuthRequest authTab(Integer authTab) {
    this.authTab = authTab;
    return this;
  }

   /**
   * 页面tab：1-底账未认证，2-传统未认证，3-未开通通道，4-认证中，5-抵扣异常，6-全部
   * @return authTab
  **/
  @ApiModelProperty(value = "页面tab：1-底账未认证，2-传统未认证，3-未开通通道，4-认证中，5-抵扣异常，6-全部")
  public Integer getAuthTab() {
    return authTab;
  }

  public void setAuthTab(Integer authTab) {
    this.authTab = authTab;
  }

  @JsonIgnore
  public InvoiceAuthRequest onlineStatus(Integer onlineStatus) {
    this.onlineStatus = onlineStatus;
    return this;
  }

   /**
   * 在线状态：0-离线；1-在线
   * @return onlineStatus
  **/
  @ApiModelProperty(value = "在线状态：0-离线；1-在线")
  public Integer getOnlineStatus() {
    return onlineStatus;
  }

  public void setOnlineStatus(Integer onlineStatus) {
    this.onlineStatus = onlineStatus;
  }

  @JsonIgnore
  public InvoiceAuthRequest authDuration(Integer authDuration) {
    this.authDuration = authDuration;
    return this;
  }

   /**
   * 认证时长：1小时以下，1小时，3小时，6小时，12小时，1天以上
   * @return authDuration
  **/
  @ApiModelProperty(value = "认证时长：1小时以下，1小时，3小时，6小时，12小时，1天以上")
  public Integer getAuthDuration() {
    return authDuration;
  }

  public void setAuthDuration(Integer authDuration) {
    this.authDuration = authDuration;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceAuthRequest invoiceAuthRequest = (InvoiceAuthRequest) o;
    return Objects.equals(this.authTab, invoiceAuthRequest.authTab) &&
        Objects.equals(this.onlineStatus, invoiceAuthRequest.onlineStatus) &&
        Objects.equals(this.authDuration, invoiceAuthRequest.authDuration) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authTab, onlineStatus, authDuration, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceAuthRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    authTab: ").append(toIndentedString(authTab)).append("\n");
    sb.append("    onlineStatus: ").append(toIndentedString(onlineStatus)).append("\n");
    sb.append("    authDuration: ").append(toIndentedString(authDuration)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
