package com.xforceplus.vanke.in.client.model;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.metadata.BaseRowModel;

import java.math.BigDecimal;

/**
 * @Description 发票导出
 * @Date 2019年07月19日 16:05
 * @Author rongying
 * @Version 1.0
 */
public class InvoiceExportBean extends BaseRowModel {

    @ExcelProperty("业务类型")
    private String dataFromSystem;

    @ExcelProperty("业务单号")
    private String salesbillNo;

    @ExcelProperty("发票类型")
    private String invoiceType;

    @ExcelProperty("发票代码")
    private String invoiceCode;

    @ExcelProperty("发票号码")
    private String invoiceNo;

    @ExcelProperty("开票日期")
    private String paperDrewDate;

    @ExcelProperty("购方公司名称")
    private String purchaserName;

    @ExcelProperty("购方公司税号")
    private String purchaserTaxNo;

    @ExcelProperty("销方公司名称")
    private String sellerName;

    @ExcelProperty("销方公司税号")
    private String sellerTaxNo;

    @ExcelProperty("金额")
    private BigDecimal amountWithoutTax;

    @ExcelProperty("税额")
    private BigDecimal taxAmount;

    @ExcelProperty("价税合计")
    private BigDecimal amountWithTax;

    @ExcelProperty("发票状态")
    private String status;

    @ExcelProperty("抵扣状态")
    private String authStatus;


    @ExcelProperty("底账获取状态")
    private String authSyncStatus;

    @ExcelProperty("底帐获取时间")
    private String authSyncTime;

    @ExcelProperty("审核时间")
    private String auditUpdateTime;

    @ExcelProperty("勾选请求时间")
    private String authCheckRequestTime;

    @ExcelProperty("勾选完成时间")
    private String authCheckResponseTime;

    @ExcelProperty("抵扣发送时间")
    private String authRequestTime;

    @ExcelProperty("抵扣反馈时间")
    private String authReturnTime;

    @ExcelProperty("抵扣完成时间")
    private String authResponseTime;

    @ExcelProperty("勾选次数")
    private Integer authCount;

    @ExcelProperty("勾选操作人")
    private String authCheckUserName;

    @ExcelProperty("抵扣操作人")
    private String authRequestUserName;

    @ExcelProperty("抵扣备注")
    private String authRemark;

    @ExcelProperty("抵扣异常分类")
    private String authExceType;

    @ExcelProperty("抵扣用途")
    private String authPurposes;

    @ExcelProperty("是否重复发票")
    private String ifRepeat;

    @ExcelProperty("是否转交异常")
    private String ifSendException;

    @ExcelProperty("转交异常备注")
    private String sendExceptionRemark;

    public String getDataFromSystem() {
        return dataFromSystem;
    }

    public void setDataFromSystem(String dataFromSystem) {
        this.dataFromSystem = dataFromSystem;
    }

    public String getSalesbillNo() {
        return salesbillNo;
    }

    public void setSalesbillNo(String salesbillNo) {
        this.salesbillNo = salesbillNo;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    public String getPaperDrewDate() {
        return paperDrewDate;
    }

    public void setPaperDrewDate(String paperDrewDate) {
        this.paperDrewDate = paperDrewDate;
    }

    public String getPurchaserName() {
        return purchaserName;
    }

    public void setPurchaserName(String purchaserName) {
        this.purchaserName = purchaserName;
    }

    public String getPurchaserTaxNo() {
        return purchaserTaxNo;
    }

    public void setPurchaserTaxNo(String purchaserTaxNo) {
        this.purchaserTaxNo = purchaserTaxNo;
    }

    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    public String getSellerTaxNo() {
        return sellerTaxNo;
    }

    public void setSellerTaxNo(String sellerTaxNo) {
        this.sellerTaxNo = sellerTaxNo;
    }

    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getAuthStatus() {
        return authStatus;
    }

    public void setAuthStatus(String authStatus) {
        this.authStatus = authStatus;
    }

    public String getAuthSyncStatus() {
        return authSyncStatus;
    }

    public void setAuthSyncStatus(String authSyncStatus) {
        this.authSyncStatus = authSyncStatus;
    }

    public String getAuthSyncTime() {
        return authSyncTime;
    }

    public void setAuthSyncTime(String authSyncTime) {
        this.authSyncTime = authSyncTime;
    }

    public String getAuditUpdateTime() {
        return auditUpdateTime;
    }

    public void setAuditUpdateTime(String auditUpdateTime) {
        this.auditUpdateTime = auditUpdateTime;
    }

    public String getAuthCheckRequestTime() {
        return authCheckRequestTime;
    }

    public void setAuthCheckRequestTime(String authCheckRequestTime) {
        this.authCheckRequestTime = authCheckRequestTime;
    }

    public String getAuthCheckResponseTime() {
        return authCheckResponseTime;
    }

    public void setAuthCheckResponseTime(String authCheckResponseTime) {
        this.authCheckResponseTime = authCheckResponseTime;
    }

    public Integer getAuthCount() {
        return authCount;
    }

    public void setAuthCount(Integer authCount) {
        this.authCount = authCount;
    }

    public String getAuthCheckUserName() {
        return authCheckUserName;
    }

    public void setAuthCheckUserName(String authCheckUserName) {
        this.authCheckUserName = authCheckUserName;
    }

    public String getAuthRequestUserName() {
        return authRequestUserName;
    }

    public void setAuthRequestUserName(String authRequestUserName) {
        this.authRequestUserName = authRequestUserName;
    }

    public String getAuthRemark() {
        return authRemark;
    }

    public void setAuthRemark(String authRemark) {
        this.authRemark = authRemark;
    }

    public String getAuthExceType() {
        return authExceType;
    }

    public void setAuthExceType(String authExceType) {
        this.authExceType = authExceType;
    }

    public String getAuthPurposes() {
        return authPurposes;
    }

    public void setAuthPurposes(String authPurposes) {
        this.authPurposes = authPurposes;
    }

    public String getIfRepeat() {
        return ifRepeat;
    }

    public void setIfRepeat(String ifRepeat) {
        this.ifRepeat = ifRepeat;
    }

    public String getIfSendException() {
        return ifSendException;
    }

    public void setIfSendException(String ifSendException) {
        this.ifSendException = ifSendException;
    }

    public String getSendExceptionRemark() {
        return sendExceptionRemark;
    }

    public void setSendExceptionRemark(String sendExceptionRemark) {
        this.sendExceptionRemark = sendExceptionRemark;
    }

    public String getAuthRequestTime() {
        return authRequestTime;
    }

    public void setAuthRequestTime(String authRequestTime) {
        this.authRequestTime = authRequestTime;
    }

    public String getAuthReturnTime() {
        return authReturnTime;
    }

    public void setAuthReturnTime(String authReturnTime) {
        this.authReturnTime = authReturnTime;
    }

    public String getAuthResponseTime() {
        return authResponseTime;
    }

    public void setAuthResponseTime(String authResponseTime) {
        this.authResponseTime = authResponseTime;
    }

}
