package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发票请求入参
 */
@ApiModel(description = "发票请求入参")

@JsonInclude(NON_NULL)
public class InvoiceInfoRequest extends BaseRequest {
  @JsonProperty("invoiceId")
  private Long invoiceId = null;

  @JsonProperty("authResult")
  private Integer authResult = null;

  @JsonProperty("authStyle")
  private Integer authStyle = null;

  @JsonProperty("taxPeriod")
  private String taxPeriod = null;

  @JsonProperty("authTime")
  private String authTime = null;

  @JsonIgnore
  public InvoiceInfoRequest invoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
    return this;
  }

   /**
   * 发票id
   * @return invoiceId
  **/
  @ApiModelProperty(value = "发票id")
  public Long getInvoiceId() {
    return invoiceId;
  }

  public void setInvoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
  }

  @JsonIgnore
  public InvoiceInfoRequest authResult(Integer authResult) {
    this.authResult = authResult;
    return this;
  }

   /**
   * 抵扣结果 0-未勾选 1-已勾选 2-已抵扣
   * @return authResult
  **/
  @ApiModelProperty(value = "抵扣结果 0-未勾选 1-已勾选 2-已抵扣")
  public Integer getAuthResult() {
    return authResult;
  }

  public void setAuthResult(Integer authResult) {
    this.authResult = authResult;
  }

  @JsonIgnore
  public InvoiceInfoRequest authStyle(Integer authStyle) {
    this.authStyle = authStyle;
    return this;
  }

   /**
   * 抵扣方式 11-底账抵扣导入 21-扫描抵扣导入
   * @return authStyle
  **/
  @ApiModelProperty(value = "抵扣方式 11-底账抵扣导入 21-扫描抵扣导入")
  public Integer getAuthStyle() {
    return authStyle;
  }

  public void setAuthStyle(Integer authStyle) {
    this.authStyle = authStyle;
  }

  @JsonIgnore
  public InvoiceInfoRequest taxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
    return this;
  }

   /**
   * 所属期 yyyyMM
   * @return taxPeriod
  **/
  @ApiModelProperty(value = "所属期 yyyyMM")
  public String getTaxPeriod() {
    return taxPeriod;
  }

  public void setTaxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
  }

  @JsonIgnore
  public InvoiceInfoRequest authTime(String authTime) {
    this.authTime = authTime;
    return this;
  }

   /**
   * 认证时间 yyyy-MM-dd HH:mm:ss
   * @return authTime
  **/
  @ApiModelProperty(value = "认证时间 yyyy-MM-dd HH:mm:ss")
  public String getAuthTime() {
    return authTime;
  }

  public void setAuthTime(String authTime) {
    this.authTime = authTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceInfoRequest invoiceInfoRequest = (InvoiceInfoRequest) o;
    return Objects.equals(this.invoiceId, invoiceInfoRequest.invoiceId) &&
        Objects.equals(this.authResult, invoiceInfoRequest.authResult) &&
        Objects.equals(this.authStyle, invoiceInfoRequest.authStyle) &&
        Objects.equals(this.taxPeriod, invoiceInfoRequest.taxPeriod) &&
        Objects.equals(this.authTime, invoiceInfoRequest.authTime) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceId, authResult, authStyle, taxPeriod, authTime, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceInfoRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    invoiceId: ").append(toIndentedString(invoiceId)).append("\n");
    sb.append("    authResult: ").append(toIndentedString(authResult)).append("\n");
    sb.append("    authStyle: ").append(toIndentedString(authStyle)).append("\n");
    sb.append("    taxPeriod: ").append(toIndentedString(taxPeriod)).append("\n");
    sb.append("    authTime: ").append(toIndentedString(authTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
