package com.xforceplus.vanke.in.client.model;

import java.io.Serializable;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
/**
 * 发票重复统计
 */
public class InvoiceRepeatCountBean implements Serializable {
    @ApiModelProperty("发票代码")
    private  String invoiceCode;

    @ApiModelProperty("发票号码")
    private  String invoiceNo;

    @ApiModelProperty("业务单号")
    private  String salesBillNo;

    @ApiModelProperty("购方名称")
    private  String purchaserName;

    @ApiModelProperty("销方名称")
    private  String sellerName;

    @ApiModelProperty("金额")//不含税金额
    private  BigDecimal amountWithoutTax;

    @ApiModelProperty("税额")
    private  BigDecimal taxAmount;

    @ApiModelProperty("价税合计")//不含税+税额
    private  BigDecimal amountWithTax;

    @ApiModelProperty("审核状态")
    private  Integer invoiceCheckStatus;

    @ApiModelProperty("认证状态")
    private  Integer authStatus;

    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    public String getInvoiceNo() {
        return invoiceNo;
    }

    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    public String getSalesBillNo() {
        return salesBillNo;
    }

    public void setSalesBillNo(String salesBillNo) {
        this.salesBillNo = salesBillNo;
    }

    public Integer getInvoiceCheckStatus() {
        return invoiceCheckStatus;
    }

    public void setInvoiceCheckStatus(Integer invoiceCheckStatus) {
        this.invoiceCheckStatus = invoiceCheckStatus;
    }

    public String getPurchaserName() {
        return purchaserName;
    }

    public void setPurchaserName(String purchaserName) {
        this.purchaserName = purchaserName;
    }

    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public Integer getAuthStatus() {
        return authStatus;
    }

    public void setAuthStatus(Integer authStatus) {
        this.authStatus = authStatus;
    }
}
