package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 转交异常，撤销转交异常按钮
 */
@ApiModel(description = "转交异常，撤销转交异常按钮")

@JsonInclude(NON_NULL)
public class InvoiceSendExceptionRequest extends BaseRequest {
  @JsonProperty("invoiceIds")
  private List<Long> invoiceIds = new ArrayList<Long>();

  @JsonProperty("ifSendException")
  private Integer ifSendException = null;

  @JsonProperty("sendExceptionRemark")
  private String sendExceptionRemark = null;

  @JsonProperty("sendType")
  private Integer sendType = null;

  @JsonIgnore
  public InvoiceSendExceptionRequest invoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
    return this;
  }

  public InvoiceSendExceptionRequest addInvoiceIdsItem(Long invoiceIdsItem) {
    this.invoiceIds.add(invoiceIdsItem);
    return this;
  }

   /**
   * 发票id集合
   * @return invoiceIds
  **/
  @ApiModelProperty(value = "发票id集合")
  public List<Long> getInvoiceIds() {
    return invoiceIds;
  }

  public void setInvoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
  }

  @JsonIgnore
  public InvoiceSendExceptionRequest ifSendException(Integer ifSendException) {
    this.ifSendException = ifSendException;
    return this;
  }

   /**
   * 是否转交异常 1-是，0-否
   * @return ifSendException
  **/
  @ApiModelProperty(value = "是否转交异常 1-是，0-否")
  public Integer getIfSendException() {
    return ifSendException;
  }

  public void setIfSendException(Integer ifSendException) {
    this.ifSendException = ifSendException;
  }

  @JsonIgnore
  public InvoiceSendExceptionRequest sendExceptionRemark(String sendExceptionRemark) {
    this.sendExceptionRemark = sendExceptionRemark;
    return this;
  }

   /**
   * 转交异常备注
   * @return sendExceptionRemark
  **/
  @ApiModelProperty(value = "转交异常备注")
  public String getSendExceptionRemark() {
    return sendExceptionRemark;
  }

  public void setSendExceptionRemark(String sendExceptionRemark) {
    this.sendExceptionRemark = sendExceptionRemark;
  }

  @JsonIgnore
  public InvoiceSendExceptionRequest sendType(Integer sendType) {
    this.sendType = sendType;
    return this;
  }

   /**
   * 转交类型 1-发票池，2-发票勾选
   * @return sendType
  **/
  @ApiModelProperty(value = "转交类型 1-发票池，2-发票勾选")
  public Integer getSendType() {
    return sendType;
  }

  public void setSendType(Integer sendType) {
    this.sendType = sendType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceSendExceptionRequest invoiceSendExceptionRequest = (InvoiceSendExceptionRequest) o;
    return Objects.equals(this.invoiceIds, invoiceSendExceptionRequest.invoiceIds) &&
        Objects.equals(this.ifSendException, invoiceSendExceptionRequest.ifSendException) &&
        Objects.equals(this.sendExceptionRemark, invoiceSendExceptionRequest.sendExceptionRemark) &&
        Objects.equals(this.sendType, invoiceSendExceptionRequest.sendType) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceIds, ifSendException, sendExceptionRemark, sendType, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceSendExceptionRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    invoiceIds: ").append(toIndentedString(invoiceIds)).append("\n");
    sb.append("    ifSendException: ").append(toIndentedString(ifSendException)).append("\n");
    sb.append("    sendExceptionRemark: ").append(toIndentedString(sendExceptionRemark)).append("\n");
    sb.append("    sendType: ").append(toIndentedString(sendType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
