package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * ModifyLegalSynergeticsRequest
 */
@ApiModel(description = "ModifyLegalSynergeticsRequest")

@JsonInclude(NON_NULL)
public class ModifyLegalSynergeticsRequest extends BaseRequest {
  @JsonProperty("salesbillNo")
  private String salesbillNo = null;

  @JsonProperty("isLegalSynergetics")
  private Integer isLegalSynergetics = null;

  @JsonIgnore
  public ModifyLegalSynergeticsRequest salesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
    return this;
  }

   /**
   * 单据编号
   * @return salesbillNo
  **/
  @ApiModelProperty(value = "单据编号")
  public String getSalesbillNo() {
    return salesbillNo;
  }

  public void setSalesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
  }

  @JsonIgnore
  public ModifyLegalSynergeticsRequest isLegalSynergetics(Integer isLegalSynergetics) {
    this.isLegalSynergetics = isLegalSynergetics;
    return this;
  }

   /**
   * 是否法人协同 1.是 0.否
   * @return isLegalSynergetics
  **/
  @ApiModelProperty(value = "是否法人协同 1.是 0.否")
  public Integer getIsLegalSynergetics() {
    return isLegalSynergetics;
  }

  public void setIsLegalSynergetics(Integer isLegalSynergetics) {
    this.isLegalSynergetics = isLegalSynergetics;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ModifyLegalSynergeticsRequest modifyLegalSynergeticsRequest = (ModifyLegalSynergeticsRequest) o;
    return Objects.equals(this.salesbillNo, modifyLegalSynergeticsRequest.salesbillNo) &&
        Objects.equals(this.isLegalSynergetics, modifyLegalSynergeticsRequest.isLegalSynergetics) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(salesbillNo, isLegalSynergetics, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ModifyLegalSynergeticsRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    salesbillNo: ").append(toIndentedString(salesbillNo)).append("\n");
    sb.append("    isLegalSynergetics: ").append(toIndentedString(isLegalSynergetics)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
