package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 邮包签收--业务单-&gt;导出Request
 */
@ApiModel(description = "邮包签收--业务单->导出Request")

@JsonInclude(NON_NULL)
public class OrdersExcelExportRequest extends BaseRequest {
  @JsonProperty("sellerExpress")
  private String sellerExpress = null;

  @JsonProperty("salesbillNo")
  private String salesbillNo = null;

  @JsonProperty("signTime")
  private List<Long> signTime = new ArrayList<Long>();

  @JsonProperty("signStatus")
  private List<Integer> signStatus = new ArrayList<Integer>();

  @JsonProperty("signFailType")
  private List<Integer> signFailType = new ArrayList<Integer>();

  @JsonIgnore
  public OrdersExcelExportRequest sellerExpress(String sellerExpress) {
    this.sellerExpress = sellerExpress;
    return this;
  }

   /**
   * 运单号
   * @return sellerExpress
  **/
  @ApiModelProperty(value = "运单号")
  public String getSellerExpress() {
    return sellerExpress;
  }

  public void setSellerExpress(String sellerExpress) {
    this.sellerExpress = sellerExpress;
  }

  @JsonIgnore
  public OrdersExcelExportRequest salesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
    return this;
  }

   /**
   * 业务单号
   * @return salesbillNo
  **/
  @ApiModelProperty(value = "业务单号")
  public String getSalesbillNo() {
    return salesbillNo;
  }

  public void setSalesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
  }

  @JsonIgnore
  public OrdersExcelExportRequest signTime(List<Long> signTime) {
    this.signTime = signTime;
    return this;
  }

  public OrdersExcelExportRequest addSignTimeItem(Long signTimeItem) {
    this.signTime.add(signTimeItem);
    return this;
  }

   /**
   * 签收时间
   * @return signTime
  **/
  @ApiModelProperty(value = "签收时间")
  public List<Long> getSignTime() {
    return signTime;
  }

  public void setSignTime(List<Long> signTime) {
    this.signTime = signTime;
  }

  @JsonIgnore
  public OrdersExcelExportRequest signStatus(List<Integer> signStatus) {
    this.signStatus = signStatus;
    return this;
  }

  public OrdersExcelExportRequest addSignStatusItem(Integer signStatusItem) {
    this.signStatus.add(signStatusItem);
    return this;
  }

   /**
   * 是否合格（签收状态）
   * @return signStatus
  **/
  @ApiModelProperty(value = "是否合格（签收状态）")
  public List<Integer> getSignStatus() {
    return signStatus;
  }

  public void setSignStatus(List<Integer> signStatus) {
    this.signStatus = signStatus;
  }

  @JsonIgnore
  public OrdersExcelExportRequest signFailType(List<Integer> signFailType) {
    this.signFailType = signFailType;
    return this;
  }

  public OrdersExcelExportRequest addSignFailTypeItem(Integer signFailTypeItem) {
    this.signFailType.add(signFailTypeItem);
    return this;
  }

   /**
   * 不合格类型（签收失败类型）
   * @return signFailType
  **/
  @ApiModelProperty(value = "不合格类型（签收失败类型）")
  public List<Integer> getSignFailType() {
    return signFailType;
  }

  public void setSignFailType(List<Integer> signFailType) {
    this.signFailType = signFailType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrdersExcelExportRequest ordersExcelExportRequest = (OrdersExcelExportRequest) o;
    return Objects.equals(this.sellerExpress, ordersExcelExportRequest.sellerExpress) &&
        Objects.equals(this.salesbillNo, ordersExcelExportRequest.salesbillNo) &&
        Objects.equals(this.signTime, ordersExcelExportRequest.signTime) &&
        Objects.equals(this.signStatus, ordersExcelExportRequest.signStatus) &&
        Objects.equals(this.signFailType, ordersExcelExportRequest.signFailType) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sellerExpress, salesbillNo, signTime, signStatus, signFailType, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrdersExcelExportRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    sellerExpress: ").append(toIndentedString(sellerExpress)).append("\n");
    sb.append("    salesbillNo: ").append(toIndentedString(salesbillNo)).append("\n");
    sb.append("    signTime: ").append(toIndentedString(signTime)).append("\n");
    sb.append("    signStatus: ").append(toIndentedString(signStatus)).append("\n");
    sb.append("    signFailType: ").append(toIndentedString(signFailType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
