package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.vanke.in.client.model.WkInvoiceDTO;
import com.xforceplus.vanke.in.client.model.WkOrdersDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 业务单信息
 */
@ApiModel(description = "业务单信息")

@JsonInclude(NON_NULL)
public class OrdersInformation {
  @JsonProperty("ordersDetails")
  private WkOrdersDTO ordersDetails = null;

  @JsonProperty("invoiceMain")
  private List<WkInvoiceDTO> invoiceMain = new ArrayList<WkInvoiceDTO>();

  @JsonIgnore
  public OrdersInformation ordersDetails(WkOrdersDTO ordersDetails) {
    this.ordersDetails = ordersDetails;
    return this;
  }

   /**
   * details
   * @return ordersDetails
  **/
  @ApiModelProperty(value = "details")
  public WkOrdersDTO getOrdersDetails() {
    return ordersDetails;
  }

  public void setOrdersDetails(WkOrdersDTO ordersDetails) {
    this.ordersDetails = ordersDetails;
  }

  @JsonIgnore
  public OrdersInformation invoiceMain(List<WkInvoiceDTO> invoiceMain) {
    this.invoiceMain = invoiceMain;
    return this;
  }

  public OrdersInformation addInvoiceMainItem(WkInvoiceDTO invoiceMainItem) {
    this.invoiceMain.add(invoiceMainItem);
    return this;
  }

   /**
   * 发票主信息
   * @return invoiceMain
  **/
  @ApiModelProperty(value = "发票主信息")
  public List<WkInvoiceDTO> getInvoiceMain() {
    return invoiceMain;
  }

  public void setInvoiceMain(List<WkInvoiceDTO> invoiceMain) {
    this.invoiceMain = invoiceMain;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrdersInformation ordersInformation = (OrdersInformation) o;
    return Objects.equals(this.ordersDetails, ordersInformation.ordersDetails) &&
        Objects.equals(this.invoiceMain, ordersInformation.invoiceMain);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ordersDetails, invoiceMain);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrdersInformation {\n");
    
    sb.append("    ordersDetails: ").append(toIndentedString(ordersDetails)).append("\n");
    sb.append("    invoiceMain: ").append(toIndentedString(invoiceMain)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
