package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查看详情
 */
@ApiModel(description = "查看详情")

@JsonInclude(NON_NULL)
public class ParcelDetailsRequest extends BaseRequest {
  @JsonProperty("parcelId")
  private Long parcelId = null;

  @JsonIgnore
  public ParcelDetailsRequest parcelId(Long parcelId) {
    this.parcelId = parcelId;
    return this;
  }

   /**
   * 包裹id
   * @return parcelId
  **/
  @ApiModelProperty(value = "包裹id")
  public Long getParcelId() {
    return parcelId;
  }

  public void setParcelId(Long parcelId) {
    this.parcelId = parcelId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ParcelDetailsRequest parcelDetailsRequest = (ParcelDetailsRequest) o;
    return Objects.equals(this.parcelId, parcelDetailsRequest.parcelId) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(parcelId, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ParcelDetailsRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    parcelId: ").append(toIndentedString(parcelId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
