package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 推送发票信息至业务系统
 */
@ApiModel(description = "推送发票信息至业务系统")

@JsonInclude(NON_NULL)
public class PushInvoiceRequest extends BaseRequest {
  @JsonProperty("pushType")
  private Integer pushType = null;

  @JsonProperty("invoiceId")
  private Long invoiceId = null;

  @JsonProperty("sysOrign")
  private String sysOrign = null;

  @JsonIgnore
  public PushInvoiceRequest pushType(Integer pushType) {
    this.pushType = pushType;
    return this;
  }

   /**
   * 1-作废信息 2-开票信息
   * @return pushType
  **/
  @ApiModelProperty(value = "1-作废信息 2-开票信息")
  public Integer getPushType() {
    return pushType;
  }

  public void setPushType(Integer pushType) {
    this.pushType = pushType;
  }

  @JsonIgnore
  public PushInvoiceRequest invoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
    return this;
  }

   /**
   * 发票id
   * @return invoiceId
  **/
  @ApiModelProperty(value = "发票id")
  public Long getInvoiceId() {
    return invoiceId;
  }

  public void setInvoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
  }

  @JsonIgnore
  public PushInvoiceRequest sysOrign(String sysOrign) {
    this.sysOrign = sysOrign;
    return this;
  }

   /**
   * 业务来源
   * @return sysOrign
  **/
  @ApiModelProperty(value = "业务来源")
  public String getSysOrign() {
    return sysOrign;
  }

  public void setSysOrign(String sysOrign) {
    this.sysOrign = sysOrign;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PushInvoiceRequest pushInvoiceRequest = (PushInvoiceRequest) o;
    return Objects.equals(this.pushType, pushInvoiceRequest.pushType) &&
        Objects.equals(this.invoiceId, pushInvoiceRequest.invoiceId) &&
        Objects.equals(this.sysOrign, pushInvoiceRequest.sysOrign) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pushType, invoiceId, sysOrign, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PushInvoiceRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    pushType: ").append(toIndentedString(pushType)).append("\n");
    sb.append("    invoiceId: ").append(toIndentedString(invoiceId)).append("\n");
    sb.append("    sysOrign: ").append(toIndentedString(sysOrign)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
