package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.vanke.in.client.model.WkExceptionDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 异常工单表Request
 */
@ApiModel(description = "异常工单表Request")

@JsonInclude(NON_NULL)
public class SaveExceptionRequest extends BaseRequest {
  @JsonProperty("entities")
  private List<WkExceptionDTO> entities = new ArrayList<WkExceptionDTO>();

  @JsonIgnore
  public SaveExceptionRequest entities(List<WkExceptionDTO> entities) {
    this.entities = entities;
    return this;
  }

  public SaveExceptionRequest addEntitiesItem(WkExceptionDTO entitiesItem) {
    this.entities.add(entitiesItem);
    return this;
  }

   /**
   * Get entities
   * @return entities
  **/
  @ApiModelProperty(value = "")
  public List<WkExceptionDTO> getEntities() {
    return entities;
  }

  public void setEntities(List<WkExceptionDTO> entities) {
    this.entities = entities;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SaveExceptionRequest saveExceptionRequest = (SaveExceptionRequest) o;
    return Objects.equals(this.entities, saveExceptionRequest.entities) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(entities, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SaveExceptionRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    entities: ").append(toIndentedString(entities)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
