package com.xforceplus.vanke.in.client.model;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Description 发送认证返回对象
 * @Date 2019年07月05日 10:45
 * @Author rongying
 * @Version 1.0
 */
public class SendAuthInfoBean implements Serializable {

  @ApiModelProperty("当前勾选发票数")
  private Integer checkInvoiceNum = 0;

  @ApiModelProperty("可认证发票数")
  private Integer authInvoiceNum = 0;

  @ApiModelProperty("不可认证发票数")
  private Integer noauthInvoiceNum = 0;

  @ApiModelProperty("可认证税额")
  private BigDecimal authTaxAmount = BigDecimal.ZERO;

  @ApiModelProperty("可认证不含税金额")
  private BigDecimal authAmountWithoutTax = BigDecimal.ZERO;

  @ApiModelProperty("可认证含税金额")
  private BigDecimal authAmountWithTax = BigDecimal.ZERO;

  @ApiModelProperty("公司集合")
  private List<SendAuthCompanyBean> companyList;

  public Integer getCheckInvoiceNum() {
    return checkInvoiceNum;
  }

  public void setCheckInvoiceNum(Integer checkInvoiceNum) {
    this.checkInvoiceNum = checkInvoiceNum;
  }

  public Integer getAuthInvoiceNum() {
    return authInvoiceNum;
  }

  public void setAuthInvoiceNum(Integer authInvoiceNum) {
    this.authInvoiceNum = authInvoiceNum;
  }

  public Integer getNoauthInvoiceNum() {
    return noauthInvoiceNum;
  }

  public void setNoauthInvoiceNum(Integer noauthInvoiceNum) {
    this.noauthInvoiceNum = noauthInvoiceNum;
  }

  public BigDecimal getAuthTaxAmount() {
    return authTaxAmount;
  }

  public void setAuthTaxAmount(BigDecimal authTaxAmount) {
    this.authTaxAmount = authTaxAmount;
  }

  public BigDecimal getAuthAmountWithoutTax() {
    return authAmountWithoutTax;
  }

  public void setAuthAmountWithoutTax(BigDecimal authAmountWithoutTax) {
    this.authAmountWithoutTax = authAmountWithoutTax;
  }

  public BigDecimal getAuthAmountWithTax() {
    return authAmountWithTax;
  }

  public void setAuthAmountWithTax(BigDecimal authAmountWithTax) {
    this.authAmountWithTax = authAmountWithTax;
  }

  public List<SendAuthCompanyBean> getCompanyList() {
    return companyList;
  }

  public void setCompanyList(List<SendAuthCompanyBean> companyList) {
    this.companyList = companyList;
  }
}
