package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发送认证请求参数
 */
@ApiModel(description = "发送认证请求参数")

@JsonInclude(NON_NULL)
public class SendAuthRequest extends BaseRequest {
  @JsonProperty("authTab")
  private Integer authTab = null;

  @JsonProperty("invoiceIds")
  private List<Long> invoiceIds = new ArrayList<Long>();

  @JsonProperty("downloadFlag")
  private Integer downloadFlag = null;

  @JsonIgnore
  public SendAuthRequest authTab(Integer authTab) {
    this.authTab = authTab;
    return this;
  }

   /**
   * 认证tab值：1-底账未认证，2-传统未认证
   * @return authTab
  **/
  @ApiModelProperty(value = "认证tab值：1-底账未认证，2-传统未认证")
  public Integer getAuthTab() {
    return authTab;
  }

  public void setAuthTab(Integer authTab) {
    this.authTab = authTab;
  }

  @JsonIgnore
  public SendAuthRequest invoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
    return this;
  }

  public SendAuthRequest addInvoiceIdsItem(Long invoiceIdsItem) {
    this.invoiceIds.add(invoiceIdsItem);
    return this;
  }

   /**
   * 发票id集合
   * @return invoiceIds
  **/
  @ApiModelProperty(value = "发票id集合")
  public List<Long> getInvoiceIds() {
    return invoiceIds;
  }

  public void setInvoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
  }

  @JsonIgnore
  public SendAuthRequest downloadFlag(Integer downloadFlag) {
    this.downloadFlag = downloadFlag;
    return this;
  }

   /**
   * 下载内容：0-发票主信息，1-发票主信息及明细
   * @return downloadFlag
  **/
  @ApiModelProperty(value = "下载内容：0-发票主信息，1-发票主信息及明细")
  public Integer getDownloadFlag() {
    return downloadFlag;
  }

  public void setDownloadFlag(Integer downloadFlag) {
    this.downloadFlag = downloadFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SendAuthRequest sendAuthRequest = (SendAuthRequest) o;
    return Objects.equals(this.authTab, sendAuthRequest.authTab) &&
        Objects.equals(this.invoiceIds, sendAuthRequest.invoiceIds) &&
        Objects.equals(this.downloadFlag, sendAuthRequest.downloadFlag) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authTab, invoiceIds, downloadFlag, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SendAuthRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    authTab: ").append(toIndentedString(authTab)).append("\n");
    sb.append("    invoiceIds: ").append(toIndentedString(invoiceIds)).append("\n");
    sb.append("    downloadFlag: ").append(toIndentedString(downloadFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
