package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 影像文件表
 */
@ApiModel(description = "影像文件表")

@JsonInclude(NON_NULL)
public class SmFileDTO {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("batchId")
  private Long batchId = null;

  @JsonProperty("bizType")
  private Integer bizType = null;

  @JsonProperty("source")
  private Integer source = null;

  @JsonProperty("requireOcrFlag")
  private Integer requireOcrFlag = null;

  @JsonProperty("fileUrl")
  private String fileUrl = null;

  @JsonProperty("fileUrlHandle")
  private String fileUrlHandle = null;

  @JsonProperty("fileType")
  private String fileType = null;

  @JsonProperty("fileTypeHandle")
  private String fileTypeHandle = null;

  @JsonProperty("parentId")
  private Long parentId = null;

  @JsonProperty("fileOrder")
  private Integer fileOrder = null;

  @JsonProperty("fileLevel")
  private Integer fileLevel = null;

  @JsonProperty("billSeq")
  private Long billSeq = null;

  @JsonProperty("invoiceSeq")
  private Long invoiceSeq = null;

  @JsonProperty("attachmentSeq")
  private Long attachmentSeq = null;

  @JsonProperty("taskId")
  private String taskId = null;

  @JsonProperty("recStartTime")
  private Long recStartTime = null;

  @JsonProperty("recEndTime")
  private Long recEndTime = null;

  @JsonProperty("recRemark")
  private String recRemark = null;

  @JsonProperty("submitTime")
  private Long submitTime = null;

  @JsonProperty("submittedFlag")
  private Integer submittedFlag = null;

  @JsonProperty("orderCode")
  private String orderCode = null;

  @JsonProperty("createUser")
  private String createUser = null;

  @JsonProperty("createUserId")
  private Long createUserId = null;

  @JsonProperty("createTime")
  private Long createTime = null;

  @JsonProperty("updateUserId")
  private Long updateUserId = null;

  @JsonProperty("updateTime")
  private Long updateTime = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("isBackScan")
  private Integer isBackScan = null;

  @JsonIgnore
  public SmFileDTO id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public SmFileDTO batchId(Long batchId) {
    this.batchId = batchId;
    return this;
  }

   /**
   * 扫描批次号
   * @return batchId
  **/
  @ApiModelProperty(value = "扫描批次号")
  public Long getBatchId() {
    return batchId;
  }

  public void setBatchId(Long batchId) {
    this.batchId = batchId;
  }

  @JsonIgnore
  public SmFileDTO bizType(Integer bizType) {
    this.bizType = bizType;
    return this;
  }

   /**
   * 业务类型：1-单据，2-发票，3-附件，99-其他
   * @return bizType
  **/
  @ApiModelProperty(value = "业务类型：1-单据，2-发票，3-附件，99-其他")
  public Integer getBizType() {
    return bizType;
  }

  public void setBizType(Integer bizType) {
    this.bizType = bizType;
  }

  @JsonIgnore
  public SmFileDTO source(Integer source) {
    this.source = source;
    return this;
  }

   /**
   * 来源：1-扫描，2-上传，3-国信接口，99-其他
   * @return source
  **/
  @ApiModelProperty(value = "来源：1-扫描，2-上传，3-国信接口，99-其他")
  public Integer getSource() {
    return source;
  }

  public void setSource(Integer source) {
    this.source = source;
  }

  @JsonIgnore
  public SmFileDTO requireOcrFlag(Integer requireOcrFlag) {
    this.requireOcrFlag = requireOcrFlag;
    return this;
  }

   /**
   * 是否需要识别：1-需要，0-不需要
   * @return requireOcrFlag
  **/
  @ApiModelProperty(value = "是否需要识别：1-需要，0-不需要")
  public Integer getRequireOcrFlag() {
    return requireOcrFlag;
  }

  public void setRequireOcrFlag(Integer requireOcrFlag) {
    this.requireOcrFlag = requireOcrFlag;
  }

  @JsonIgnore
  public SmFileDTO fileUrl(String fileUrl) {
    this.fileUrl = fileUrl;
    return this;
  }

   /**
   * 原始文件路径
   * @return fileUrl
  **/
  @ApiModelProperty(value = "原始文件路径")
  public String getFileUrl() {
    return fileUrl;
  }

  public void setFileUrl(String fileUrl) {
    this.fileUrl = fileUrl;
  }

  @JsonIgnore
  public SmFileDTO fileUrlHandle(String fileUrlHandle) {
    this.fileUrlHandle = fileUrlHandle;
    return this;
  }

   /**
   * 处理文件路径
   * @return fileUrlHandle
  **/
  @ApiModelProperty(value = "处理文件路径")
  public String getFileUrlHandle() {
    return fileUrlHandle;
  }

  public void setFileUrlHandle(String fileUrlHandle) {
    this.fileUrlHandle = fileUrlHandle;
  }

  @JsonIgnore
  public SmFileDTO fileType(String fileType) {
    this.fileType = fileType;
    return this;
  }

   /**
   * 原始文件类型：PNG-PNG,JPG-JPG,JPEG-JPEG,PDF-PDF
   * @return fileType
  **/
  @ApiModelProperty(value = "原始文件类型：PNG-PNG,JPG-JPG,JPEG-JPEG,PDF-PDF")
  public String getFileType() {
    return fileType;
  }

  public void setFileType(String fileType) {
    this.fileType = fileType;
  }

  @JsonIgnore
  public SmFileDTO fileTypeHandle(String fileTypeHandle) {
    this.fileTypeHandle = fileTypeHandle;
    return this;
  }

   /**
   * 处理文件类型（如pdf转换为图片）：文件类型：PNG-PNG,JPG-JPG,JPEG-JPEG,PDF-PDF
   * @return fileTypeHandle
  **/
  @ApiModelProperty(value = "处理文件类型（如pdf转换为图片）：文件类型：PNG-PNG,JPG-JPG,JPEG-JPEG,PDF-PDF")
  public String getFileTypeHandle() {
    return fileTypeHandle;
  }

  public void setFileTypeHandle(String fileTypeHandle) {
    this.fileTypeHandle = fileTypeHandle;
  }

  @JsonIgnore
  public SmFileDTO parentId(Long parentId) {
    this.parentId = parentId;
    return this;
  }

   /**
   * 父文件id：0-代表空，1-顶级parentId
   * @return parentId
  **/
  @ApiModelProperty(value = "父文件id：0-代表空，1-顶级parentId")
  public Long getParentId() {
    return parentId;
  }

  public void setParentId(Long parentId) {
    this.parentId = parentId;
  }

  @JsonIgnore
  public SmFileDTO fileOrder(Integer fileOrder) {
    this.fileOrder = fileOrder;
    return this;
  }

   /**
   * 文件顺序
   * @return fileOrder
  **/
  @ApiModelProperty(value = "文件顺序")
  public Integer getFileOrder() {
    return fileOrder;
  }

  public void setFileOrder(Integer fileOrder) {
    this.fileOrder = fileOrder;
  }

  @JsonIgnore
  public SmFileDTO fileLevel(Integer fileLevel) {
    this.fileLevel = fileLevel;
    return this;
  }

   /**
   * 文件level
   * @return fileLevel
  **/
  @ApiModelProperty(value = "文件level")
  public Integer getFileLevel() {
    return fileLevel;
  }

  public void setFileLevel(Integer fileLevel) {
    this.fileLevel = fileLevel;
  }

  @JsonIgnore
  public SmFileDTO billSeq(Long billSeq) {
    this.billSeq = billSeq;
    return this;
  }

   /**
   * 单据序列，0代表空
   * @return billSeq
  **/
  @ApiModelProperty(value = "单据序列，0代表空")
  public Long getBillSeq() {
    return billSeq;
  }

  public void setBillSeq(Long billSeq) {
    this.billSeq = billSeq;
  }

  @JsonIgnore
  public SmFileDTO invoiceSeq(Long invoiceSeq) {
    this.invoiceSeq = invoiceSeq;
    return this;
  }

   /**
   * 发票序列，0代表空
   * @return invoiceSeq
  **/
  @ApiModelProperty(value = "发票序列，0代表空")
  public Long getInvoiceSeq() {
    return invoiceSeq;
  }

  public void setInvoiceSeq(Long invoiceSeq) {
    this.invoiceSeq = invoiceSeq;
  }

  @JsonIgnore
  public SmFileDTO attachmentSeq(Long attachmentSeq) {
    this.attachmentSeq = attachmentSeq;
    return this;
  }

   /**
   * 附件序列，0代表空
   * @return attachmentSeq
  **/
  @ApiModelProperty(value = "附件序列，0代表空")
  public Long getAttachmentSeq() {
    return attachmentSeq;
  }

  public void setAttachmentSeq(Long attachmentSeq) {
    this.attachmentSeq = attachmentSeq;
  }

  @JsonIgnore
  public SmFileDTO taskId(String taskId) {
    this.taskId = taskId;
    return this;
  }

   /**
   * 任务编号，识别任务编号
   * @return taskId
  **/
  @ApiModelProperty(value = "任务编号，识别任务编号")
  public String getTaskId() {
    return taskId;
  }

  public void setTaskId(String taskId) {
    this.taskId = taskId;
  }

  @JsonIgnore
  public SmFileDTO recStartTime(Long recStartTime) {
    this.recStartTime = recStartTime;
    return this;
  }

   /**
   * 识别开始时间
   * @return recStartTime
  **/
  @ApiModelProperty(value = "识别开始时间")
  public Long getRecStartTime() {
    return recStartTime;
  }

  public void setRecStartTime(Long recStartTime) {
    this.recStartTime = recStartTime;
  }

  @JsonIgnore
  public SmFileDTO recEndTime(Long recEndTime) {
    this.recEndTime = recEndTime;
    return this;
  }

   /**
   * 识别结束时间
   * @return recEndTime
  **/
  @ApiModelProperty(value = "识别结束时间")
  public Long getRecEndTime() {
    return recEndTime;
  }

  public void setRecEndTime(Long recEndTime) {
    this.recEndTime = recEndTime;
  }

  @JsonIgnore
  public SmFileDTO recRemark(String recRemark) {
    this.recRemark = recRemark;
    return this;
  }

   /**
   * 处理备注
   * @return recRemark
  **/
  @ApiModelProperty(value = "处理备注")
  public String getRecRemark() {
    return recRemark;
  }

  public void setRecRemark(String recRemark) {
    this.recRemark = recRemark;
  }

  @JsonIgnore
  public SmFileDTO submitTime(Long submitTime) {
    this.submitTime = submitTime;
    return this;
  }

   /**
   * 提交时间
   * @return submitTime
  **/
  @ApiModelProperty(value = "提交时间")
  public Long getSubmitTime() {
    return submitTime;
  }

  public void setSubmitTime(Long submitTime) {
    this.submitTime = submitTime;
  }

  @JsonIgnore
  public SmFileDTO submittedFlag(Integer submittedFlag) {
    this.submittedFlag = submittedFlag;
    return this;
  }

   /**
   * 已提交标志：0-未提交，1-提交中，2-已提交
   * @return submittedFlag
  **/
  @ApiModelProperty(value = "已提交标志：0-未提交，1-提交中，2-已提交")
  public Integer getSubmittedFlag() {
    return submittedFlag;
  }

  public void setSubmittedFlag(Integer submittedFlag) {
    this.submittedFlag = submittedFlag;
  }

  @JsonIgnore
  public SmFileDTO orderCode(String orderCode) {
    this.orderCode = orderCode;
    return this;
  }

   /**
   * 业务单据编码
   * @return orderCode
  **/
  @ApiModelProperty(value = "业务单据编码")
  public String getOrderCode() {
    return orderCode;
  }

  public void setOrderCode(String orderCode) {
    this.orderCode = orderCode;
  }

  @JsonIgnore
  public SmFileDTO createUser(String createUser) {
    this.createUser = createUser;
    return this;
  }

   /**
   * 创建用户名
   * @return createUser
  **/
  @ApiModelProperty(value = "创建用户名")
  public String getCreateUser() {
    return createUser;
  }

  public void setCreateUser(String createUser) {
    this.createUser = createUser;
  }

  @JsonIgnore
  public SmFileDTO createUserId(Long createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建账号
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建账号")
  public Long getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(Long createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public SmFileDTO createTime(Long createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public Long getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Long createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public SmFileDTO updateUserId(Long updateUserId) {
    this.updateUserId = updateUserId;
    return this;
  }

   /**
   * 更新账号
   * @return updateUserId
  **/
  @ApiModelProperty(value = "更新账号")
  public Long getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(Long updateUserId) {
    this.updateUserId = updateUserId;
  }

  @JsonIgnore
  public SmFileDTO updateTime(Long updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public Long getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(Long updateTime) {
    this.updateTime = updateTime;
  }

  @JsonIgnore
  public SmFileDTO status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态：1-正常，9-删除
   * @return status
  **/
  @ApiModelProperty(value = "状态：1-正常，9-删除")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public SmFileDTO isBackScan(Integer isBackScan) {
    this.isBackScan = isBackScan;
    return this;
  }

   /**
   * 是否退扫：0-否，1-是
   * @return isBackScan
  **/
  @ApiModelProperty(value = "是否退扫：0-否，1-是")
  public Integer getIsBackScan() {
    return isBackScan;
  }

  public void setIsBackScan(Integer isBackScan) {
    this.isBackScan = isBackScan;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SmFileDTO smFileDTO = (SmFileDTO) o;
    return Objects.equals(this.id, smFileDTO.id) &&
        Objects.equals(this.batchId, smFileDTO.batchId) &&
        Objects.equals(this.bizType, smFileDTO.bizType) &&
        Objects.equals(this.source, smFileDTO.source) &&
        Objects.equals(this.requireOcrFlag, smFileDTO.requireOcrFlag) &&
        Objects.equals(this.fileUrl, smFileDTO.fileUrl) &&
        Objects.equals(this.fileUrlHandle, smFileDTO.fileUrlHandle) &&
        Objects.equals(this.fileType, smFileDTO.fileType) &&
        Objects.equals(this.fileTypeHandle, smFileDTO.fileTypeHandle) &&
        Objects.equals(this.parentId, smFileDTO.parentId) &&
        Objects.equals(this.fileOrder, smFileDTO.fileOrder) &&
        Objects.equals(this.fileLevel, smFileDTO.fileLevel) &&
        Objects.equals(this.billSeq, smFileDTO.billSeq) &&
        Objects.equals(this.invoiceSeq, smFileDTO.invoiceSeq) &&
        Objects.equals(this.attachmentSeq, smFileDTO.attachmentSeq) &&
        Objects.equals(this.taskId, smFileDTO.taskId) &&
        Objects.equals(this.recStartTime, smFileDTO.recStartTime) &&
        Objects.equals(this.recEndTime, smFileDTO.recEndTime) &&
        Objects.equals(this.recRemark, smFileDTO.recRemark) &&
        Objects.equals(this.submitTime, smFileDTO.submitTime) &&
        Objects.equals(this.submittedFlag, smFileDTO.submittedFlag) &&
        Objects.equals(this.orderCode, smFileDTO.orderCode) &&
        Objects.equals(this.createUser, smFileDTO.createUser) &&
        Objects.equals(this.createUserId, smFileDTO.createUserId) &&
        Objects.equals(this.createTime, smFileDTO.createTime) &&
        Objects.equals(this.updateUserId, smFileDTO.updateUserId) &&
        Objects.equals(this.updateTime, smFileDTO.updateTime) &&
        Objects.equals(this.status, smFileDTO.status) &&
        Objects.equals(this.isBackScan, smFileDTO.isBackScan);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, batchId, bizType, source, requireOcrFlag, fileUrl, fileUrlHandle, fileType, fileTypeHandle, parentId, fileOrder, fileLevel, billSeq, invoiceSeq, attachmentSeq, taskId, recStartTime, recEndTime, recRemark, submitTime, submittedFlag, orderCode, createUser, createUserId, createTime, updateUserId, updateTime, status, isBackScan);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SmFileDTO {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    batchId: ").append(toIndentedString(batchId)).append("\n");
    sb.append("    bizType: ").append(toIndentedString(bizType)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    requireOcrFlag: ").append(toIndentedString(requireOcrFlag)).append("\n");
    sb.append("    fileUrl: ").append(toIndentedString(fileUrl)).append("\n");
    sb.append("    fileUrlHandle: ").append(toIndentedString(fileUrlHandle)).append("\n");
    sb.append("    fileType: ").append(toIndentedString(fileType)).append("\n");
    sb.append("    fileTypeHandle: ").append(toIndentedString(fileTypeHandle)).append("\n");
    sb.append("    parentId: ").append(toIndentedString(parentId)).append("\n");
    sb.append("    fileOrder: ").append(toIndentedString(fileOrder)).append("\n");
    sb.append("    fileLevel: ").append(toIndentedString(fileLevel)).append("\n");
    sb.append("    billSeq: ").append(toIndentedString(billSeq)).append("\n");
    sb.append("    invoiceSeq: ").append(toIndentedString(invoiceSeq)).append("\n");
    sb.append("    attachmentSeq: ").append(toIndentedString(attachmentSeq)).append("\n");
    sb.append("    taskId: ").append(toIndentedString(taskId)).append("\n");
    sb.append("    recStartTime: ").append(toIndentedString(recStartTime)).append("\n");
    sb.append("    recEndTime: ").append(toIndentedString(recEndTime)).append("\n");
    sb.append("    recRemark: ").append(toIndentedString(recRemark)).append("\n");
    sb.append("    submitTime: ").append(toIndentedString(submitTime)).append("\n");
    sb.append("    submittedFlag: ").append(toIndentedString(submittedFlag)).append("\n");
    sb.append("    orderCode: ").append(toIndentedString(orderCode)).append("\n");
    sb.append("    createUser: ").append(toIndentedString(createUser)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    isBackScan: ").append(toIndentedString(isBackScan)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
