package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 待提交影像文件表
 */
@ApiModel(description = "待提交影像文件表")

@JsonInclude(NON_NULL)
public class SmFileInvoiceDTO {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("batchId")
  private Long batchId = null;

  @JsonProperty("bizType")
  private Integer bizType = null;

  @JsonProperty("source")
  private Integer source = null;

  @JsonProperty("requireOcrFlag")
  private Integer requireOcrFlag = null;

  @JsonProperty("fileUrl")
  private String fileUrl = null;

  @JsonProperty("fileUrlHandle")
  private String fileUrlHandle = null;

  @JsonProperty("fileType")
  private String fileType = null;

  @JsonProperty("fileTypeHandle")
  private String fileTypeHandle = null;

  @JsonProperty("fileOrder")
  private Integer fileOrder = null;

  @JsonProperty("fileLevel")
  private Integer fileLevel = null;

  @JsonProperty("billSeq")
  private Long billSeq = null;

  @JsonProperty("invoiceSeq")
  private Long invoiceSeq = null;

  @JsonProperty("attachmentSeq")
  private Long attachmentSeq = null;

  @JsonProperty("recStatus")
  private Integer recStatus = null;

  @JsonProperty("taskId")
  private String taskId = null;

  @JsonProperty("recStartTime")
  private Long recStartTime = null;

  @JsonProperty("recEndTime")
  private Long recEndTime = null;

  @JsonProperty("recRemark")
  private String recRemark = null;

  @JsonProperty("orderCode")
  private String orderCode = null;

  @JsonProperty("billCode")
  private String billCode = null;

  @JsonProperty("billCodePrn")
  private String billCodePrn = null;

  @JsonProperty("billNumber")
  private String billNumber = null;

  @JsonProperty("billNumberPrn")
  private String billNumberPrn = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("createBillTime")
  private Long createBillTime = null;

  @JsonProperty("notContainTaxAmount")
  private BigDecimal notContainTaxAmount = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("containTaxAmount")
  private BigDecimal containTaxAmount = null;

  @JsonProperty("invoiceScanId")
  private String invoiceScanId = null;

  @JsonProperty("invoiceScanTime")
  private Long invoiceScanTime = null;

  @JsonProperty("fpzt")
  private Integer fpzt = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("invoiceQrcode")
  private String invoiceQrcode = null;

  @JsonProperty("passArea")
  private String passArea = null;

  @JsonProperty("createBillTimestr")
  private String createBillTimestr = null;

  @JsonProperty("scanBatchNo")
  private String scanBatchNo = null;

  @JsonProperty("cooperateFlag")
  private Integer cooperateFlag = null;

  @JsonProperty("sellerTel")
  private String sellerTel = null;

  @JsonProperty("sellerAddress")
  private String sellerAddress = null;

  @JsonProperty("sellerBankName")
  private String sellerBankName = null;

  @JsonProperty("sellerBankAccount")
  private String sellerBankAccount = null;

  @JsonProperty("purchaserTel")
  private String purchaserTel = null;

  @JsonProperty("purchaserAddress")
  private String purchaserAddress = null;

  @JsonProperty("purchaserBankAccount")
  private String purchaserBankAccount = null;

  @JsonProperty("purchaserBankName")
  private String purchaserBankName = null;

  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("chargeTaxUnitCode")
  private String chargeTaxUnitCode = null;

  @JsonProperty("twoCodeFlag")
  private String twoCodeFlag = null;

  @JsonProperty("chargeTaxUnitName")
  private String chargeTaxUnitName = null;

  @JsonProperty("cloudIdentifyFlag")
  private Integer cloudIdentifyFlag = null;

  @JsonProperty("cloudIdentifyRemark")
  private String cloudIdentifyRemark = null;

  @JsonProperty("machineCode")
  private String machineCode = null;

  @JsonProperty("purchaseName")
  private String purchaseName = null;

  @JsonProperty("sellerTaxName")
  private String sellerTaxName = null;

  @JsonProperty("checkCode")
  private String checkCode = null;

  @JsonProperty("containTaxAmountChn")
  private String containTaxAmountChn = null;

  @JsonProperty("interceptInfo")
  private String interceptInfo = null;

  @JsonProperty("warningInfo")
  private String warningInfo = null;

  @JsonProperty("specialInvoiceFlag")
  private Integer specialInvoiceFlag = null;

  @JsonProperty("payee")
  private String payee = null;

  @JsonProperty("reviewer")
  private String reviewer = null;

  @JsonProperty("drawer")
  private String drawer = null;

  @JsonProperty("createUser")
  private String createUser = null;

  @JsonProperty("createUserId")
  private Long createUserId = null;

  @JsonProperty("createTime")
  private Long createTime = null;

  @JsonProperty("updateUserId")
  private Long updateUserId = null;

  @JsonProperty("updateTime")
  private Long updateTime = null;

  @JsonProperty("invoiceSheet")
  private Integer invoiceSheet = null;

  @JsonIgnore
  public SmFileInvoiceDTO id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public SmFileInvoiceDTO batchId(Long batchId) {
    this.batchId = batchId;
    return this;
  }

   /**
   * 扫描批次号
   * @return batchId
  **/
  @ApiModelProperty(value = "扫描批次号")
  public Long getBatchId() {
    return batchId;
  }

  public void setBatchId(Long batchId) {
    this.batchId = batchId;
  }

  @JsonIgnore
  public SmFileInvoiceDTO bizType(Integer bizType) {
    this.bizType = bizType;
    return this;
  }

   /**
   * 业务类型：1-单据，2-发票，3-附件，99-其他
   * @return bizType
  **/
  @ApiModelProperty(value = "业务类型：1-单据，2-发票，3-附件，99-其他")
  public Integer getBizType() {
    return bizType;
  }

  public void setBizType(Integer bizType) {
    this.bizType = bizType;
  }

  @JsonIgnore
  public SmFileInvoiceDTO source(Integer source) {
    this.source = source;
    return this;
  }

   /**
   * 来源：1-扫描，2-上传，3-国信接口，99-其他
   * @return source
  **/
  @ApiModelProperty(value = "来源：1-扫描，2-上传，3-国信接口，99-其他")
  public Integer getSource() {
    return source;
  }

  public void setSource(Integer source) {
    this.source = source;
  }

  @JsonIgnore
  public SmFileInvoiceDTO requireOcrFlag(Integer requireOcrFlag) {
    this.requireOcrFlag = requireOcrFlag;
    return this;
  }

   /**
   * 是否需要识别：1-需要，0-不需要
   * @return requireOcrFlag
  **/
  @ApiModelProperty(value = "是否需要识别：1-需要，0-不需要")
  public Integer getRequireOcrFlag() {
    return requireOcrFlag;
  }

  public void setRequireOcrFlag(Integer requireOcrFlag) {
    this.requireOcrFlag = requireOcrFlag;
  }

  @JsonIgnore
  public SmFileInvoiceDTO fileUrl(String fileUrl) {
    this.fileUrl = fileUrl;
    return this;
  }

   /**
   * 原始文件路径
   * @return fileUrl
  **/
  @ApiModelProperty(value = "原始文件路径")
  public String getFileUrl() {
    return fileUrl;
  }

  public void setFileUrl(String fileUrl) {
    this.fileUrl = fileUrl;
  }

  @JsonIgnore
  public SmFileInvoiceDTO fileUrlHandle(String fileUrlHandle) {
    this.fileUrlHandle = fileUrlHandle;
    return this;
  }

   /**
   * 处理文件路径
   * @return fileUrlHandle
  **/
  @ApiModelProperty(value = "处理文件路径")
  public String getFileUrlHandle() {
    return fileUrlHandle;
  }

  public void setFileUrlHandle(String fileUrlHandle) {
    this.fileUrlHandle = fileUrlHandle;
  }

  @JsonIgnore
  public SmFileInvoiceDTO fileType(String fileType) {
    this.fileType = fileType;
    return this;
  }

   /**
   * 原始文件类型：PNG-PNG,JPG-JPG,JPEG-JPEG,PDF-PDF
   * @return fileType
  **/
  @ApiModelProperty(value = "原始文件类型：PNG-PNG,JPG-JPG,JPEG-JPEG,PDF-PDF")
  public String getFileType() {
    return fileType;
  }

  public void setFileType(String fileType) {
    this.fileType = fileType;
  }

  @JsonIgnore
  public SmFileInvoiceDTO fileTypeHandle(String fileTypeHandle) {
    this.fileTypeHandle = fileTypeHandle;
    return this;
  }

   /**
   * 处理文件类型（如pdf转换为图片）：文件类型：PNG-PNG,JPG-JPG,JPEG-JPEG,PDF-PDF
   * @return fileTypeHandle
  **/
  @ApiModelProperty(value = "处理文件类型（如pdf转换为图片）：文件类型：PNG-PNG,JPG-JPG,JPEG-JPEG,PDF-PDF")
  public String getFileTypeHandle() {
    return fileTypeHandle;
  }

  public void setFileTypeHandle(String fileTypeHandle) {
    this.fileTypeHandle = fileTypeHandle;
  }

  @JsonIgnore
  public SmFileInvoiceDTO fileOrder(Integer fileOrder) {
    this.fileOrder = fileOrder;
    return this;
  }

   /**
   * 文件顺序
   * @return fileOrder
  **/
  @ApiModelProperty(value = "文件顺序")
  public Integer getFileOrder() {
    return fileOrder;
  }

  public void setFileOrder(Integer fileOrder) {
    this.fileOrder = fileOrder;
  }

  @JsonIgnore
  public SmFileInvoiceDTO fileLevel(Integer fileLevel) {
    this.fileLevel = fileLevel;
    return this;
  }

   /**
   * 文件level
   * @return fileLevel
  **/
  @ApiModelProperty(value = "文件level")
  public Integer getFileLevel() {
    return fileLevel;
  }

  public void setFileLevel(Integer fileLevel) {
    this.fileLevel = fileLevel;
  }

  @JsonIgnore
  public SmFileInvoiceDTO billSeq(Long billSeq) {
    this.billSeq = billSeq;
    return this;
  }

   /**
   * 单据序列，0代表空
   * @return billSeq
  **/
  @ApiModelProperty(value = "单据序列，0代表空")
  public Long getBillSeq() {
    return billSeq;
  }

  public void setBillSeq(Long billSeq) {
    this.billSeq = billSeq;
  }

  @JsonIgnore
  public SmFileInvoiceDTO invoiceSeq(Long invoiceSeq) {
    this.invoiceSeq = invoiceSeq;
    return this;
  }

   /**
   * 发票序列，0代表空
   * @return invoiceSeq
  **/
  @ApiModelProperty(value = "发票序列，0代表空")
  public Long getInvoiceSeq() {
    return invoiceSeq;
  }

  public void setInvoiceSeq(Long invoiceSeq) {
    this.invoiceSeq = invoiceSeq;
  }

  @JsonIgnore
  public SmFileInvoiceDTO attachmentSeq(Long attachmentSeq) {
    this.attachmentSeq = attachmentSeq;
    return this;
  }

   /**
   * 附件序列，0代表空
   * @return attachmentSeq
  **/
  @ApiModelProperty(value = "附件序列，0代表空")
  public Long getAttachmentSeq() {
    return attachmentSeq;
  }

  public void setAttachmentSeq(Long attachmentSeq) {
    this.attachmentSeq = attachmentSeq;
  }

  @JsonIgnore
  public SmFileInvoiceDTO recStatus(Integer recStatus) {
    this.recStatus = recStatus;
    return this;
  }

   /**
   * 处理状态：0-未识别,1-正在识别,2-识别完成
   * @return recStatus
  **/
  @ApiModelProperty(value = "处理状态：0-未识别,1-正在识别,2-识别完成")
  public Integer getRecStatus() {
    return recStatus;
  }

  public void setRecStatus(Integer recStatus) {
    this.recStatus = recStatus;
  }

  @JsonIgnore
  public SmFileInvoiceDTO taskId(String taskId) {
    this.taskId = taskId;
    return this;
  }

   /**
   * 任务编号，识别任务编号
   * @return taskId
  **/
  @ApiModelProperty(value = "任务编号，识别任务编号")
  public String getTaskId() {
    return taskId;
  }

  public void setTaskId(String taskId) {
    this.taskId = taskId;
  }

  @JsonIgnore
  public SmFileInvoiceDTO recStartTime(Long recStartTime) {
    this.recStartTime = recStartTime;
    return this;
  }

   /**
   * 识别开始时间
   * @return recStartTime
  **/
  @ApiModelProperty(value = "识别开始时间")
  public Long getRecStartTime() {
    return recStartTime;
  }

  public void setRecStartTime(Long recStartTime) {
    this.recStartTime = recStartTime;
  }

  @JsonIgnore
  public SmFileInvoiceDTO recEndTime(Long recEndTime) {
    this.recEndTime = recEndTime;
    return this;
  }

   /**
   * 识别结束时间
   * @return recEndTime
  **/
  @ApiModelProperty(value = "识别结束时间")
  public Long getRecEndTime() {
    return recEndTime;
  }

  public void setRecEndTime(Long recEndTime) {
    this.recEndTime = recEndTime;
  }

  @JsonIgnore
  public SmFileInvoiceDTO recRemark(String recRemark) {
    this.recRemark = recRemark;
    return this;
  }

   /**
   * 处理备注
   * @return recRemark
  **/
  @ApiModelProperty(value = "处理备注")
  public String getRecRemark() {
    return recRemark;
  }

  public void setRecRemark(String recRemark) {
    this.recRemark = recRemark;
  }

  @JsonIgnore
  public SmFileInvoiceDTO orderCode(String orderCode) {
    this.orderCode = orderCode;
    return this;
  }

   /**
   * 业务单据编码
   * @return orderCode
  **/
  @ApiModelProperty(value = "业务单据编码")
  public String getOrderCode() {
    return orderCode;
  }

  public void setOrderCode(String orderCode) {
    this.orderCode = orderCode;
  }

  @JsonIgnore
  public SmFileInvoiceDTO billCode(String billCode) {
    this.billCode = billCode;
    return this;
  }

   /**
   * 发票代码
   * @return billCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getBillCode() {
    return billCode;
  }

  public void setBillCode(String billCode) {
    this.billCode = billCode;
  }

  @JsonIgnore
  public SmFileInvoiceDTO billCodePrn(String billCodePrn) {
    this.billCodePrn = billCodePrn;
    return this;
  }

   /**
   * 印刷发票代码
   * @return billCodePrn
  **/
  @ApiModelProperty(value = "印刷发票代码")
  public String getBillCodePrn() {
    return billCodePrn;
  }

  public void setBillCodePrn(String billCodePrn) {
    this.billCodePrn = billCodePrn;
  }

  @JsonIgnore
  public SmFileInvoiceDTO billNumber(String billNumber) {
    this.billNumber = billNumber;
    return this;
  }

   /**
   * 发票号码
   * @return billNumber
  **/
  @ApiModelProperty(value = "发票号码")
  public String getBillNumber() {
    return billNumber;
  }

  public void setBillNumber(String billNumber) {
    this.billNumber = billNumber;
  }

  @JsonIgnore
  public SmFileInvoiceDTO billNumberPrn(String billNumberPrn) {
    this.billNumberPrn = billNumberPrn;
    return this;
  }

   /**
   * 印刷发票号码
   * @return billNumberPrn
  **/
  @ApiModelProperty(value = "印刷发票号码")
  public String getBillNumberPrn() {
    return billNumberPrn;
  }

  public void setBillNumberPrn(String billNumberPrn) {
    this.billNumberPrn = billNumberPrn;
  }

  @JsonIgnore
  public SmFileInvoiceDTO purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方纳税人识别号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方纳税人识别号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public SmFileInvoiceDTO sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方纳税人识别号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方纳税人识别号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public SmFileInvoiceDTO createBillTime(Long createBillTime) {
    this.createBillTime = createBillTime;
    return this;
  }

   /**
   * 开票日期
   * @return createBillTime
  **/
  @ApiModelProperty(value = "开票日期")
  public Long getCreateBillTime() {
    return createBillTime;
  }

  public void setCreateBillTime(Long createBillTime) {
    this.createBillTime = createBillTime;
  }

  @JsonIgnore
  public SmFileInvoiceDTO notContainTaxAmount(BigDecimal notContainTaxAmount) {
    this.notContainTaxAmount = notContainTaxAmount;
    return this;
  }

   /**
   * 不含税金额
   * @return notContainTaxAmount
  **/
  @ApiModelProperty(value = "不含税金额")
  public BigDecimal getNotContainTaxAmount() {
    return notContainTaxAmount;
  }

  public void setNotContainTaxAmount(BigDecimal notContainTaxAmount) {
    this.notContainTaxAmount = notContainTaxAmount;
  }

  @JsonIgnore
  public SmFileInvoiceDTO taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public SmFileInvoiceDTO containTaxAmount(BigDecimal containTaxAmount) {
    this.containTaxAmount = containTaxAmount;
    return this;
  }

   /**
   * 含税金额
   * @return containTaxAmount
  **/
  @ApiModelProperty(value = "含税金额")
  public BigDecimal getContainTaxAmount() {
    return containTaxAmount;
  }

  public void setContainTaxAmount(BigDecimal containTaxAmount) {
    this.containTaxAmount = containTaxAmount;
  }

  @JsonIgnore
  public SmFileInvoiceDTO invoiceScanId(String invoiceScanId) {
    this.invoiceScanId = invoiceScanId;
    return this;
  }

   /**
   * 扫描id
   * @return invoiceScanId
  **/
  @ApiModelProperty(value = "扫描id")
  public String getInvoiceScanId() {
    return invoiceScanId;
  }

  public void setInvoiceScanId(String invoiceScanId) {
    this.invoiceScanId = invoiceScanId;
  }

  @JsonIgnore
  public SmFileInvoiceDTO invoiceScanTime(Long invoiceScanTime) {
    this.invoiceScanTime = invoiceScanTime;
    return this;
  }

   /**
   * 发票扫描时间
   * @return invoiceScanTime
  **/
  @ApiModelProperty(value = "发票扫描时间")
  public Long getInvoiceScanTime() {
    return invoiceScanTime;
  }

  public void setInvoiceScanTime(Long invoiceScanTime) {
    this.invoiceScanTime = invoiceScanTime;
  }

  @JsonIgnore
  public SmFileInvoiceDTO fpzt(Integer fpzt) {
    this.fpzt = fpzt;
    return this;
  }

   /**
   * 发票状态：1-正常，2-删除，3-作废
   * @return fpzt
  **/
  @ApiModelProperty(value = "发票状态：1-正常，2-删除，3-作废")
  public Integer getFpzt() {
    return fpzt;
  }

  public void setFpzt(Integer fpzt) {
    this.fpzt = fpzt;
  }

  @JsonIgnore
  public SmFileInvoiceDTO invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型：s-增值税专用发票，c-增值税普通发票，ce-增值税电子普通发票，ju-增值税普通发票（卷票），ct-通行费增值税电子普通发票，v-机动车统一销售发票
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型：s-增值税专用发票，c-增值税普通发票，ce-增值税电子普通发票，ju-增值税普通发票（卷票），ct-通行费增值税电子普通发票，v-机动车统一销售发票")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public SmFileInvoiceDTO invoiceQrcode(String invoiceQrcode) {
    this.invoiceQrcode = invoiceQrcode;
    return this;
  }

   /**
   * null
   * @return invoiceQrcode
  **/
  @ApiModelProperty(value = "null")
  public String getInvoiceQrcode() {
    return invoiceQrcode;
  }

  public void setInvoiceQrcode(String invoiceQrcode) {
    this.invoiceQrcode = invoiceQrcode;
  }

  @JsonIgnore
  public SmFileInvoiceDTO passArea(String passArea) {
    this.passArea = passArea;
    return this;
  }

   /**
   * 发票密文
   * @return passArea
  **/
  @ApiModelProperty(value = "发票密文")
  public String getPassArea() {
    return passArea;
  }

  public void setPassArea(String passArea) {
    this.passArea = passArea;
  }

  @JsonIgnore
  public SmFileInvoiceDTO createBillTimestr(String createBillTimestr) {
    this.createBillTimestr = createBillTimestr;
    return this;
  }

   /**
   * 开票日期字符串
   * @return createBillTimestr
  **/
  @ApiModelProperty(value = "开票日期字符串")
  public String getCreateBillTimestr() {
    return createBillTimestr;
  }

  public void setCreateBillTimestr(String createBillTimestr) {
    this.createBillTimestr = createBillTimestr;
  }

  @JsonIgnore
  public SmFileInvoiceDTO scanBatchNo(String scanBatchNo) {
    this.scanBatchNo = scanBatchNo;
    return this;
  }

   /**
   * 扫描批次号
   * @return scanBatchNo
  **/
  @ApiModelProperty(value = "扫描批次号")
  public String getScanBatchNo() {
    return scanBatchNo;
  }

  public void setScanBatchNo(String scanBatchNo) {
    this.scanBatchNo = scanBatchNo;
  }

  @JsonIgnore
  public SmFileInvoiceDTO cooperateFlag(Integer cooperateFlag) {
    this.cooperateFlag = cooperateFlag;
    return this;
  }

   /**
   * 是否协同：0-非协同，1-协同
   * @return cooperateFlag
  **/
  @ApiModelProperty(value = "是否协同：0-非协同，1-协同")
  public Integer getCooperateFlag() {
    return cooperateFlag;
  }

  public void setCooperateFlag(Integer cooperateFlag) {
    this.cooperateFlag = cooperateFlag;
  }

  @JsonIgnore
  public SmFileInvoiceDTO sellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
    return this;
  }

   /**
   * 销方电话
   * @return sellerTel
  **/
  @ApiModelProperty(value = "销方电话")
  public String getSellerTel() {
    return sellerTel;
  }

  public void setSellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
  }

  @JsonIgnore
  public SmFileInvoiceDTO sellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
    return this;
  }

   /**
   * 销方地址
   * @return sellerAddress
  **/
  @ApiModelProperty(value = "销方地址")
  public String getSellerAddress() {
    return sellerAddress;
  }

  public void setSellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
  }

  @JsonIgnore
  public SmFileInvoiceDTO sellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
    return this;
  }

   /**
   * 销方银行名称
   * @return sellerBankName
  **/
  @ApiModelProperty(value = "销方银行名称")
  public String getSellerBankName() {
    return sellerBankName;
  }

  public void setSellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
  }

  @JsonIgnore
  public SmFileInvoiceDTO sellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
    return this;
  }

   /**
   * 销方银行卡号
   * @return sellerBankAccount
  **/
  @ApiModelProperty(value = "销方银行卡号")
  public String getSellerBankAccount() {
    return sellerBankAccount;
  }

  public void setSellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
  }

  @JsonIgnore
  public SmFileInvoiceDTO purchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
    return this;
  }

   /**
   * 购方电话
   * @return purchaserTel
  **/
  @ApiModelProperty(value = "购方电话")
  public String getPurchaserTel() {
    return purchaserTel;
  }

  public void setPurchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
  }

  @JsonIgnore
  public SmFileInvoiceDTO purchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
    return this;
  }

   /**
   * 购方地址
   * @return purchaserAddress
  **/
  @ApiModelProperty(value = "购方地址")
  public String getPurchaserAddress() {
    return purchaserAddress;
  }

  public void setPurchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
  }

  @JsonIgnore
  public SmFileInvoiceDTO purchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
    return this;
  }

   /**
   * 购方银行名称
   * @return purchaserBankAccount
  **/
  @ApiModelProperty(value = "购方银行名称")
  public String getPurchaserBankAccount() {
    return purchaserBankAccount;
  }

  public void setPurchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
  }

  @JsonIgnore
  public SmFileInvoiceDTO purchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
    return this;
  }

   /**
   * 购方银行卡号
   * @return purchaserBankName
  **/
  @ApiModelProperty(value = "购方银行卡号")
  public String getPurchaserBankName() {
    return purchaserBankName;
  }

  public void setPurchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
  }

  @JsonIgnore
  public SmFileInvoiceDTO taxRate(String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public SmFileInvoiceDTO remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public SmFileInvoiceDTO chargeTaxUnitCode(String chargeTaxUnitCode) {
    this.chargeTaxUnitCode = chargeTaxUnitCode;
    return this;
  }

   /**
   * null
   * @return chargeTaxUnitCode
  **/
  @ApiModelProperty(value = "null")
  public String getChargeTaxUnitCode() {
    return chargeTaxUnitCode;
  }

  public void setChargeTaxUnitCode(String chargeTaxUnitCode) {
    this.chargeTaxUnitCode = chargeTaxUnitCode;
  }

  @JsonIgnore
  public SmFileInvoiceDTO twoCodeFlag(String twoCodeFlag) {
    this.twoCodeFlag = twoCodeFlag;
    return this;
  }

   /**
   * null
   * @return twoCodeFlag
  **/
  @ApiModelProperty(value = "null")
  public String getTwoCodeFlag() {
    return twoCodeFlag;
  }

  public void setTwoCodeFlag(String twoCodeFlag) {
    this.twoCodeFlag = twoCodeFlag;
  }

  @JsonIgnore
  public SmFileInvoiceDTO chargeTaxUnitName(String chargeTaxUnitName) {
    this.chargeTaxUnitName = chargeTaxUnitName;
    return this;
  }

   /**
   * null
   * @return chargeTaxUnitName
  **/
  @ApiModelProperty(value = "null")
  public String getChargeTaxUnitName() {
    return chargeTaxUnitName;
  }

  public void setChargeTaxUnitName(String chargeTaxUnitName) {
    this.chargeTaxUnitName = chargeTaxUnitName;
  }

  @JsonIgnore
  public SmFileInvoiceDTO cloudIdentifyFlag(Integer cloudIdentifyFlag) {
    this.cloudIdentifyFlag = cloudIdentifyFlag;
    return this;
  }

   /**
   * null
   * @return cloudIdentifyFlag
  **/
  @ApiModelProperty(value = "null")
  public Integer getCloudIdentifyFlag() {
    return cloudIdentifyFlag;
  }

  public void setCloudIdentifyFlag(Integer cloudIdentifyFlag) {
    this.cloudIdentifyFlag = cloudIdentifyFlag;
  }

  @JsonIgnore
  public SmFileInvoiceDTO cloudIdentifyRemark(String cloudIdentifyRemark) {
    this.cloudIdentifyRemark = cloudIdentifyRemark;
    return this;
  }

   /**
   * null
   * @return cloudIdentifyRemark
  **/
  @ApiModelProperty(value = "null")
  public String getCloudIdentifyRemark() {
    return cloudIdentifyRemark;
  }

  public void setCloudIdentifyRemark(String cloudIdentifyRemark) {
    this.cloudIdentifyRemark = cloudIdentifyRemark;
  }

  @JsonIgnore
  public SmFileInvoiceDTO machineCode(String machineCode) {
    this.machineCode = machineCode;
    return this;
  }

   /**
   * 机器编码
   * @return machineCode
  **/
  @ApiModelProperty(value = "机器编码")
  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  @JsonIgnore
  public SmFileInvoiceDTO purchaseName(String purchaseName) {
    this.purchaseName = purchaseName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaseName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaseName() {
    return purchaseName;
  }

  public void setPurchaseName(String purchaseName) {
    this.purchaseName = purchaseName;
  }

  @JsonIgnore
  public SmFileInvoiceDTO sellerTaxName(String sellerTaxName) {
    this.sellerTaxName = sellerTaxName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerTaxName
  **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerTaxName() {
    return sellerTaxName;
  }

  public void setSellerTaxName(String sellerTaxName) {
    this.sellerTaxName = sellerTaxName;
  }

  @JsonIgnore
  public SmFileInvoiceDTO checkCode(String checkCode) {
    this.checkCode = checkCode;
    return this;
  }

   /**
   * 校验码
   * @return checkCode
  **/
  @ApiModelProperty(value = "校验码")
  public String getCheckCode() {
    return checkCode;
  }

  public void setCheckCode(String checkCode) {
    this.checkCode = checkCode;
  }

  @JsonIgnore
  public SmFileInvoiceDTO containTaxAmountChn(String containTaxAmountChn) {
    this.containTaxAmountChn = containTaxAmountChn;
    return this;
  }

   /**
   * 含税金额大写
   * @return containTaxAmountChn
  **/
  @ApiModelProperty(value = "含税金额大写")
  public String getContainTaxAmountChn() {
    return containTaxAmountChn;
  }

  public void setContainTaxAmountChn(String containTaxAmountChn) {
    this.containTaxAmountChn = containTaxAmountChn;
  }

  @JsonIgnore
  public SmFileInvoiceDTO interceptInfo(String interceptInfo) {
    this.interceptInfo = interceptInfo;
    return this;
  }

   /**
   * 拦截信息
   * @return interceptInfo
  **/
  @ApiModelProperty(value = "拦截信息")
  public String getInterceptInfo() {
    return interceptInfo;
  }

  public void setInterceptInfo(String interceptInfo) {
    this.interceptInfo = interceptInfo;
  }

  @JsonIgnore
  public SmFileInvoiceDTO warningInfo(String warningInfo) {
    this.warningInfo = warningInfo;
    return this;
  }

   /**
   * 预警信息
   * @return warningInfo
  **/
  @ApiModelProperty(value = "预警信息")
  public String getWarningInfo() {
    return warningInfo;
  }

  public void setWarningInfo(String warningInfo) {
    this.warningInfo = warningInfo;
  }

  @JsonIgnore
  public SmFileInvoiceDTO specialInvoiceFlag(Integer specialInvoiceFlag) {
    this.specialInvoiceFlag = specialInvoiceFlag;
    return this;
  }

   /**
   * 特殊发票标记：0-默认，1-通行费，2-成品油
   * @return specialInvoiceFlag
  **/
  @ApiModelProperty(value = "特殊发票标记：0-默认，1-通行费，2-成品油")
  public Integer getSpecialInvoiceFlag() {
    return specialInvoiceFlag;
  }

  public void setSpecialInvoiceFlag(Integer specialInvoiceFlag) {
    this.specialInvoiceFlag = specialInvoiceFlag;
  }

  @JsonIgnore
  public SmFileInvoiceDTO payee(String payee) {
    this.payee = payee;
    return this;
  }

   /**
   * 收款人
   * @return payee
  **/
  @ApiModelProperty(value = "收款人")
  public String getPayee() {
    return payee;
  }

  public void setPayee(String payee) {
    this.payee = payee;
  }

  @JsonIgnore
  public SmFileInvoiceDTO reviewer(String reviewer) {
    this.reviewer = reviewer;
    return this;
  }

   /**
   * 复核人
   * @return reviewer
  **/
  @ApiModelProperty(value = "复核人")
  public String getReviewer() {
    return reviewer;
  }

  public void setReviewer(String reviewer) {
    this.reviewer = reviewer;
  }

  @JsonIgnore
  public SmFileInvoiceDTO drawer(String drawer) {
    this.drawer = drawer;
    return this;
  }

   /**
   * 开票人
   * @return drawer
  **/
  @ApiModelProperty(value = "开票人")
  public String getDrawer() {
    return drawer;
  }

  public void setDrawer(String drawer) {
    this.drawer = drawer;
  }

  @JsonIgnore
  public SmFileInvoiceDTO createUser(String createUser) {
    this.createUser = createUser;
    return this;
  }

   /**
   * 创建用户名
   * @return createUser
  **/
  @ApiModelProperty(value = "创建用户名")
  public String getCreateUser() {
    return createUser;
  }

  public void setCreateUser(String createUser) {
    this.createUser = createUser;
  }

  @JsonIgnore
  public SmFileInvoiceDTO createUserId(Long createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建账号
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建账号")
  public Long getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(Long createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public SmFileInvoiceDTO createTime(Long createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public Long getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Long createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public SmFileInvoiceDTO updateUserId(Long updateUserId) {
    this.updateUserId = updateUserId;
    return this;
  }

   /**
   * 更新账号
   * @return updateUserId
  **/
  @ApiModelProperty(value = "更新账号")
  public Long getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(Long updateUserId) {
    this.updateUserId = updateUserId;
  }

  @JsonIgnore
  public SmFileInvoiceDTO updateTime(Long updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public Long getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(Long updateTime) {
    this.updateTime = updateTime;
  }

  @JsonIgnore
  public SmFileInvoiceDTO invoiceSheet(Integer invoiceSheet) {
    this.invoiceSheet = invoiceSheet;
    return this;
  }

   /**
   * 发票联次：1-发票联，2-抵扣联
   * @return invoiceSheet
  **/
  @ApiModelProperty(value = "发票联次：1-发票联，2-抵扣联")
  public Integer getInvoiceSheet() {
    return invoiceSheet;
  }

  public void setInvoiceSheet(Integer invoiceSheet) {
    this.invoiceSheet = invoiceSheet;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SmFileInvoiceDTO smFileInvoiceDTO = (SmFileInvoiceDTO) o;
    return Objects.equals(this.id, smFileInvoiceDTO.id) &&
        Objects.equals(this.batchId, smFileInvoiceDTO.batchId) &&
        Objects.equals(this.bizType, smFileInvoiceDTO.bizType) &&
        Objects.equals(this.source, smFileInvoiceDTO.source) &&
        Objects.equals(this.requireOcrFlag, smFileInvoiceDTO.requireOcrFlag) &&
        Objects.equals(this.fileUrl, smFileInvoiceDTO.fileUrl) &&
        Objects.equals(this.fileUrlHandle, smFileInvoiceDTO.fileUrlHandle) &&
        Objects.equals(this.fileType, smFileInvoiceDTO.fileType) &&
        Objects.equals(this.fileTypeHandle, smFileInvoiceDTO.fileTypeHandle) &&
        Objects.equals(this.fileOrder, smFileInvoiceDTO.fileOrder) &&
        Objects.equals(this.fileLevel, smFileInvoiceDTO.fileLevel) &&
        Objects.equals(this.billSeq, smFileInvoiceDTO.billSeq) &&
        Objects.equals(this.invoiceSeq, smFileInvoiceDTO.invoiceSeq) &&
        Objects.equals(this.attachmentSeq, smFileInvoiceDTO.attachmentSeq) &&
        Objects.equals(this.recStatus, smFileInvoiceDTO.recStatus) &&
        Objects.equals(this.taskId, smFileInvoiceDTO.taskId) &&
        Objects.equals(this.recStartTime, smFileInvoiceDTO.recStartTime) &&
        Objects.equals(this.recEndTime, smFileInvoiceDTO.recEndTime) &&
        Objects.equals(this.recRemark, smFileInvoiceDTO.recRemark) &&
        Objects.equals(this.orderCode, smFileInvoiceDTO.orderCode) &&
        Objects.equals(this.billCode, smFileInvoiceDTO.billCode) &&
        Objects.equals(this.billCodePrn, smFileInvoiceDTO.billCodePrn) &&
        Objects.equals(this.billNumber, smFileInvoiceDTO.billNumber) &&
        Objects.equals(this.billNumberPrn, smFileInvoiceDTO.billNumberPrn) &&
        Objects.equals(this.purchaserTaxNo, smFileInvoiceDTO.purchaserTaxNo) &&
        Objects.equals(this.sellerTaxNo, smFileInvoiceDTO.sellerTaxNo) &&
        Objects.equals(this.createBillTime, smFileInvoiceDTO.createBillTime) &&
        Objects.equals(this.notContainTaxAmount, smFileInvoiceDTO.notContainTaxAmount) &&
        Objects.equals(this.taxAmount, smFileInvoiceDTO.taxAmount) &&
        Objects.equals(this.containTaxAmount, smFileInvoiceDTO.containTaxAmount) &&
        Objects.equals(this.invoiceScanId, smFileInvoiceDTO.invoiceScanId) &&
        Objects.equals(this.invoiceScanTime, smFileInvoiceDTO.invoiceScanTime) &&
        Objects.equals(this.fpzt, smFileInvoiceDTO.fpzt) &&
        Objects.equals(this.invoiceType, smFileInvoiceDTO.invoiceType) &&
        Objects.equals(this.invoiceQrcode, smFileInvoiceDTO.invoiceQrcode) &&
        Objects.equals(this.passArea, smFileInvoiceDTO.passArea) &&
        Objects.equals(this.createBillTimestr, smFileInvoiceDTO.createBillTimestr) &&
        Objects.equals(this.scanBatchNo, smFileInvoiceDTO.scanBatchNo) &&
        Objects.equals(this.cooperateFlag, smFileInvoiceDTO.cooperateFlag) &&
        Objects.equals(this.sellerTel, smFileInvoiceDTO.sellerTel) &&
        Objects.equals(this.sellerAddress, smFileInvoiceDTO.sellerAddress) &&
        Objects.equals(this.sellerBankName, smFileInvoiceDTO.sellerBankName) &&
        Objects.equals(this.sellerBankAccount, smFileInvoiceDTO.sellerBankAccount) &&
        Objects.equals(this.purchaserTel, smFileInvoiceDTO.purchaserTel) &&
        Objects.equals(this.purchaserAddress, smFileInvoiceDTO.purchaserAddress) &&
        Objects.equals(this.purchaserBankAccount, smFileInvoiceDTO.purchaserBankAccount) &&
        Objects.equals(this.purchaserBankName, smFileInvoiceDTO.purchaserBankName) &&
        Objects.equals(this.taxRate, smFileInvoiceDTO.taxRate) &&
        Objects.equals(this.remark, smFileInvoiceDTO.remark) &&
        Objects.equals(this.chargeTaxUnitCode, smFileInvoiceDTO.chargeTaxUnitCode) &&
        Objects.equals(this.twoCodeFlag, smFileInvoiceDTO.twoCodeFlag) &&
        Objects.equals(this.chargeTaxUnitName, smFileInvoiceDTO.chargeTaxUnitName) &&
        Objects.equals(this.cloudIdentifyFlag, smFileInvoiceDTO.cloudIdentifyFlag) &&
        Objects.equals(this.cloudIdentifyRemark, smFileInvoiceDTO.cloudIdentifyRemark) &&
        Objects.equals(this.machineCode, smFileInvoiceDTO.machineCode) &&
        Objects.equals(this.purchaseName, smFileInvoiceDTO.purchaseName) &&
        Objects.equals(this.sellerTaxName, smFileInvoiceDTO.sellerTaxName) &&
        Objects.equals(this.checkCode, smFileInvoiceDTO.checkCode) &&
        Objects.equals(this.containTaxAmountChn, smFileInvoiceDTO.containTaxAmountChn) &&
        Objects.equals(this.interceptInfo, smFileInvoiceDTO.interceptInfo) &&
        Objects.equals(this.warningInfo, smFileInvoiceDTO.warningInfo) &&
        Objects.equals(this.specialInvoiceFlag, smFileInvoiceDTO.specialInvoiceFlag) &&
        Objects.equals(this.payee, smFileInvoiceDTO.payee) &&
        Objects.equals(this.reviewer, smFileInvoiceDTO.reviewer) &&
        Objects.equals(this.drawer, smFileInvoiceDTO.drawer) &&
        Objects.equals(this.createUser, smFileInvoiceDTO.createUser) &&
        Objects.equals(this.createUserId, smFileInvoiceDTO.createUserId) &&
        Objects.equals(this.createTime, smFileInvoiceDTO.createTime) &&
        Objects.equals(this.updateUserId, smFileInvoiceDTO.updateUserId) &&
        Objects.equals(this.updateTime, smFileInvoiceDTO.updateTime) &&
        Objects.equals(this.invoiceSheet, smFileInvoiceDTO.invoiceSheet);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, batchId, bizType, source, requireOcrFlag, fileUrl, fileUrlHandle, fileType, fileTypeHandle, fileOrder, fileLevel, billSeq, invoiceSeq, attachmentSeq, recStatus, taskId, recStartTime, recEndTime, recRemark, orderCode, billCode, billCodePrn, billNumber, billNumberPrn, purchaserTaxNo, sellerTaxNo, createBillTime, notContainTaxAmount, taxAmount, containTaxAmount, invoiceScanId, invoiceScanTime, fpzt, invoiceType, invoiceQrcode, passArea, createBillTimestr, scanBatchNo, cooperateFlag, sellerTel, sellerAddress, sellerBankName, sellerBankAccount, purchaserTel, purchaserAddress, purchaserBankAccount, purchaserBankName, taxRate, remark, chargeTaxUnitCode, twoCodeFlag, chargeTaxUnitName, cloudIdentifyFlag, cloudIdentifyRemark, machineCode, purchaseName, sellerTaxName, checkCode, containTaxAmountChn, interceptInfo, warningInfo, specialInvoiceFlag, payee, reviewer, drawer, createUser, createUserId, createTime, updateUserId, updateTime, invoiceSheet);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SmFileInvoiceDTO {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    batchId: ").append(toIndentedString(batchId)).append("\n");
    sb.append("    bizType: ").append(toIndentedString(bizType)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    requireOcrFlag: ").append(toIndentedString(requireOcrFlag)).append("\n");
    sb.append("    fileUrl: ").append(toIndentedString(fileUrl)).append("\n");
    sb.append("    fileUrlHandle: ").append(toIndentedString(fileUrlHandle)).append("\n");
    sb.append("    fileType: ").append(toIndentedString(fileType)).append("\n");
    sb.append("    fileTypeHandle: ").append(toIndentedString(fileTypeHandle)).append("\n");
    sb.append("    fileOrder: ").append(toIndentedString(fileOrder)).append("\n");
    sb.append("    fileLevel: ").append(toIndentedString(fileLevel)).append("\n");
    sb.append("    billSeq: ").append(toIndentedString(billSeq)).append("\n");
    sb.append("    invoiceSeq: ").append(toIndentedString(invoiceSeq)).append("\n");
    sb.append("    attachmentSeq: ").append(toIndentedString(attachmentSeq)).append("\n");
    sb.append("    recStatus: ").append(toIndentedString(recStatus)).append("\n");
    sb.append("    taskId: ").append(toIndentedString(taskId)).append("\n");
    sb.append("    recStartTime: ").append(toIndentedString(recStartTime)).append("\n");
    sb.append("    recEndTime: ").append(toIndentedString(recEndTime)).append("\n");
    sb.append("    recRemark: ").append(toIndentedString(recRemark)).append("\n");
    sb.append("    orderCode: ").append(toIndentedString(orderCode)).append("\n");
    sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
    sb.append("    billCodePrn: ").append(toIndentedString(billCodePrn)).append("\n");
    sb.append("    billNumber: ").append(toIndentedString(billNumber)).append("\n");
    sb.append("    billNumberPrn: ").append(toIndentedString(billNumberPrn)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    createBillTime: ").append(toIndentedString(createBillTime)).append("\n");
    sb.append("    notContainTaxAmount: ").append(toIndentedString(notContainTaxAmount)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    containTaxAmount: ").append(toIndentedString(containTaxAmount)).append("\n");
    sb.append("    invoiceScanId: ").append(toIndentedString(invoiceScanId)).append("\n");
    sb.append("    invoiceScanTime: ").append(toIndentedString(invoiceScanTime)).append("\n");
    sb.append("    fpzt: ").append(toIndentedString(fpzt)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    invoiceQrcode: ").append(toIndentedString(invoiceQrcode)).append("\n");
    sb.append("    passArea: ").append(toIndentedString(passArea)).append("\n");
    sb.append("    createBillTimestr: ").append(toIndentedString(createBillTimestr)).append("\n");
    sb.append("    scanBatchNo: ").append(toIndentedString(scanBatchNo)).append("\n");
    sb.append("    cooperateFlag: ").append(toIndentedString(cooperateFlag)).append("\n");
    sb.append("    sellerTel: ").append(toIndentedString(sellerTel)).append("\n");
    sb.append("    sellerAddress: ").append(toIndentedString(sellerAddress)).append("\n");
    sb.append("    sellerBankName: ").append(toIndentedString(sellerBankName)).append("\n");
    sb.append("    sellerBankAccount: ").append(toIndentedString(sellerBankAccount)).append("\n");
    sb.append("    purchaserTel: ").append(toIndentedString(purchaserTel)).append("\n");
    sb.append("    purchaserAddress: ").append(toIndentedString(purchaserAddress)).append("\n");
    sb.append("    purchaserBankAccount: ").append(toIndentedString(purchaserBankAccount)).append("\n");
    sb.append("    purchaserBankName: ").append(toIndentedString(purchaserBankName)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    chargeTaxUnitCode: ").append(toIndentedString(chargeTaxUnitCode)).append("\n");
    sb.append("    twoCodeFlag: ").append(toIndentedString(twoCodeFlag)).append("\n");
    sb.append("    chargeTaxUnitName: ").append(toIndentedString(chargeTaxUnitName)).append("\n");
    sb.append("    cloudIdentifyFlag: ").append(toIndentedString(cloudIdentifyFlag)).append("\n");
    sb.append("    cloudIdentifyRemark: ").append(toIndentedString(cloudIdentifyRemark)).append("\n");
    sb.append("    machineCode: ").append(toIndentedString(machineCode)).append("\n");
    sb.append("    purchaseName: ").append(toIndentedString(purchaseName)).append("\n");
    sb.append("    sellerTaxName: ").append(toIndentedString(sellerTaxName)).append("\n");
    sb.append("    checkCode: ").append(toIndentedString(checkCode)).append("\n");
    sb.append("    containTaxAmountChn: ").append(toIndentedString(containTaxAmountChn)).append("\n");
    sb.append("    interceptInfo: ").append(toIndentedString(interceptInfo)).append("\n");
    sb.append("    warningInfo: ").append(toIndentedString(warningInfo)).append("\n");
    sb.append("    specialInvoiceFlag: ").append(toIndentedString(specialInvoiceFlag)).append("\n");
    sb.append("    payee: ").append(toIndentedString(payee)).append("\n");
    sb.append("    reviewer: ").append(toIndentedString(reviewer)).append("\n");
    sb.append("    drawer: ").append(toIndentedString(drawer)).append("\n");
    sb.append("    createUser: ").append(toIndentedString(createUser)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    invoiceSheet: ").append(toIndentedString(invoiceSheet)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
