package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.vanke.in.client.model.SubmitParcelsItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 提交的包裹信息
 */
@ApiModel(description = "提交的包裹信息")

@JsonInclude(NON_NULL)
public class SubmitParcelsRequest extends BaseRequest {
  @JsonProperty("itemList")
  private List<SubmitParcelsItem> itemList = new ArrayList<SubmitParcelsItem>();

  @JsonIgnore
  public SubmitParcelsRequest itemList(List<SubmitParcelsItem> itemList) {
    this.itemList = itemList;
    return this;
  }

  public SubmitParcelsRequest addItemListItem(SubmitParcelsItem itemListItem) {
    this.itemList.add(itemListItem);
    return this;
  }

   /**
   * Get itemList
   * @return itemList
  **/
  @ApiModelProperty(value = "")
  public List<SubmitParcelsItem> getItemList() {
    return itemList;
  }

  public void setItemList(List<SubmitParcelsItem> itemList) {
    this.itemList = itemList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SubmitParcelsRequest submitParcelsRequest = (SubmitParcelsRequest) o;
    return Objects.equals(this.itemList, submitParcelsRequest.itemList) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(itemList, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SubmitParcelsRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    itemList: ").append(toIndentedString(itemList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
