package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.vanke.in.client.model.WkInvoiceDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发票主表Request
 */
@ApiModel(description = "发票主表Request")

@JsonInclude(NON_NULL)
public class UpdateInvoiceRequest extends BaseRequest {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("createTime")
  private Long createTime = null;

  @JsonProperty("updateTime")
  private Long updateTime = null;

  @JsonProperty("salesbillId")
  private Long salesbillId = null;

  @JsonProperty("salesbillNo")
  private String salesbillNo = null;

  @JsonProperty("packageCode")
  private String packageCode = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("purchaserAddress")
  private String purchaserAddress = null;

  @JsonProperty("purchaserTel")
  private String purchaserTel = null;

  @JsonProperty("purchaserAddrTel")
  private String purchaserAddrTel = null;

  @JsonProperty("purchaserBankName")
  private String purchaserBankName = null;

  @JsonProperty("purchaserBankAccount")
  private String purchaserBankAccount = null;

  @JsonProperty("purchaserBankNameAccount")
  private String purchaserBankNameAccount = null;

  @JsonProperty("purchaserExternalCode")
  private String purchaserExternalCode = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("sellerAddress")
  private String sellerAddress = null;

  @JsonProperty("sellerTel")
  private String sellerTel = null;

  @JsonProperty("sellerAddrTel")
  private String sellerAddrTel = null;

  @JsonProperty("sellerBankName")
  private String sellerBankName = null;

  @JsonProperty("sellerBankAccount")
  private String sellerBankAccount = null;

  @JsonProperty("sellerBankNameAccount")
  private String sellerBankNameAccount = null;

  @JsonProperty("sellerExternalCode")
  private String sellerExternalCode = null;

  @JsonProperty("sellerInvoiceId")
  private Long sellerInvoiceId = null;

  @JsonProperty("sellerUserName")
  private String sellerUserName = null;

  @JsonProperty("sellerViewImageFlag")
  private Integer sellerViewImageFlag = null;

  @JsonProperty("sellerSyncStatus")
  private Integer sellerSyncStatus = null;

  @JsonProperty("sellerSyncTime")
  private Long sellerSyncTime = null;

  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("amountWithoutTax")
  private BigDecimal amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("amountWithTax")
  private BigDecimal amountWithTax = null;

  @JsonProperty("amountWithTaxCapital")
  private String amountWithTaxCapital = null;

  @JsonProperty("paperDrewDate")
  private String paperDrewDate = null;

  @JsonProperty("machineCode")
  private String machineCode = null;

  @JsonProperty("checkCode")
  private String checkCode = null;

  @JsonProperty("cipherText")
  private String cipherText = null;

  @JsonProperty("invoiceOrig")
  private Integer invoiceOrig = null;

  @JsonProperty("dataFromSystem")
  private String dataFromSystem = null;

  @JsonProperty("specialInvoiceFlag")
  private Integer specialInvoiceFlag = null;

  @JsonProperty("titleOkFlag")
  private Integer titleOkFlag = null;

  @JsonProperty("saleListFlag")
  private Integer saleListFlag = null;

  @JsonProperty("dataOkFlag")
  private Integer dataOkFlag = null;

  @JsonProperty("recogStatus")
  private Integer recogStatus = null;

  @JsonProperty("recogImageStatus")
  private Integer recogImageStatus = null;

  @JsonProperty("recogInvoiceId")
  private Long recogInvoiceId = null;

  @JsonProperty("recogResponseTime")
  private Long recogResponseTime = null;

  @JsonProperty("recogUserName")
  private String recogUserName = null;

  @JsonProperty("recogUploadNum")
  private Integer recogUploadNum = null;

  @JsonProperty("veriInvoiceId")
  private Long veriInvoiceId = null;

  @JsonProperty("veriStatus")
  private Integer veriStatus = null;

  @JsonProperty("veriRequestTime")
  private Long veriRequestTime = null;

  @JsonProperty("veriResponseTime")
  private Long veriResponseTime = null;

  @JsonProperty("veriUserId")
  private Long veriUserId = null;

  @JsonProperty("veriUserName")
  private String veriUserName = null;

  @JsonProperty("veriRemark")
  private String veriRemark = null;

  @JsonProperty("taxInvoiceId")
  private Long taxInvoiceId = null;

  @JsonProperty("authSyncStatus")
  private Integer authSyncStatus = null;

  @JsonProperty("authSyncTime")
  private Long authSyncTime = null;

  @JsonProperty("authStatus")
  private Integer authStatus = null;

  @JsonProperty("authStyle")
  private Integer authStyle = null;

  @JsonProperty("authBussiDate")
  private String authBussiDate = null;

  @JsonProperty("authTaxPeriod")
  private String authTaxPeriod = null;

  @JsonProperty("authRequestTime")
  private Long authRequestTime = null;

  @JsonProperty("authResponseTime")
  private Long authResponseTime = null;

  @JsonProperty("authRequestUserId")
  private Long authRequestUserId = null;

  @JsonProperty("authRequestUserName")
  private String authRequestUserName = null;

  @JsonProperty("authRequestSerialNo")
  private String authRequestSerialNo = null;

  @JsonProperty("authRemark")
  private String authRemark = null;

  @JsonProperty("authValidTime")
  private Long authValidTime = null;

  @JsonProperty("authValidResult")
  private Integer authValidResult = null;

  @JsonProperty("authValidRemark")
  private String authValidRemark = null;

  @JsonProperty("authAmountWithoutTax")
  private BigDecimal authAmountWithoutTax = null;

  @JsonProperty("authTaxAmount")
  private BigDecimal authTaxAmount = null;

  @JsonProperty("authCount")
  private Integer authCount = null;

  @JsonProperty("authReturnTime")
  private Long authReturnTime = null;

  @JsonProperty("actualAuthWay")
  private Integer actualAuthWay = null;

  @JsonProperty("redStatus")
  private Integer redStatus = null;

  @JsonProperty("redTime")
  private Long redTime = null;

  @JsonProperty("redNotificationNo")
  private String redNotificationNo = null;

  @JsonProperty("redUserId")
  private Long redUserId = null;

  @JsonProperty("redUserName")
  private String redUserName = null;

  @JsonProperty("originInvoiceNo")
  private String originInvoiceNo = null;

  @JsonProperty("originInvoiceCode")
  private String originInvoiceCode = null;

  @JsonProperty("redRemark")
  private String redRemark = null;

  @JsonProperty("retreatStatus")
  private Integer retreatStatus = null;

  @JsonProperty("retreatTime")
  private Long retreatTime = null;

  @JsonProperty("retreatUserId")
  private Long retreatUserId = null;

  @JsonProperty("retreatUserName")
  private String retreatUserName = null;

  @JsonProperty("retreatRemark")
  private String retreatRemark = null;

  @JsonProperty("originSalesbillId")
  private Long originSalesbillId = null;

  @JsonProperty("originSalesbillNo")
  private String originSalesbillNo = null;

  @JsonProperty("cashierName")
  private String cashierName = null;

  @JsonProperty("checkerName")
  private String checkerName = null;

  @JsonProperty("invoicerName")
  private String invoicerName = null;

  @JsonProperty("provinceCode")
  private Integer provinceCode = null;

  @JsonProperty("provinceName")
  private String provinceName = null;

  @JsonProperty("recogUserId")
  private Long recogUserId = null;

  @JsonProperty("recogDeductionImageUrl")
  private String recogDeductionImageUrl = null;

  @JsonProperty("recogInvoiceImageUrl")
  private String recogInvoiceImageUrl = null;

  @JsonProperty("pdfUrl")
  private String pdfUrl = null;

  @JsonProperty("vehicleType")
  private String vehicleType = null;

  @JsonProperty("vehicleBrand")
  private String vehicleBrand = null;

  @JsonProperty("productionArea")
  private String productionArea = null;

  @JsonProperty("certNo")
  private String certNo = null;

  @JsonProperty("importCertNo")
  private String importCertNo = null;

  @JsonProperty("inspectionNo")
  private String inspectionNo = null;

  @JsonProperty("engineNo")
  private String engineNo = null;

  @JsonProperty("organizationCode")
  private String organizationCode = null;

  @JsonProperty("vin")
  private String vin = null;

  @JsonProperty("tonnage")
  private String tonnage = null;

  @JsonProperty("taxPaidProof")
  private String taxPaidProof = null;

  @JsonProperty("maxCapacity")
  private String maxCapacity = null;

  @JsonProperty("taxAuthName")
  private String taxAuthName = null;

  @JsonProperty("taxAuthCode")
  private String taxAuthCode = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("invoiceCheckStatus")
  private Integer invoiceCheckStatus = null;

  @JsonProperty("invoiceCheckNote")
  private String invoiceCheckNote = null;

  @JsonProperty("invoiceCheckPerson")
  private String invoiceCheckPerson = null;

  @JsonProperty("invoiceCheckTime")
  private Long invoiceCheckTime = null;

  @JsonProperty("smInvoiceCode")
  private String smInvoiceCode = null;

  @JsonProperty("smInvoiceNo")
  private String smInvoiceNo = null;

  @JsonProperty("smPurchaserTaxNo")
  private String smPurchaserTaxNo = null;

  @JsonProperty("smSellerTaxNo")
  private String smSellerTaxNo = null;

  @JsonProperty("smPaperDrewDate")
  private String smPaperDrewDate = null;

  @JsonProperty("smAmountWithoutTax")
  private String smAmountWithoutTax = null;

  @JsonProperty("smTaxAmount")
  private String smTaxAmount = null;

  @JsonProperty("smAmountWithTax")
  private String smAmountWithTax = null;

  @JsonProperty("smUpdator")
  private String smUpdator = null;

  @JsonProperty("smBarcode")
  private String smBarcode = null;

  @JsonProperty("smImgUrl")
  private String smImgUrl = null;

  @JsonProperty("smInvoiceId")
  private String smInvoiceId = null;

  @JsonProperty("smInvoiceSource")
  private Integer smInvoiceSource = null;

  @JsonProperty("enInvoiceCode")
  private String enInvoiceCode = null;

  @JsonProperty("enInvoiceNo")
  private String enInvoiceNo = null;

  @JsonProperty("enPurchaserTaxNo")
  private String enPurchaserTaxNo = null;

  @JsonProperty("enSellerTaxNo")
  private String enSellerTaxNo = null;

  @JsonProperty("enPaperDrewDate")
  private String enPaperDrewDate = null;

  @JsonProperty("enAmountWithoutTax")
  private String enAmountWithoutTax = null;

  @JsonProperty("enTaxAmount")
  private String enTaxAmount = null;

  @JsonProperty("enAmountWithTax")
  private String enAmountWithTax = null;

  @JsonProperty("enTaxRate")
  private BigDecimal enTaxRate = null;

  @JsonProperty("isPushTask")
  private Integer isPushTask = null;

  @JsonProperty("isObsolete")
  private Integer isObsolete = null;

  @JsonProperty("isResult")
  private Integer isResult = null;

  @JsonProperty("ifRepeat")
  private Integer ifRepeat = null;

  @JsonProperty("ifAuthFlag")
  private Integer ifAuthFlag = null;

  @JsonProperty("isLegalSynergetics")
  private Integer isLegalSynergetics = null;

  @JsonProperty("signStatus")
  private Integer signStatus = null;

  @JsonProperty("ifSendExption")
  private Integer ifSendExption = null;

  @JsonIgnore
  public UpdateInvoiceRequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * null
   * @return id
  **/
  @ApiModelProperty(value = "null")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public UpdateInvoiceRequest invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型：s-增值税专用发票 c-增值税普通发票ce-增值税电子普通发票ju-增值税普通发票（卷票）ct-通行费增值税电子普通发票v-机动车统一销售发票
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型：s-增值税专用发票 c-增值税普通发票ce-增值税电子普通发票ju-增值税普通发票（卷票）ct-通行费增值税电子普通发票v-机动车统一销售发票")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public UpdateInvoiceRequest invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public UpdateInvoiceRequest invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public UpdateInvoiceRequest status(String status) {
    this.status = status;
    return this;
  }

   /**
   * 发票状态0-默认；1-正常；2-作废；3-被红冲；7-异常；8-失控；9-删除
   * @return status
  **/
  @ApiModelProperty(value = "发票状态0-默认；1-正常；2-作废；3-被红冲；7-异常；8-失控；9-删除")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  @JsonIgnore
  public UpdateInvoiceRequest createTime(Long createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 数据创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "数据创建时间")
  public Long getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Long createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public UpdateInvoiceRequest updateTime(Long updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public Long getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(Long updateTime) {
    this.updateTime = updateTime;
  }

  @JsonIgnore
  public UpdateInvoiceRequest salesbillId(Long salesbillId) {
    this.salesbillId = salesbillId;
    return this;
  }

   /**
   * 业务单ID
   * @return salesbillId
  **/
  @ApiModelProperty(value = "业务单ID")
  public Long getSalesbillId() {
    return salesbillId;
  }

  public void setSalesbillId(Long salesbillId) {
    this.salesbillId = salesbillId;
  }

  @JsonIgnore
  public UpdateInvoiceRequest salesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
    return this;
  }

   /**
   * 业务单号
   * @return salesbillNo
  **/
  @ApiModelProperty(value = "业务单号")
  public String getSalesbillNo() {
    return salesbillNo;
  }

  public void setSalesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
  }

  @JsonIgnore
  public UpdateInvoiceRequest packageCode(String packageCode) {
    this.packageCode = packageCode;
    return this;
  }

   /**
   * 邮包快递单号
   * @return packageCode
  **/
  @ApiModelProperty(value = "邮包快递单号")
  public String getPackageCode() {
    return packageCode;
  }

  public void setPackageCode(String packageCode) {
    this.packageCode = packageCode;
  }

  @JsonIgnore
  public UpdateInvoiceRequest purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public UpdateInvoiceRequest purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方纳税人识别号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方纳税人识别号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public UpdateInvoiceRequest purchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
    return this;
  }

   /**
   * 购方地址
   * @return purchaserAddress
  **/
  @ApiModelProperty(value = "购方地址")
  public String getPurchaserAddress() {
    return purchaserAddress;
  }

  public void setPurchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
  }

  @JsonIgnore
  public UpdateInvoiceRequest purchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
    return this;
  }

   /**
   * 购方电话
   * @return purchaserTel
  **/
  @ApiModelProperty(value = "购方电话")
  public String getPurchaserTel() {
    return purchaserTel;
  }

  public void setPurchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
  }

  @JsonIgnore
  public UpdateInvoiceRequest purchaserAddrTel(String purchaserAddrTel) {
    this.purchaserAddrTel = purchaserAddrTel;
    return this;
  }

   /**
   * 购方地址电话
   * @return purchaserAddrTel
  **/
  @ApiModelProperty(value = "购方地址电话")
  public String getPurchaserAddrTel() {
    return purchaserAddrTel;
  }

  public void setPurchaserAddrTel(String purchaserAddrTel) {
    this.purchaserAddrTel = purchaserAddrTel;
  }

  @JsonIgnore
  public UpdateInvoiceRequest purchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
    return this;
  }

   /**
   * 购方银行名称
   * @return purchaserBankName
  **/
  @ApiModelProperty(value = "购方银行名称")
  public String getPurchaserBankName() {
    return purchaserBankName;
  }

  public void setPurchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
  }

  @JsonIgnore
  public UpdateInvoiceRequest purchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
    return this;
  }

   /**
   * 购方银行账号
   * @return purchaserBankAccount
  **/
  @ApiModelProperty(value = "购方银行账号")
  public String getPurchaserBankAccount() {
    return purchaserBankAccount;
  }

  public void setPurchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
  }

  @JsonIgnore
  public UpdateInvoiceRequest purchaserBankNameAccount(String purchaserBankNameAccount) {
    this.purchaserBankNameAccount = purchaserBankNameAccount;
    return this;
  }

   /**
   * 购方银行名称账号
   * @return purchaserBankNameAccount
  **/
  @ApiModelProperty(value = "购方银行名称账号")
  public String getPurchaserBankNameAccount() {
    return purchaserBankNameAccount;
  }

  public void setPurchaserBankNameAccount(String purchaserBankNameAccount) {
    this.purchaserBankNameAccount = purchaserBankNameAccount;
  }

  @JsonIgnore
  public UpdateInvoiceRequest purchaserExternalCode(String purchaserExternalCode) {
    this.purchaserExternalCode = purchaserExternalCode;
    return this;
  }

   /**
   * 购方公司编号（外部系统）
   * @return purchaserExternalCode
  **/
  @ApiModelProperty(value = "购方公司编号（外部系统）")
  public String getPurchaserExternalCode() {
    return purchaserExternalCode;
  }

  public void setPurchaserExternalCode(String purchaserExternalCode) {
    this.purchaserExternalCode = purchaserExternalCode;
  }

  @JsonIgnore
  public UpdateInvoiceRequest sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public UpdateInvoiceRequest sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方纳税人识别号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方纳税人识别号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public UpdateInvoiceRequest sellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
    return this;
  }

   /**
   * 销方地址
   * @return sellerAddress
  **/
  @ApiModelProperty(value = "销方地址")
  public String getSellerAddress() {
    return sellerAddress;
  }

  public void setSellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
  }

  @JsonIgnore
  public UpdateInvoiceRequest sellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
    return this;
  }

   /**
   * 销方电话
   * @return sellerTel
  **/
  @ApiModelProperty(value = "销方电话")
  public String getSellerTel() {
    return sellerTel;
  }

  public void setSellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
  }

  @JsonIgnore
  public UpdateInvoiceRequest sellerAddrTel(String sellerAddrTel) {
    this.sellerAddrTel = sellerAddrTel;
    return this;
  }

   /**
   * 销方地址电话
   * @return sellerAddrTel
  **/
  @ApiModelProperty(value = "销方地址电话")
  public String getSellerAddrTel() {
    return sellerAddrTel;
  }

  public void setSellerAddrTel(String sellerAddrTel) {
    this.sellerAddrTel = sellerAddrTel;
  }

  @JsonIgnore
  public UpdateInvoiceRequest sellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
    return this;
  }

   /**
   * 销方银行名称
   * @return sellerBankName
  **/
  @ApiModelProperty(value = "销方银行名称")
  public String getSellerBankName() {
    return sellerBankName;
  }

  public void setSellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
  }

  @JsonIgnore
  public UpdateInvoiceRequest sellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
    return this;
  }

   /**
   * 销方银行账号
   * @return sellerBankAccount
  **/
  @ApiModelProperty(value = "销方银行账号")
  public String getSellerBankAccount() {
    return sellerBankAccount;
  }

  public void setSellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
  }

  @JsonIgnore
  public UpdateInvoiceRequest sellerBankNameAccount(String sellerBankNameAccount) {
    this.sellerBankNameAccount = sellerBankNameAccount;
    return this;
  }

   /**
   * 销方银行名称账号
   * @return sellerBankNameAccount
  **/
  @ApiModelProperty(value = "销方银行名称账号")
  public String getSellerBankNameAccount() {
    return sellerBankNameAccount;
  }

  public void setSellerBankNameAccount(String sellerBankNameAccount) {
    this.sellerBankNameAccount = sellerBankNameAccount;
  }

  @JsonIgnore
  public UpdateInvoiceRequest sellerExternalCode(String sellerExternalCode) {
    this.sellerExternalCode = sellerExternalCode;
    return this;
  }

   /**
   * 销方公司编号（外部系统）
   * @return sellerExternalCode
  **/
  @ApiModelProperty(value = "销方公司编号（外部系统）")
  public String getSellerExternalCode() {
    return sellerExternalCode;
  }

  public void setSellerExternalCode(String sellerExternalCode) {
    this.sellerExternalCode = sellerExternalCode;
  }

  @JsonIgnore
  public UpdateInvoiceRequest sellerInvoiceId(Long sellerInvoiceId) {
    this.sellerInvoiceId = sellerInvoiceId;
    return this;
  }

   /**
   * 销方发票主表ID
   * @return sellerInvoiceId
  **/
  @ApiModelProperty(value = "销方发票主表ID")
  public Long getSellerInvoiceId() {
    return sellerInvoiceId;
  }

  public void setSellerInvoiceId(Long sellerInvoiceId) {
    this.sellerInvoiceId = sellerInvoiceId;
  }

  @JsonIgnore
  public UpdateInvoiceRequest sellerUserName(String sellerUserName) {
    this.sellerUserName = sellerUserName;
    return this;
  }

   /**
   * 销方开票操作人姓名
   * @return sellerUserName
  **/
  @ApiModelProperty(value = "销方开票操作人姓名")
  public String getSellerUserName() {
    return sellerUserName;
  }

  public void setSellerUserName(String sellerUserName) {
    this.sellerUserName = sellerUserName;
  }

  @JsonIgnore
  public UpdateInvoiceRequest sellerViewImageFlag(Integer sellerViewImageFlag) {
    this.sellerViewImageFlag = sellerViewImageFlag;
    return this;
  }

   /**
   * 销方查看影像标志：0-默认；1-允许销方查看影像
   * @return sellerViewImageFlag
  **/
  @ApiModelProperty(value = "销方查看影像标志：0-默认；1-允许销方查看影像")
  public Integer getSellerViewImageFlag() {
    return sellerViewImageFlag;
  }

  public void setSellerViewImageFlag(Integer sellerViewImageFlag) {
    this.sellerViewImageFlag = sellerViewImageFlag;
  }

  @JsonIgnore
  public UpdateInvoiceRequest sellerSyncStatus(Integer sellerSyncStatus) {
    this.sellerSyncStatus = sellerSyncStatus;
    return this;
  }

   /**
   * 销方开具状态：0-默认；1-无销方信息（非协同）；2-销方信息未 到（协同）；3-销方信息已到（协同）
   * @return sellerSyncStatus
  **/
  @ApiModelProperty(value = "销方开具状态：0-默认；1-无销方信息（非协同）；2-销方信息未 到（协同）；3-销方信息已到（协同）")
  public Integer getSellerSyncStatus() {
    return sellerSyncStatus;
  }

  public void setSellerSyncStatus(Integer sellerSyncStatus) {
    this.sellerSyncStatus = sellerSyncStatus;
  }

  @JsonIgnore
  public UpdateInvoiceRequest sellerSyncTime(Long sellerSyncTime) {
    this.sellerSyncTime = sellerSyncTime;
    return this;
  }

   /**
   * 销方信息获取时间
   * @return sellerSyncTime
  **/
  @ApiModelProperty(value = "销方信息获取时间")
  public Long getSellerSyncTime() {
    return sellerSyncTime;
  }

  public void setSellerSyncTime(Long sellerSyncTime) {
    this.sellerSyncTime = sellerSyncTime;
  }

  @JsonIgnore
  public UpdateInvoiceRequest taxRate(String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 多税率以逗号隔开，如16%,11%,3%
   * @return taxRate
  **/
  @ApiModelProperty(value = "多税率以逗号隔开，如16%,11%,3%")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public UpdateInvoiceRequest amountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public UpdateInvoiceRequest taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public UpdateInvoiceRequest amountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public BigDecimal getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public UpdateInvoiceRequest amountWithTaxCapital(String amountWithTaxCapital) {
    this.amountWithTaxCapital = amountWithTaxCapital;
    return this;
  }

   /**
   * 含税金额(大写)
   * @return amountWithTaxCapital
  **/
  @ApiModelProperty(value = "含税金额(大写)")
  public String getAmountWithTaxCapital() {
    return amountWithTaxCapital;
  }

  public void setAmountWithTaxCapital(String amountWithTaxCapital) {
    this.amountWithTaxCapital = amountWithTaxCapital;
  }

  @JsonIgnore
  public UpdateInvoiceRequest paperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
    return this;
  }

   /**
   * 发票开票日期（例：20161027）
   * @return paperDrewDate
  **/
  @ApiModelProperty(value = "发票开票日期（例：20161027）")
  public String getPaperDrewDate() {
    return paperDrewDate;
  }

  public void setPaperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
  }

  @JsonIgnore
  public UpdateInvoiceRequest machineCode(String machineCode) {
    this.machineCode = machineCode;
    return this;
  }

   /**
   * 机器编码
   * @return machineCode
  **/
  @ApiModelProperty(value = "机器编码")
  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  @JsonIgnore
  public UpdateInvoiceRequest checkCode(String checkCode) {
    this.checkCode = checkCode;
    return this;
  }

   /**
   * 校验码
   * @return checkCode
  **/
  @ApiModelProperty(value = "校验码")
  public String getCheckCode() {
    return checkCode;
  }

  public void setCheckCode(String checkCode) {
    this.checkCode = checkCode;
  }

  @JsonIgnore
  public UpdateInvoiceRequest cipherText(String cipherText) {
    this.cipherText = cipherText;
    return this;
  }

   /**
   * 密文
   * @return cipherText
  **/
  @ApiModelProperty(value = "密文")
  public String getCipherText() {
    return cipherText;
  }

  public void setCipherText(String cipherText) {
    this.cipherText = cipherText;
  }

  @JsonIgnore
  public UpdateInvoiceRequest invoiceOrig(Integer invoiceOrig) {
    this.invoiceOrig = invoiceOrig;
    return this;
  }

   /**
   * 发票来源：0-默认；1,抽取,y;2,扫描,y;3,导入,y;4,税局下载,y;5,直连开票生成,y;6,金税回传生成,y;7,手工回填生成,y;8,电子发票生成,y;9,电子底账,y;71,非直连接口生成,y;
   * @return invoiceOrig
  **/
  @ApiModelProperty(value = "发票来源：0-默认；1,抽取,y;2,扫描,y;3,导入,y;4,税局下载,y;5,直连开票生成,y;6,金税回传生成,y;7,手工回填生成,y;8,电子发票生成,y;9,电子底账,y;71,非直连接口生成,y;")
  public Integer getInvoiceOrig() {
    return invoiceOrig;
  }

  public void setInvoiceOrig(Integer invoiceOrig) {
    this.invoiceOrig = invoiceOrig;
  }

  @JsonIgnore
  public UpdateInvoiceRequest dataFromSystem(String dataFromSystem) {
    this.dataFromSystem = dataFromSystem;
    return this;
  }

   /**
   * 数据来源
   * @return dataFromSystem
  **/
  @ApiModelProperty(value = "数据来源")
  public String getDataFromSystem() {
    return dataFromSystem;
  }

  public void setDataFromSystem(String dataFromSystem) {
    this.dataFromSystem = dataFromSystem;
  }

  @JsonIgnore
  public UpdateInvoiceRequest specialInvoiceFlag(Integer specialInvoiceFlag) {
    this.specialInvoiceFlag = specialInvoiceFlag;
    return this;
  }

   /**
   * 特殊发票标记：0-默认；1-通行费；2-成品油
   * @return specialInvoiceFlag
  **/
  @ApiModelProperty(value = "特殊发票标记：0-默认；1-通行费；2-成品油")
  public Integer getSpecialInvoiceFlag() {
    return specialInvoiceFlag;
  }

  public void setSpecialInvoiceFlag(Integer specialInvoiceFlag) {
    this.specialInvoiceFlag = specialInvoiceFlag;
  }

  @JsonIgnore
  public UpdateInvoiceRequest titleOkFlag(Integer titleOkFlag) {
    this.titleOkFlag = titleOkFlag;
    return this;
  }

   /**
   * 抬头是否有误：0-默认；1-无误；2-有误
   * @return titleOkFlag
  **/
  @ApiModelProperty(value = "抬头是否有误：0-默认；1-无误；2-有误")
  public Integer getTitleOkFlag() {
    return titleOkFlag;
  }

  public void setTitleOkFlag(Integer titleOkFlag) {
    this.titleOkFlag = titleOkFlag;
  }

  @JsonIgnore
  public UpdateInvoiceRequest saleListFlag(Integer saleListFlag) {
    this.saleListFlag = saleListFlag;
    return this;
  }

   /**
   * 是否有销货清单：0-未知（默认）；1-有；2-无
   * @return saleListFlag
  **/
  @ApiModelProperty(value = "是否有销货清单：0-未知（默认）；1-有；2-无")
  public Integer getSaleListFlag() {
    return saleListFlag;
  }

  public void setSaleListFlag(Integer saleListFlag) {
    this.saleListFlag = saleListFlag;
  }

  @JsonIgnore
  public UpdateInvoiceRequest dataOkFlag(Integer dataOkFlag) {
    this.dataOkFlag = dataOkFlag;
    return this;
  }

   /**
   * 数据源比对是否一致：0-未知（默认）；1 - 一致；2 - 不一致
   * @return dataOkFlag
  **/
  @ApiModelProperty(value = "数据源比对是否一致：0-未知（默认）；1 - 一致；2 - 不一致")
  public Integer getDataOkFlag() {
    return dataOkFlag;
  }

  public void setDataOkFlag(Integer dataOkFlag) {
    this.dataOkFlag = dataOkFlag;
  }

  @JsonIgnore
  public UpdateInvoiceRequest recogStatus(Integer recogStatus) {
    this.recogStatus = recogStatus;
    return this;
  }

   /**
   * 识别状态：0-未识别（默认）；1-已识别
   * @return recogStatus
  **/
  @ApiModelProperty(value = "识别状态：0-未识别（默认）；1-已识别")
  public Integer getRecogStatus() {
    return recogStatus;
  }

  public void setRecogStatus(Integer recogStatus) {
    this.recogStatus = recogStatus;
  }

  @JsonIgnore
  public UpdateInvoiceRequest recogImageStatus(Integer recogImageStatus) {
    this.recogImageStatus = recogImageStatus;
    return this;
  }

   /**
   * 识别影像状态：0-无影像(默认)；1-仅有抵扣联；2-仅有发票联；3-两联均有
   * @return recogImageStatus
  **/
  @ApiModelProperty(value = "识别影像状态：0-无影像(默认)；1-仅有抵扣联；2-仅有发票联；3-两联均有")
  public Integer getRecogImageStatus() {
    return recogImageStatus;
  }

  public void setRecogImageStatus(Integer recogImageStatus) {
    this.recogImageStatus = recogImageStatus;
  }

  @JsonIgnore
  public UpdateInvoiceRequest recogInvoiceId(Long recogInvoiceId) {
    this.recogInvoiceId = recogInvoiceId;
    return this;
  }

   /**
   * 识别发票主表ID
   * @return recogInvoiceId
  **/
  @ApiModelProperty(value = "识别发票主表ID")
  public Long getRecogInvoiceId() {
    return recogInvoiceId;
  }

  public void setRecogInvoiceId(Long recogInvoiceId) {
    this.recogInvoiceId = recogInvoiceId;
  }

  @JsonIgnore
  public UpdateInvoiceRequest recogResponseTime(Long recogResponseTime) {
    this.recogResponseTime = recogResponseTime;
    return this;
  }

   /**
   * 识别完成时间
   * @return recogResponseTime
  **/
  @ApiModelProperty(value = "识别完成时间")
  public Long getRecogResponseTime() {
    return recogResponseTime;
  }

  public void setRecogResponseTime(Long recogResponseTime) {
    this.recogResponseTime = recogResponseTime;
  }

  @JsonIgnore
  public UpdateInvoiceRequest recogUserName(String recogUserName) {
    this.recogUserName = recogUserName;
    return this;
  }

   /**
   * 识别操作人姓名
   * @return recogUserName
  **/
  @ApiModelProperty(value = "识别操作人姓名")
  public String getRecogUserName() {
    return recogUserName;
  }

  public void setRecogUserName(String recogUserName) {
    this.recogUserName = recogUserName;
  }

  @JsonIgnore
  public UpdateInvoiceRequest recogUploadNum(Integer recogUploadNum) {
    this.recogUploadNum = recogUploadNum;
    return this;
  }

   /**
   * 识别上传次数
   * @return recogUploadNum
  **/
  @ApiModelProperty(value = "识别上传次数")
  public Integer getRecogUploadNum() {
    return recogUploadNum;
  }

  public void setRecogUploadNum(Integer recogUploadNum) {
    this.recogUploadNum = recogUploadNum;
  }

  @JsonIgnore
  public UpdateInvoiceRequest veriInvoiceId(Long veriInvoiceId) {
    this.veriInvoiceId = veriInvoiceId;
    return this;
  }

   /**
   * 国税验真主表ID
   * @return veriInvoiceId
  **/
  @ApiModelProperty(value = "国税验真主表ID")
  public Long getVeriInvoiceId() {
    return veriInvoiceId;
  }

  public void setVeriInvoiceId(Long veriInvoiceId) {
    this.veriInvoiceId = veriInvoiceId;
  }

  @JsonIgnore
  public UpdateInvoiceRequest veriStatus(Integer veriStatus) {
    this.veriStatus = veriStatus;
    return this;
  }

   /**
   * 查验状态：0-未查验(默认)；1-待查验；2-查验中；3-查验成功；4-查验失败
   * @return veriStatus
  **/
  @ApiModelProperty(value = "查验状态：0-未查验(默认)；1-待查验；2-查验中；3-查验成功；4-查验失败")
  public Integer getVeriStatus() {
    return veriStatus;
  }

  public void setVeriStatus(Integer veriStatus) {
    this.veriStatus = veriStatus;
  }

  @JsonIgnore
  public UpdateInvoiceRequest veriRequestTime(Long veriRequestTime) {
    this.veriRequestTime = veriRequestTime;
    return this;
  }

   /**
   * 查验发送时间
   * @return veriRequestTime
  **/
  @ApiModelProperty(value = "查验发送时间")
  public Long getVeriRequestTime() {
    return veriRequestTime;
  }

  public void setVeriRequestTime(Long veriRequestTime) {
    this.veriRequestTime = veriRequestTime;
  }

  @JsonIgnore
  public UpdateInvoiceRequest veriResponseTime(Long veriResponseTime) {
    this.veriResponseTime = veriResponseTime;
    return this;
  }

   /**
   * 查验完成时间
   * @return veriResponseTime
  **/
  @ApiModelProperty(value = "查验完成时间")
  public Long getVeriResponseTime() {
    return veriResponseTime;
  }

  public void setVeriResponseTime(Long veriResponseTime) {
    this.veriResponseTime = veriResponseTime;
  }

  @JsonIgnore
  public UpdateInvoiceRequest veriUserId(Long veriUserId) {
    this.veriUserId = veriUserId;
    return this;
  }

   /**
   * 查验操作人ID
   * @return veriUserId
  **/
  @ApiModelProperty(value = "查验操作人ID")
  public Long getVeriUserId() {
    return veriUserId;
  }

  public void setVeriUserId(Long veriUserId) {
    this.veriUserId = veriUserId;
  }

  @JsonIgnore
  public UpdateInvoiceRequest veriUserName(String veriUserName) {
    this.veriUserName = veriUserName;
    return this;
  }

   /**
   * 查验操作人姓名
   * @return veriUserName
  **/
  @ApiModelProperty(value = "查验操作人姓名")
  public String getVeriUserName() {
    return veriUserName;
  }

  public void setVeriUserName(String veriUserName) {
    this.veriUserName = veriUserName;
  }

  @JsonIgnore
  public UpdateInvoiceRequest veriRemark(String veriRemark) {
    this.veriRemark = veriRemark;
    return this;
  }

   /**
   * 查验备注
   * @return veriRemark
  **/
  @ApiModelProperty(value = "查验备注")
  public String getVeriRemark() {
    return veriRemark;
  }

  public void setVeriRemark(String veriRemark) {
    this.veriRemark = veriRemark;
  }

  @JsonIgnore
  public UpdateInvoiceRequest taxInvoiceId(Long taxInvoiceId) {
    this.taxInvoiceId = taxInvoiceId;
    return this;
  }

   /**
   * 国税底账主表ID
   * @return taxInvoiceId
  **/
  @ApiModelProperty(value = "国税底账主表ID")
  public Long getTaxInvoiceId() {
    return taxInvoiceId;
  }

  public void setTaxInvoiceId(Long taxInvoiceId) {
    this.taxInvoiceId = taxInvoiceId;
  }

  @JsonIgnore
  public UpdateInvoiceRequest authSyncStatus(Integer authSyncStatus) {
    this.authSyncStatus = authSyncStatus;
    return this;
  }

   /**
   * 电子底账状态：0-未获取(默认)；1-未勾选；2-已勾选；3-底账确认 失败；4-已确认；5-不可勾选确认
   * @return authSyncStatus
  **/
  @ApiModelProperty(value = "电子底账状态：0-未获取(默认)；1-未勾选；2-已勾选；3-底账确认 失败；4-已确认；5-不可勾选确认")
  public Integer getAuthSyncStatus() {
    return authSyncStatus;
  }

  public void setAuthSyncStatus(Integer authSyncStatus) {
    this.authSyncStatus = authSyncStatus;
  }

  @JsonIgnore
  public UpdateInvoiceRequest authSyncTime(Long authSyncTime) {
    this.authSyncTime = authSyncTime;
    return this;
  }

   /**
   * 电子底帐获取时间
   * @return authSyncTime
  **/
  @ApiModelProperty(value = "电子底帐获取时间")
  public Long getAuthSyncTime() {
    return authSyncTime;
  }

  public void setAuthSyncTime(Long authSyncTime) {
    this.authSyncTime = authSyncTime;
  }

  @JsonIgnore
  public UpdateInvoiceRequest authStatus(Integer authStatus) {
    this.authStatus = authStatus;
    return this;
  }

   /**
   * 认证状态：0-默认；1-不可认证；2-未认证；3-认证中；4-认证成功；5-认证失败；6-抵扣异常；7-已转出
   * @return authStatus
  **/
  @ApiModelProperty(value = "认证状态：0-默认；1-不可认证；2-未认证；3-认证中；4-认证成功；5-认证失败；6-抵扣异常；7-已转出")
  public Integer getAuthStatus() {
    return authStatus;
  }

  public void setAuthStatus(Integer authStatus) {
    this.authStatus = authStatus;
  }

  @JsonIgnore
  public UpdateInvoiceRequest authStyle(Integer authStyle) {
    this.authStyle = authStyle;
    return this;
  }

   /**
   * 认证方式：0-默认10-票易通底账确认；20-票易通扫描认证30-票易通退税确认；40-票易通代理出口退税11-票易通底账认证导入；21-票易通扫描认证导入12-国税底账确认；22-国税扫描认证32-国税退税认证；42-国税代理出口退税
   * @return authStyle
  **/
  @ApiModelProperty(value = "认证方式：0-默认10-票易通底账确认；20-票易通扫描认证30-票易通退税确认；40-票易通代理出口退税11-票易通底账认证导入；21-票易通扫描认证导入12-国税底账确认；22-国税扫描认证32-国税退税认证；42-国税代理出口退税")
  public Integer getAuthStyle() {
    return authStyle;
  }

  public void setAuthStyle(Integer authStyle) {
    this.authStyle = authStyle;
  }

  @JsonIgnore
  public UpdateInvoiceRequest authBussiDate(String authBussiDate) {
    this.authBussiDate = authBussiDate;
    return this;
  }

   /**
   * 认证业务日期
   * @return authBussiDate
  **/
  @ApiModelProperty(value = "认证业务日期")
  public String getAuthBussiDate() {
    return authBussiDate;
  }

  public void setAuthBussiDate(String authBussiDate) {
    this.authBussiDate = authBussiDate;
  }

  @JsonIgnore
  public UpdateInvoiceRequest authTaxPeriod(String authTaxPeriod) {
    this.authTaxPeriod = authTaxPeriod;
    return this;
  }

   /**
   * 认证所属期
   * @return authTaxPeriod
  **/
  @ApiModelProperty(value = "认证所属期")
  public String getAuthTaxPeriod() {
    return authTaxPeriod;
  }

  public void setAuthTaxPeriod(String authTaxPeriod) {
    this.authTaxPeriod = authTaxPeriod;
  }

  @JsonIgnore
  public UpdateInvoiceRequest authRequestTime(Long authRequestTime) {
    this.authRequestTime = authRequestTime;
    return this;
  }

   /**
   * 认证发送时间
   * @return authRequestTime
  **/
  @ApiModelProperty(value = "认证发送时间")
  public Long getAuthRequestTime() {
    return authRequestTime;
  }

  public void setAuthRequestTime(Long authRequestTime) {
    this.authRequestTime = authRequestTime;
  }

  @JsonIgnore
  public UpdateInvoiceRequest authResponseTime(Long authResponseTime) {
    this.authResponseTime = authResponseTime;
    return this;
  }

   /**
   * 认证完成时间
   * @return authResponseTime
  **/
  @ApiModelProperty(value = "认证完成时间")
  public Long getAuthResponseTime() {
    return authResponseTime;
  }

  public void setAuthResponseTime(Long authResponseTime) {
    this.authResponseTime = authResponseTime;
  }

  @JsonIgnore
  public UpdateInvoiceRequest authRequestUserId(Long authRequestUserId) {
    this.authRequestUserId = authRequestUserId;
    return this;
  }

   /**
   * 认证操作员ID
   * @return authRequestUserId
  **/
  @ApiModelProperty(value = "认证操作员ID")
  public Long getAuthRequestUserId() {
    return authRequestUserId;
  }

  public void setAuthRequestUserId(Long authRequestUserId) {
    this.authRequestUserId = authRequestUserId;
  }

  @JsonIgnore
  public UpdateInvoiceRequest authRequestUserName(String authRequestUserName) {
    this.authRequestUserName = authRequestUserName;
    return this;
  }

   /**
   * 认证操作人姓名
   * @return authRequestUserName
  **/
  @ApiModelProperty(value = "认证操作人姓名")
  public String getAuthRequestUserName() {
    return authRequestUserName;
  }

  public void setAuthRequestUserName(String authRequestUserName) {
    this.authRequestUserName = authRequestUserName;
  }

  @JsonIgnore
  public UpdateInvoiceRequest authRequestSerialNo(String authRequestSerialNo) {
    this.authRequestSerialNo = authRequestSerialNo;
    return this;
  }

   /**
   * 认证请求流水号
   * @return authRequestSerialNo
  **/
  @ApiModelProperty(value = "认证请求流水号")
  public String getAuthRequestSerialNo() {
    return authRequestSerialNo;
  }

  public void setAuthRequestSerialNo(String authRequestSerialNo) {
    this.authRequestSerialNo = authRequestSerialNo;
  }

  @JsonIgnore
  public UpdateInvoiceRequest authRemark(String authRemark) {
    this.authRemark = authRemark;
    return this;
  }

   /**
   * 认证备注
   * @return authRemark
  **/
  @ApiModelProperty(value = "认证备注")
  public String getAuthRemark() {
    return authRemark;
  }

  public void setAuthRemark(String authRemark) {
    this.authRemark = authRemark;
  }

  @JsonIgnore
  public UpdateInvoiceRequest authValidTime(Long authValidTime) {
    this.authValidTime = authValidTime;
    return this;
  }

   /**
   * 认证验证时间
   * @return authValidTime
  **/
  @ApiModelProperty(value = "认证验证时间")
  public Long getAuthValidTime() {
    return authValidTime;
  }

  public void setAuthValidTime(Long authValidTime) {
    this.authValidTime = authValidTime;
  }

  @JsonIgnore
  public UpdateInvoiceRequest authValidResult(Integer authValidResult) {
    this.authValidResult = authValidResult;
    return this;
  }

   /**
   * 认证验证结果 -1校验不通过,1校验通过,0已推送校验2-无
   * @return authValidResult
  **/
  @ApiModelProperty(value = "认证验证结果 -1校验不通过,1校验通过,0已推送校验2-无")
  public Integer getAuthValidResult() {
    return authValidResult;
  }

  public void setAuthValidResult(Integer authValidResult) {
    this.authValidResult = authValidResult;
  }

  @JsonIgnore
  public UpdateInvoiceRequest authValidRemark(String authValidRemark) {
    this.authValidRemark = authValidRemark;
    return this;
  }

   /**
   * 认证验证描述
   * @return authValidRemark
  **/
  @ApiModelProperty(value = "认证验证描述")
  public String getAuthValidRemark() {
    return authValidRemark;
  }

  public void setAuthValidRemark(String authValidRemark) {
    this.authValidRemark = authValidRemark;
  }

  @JsonIgnore
  public UpdateInvoiceRequest authAmountWithoutTax(BigDecimal authAmountWithoutTax) {
    this.authAmountWithoutTax = authAmountWithoutTax;
    return this;
  }

   /**
   * 认证不含税总金额
   * @return authAmountWithoutTax
  **/
  @ApiModelProperty(value = "认证不含税总金额")
  public BigDecimal getAuthAmountWithoutTax() {
    return authAmountWithoutTax;
  }

  public void setAuthAmountWithoutTax(BigDecimal authAmountWithoutTax) {
    this.authAmountWithoutTax = authAmountWithoutTax;
  }

  @JsonIgnore
  public UpdateInvoiceRequest authTaxAmount(BigDecimal authTaxAmount) {
    this.authTaxAmount = authTaxAmount;
    return this;
  }

   /**
   * 认证总税额
   * @return authTaxAmount
  **/
  @ApiModelProperty(value = "认证总税额")
  public BigDecimal getAuthTaxAmount() {
    return authTaxAmount;
  }

  public void setAuthTaxAmount(BigDecimal authTaxAmount) {
    this.authTaxAmount = authTaxAmount;
  }

  @JsonIgnore
  public UpdateInvoiceRequest authCount(Integer authCount) {
    this.authCount = authCount;
    return this;
  }

   /**
   * 认证次数
   * @return authCount
  **/
  @ApiModelProperty(value = "认证次数")
  public Integer getAuthCount() {
    return authCount;
  }

  public void setAuthCount(Integer authCount) {
    this.authCount = authCount;
  }

  @JsonIgnore
  public UpdateInvoiceRequest authReturnTime(Long authReturnTime) {
    this.authReturnTime = authReturnTime;
    return this;
  }

   /**
   * 接收到认证反馈的时间
   * @return authReturnTime
  **/
  @ApiModelProperty(value = "接收到认证反馈的时间")
  public Long getAuthReturnTime() {
    return authReturnTime;
  }

  public void setAuthReturnTime(Long authReturnTime) {
    this.authReturnTime = authReturnTime;
  }

  @JsonIgnore
  public UpdateInvoiceRequest actualAuthWay(Integer actualAuthWay) {
    this.actualAuthWay = actualAuthWay;
    return this;
  }

   /**
   * 实际认证方式 0非手工调整 1手工调整2-无
   * @return actualAuthWay
  **/
  @ApiModelProperty(value = "实际认证方式 0非手工调整 1手工调整2-无")
  public Integer getActualAuthWay() {
    return actualAuthWay;
  }

  public void setActualAuthWay(Integer actualAuthWay) {
    this.actualAuthWay = actualAuthWay;
  }

  @JsonIgnore
  public UpdateInvoiceRequest redStatus(Integer redStatus) {
    this.redStatus = redStatus;
    return this;
  }

   /**
   * 红冲状态：0-默认；1-待红冲；2-待部分红冲；3-红冲；4-部分红冲, 5-红字发票
   * @return redStatus
  **/
  @ApiModelProperty(value = "红冲状态：0-默认；1-待红冲；2-待部分红冲；3-红冲；4-部分红冲, 5-红字发票")
  public Integer getRedStatus() {
    return redStatus;
  }

  public void setRedStatus(Integer redStatus) {
    this.redStatus = redStatus;
  }

  @JsonIgnore
  public UpdateInvoiceRequest redTime(Long redTime) {
    this.redTime = redTime;
    return this;
  }

   /**
   * 红冲时间
   * @return redTime
  **/
  @ApiModelProperty(value = "红冲时间")
  public Long getRedTime() {
    return redTime;
  }

  public void setRedTime(Long redTime) {
    this.redTime = redTime;
  }

  @JsonIgnore
  public UpdateInvoiceRequest redNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
    return this;
  }

   /**
   * 红字信息表编号
   * @return redNotificationNo
  **/
  @ApiModelProperty(value = "红字信息表编号")
  public String getRedNotificationNo() {
    return redNotificationNo;
  }

  public void setRedNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
  }

  @JsonIgnore
  public UpdateInvoiceRequest redUserId(Long redUserId) {
    this.redUserId = redUserId;
    return this;
  }

   /**
   * 红冲人ID
   * @return redUserId
  **/
  @ApiModelProperty(value = "红冲人ID")
  public Long getRedUserId() {
    return redUserId;
  }

  public void setRedUserId(Long redUserId) {
    this.redUserId = redUserId;
  }

  @JsonIgnore
  public UpdateInvoiceRequest redUserName(String redUserName) {
    this.redUserName = redUserName;
    return this;
  }

   /**
   * 红冲人姓名
   * @return redUserName
  **/
  @ApiModelProperty(value = "红冲人姓名")
  public String getRedUserName() {
    return redUserName;
  }

  public void setRedUserName(String redUserName) {
    this.redUserName = redUserName;
  }

  @JsonIgnore
  public UpdateInvoiceRequest originInvoiceNo(String originInvoiceNo) {
    this.originInvoiceNo = originInvoiceNo;
    return this;
  }

   /**
   * 红冲发票号码
   * @return originInvoiceNo
  **/
  @ApiModelProperty(value = "红冲发票号码")
  public String getOriginInvoiceNo() {
    return originInvoiceNo;
  }

  public void setOriginInvoiceNo(String originInvoiceNo) {
    this.originInvoiceNo = originInvoiceNo;
  }

  @JsonIgnore
  public UpdateInvoiceRequest originInvoiceCode(String originInvoiceCode) {
    this.originInvoiceCode = originInvoiceCode;
    return this;
  }

   /**
   * 红冲发票代码
   * @return originInvoiceCode
  **/
  @ApiModelProperty(value = "红冲发票代码")
  public String getOriginInvoiceCode() {
    return originInvoiceCode;
  }

  public void setOriginInvoiceCode(String originInvoiceCode) {
    this.originInvoiceCode = originInvoiceCode;
  }

  @JsonIgnore
  public UpdateInvoiceRequest redRemark(String redRemark) {
    this.redRemark = redRemark;
    return this;
  }

   /**
   * 红冲备注
   * @return redRemark
  **/
  @ApiModelProperty(value = "红冲备注")
  public String getRedRemark() {
    return redRemark;
  }

  public void setRedRemark(String redRemark) {
    this.redRemark = redRemark;
  }

  @JsonIgnore
  public UpdateInvoiceRequest retreatStatus(Integer retreatStatus) {
    this.retreatStatus = retreatStatus;
    return this;
  }

   /**
   * 退票状态：0-未退(默认)；1-已退
   * @return retreatStatus
  **/
  @ApiModelProperty(value = "退票状态：0-未退(默认)；1-已退")
  public Integer getRetreatStatus() {
    return retreatStatus;
  }

  public void setRetreatStatus(Integer retreatStatus) {
    this.retreatStatus = retreatStatus;
  }

  @JsonIgnore
  public UpdateInvoiceRequest retreatTime(Long retreatTime) {
    this.retreatTime = retreatTime;
    return this;
  }

   /**
   * 退票操作时间
   * @return retreatTime
  **/
  @ApiModelProperty(value = "退票操作时间")
  public Long getRetreatTime() {
    return retreatTime;
  }

  public void setRetreatTime(Long retreatTime) {
    this.retreatTime = retreatTime;
  }

  @JsonIgnore
  public UpdateInvoiceRequest retreatUserId(Long retreatUserId) {
    this.retreatUserId = retreatUserId;
    return this;
  }

   /**
   * 退票操作人ID
   * @return retreatUserId
  **/
  @ApiModelProperty(value = "退票操作人ID")
  public Long getRetreatUserId() {
    return retreatUserId;
  }

  public void setRetreatUserId(Long retreatUserId) {
    this.retreatUserId = retreatUserId;
  }

  @JsonIgnore
  public UpdateInvoiceRequest retreatUserName(String retreatUserName) {
    this.retreatUserName = retreatUserName;
    return this;
  }

   /**
   * 退票操作人姓名
   * @return retreatUserName
  **/
  @ApiModelProperty(value = "退票操作人姓名")
  public String getRetreatUserName() {
    return retreatUserName;
  }

  public void setRetreatUserName(String retreatUserName) {
    this.retreatUserName = retreatUserName;
  }

  @JsonIgnore
  public UpdateInvoiceRequest retreatRemark(String retreatRemark) {
    this.retreatRemark = retreatRemark;
    return this;
  }

   /**
   * 退票备注
   * @return retreatRemark
  **/
  @ApiModelProperty(value = "退票备注")
  public String getRetreatRemark() {
    return retreatRemark;
  }

  public void setRetreatRemark(String retreatRemark) {
    this.retreatRemark = retreatRemark;
  }

  @JsonIgnore
  public UpdateInvoiceRequest originSalesbillId(Long originSalesbillId) {
    this.originSalesbillId = originSalesbillId;
    return this;
  }

   /**
   * 原业务单ID
   * @return originSalesbillId
  **/
  @ApiModelProperty(value = "原业务单ID")
  public Long getOriginSalesbillId() {
    return originSalesbillId;
  }

  public void setOriginSalesbillId(Long originSalesbillId) {
    this.originSalesbillId = originSalesbillId;
  }

  @JsonIgnore
  public UpdateInvoiceRequest originSalesbillNo(String originSalesbillNo) {
    this.originSalesbillNo = originSalesbillNo;
    return this;
  }

   /**
   * 原业务单号
   * @return originSalesbillNo
  **/
  @ApiModelProperty(value = "原业务单号")
  public String getOriginSalesbillNo() {
    return originSalesbillNo;
  }

  public void setOriginSalesbillNo(String originSalesbillNo) {
    this.originSalesbillNo = originSalesbillNo;
  }

  @JsonIgnore
  public UpdateInvoiceRequest cashierName(String cashierName) {
    this.cashierName = cashierName;
    return this;
  }

   /**
   * 收款人姓名
   * @return cashierName
  **/
  @ApiModelProperty(value = "收款人姓名")
  public String getCashierName() {
    return cashierName;
  }

  public void setCashierName(String cashierName) {
    this.cashierName = cashierName;
  }

  @JsonIgnore
  public UpdateInvoiceRequest checkerName(String checkerName) {
    this.checkerName = checkerName;
    return this;
  }

   /**
   * 复核人姓名
   * @return checkerName
  **/
  @ApiModelProperty(value = "复核人姓名")
  public String getCheckerName() {
    return checkerName;
  }

  public void setCheckerName(String checkerName) {
    this.checkerName = checkerName;
  }

  @JsonIgnore
  public UpdateInvoiceRequest invoicerName(String invoicerName) {
    this.invoicerName = invoicerName;
    return this;
  }

   /**
   * 开票人姓名
   * @return invoicerName
  **/
  @ApiModelProperty(value = "开票人姓名")
  public String getInvoicerName() {
    return invoicerName;
  }

  public void setInvoicerName(String invoicerName) {
    this.invoicerName = invoicerName;
  }

  @JsonIgnore
  public UpdateInvoiceRequest provinceCode(Integer provinceCode) {
    this.provinceCode = provinceCode;
    return this;
  }

   /**
   * 省份代码 1100-北京 1200-天津 1300-河北 1400-山西 1500-内蒙古 2100- 辽宁 2102-大连 2200-吉林 2300-黑龙江 3100-上海 3200-江苏 3300-浙江 3302-宁波 3400-安徽 3500-福建 3502-厦门 3600-江西 3700-山东 3702-青岛 4100-河南 4200-湖北 4300-湖南 4400-广东 4403-深圳 4500-广西 5000-重庆 5100-四川 5200-贵州 5300-云南 5400-西藏 6100-陕西 6200-甘肃 6300-青海 6400-宁夏 6500-新疆
   * @return provinceCode
  **/
  @ApiModelProperty(value = "省份代码 1100-北京 1200-天津 1300-河北 1400-山西 1500-内蒙古 2100- 辽宁 2102-大连 2200-吉林 2300-黑龙江 3100-上海 3200-江苏 3300-浙江 3302-宁波 3400-安徽 3500-福建 3502-厦门 3600-江西 3700-山东 3702-青岛 4100-河南 4200-湖北 4300-湖南 4400-广东 4403-深圳 4500-广西 5000-重庆 5100-四川 5200-贵州 5300-云南 5400-西藏 6100-陕西 6200-甘肃 6300-青海 6400-宁夏 6500-新疆")
  public Integer getProvinceCode() {
    return provinceCode;
  }

  public void setProvinceCode(Integer provinceCode) {
    this.provinceCode = provinceCode;
  }

  @JsonIgnore
  public UpdateInvoiceRequest provinceName(String provinceName) {
    this.provinceName = provinceName;
    return this;
  }

   /**
   * 省份名称
   * @return provinceName
  **/
  @ApiModelProperty(value = "省份名称")
  public String getProvinceName() {
    return provinceName;
  }

  public void setProvinceName(String provinceName) {
    this.provinceName = provinceName;
  }

  @JsonIgnore
  public UpdateInvoiceRequest recogUserId(Long recogUserId) {
    this.recogUserId = recogUserId;
    return this;
  }

   /**
   * 识别操作人ID
   * @return recogUserId
  **/
  @ApiModelProperty(value = "识别操作人ID")
  public Long getRecogUserId() {
    return recogUserId;
  }

  public void setRecogUserId(Long recogUserId) {
    this.recogUserId = recogUserId;
  }

  @JsonIgnore
  public UpdateInvoiceRequest recogDeductionImageUrl(String recogDeductionImageUrl) {
    this.recogDeductionImageUrl = recogDeductionImageUrl;
    return this;
  }

   /**
   * 识别影像抵扣联路径
   * @return recogDeductionImageUrl
  **/
  @ApiModelProperty(value = "识别影像抵扣联路径")
  public String getRecogDeductionImageUrl() {
    return recogDeductionImageUrl;
  }

  public void setRecogDeductionImageUrl(String recogDeductionImageUrl) {
    this.recogDeductionImageUrl = recogDeductionImageUrl;
  }

  @JsonIgnore
  public UpdateInvoiceRequest recogInvoiceImageUrl(String recogInvoiceImageUrl) {
    this.recogInvoiceImageUrl = recogInvoiceImageUrl;
    return this;
  }

   /**
   * 识别影像发票联路径
   * @return recogInvoiceImageUrl
  **/
  @ApiModelProperty(value = "识别影像发票联路径")
  public String getRecogInvoiceImageUrl() {
    return recogInvoiceImageUrl;
  }

  public void setRecogInvoiceImageUrl(String recogInvoiceImageUrl) {
    this.recogInvoiceImageUrl = recogInvoiceImageUrl;
  }

  @JsonIgnore
  public UpdateInvoiceRequest pdfUrl(String pdfUrl) {
    this.pdfUrl = pdfUrl;
    return this;
  }

   /**
   * PDF文件地址
   * @return pdfUrl
  **/
  @ApiModelProperty(value = "PDF文件地址")
  public String getPdfUrl() {
    return pdfUrl;
  }

  public void setPdfUrl(String pdfUrl) {
    this.pdfUrl = pdfUrl;
  }

  @JsonIgnore
  public UpdateInvoiceRequest vehicleType(String vehicleType) {
    this.vehicleType = vehicleType;
    return this;
  }

   /**
   * 车辆类型
   * @return vehicleType
  **/
  @ApiModelProperty(value = "车辆类型")
  public String getVehicleType() {
    return vehicleType;
  }

  public void setVehicleType(String vehicleType) {
    this.vehicleType = vehicleType;
  }

  @JsonIgnore
  public UpdateInvoiceRequest vehicleBrand(String vehicleBrand) {
    this.vehicleBrand = vehicleBrand;
    return this;
  }

   /**
   * 厂牌型号
   * @return vehicleBrand
  **/
  @ApiModelProperty(value = "厂牌型号")
  public String getVehicleBrand() {
    return vehicleBrand;
  }

  public void setVehicleBrand(String vehicleBrand) {
    this.vehicleBrand = vehicleBrand;
  }

  @JsonIgnore
  public UpdateInvoiceRequest productionArea(String productionArea) {
    this.productionArea = productionArea;
    return this;
  }

   /**
   * 产地
   * @return productionArea
  **/
  @ApiModelProperty(value = "产地")
  public String getProductionArea() {
    return productionArea;
  }

  public void setProductionArea(String productionArea) {
    this.productionArea = productionArea;
  }

  @JsonIgnore
  public UpdateInvoiceRequest certNo(String certNo) {
    this.certNo = certNo;
    return this;
  }

   /**
   * 合格证号
   * @return certNo
  **/
  @ApiModelProperty(value = "合格证号")
  public String getCertNo() {
    return certNo;
  }

  public void setCertNo(String certNo) {
    this.certNo = certNo;
  }

  @JsonIgnore
  public UpdateInvoiceRequest importCertNo(String importCertNo) {
    this.importCertNo = importCertNo;
    return this;
  }

   /**
   * 进口证明书编号
   * @return importCertNo
  **/
  @ApiModelProperty(value = "进口证明书编号")
  public String getImportCertNo() {
    return importCertNo;
  }

  public void setImportCertNo(String importCertNo) {
    this.importCertNo = importCertNo;
  }

  @JsonIgnore
  public UpdateInvoiceRequest inspectionNo(String inspectionNo) {
    this.inspectionNo = inspectionNo;
    return this;
  }

   /**
   * 商检单号
   * @return inspectionNo
  **/
  @ApiModelProperty(value = "商检单号")
  public String getInspectionNo() {
    return inspectionNo;
  }

  public void setInspectionNo(String inspectionNo) {
    this.inspectionNo = inspectionNo;
  }

  @JsonIgnore
  public UpdateInvoiceRequest engineNo(String engineNo) {
    this.engineNo = engineNo;
    return this;
  }

   /**
   * 发动机号码
   * @return engineNo
  **/
  @ApiModelProperty(value = "发动机号码")
  public String getEngineNo() {
    return engineNo;
  }

  public void setEngineNo(String engineNo) {
    this.engineNo = engineNo;
  }

  @JsonIgnore
  public UpdateInvoiceRequest organizationCode(String organizationCode) {
    this.organizationCode = organizationCode;
    return this;
  }

   /**
   * 身份证号码/组织机构码
   * @return organizationCode
  **/
  @ApiModelProperty(value = "身份证号码/组织机构码")
  public String getOrganizationCode() {
    return organizationCode;
  }

  public void setOrganizationCode(String organizationCode) {
    this.organizationCode = organizationCode;
  }

  @JsonIgnore
  public UpdateInvoiceRequest vin(String vin) {
    this.vin = vin;
    return this;
  }

   /**
   * 车辆识别代号/车架号码
   * @return vin
  **/
  @ApiModelProperty(value = "车辆识别代号/车架号码")
  public String getVin() {
    return vin;
  }

  public void setVin(String vin) {
    this.vin = vin;
  }

  @JsonIgnore
  public UpdateInvoiceRequest tonnage(String tonnage) {
    this.tonnage = tonnage;
    return this;
  }

   /**
   * 吨位
   * @return tonnage
  **/
  @ApiModelProperty(value = "吨位")
  public String getTonnage() {
    return tonnage;
  }

  public void setTonnage(String tonnage) {
    this.tonnage = tonnage;
  }

  @JsonIgnore
  public UpdateInvoiceRequest taxPaidProof(String taxPaidProof) {
    this.taxPaidProof = taxPaidProof;
    return this;
  }

   /**
   * 完税凭证号
   * @return taxPaidProof
  **/
  @ApiModelProperty(value = "完税凭证号")
  public String getTaxPaidProof() {
    return taxPaidProof;
  }

  public void setTaxPaidProof(String taxPaidProof) {
    this.taxPaidProof = taxPaidProof;
  }

  @JsonIgnore
  public UpdateInvoiceRequest maxCapacity(String maxCapacity) {
    this.maxCapacity = maxCapacity;
    return this;
  }

   /**
   * 限乘人数
   * @return maxCapacity
  **/
  @ApiModelProperty(value = "限乘人数")
  public String getMaxCapacity() {
    return maxCapacity;
  }

  public void setMaxCapacity(String maxCapacity) {
    this.maxCapacity = maxCapacity;
  }

  @JsonIgnore
  public UpdateInvoiceRequest taxAuthName(String taxAuthName) {
    this.taxAuthName = taxAuthName;
    return this;
  }

   /**
   * 主管税务机关名称
   * @return taxAuthName
  **/
  @ApiModelProperty(value = "主管税务机关名称")
  public String getTaxAuthName() {
    return taxAuthName;
  }

  public void setTaxAuthName(String taxAuthName) {
    this.taxAuthName = taxAuthName;
  }

  @JsonIgnore
  public UpdateInvoiceRequest taxAuthCode(String taxAuthCode) {
    this.taxAuthCode = taxAuthCode;
    return this;
  }

   /**
   * 主管税务机关代码
   * @return taxAuthCode
  **/
  @ApiModelProperty(value = "主管税务机关代码")
  public String getTaxAuthCode() {
    return taxAuthCode;
  }

  public void setTaxAuthCode(String taxAuthCode) {
    this.taxAuthCode = taxAuthCode;
  }

  @JsonIgnore
  public UpdateInvoiceRequest remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 发票备注
   * @return remark
  **/
  @ApiModelProperty(value = "发票备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public UpdateInvoiceRequest invoiceCheckStatus(Integer invoiceCheckStatus) {
    this.invoiceCheckStatus = invoiceCheckStatus;
    return this;
  }

   /**
   * 发票审核状态：0-待审核，20-审核成功，30-审核不通过,40-打回
   * @return invoiceCheckStatus
  **/
  @ApiModelProperty(value = "发票审核状态：0-待审核，20-审核成功，30-审核不通过,40-打回")
  public Integer getInvoiceCheckStatus() {
    return invoiceCheckStatus;
  }

  public void setInvoiceCheckStatus(Integer invoiceCheckStatus) {
    this.invoiceCheckStatus = invoiceCheckStatus;
  }

  @JsonIgnore
  public UpdateInvoiceRequest invoiceCheckNote(String invoiceCheckNote) {
    this.invoiceCheckNote = invoiceCheckNote;
    return this;
  }

   /**
   * 结算单发票审核说明
   * @return invoiceCheckNote
  **/
  @ApiModelProperty(value = "结算单发票审核说明")
  public String getInvoiceCheckNote() {
    return invoiceCheckNote;
  }

  public void setInvoiceCheckNote(String invoiceCheckNote) {
    this.invoiceCheckNote = invoiceCheckNote;
  }

  @JsonIgnore
  public UpdateInvoiceRequest invoiceCheckPerson(String invoiceCheckPerson) {
    this.invoiceCheckPerson = invoiceCheckPerson;
    return this;
  }

   /**
   * 结算单发票审核人
   * @return invoiceCheckPerson
  **/
  @ApiModelProperty(value = "结算单发票审核人")
  public String getInvoiceCheckPerson() {
    return invoiceCheckPerson;
  }

  public void setInvoiceCheckPerson(String invoiceCheckPerson) {
    this.invoiceCheckPerson = invoiceCheckPerson;
  }

  @JsonIgnore
  public UpdateInvoiceRequest invoiceCheckTime(Long invoiceCheckTime) {
    this.invoiceCheckTime = invoiceCheckTime;
    return this;
  }

   /**
   * 发票审核时间
   * @return invoiceCheckTime
  **/
  @ApiModelProperty(value = "发票审核时间")
  public Long getInvoiceCheckTime() {
    return invoiceCheckTime;
  }

  public void setInvoiceCheckTime(Long invoiceCheckTime) {
    this.invoiceCheckTime = invoiceCheckTime;
  }

  @JsonIgnore
  public UpdateInvoiceRequest smInvoiceCode(String smInvoiceCode) {
    this.smInvoiceCode = smInvoiceCode;
    return this;
  }

   /**
   * 扫描发票代码
   * @return smInvoiceCode
  **/
  @ApiModelProperty(value = "扫描发票代码")
  public String getSmInvoiceCode() {
    return smInvoiceCode;
  }

  public void setSmInvoiceCode(String smInvoiceCode) {
    this.smInvoiceCode = smInvoiceCode;
  }

  @JsonIgnore
  public UpdateInvoiceRequest smInvoiceNo(String smInvoiceNo) {
    this.smInvoiceNo = smInvoiceNo;
    return this;
  }

   /**
   * 扫描发票号码
   * @return smInvoiceNo
  **/
  @ApiModelProperty(value = "扫描发票号码")
  public String getSmInvoiceNo() {
    return smInvoiceNo;
  }

  public void setSmInvoiceNo(String smInvoiceNo) {
    this.smInvoiceNo = smInvoiceNo;
  }

  @JsonIgnore
  public UpdateInvoiceRequest smPurchaserTaxNo(String smPurchaserTaxNo) {
    this.smPurchaserTaxNo = smPurchaserTaxNo;
    return this;
  }

   /**
   * 扫描购方纳税人识别号
   * @return smPurchaserTaxNo
  **/
  @ApiModelProperty(value = "扫描购方纳税人识别号")
  public String getSmPurchaserTaxNo() {
    return smPurchaserTaxNo;
  }

  public void setSmPurchaserTaxNo(String smPurchaserTaxNo) {
    this.smPurchaserTaxNo = smPurchaserTaxNo;
  }

  @JsonIgnore
  public UpdateInvoiceRequest smSellerTaxNo(String smSellerTaxNo) {
    this.smSellerTaxNo = smSellerTaxNo;
    return this;
  }

   /**
   * 扫描销方纳税人识别号
   * @return smSellerTaxNo
  **/
  @ApiModelProperty(value = "扫描销方纳税人识别号")
  public String getSmSellerTaxNo() {
    return smSellerTaxNo;
  }

  public void setSmSellerTaxNo(String smSellerTaxNo) {
    this.smSellerTaxNo = smSellerTaxNo;
  }

  @JsonIgnore
  public UpdateInvoiceRequest smPaperDrewDate(String smPaperDrewDate) {
    this.smPaperDrewDate = smPaperDrewDate;
    return this;
  }

   /**
   * 扫描过来开票日期
   * @return smPaperDrewDate
  **/
  @ApiModelProperty(value = "扫描过来开票日期")
  public String getSmPaperDrewDate() {
    return smPaperDrewDate;
  }

  public void setSmPaperDrewDate(String smPaperDrewDate) {
    this.smPaperDrewDate = smPaperDrewDate;
  }

  @JsonIgnore
  public UpdateInvoiceRequest smAmountWithoutTax(String smAmountWithoutTax) {
    this.smAmountWithoutTax = smAmountWithoutTax;
    return this;
  }

   /**
   * 不含税金额 - 扫描
   * @return smAmountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额 - 扫描")
  public String getSmAmountWithoutTax() {
    return smAmountWithoutTax;
  }

  public void setSmAmountWithoutTax(String smAmountWithoutTax) {
    this.smAmountWithoutTax = smAmountWithoutTax;
  }

  @JsonIgnore
  public UpdateInvoiceRequest smTaxAmount(String smTaxAmount) {
    this.smTaxAmount = smTaxAmount;
    return this;
  }

   /**
   * 税额 - 扫描
   * @return smTaxAmount
  **/
  @ApiModelProperty(value = "税额 - 扫描")
  public String getSmTaxAmount() {
    return smTaxAmount;
  }

  public void setSmTaxAmount(String smTaxAmount) {
    this.smTaxAmount = smTaxAmount;
  }

  @JsonIgnore
  public UpdateInvoiceRequest smAmountWithTax(String smAmountWithTax) {
    this.smAmountWithTax = smAmountWithTax;
    return this;
  }

   /**
   * 含税金额 - 扫描
   * @return smAmountWithTax
  **/
  @ApiModelProperty(value = "含税金额 - 扫描")
  public String getSmAmountWithTax() {
    return smAmountWithTax;
  }

  public void setSmAmountWithTax(String smAmountWithTax) {
    this.smAmountWithTax = smAmountWithTax;
  }

  @JsonIgnore
  public UpdateInvoiceRequest smUpdator(String smUpdator) {
    this.smUpdator = smUpdator;
    return this;
  }

   /**
   * 修改人-扫描过来
   * @return smUpdator
  **/
  @ApiModelProperty(value = "修改人-扫描过来")
  public String getSmUpdator() {
    return smUpdator;
  }

  public void setSmUpdator(String smUpdator) {
    this.smUpdator = smUpdator;
  }

  @JsonIgnore
  public UpdateInvoiceRequest smBarcode(String smBarcode) {
    this.smBarcode = smBarcode;
    return this;
  }

   /**
   * 国信接口的发票图片编号
   * @return smBarcode
  **/
  @ApiModelProperty(value = "国信接口的发票图片编号")
  public String getSmBarcode() {
    return smBarcode;
  }

  public void setSmBarcode(String smBarcode) {
    this.smBarcode = smBarcode;
  }

  @JsonIgnore
  public UpdateInvoiceRequest smImgUrl(String smImgUrl) {
    this.smImgUrl = smImgUrl;
    return this;
  }

   /**
   * 发票影像地址
   * @return smImgUrl
  **/
  @ApiModelProperty(value = "发票影像地址")
  public String getSmImgUrl() {
    return smImgUrl;
  }

  public void setSmImgUrl(String smImgUrl) {
    this.smImgUrl = smImgUrl;
  }

  @JsonIgnore
  public UpdateInvoiceRequest smInvoiceId(String smInvoiceId) {
    this.smInvoiceId = smInvoiceId;
    return this;
  }

   /**
   * 扫描id
   * @return smInvoiceId
  **/
  @ApiModelProperty(value = "扫描id")
  public String getSmInvoiceId() {
    return smInvoiceId;
  }

  public void setSmInvoiceId(String smInvoiceId) {
    this.smInvoiceId = smInvoiceId;
  }

  @JsonIgnore
  public UpdateInvoiceRequest smInvoiceSource(Integer smInvoiceSource) {
    this.smInvoiceSource = smInvoiceSource;
    return this;
  }

   /**
   * 1扫描仪2单多啦3手机拍照4其他
   * @return smInvoiceSource
  **/
  @ApiModelProperty(value = "1扫描仪2单多啦3手机拍照4其他")
  public Integer getSmInvoiceSource() {
    return smInvoiceSource;
  }

  public void setSmInvoiceSource(Integer smInvoiceSource) {
    this.smInvoiceSource = smInvoiceSource;
  }

  @JsonIgnore
  public UpdateInvoiceRequest enInvoiceCode(String enInvoiceCode) {
    this.enInvoiceCode = enInvoiceCode;
    return this;
  }

   /**
   * 发票代码-来自于业务系统或者喜盈佳
   * @return enInvoiceCode
  **/
  @ApiModelProperty(value = "发票代码-来自于业务系统或者喜盈佳")
  public String getEnInvoiceCode() {
    return enInvoiceCode;
  }

  public void setEnInvoiceCode(String enInvoiceCode) {
    this.enInvoiceCode = enInvoiceCode;
  }

  @JsonIgnore
  public UpdateInvoiceRequest enInvoiceNo(String enInvoiceNo) {
    this.enInvoiceNo = enInvoiceNo;
    return this;
  }

   /**
   * 发票号码-来自于业务系统或者喜盈佳
   * @return enInvoiceNo
  **/
  @ApiModelProperty(value = "发票号码-来自于业务系统或者喜盈佳")
  public String getEnInvoiceNo() {
    return enInvoiceNo;
  }

  public void setEnInvoiceNo(String enInvoiceNo) {
    this.enInvoiceNo = enInvoiceNo;
  }

  @JsonIgnore
  public UpdateInvoiceRequest enPurchaserTaxNo(String enPurchaserTaxNo) {
    this.enPurchaserTaxNo = enPurchaserTaxNo;
    return this;
  }

   /**
   * 购方纳税人识别号-来自于业务系统或者喜盈佳
   * @return enPurchaserTaxNo
  **/
  @ApiModelProperty(value = "购方纳税人识别号-来自于业务系统或者喜盈佳")
  public String getEnPurchaserTaxNo() {
    return enPurchaserTaxNo;
  }

  public void setEnPurchaserTaxNo(String enPurchaserTaxNo) {
    this.enPurchaserTaxNo = enPurchaserTaxNo;
  }

  @JsonIgnore
  public UpdateInvoiceRequest enSellerTaxNo(String enSellerTaxNo) {
    this.enSellerTaxNo = enSellerTaxNo;
    return this;
  }

   /**
   * 销方纳税人识别号-来自于业务系统或者喜盈佳
   * @return enSellerTaxNo
  **/
  @ApiModelProperty(value = "销方纳税人识别号-来自于业务系统或者喜盈佳")
  public String getEnSellerTaxNo() {
    return enSellerTaxNo;
  }

  public void setEnSellerTaxNo(String enSellerTaxNo) {
    this.enSellerTaxNo = enSellerTaxNo;
  }

  @JsonIgnore
  public UpdateInvoiceRequest enPaperDrewDate(String enPaperDrewDate) {
    this.enPaperDrewDate = enPaperDrewDate;
    return this;
  }

   /**
   * 开票日期-来自于业务系统或者喜盈佳
   * @return enPaperDrewDate
  **/
  @ApiModelProperty(value = "开票日期-来自于业务系统或者喜盈佳")
  public String getEnPaperDrewDate() {
    return enPaperDrewDate;
  }

  public void setEnPaperDrewDate(String enPaperDrewDate) {
    this.enPaperDrewDate = enPaperDrewDate;
  }

  @JsonIgnore
  public UpdateInvoiceRequest enAmountWithoutTax(String enAmountWithoutTax) {
    this.enAmountWithoutTax = enAmountWithoutTax;
    return this;
  }

   /**
   * 不含税金额-来自于authTime业务系统或者喜盈佳
   * @return enAmountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额-来自于authTime业务系统或者喜盈佳")
  public String getEnAmountWithoutTax() {
    return enAmountWithoutTax;
  }

  public void setEnAmountWithoutTax(String enAmountWithoutTax) {
    this.enAmountWithoutTax = enAmountWithoutTax;
  }

  @JsonIgnore
  public UpdateInvoiceRequest enTaxAmount(String enTaxAmount) {
    this.enTaxAmount = enTaxAmount;
    return this;
  }

   /**
   * 税额-来自于业务系统或者喜盈佳
   * @return enTaxAmount
  **/
  @ApiModelProperty(value = "税额-来自于业务系统或者喜盈佳")
  public String getEnTaxAmount() {
    return enTaxAmount;
  }

  public void setEnTaxAmount(String enTaxAmount) {
    this.enTaxAmount = enTaxAmount;
  }

  @JsonIgnore
  public UpdateInvoiceRequest enAmountWithTax(String enAmountWithTax) {
    this.enAmountWithTax = enAmountWithTax;
    return this;
  }

   /**
   * 含税金额-来自于业务系统或者喜盈佳
   * @return enAmountWithTax
  **/
  @ApiModelProperty(value = "含税金额-来自于业务系统或者喜盈佳")
  public String getEnAmountWithTax() {
    return enAmountWithTax;
  }

  public void setEnAmountWithTax(String enAmountWithTax) {
    this.enAmountWithTax = enAmountWithTax;
  }

  @JsonIgnore
  public UpdateInvoiceRequest enTaxRate(BigDecimal enTaxRate) {
    this.enTaxRate = enTaxRate;
    return this;
  }

   /**
   * 税率
   * @return enTaxRate
  **/
  @ApiModelProperty(value = "税率")
  public BigDecimal getEnTaxRate() {
    return enTaxRate;
  }

  public void setEnTaxRate(BigDecimal enTaxRate) {
    this.enTaxRate = enTaxRate;
  }

  @JsonIgnore
  public UpdateInvoiceRequest isPushTask(Integer isPushTask) {
    this.isPushTask = isPushTask;
    return this;
  }

   /**
   * 是否推送任务1-是
   * @return isPushTask
  **/
  @ApiModelProperty(value = "是否推送任务1-是")
  public Integer getIsPushTask() {
    return isPushTask;
  }

  public void setIsPushTask(Integer isPushTask) {
    this.isPushTask = isPushTask;
  }

  @JsonIgnore
  public UpdateInvoiceRequest isObsolete(Integer isObsolete) {
    this.isObsolete = isObsolete;
    return this;
  }

   /**
   * 是否作废，0否，1是(协同就是从喜盈佳发起作废，非协同就是发票平台自 己作废的)
   * @return isObsolete
  **/
  @ApiModelProperty(value = "是否作废，0否，1是(协同就是从喜盈佳发起作废，非协同就是发票平台自 己作废的)")
  public Integer getIsObsolete() {
    return isObsolete;
  }

  public void setIsObsolete(Integer isObsolete) {
    this.isObsolete = isObsolete;
  }

  @JsonIgnore
  public UpdateInvoiceRequest isResult(Integer isResult) {
    this.isResult = isResult;
    return this;
  }

   /**
   * 临时方案针对勾选确认二合一异常的处理1已反馈，0未反馈
   * @return isResult
  **/
  @ApiModelProperty(value = "临时方案针对勾选确认二合一异常的处理1已反馈，0未反馈")
  public Integer getIsResult() {
    return isResult;
  }

  public void setIsResult(Integer isResult) {
    this.isResult = isResult;
  }

  @JsonIgnore
  public UpdateInvoiceRequest ifRepeat(Integer ifRepeat) {
    this.ifRepeat = ifRepeat;
    return this;
  }

   /**
   * 是否重复发票1是，0否
   * @return ifRepeat
  **/
  @ApiModelProperty(value = "是否重复发票1是，0否")
  public Integer getIfRepeat() {
    return ifRepeat;
  }

  public void setIfRepeat(Integer ifRepeat) {
    this.ifRepeat = ifRepeat;
  }

  @JsonIgnore
  public UpdateInvoiceRequest ifAuthFlag(Integer ifAuthFlag) {
    this.ifAuthFlag = ifAuthFlag;
    return this;
  }

   /**
   * 是否需要认证状态 1：是  0：否
   * @return ifAuthFlag
  **/
  @ApiModelProperty(value = "是否需要认证状态 1：是  0：否")
  public Integer getIfAuthFlag() {
    return ifAuthFlag;
  }

  public void setIfAuthFlag(Integer ifAuthFlag) {
    this.ifAuthFlag = ifAuthFlag;
  }

  @JsonIgnore
  public UpdateInvoiceRequest isLegalSynergetics(Integer isLegalSynergetics) {
    this.isLegalSynergetics = isLegalSynergetics;
    return this;
  }

   /**
   * 是否法人协同 1.是 0.否
   * @return isLegalSynergetics
  **/
  @ApiModelProperty(value = "是否法人协同 1.是 0.否")
  public Integer getIsLegalSynergetics() {
    return isLegalSynergetics;
  }

  public void setIsLegalSynergetics(Integer isLegalSynergetics) {
    this.isLegalSynergetics = isLegalSynergetics;
  }

  @JsonIgnore
  public UpdateInvoiceRequest signStatus(Integer signStatus) {
    this.signStatus = signStatus;
    return this;
  }

   /**
   * 签收状态 ：10-成功 20-失败
   * @return signStatus
  **/
  @ApiModelProperty(value = "签收状态 ：10-成功 20-失败")
  public Integer getSignStatus() {
    return signStatus;
  }

  public void setSignStatus(Integer signStatus) {
    this.signStatus = signStatus;
  }

  @JsonIgnore
  public UpdateInvoiceRequest ifSendExption(Integer ifSendExption) {
    this.ifSendExption = ifSendExption;
    return this;
  }

   /**
   * 是否转交异常1是，0否
   * @return ifSendExption
  **/
  @ApiModelProperty(value = "是否转交异常1是，0否")
  public Integer getIfSendExption() {
    return ifSendExption;
  }

  public void setIfSendExption(Integer ifSendExption) {
    this.ifSendExption = ifSendExption;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateInvoiceRequest updateInvoiceRequest = (UpdateInvoiceRequest) o;
    return Objects.equals(this.id, updateInvoiceRequest.id) &&
        Objects.equals(this.invoiceType, updateInvoiceRequest.invoiceType) &&
        Objects.equals(this.invoiceNo, updateInvoiceRequest.invoiceNo) &&
        Objects.equals(this.invoiceCode, updateInvoiceRequest.invoiceCode) &&
        Objects.equals(this.status, updateInvoiceRequest.status) &&
        Objects.equals(this.createTime, updateInvoiceRequest.createTime) &&
        Objects.equals(this.updateTime, updateInvoiceRequest.updateTime) &&
        Objects.equals(this.salesbillId, updateInvoiceRequest.salesbillId) &&
        Objects.equals(this.salesbillNo, updateInvoiceRequest.salesbillNo) &&
        Objects.equals(this.packageCode, updateInvoiceRequest.packageCode) &&
        Objects.equals(this.purchaserName, updateInvoiceRequest.purchaserName) &&
        Objects.equals(this.purchaserTaxNo, updateInvoiceRequest.purchaserTaxNo) &&
        Objects.equals(this.purchaserAddress, updateInvoiceRequest.purchaserAddress) &&
        Objects.equals(this.purchaserTel, updateInvoiceRequest.purchaserTel) &&
        Objects.equals(this.purchaserAddrTel, updateInvoiceRequest.purchaserAddrTel) &&
        Objects.equals(this.purchaserBankName, updateInvoiceRequest.purchaserBankName) &&
        Objects.equals(this.purchaserBankAccount, updateInvoiceRequest.purchaserBankAccount) &&
        Objects.equals(this.purchaserBankNameAccount, updateInvoiceRequest.purchaserBankNameAccount) &&
        Objects.equals(this.purchaserExternalCode, updateInvoiceRequest.purchaserExternalCode) &&
        Objects.equals(this.sellerName, updateInvoiceRequest.sellerName) &&
        Objects.equals(this.sellerTaxNo, updateInvoiceRequest.sellerTaxNo) &&
        Objects.equals(this.sellerAddress, updateInvoiceRequest.sellerAddress) &&
        Objects.equals(this.sellerTel, updateInvoiceRequest.sellerTel) &&
        Objects.equals(this.sellerAddrTel, updateInvoiceRequest.sellerAddrTel) &&
        Objects.equals(this.sellerBankName, updateInvoiceRequest.sellerBankName) &&
        Objects.equals(this.sellerBankAccount, updateInvoiceRequest.sellerBankAccount) &&
        Objects.equals(this.sellerBankNameAccount, updateInvoiceRequest.sellerBankNameAccount) &&
        Objects.equals(this.sellerExternalCode, updateInvoiceRequest.sellerExternalCode) &&
        Objects.equals(this.sellerInvoiceId, updateInvoiceRequest.sellerInvoiceId) &&
        Objects.equals(this.sellerUserName, updateInvoiceRequest.sellerUserName) &&
        Objects.equals(this.sellerViewImageFlag, updateInvoiceRequest.sellerViewImageFlag) &&
        Objects.equals(this.sellerSyncStatus, updateInvoiceRequest.sellerSyncStatus) &&
        Objects.equals(this.sellerSyncTime, updateInvoiceRequest.sellerSyncTime) &&
        Objects.equals(this.taxRate, updateInvoiceRequest.taxRate) &&
        Objects.equals(this.amountWithoutTax, updateInvoiceRequest.amountWithoutTax) &&
        Objects.equals(this.taxAmount, updateInvoiceRequest.taxAmount) &&
        Objects.equals(this.amountWithTax, updateInvoiceRequest.amountWithTax) &&
        Objects.equals(this.amountWithTaxCapital, updateInvoiceRequest.amountWithTaxCapital) &&
        Objects.equals(this.paperDrewDate, updateInvoiceRequest.paperDrewDate) &&
        Objects.equals(this.machineCode, updateInvoiceRequest.machineCode) &&
        Objects.equals(this.checkCode, updateInvoiceRequest.checkCode) &&
        Objects.equals(this.cipherText, updateInvoiceRequest.cipherText) &&
        Objects.equals(this.invoiceOrig, updateInvoiceRequest.invoiceOrig) &&
        Objects.equals(this.dataFromSystem, updateInvoiceRequest.dataFromSystem) &&
        Objects.equals(this.specialInvoiceFlag, updateInvoiceRequest.specialInvoiceFlag) &&
        Objects.equals(this.titleOkFlag, updateInvoiceRequest.titleOkFlag) &&
        Objects.equals(this.saleListFlag, updateInvoiceRequest.saleListFlag) &&
        Objects.equals(this.dataOkFlag, updateInvoiceRequest.dataOkFlag) &&
        Objects.equals(this.recogStatus, updateInvoiceRequest.recogStatus) &&
        Objects.equals(this.recogImageStatus, updateInvoiceRequest.recogImageStatus) &&
        Objects.equals(this.recogInvoiceId, updateInvoiceRequest.recogInvoiceId) &&
        Objects.equals(this.recogResponseTime, updateInvoiceRequest.recogResponseTime) &&
        Objects.equals(this.recogUserName, updateInvoiceRequest.recogUserName) &&
        Objects.equals(this.recogUploadNum, updateInvoiceRequest.recogUploadNum) &&
        Objects.equals(this.veriInvoiceId, updateInvoiceRequest.veriInvoiceId) &&
        Objects.equals(this.veriStatus, updateInvoiceRequest.veriStatus) &&
        Objects.equals(this.veriRequestTime, updateInvoiceRequest.veriRequestTime) &&
        Objects.equals(this.veriResponseTime, updateInvoiceRequest.veriResponseTime) &&
        Objects.equals(this.veriUserId, updateInvoiceRequest.veriUserId) &&
        Objects.equals(this.veriUserName, updateInvoiceRequest.veriUserName) &&
        Objects.equals(this.veriRemark, updateInvoiceRequest.veriRemark) &&
        Objects.equals(this.taxInvoiceId, updateInvoiceRequest.taxInvoiceId) &&
        Objects.equals(this.authSyncStatus, updateInvoiceRequest.authSyncStatus) &&
        Objects.equals(this.authSyncTime, updateInvoiceRequest.authSyncTime) &&
        Objects.equals(this.authStatus, updateInvoiceRequest.authStatus) &&
        Objects.equals(this.authStyle, updateInvoiceRequest.authStyle) &&
        Objects.equals(this.authBussiDate, updateInvoiceRequest.authBussiDate) &&
        Objects.equals(this.authTaxPeriod, updateInvoiceRequest.authTaxPeriod) &&
        Objects.equals(this.authRequestTime, updateInvoiceRequest.authRequestTime) &&
        Objects.equals(this.authResponseTime, updateInvoiceRequest.authResponseTime) &&
        Objects.equals(this.authRequestUserId, updateInvoiceRequest.authRequestUserId) &&
        Objects.equals(this.authRequestUserName, updateInvoiceRequest.authRequestUserName) &&
        Objects.equals(this.authRequestSerialNo, updateInvoiceRequest.authRequestSerialNo) &&
        Objects.equals(this.authRemark, updateInvoiceRequest.authRemark) &&
        Objects.equals(this.authValidTime, updateInvoiceRequest.authValidTime) &&
        Objects.equals(this.authValidResult, updateInvoiceRequest.authValidResult) &&
        Objects.equals(this.authValidRemark, updateInvoiceRequest.authValidRemark) &&
        Objects.equals(this.authAmountWithoutTax, updateInvoiceRequest.authAmountWithoutTax) &&
        Objects.equals(this.authTaxAmount, updateInvoiceRequest.authTaxAmount) &&
        Objects.equals(this.authCount, updateInvoiceRequest.authCount) &&
        Objects.equals(this.authReturnTime, updateInvoiceRequest.authReturnTime) &&
        Objects.equals(this.actualAuthWay, updateInvoiceRequest.actualAuthWay) &&
        Objects.equals(this.redStatus, updateInvoiceRequest.redStatus) &&
        Objects.equals(this.redTime, updateInvoiceRequest.redTime) &&
        Objects.equals(this.redNotificationNo, updateInvoiceRequest.redNotificationNo) &&
        Objects.equals(this.redUserId, updateInvoiceRequest.redUserId) &&
        Objects.equals(this.redUserName, updateInvoiceRequest.redUserName) &&
        Objects.equals(this.originInvoiceNo, updateInvoiceRequest.originInvoiceNo) &&
        Objects.equals(this.originInvoiceCode, updateInvoiceRequest.originInvoiceCode) &&
        Objects.equals(this.redRemark, updateInvoiceRequest.redRemark) &&
        Objects.equals(this.retreatStatus, updateInvoiceRequest.retreatStatus) &&
        Objects.equals(this.retreatTime, updateInvoiceRequest.retreatTime) &&
        Objects.equals(this.retreatUserId, updateInvoiceRequest.retreatUserId) &&
        Objects.equals(this.retreatUserName, updateInvoiceRequest.retreatUserName) &&
        Objects.equals(this.retreatRemark, updateInvoiceRequest.retreatRemark) &&
        Objects.equals(this.originSalesbillId, updateInvoiceRequest.originSalesbillId) &&
        Objects.equals(this.originSalesbillNo, updateInvoiceRequest.originSalesbillNo) &&
        Objects.equals(this.cashierName, updateInvoiceRequest.cashierName) &&
        Objects.equals(this.checkerName, updateInvoiceRequest.checkerName) &&
        Objects.equals(this.invoicerName, updateInvoiceRequest.invoicerName) &&
        Objects.equals(this.provinceCode, updateInvoiceRequest.provinceCode) &&
        Objects.equals(this.provinceName, updateInvoiceRequest.provinceName) &&
        Objects.equals(this.recogUserId, updateInvoiceRequest.recogUserId) &&
        Objects.equals(this.recogDeductionImageUrl, updateInvoiceRequest.recogDeductionImageUrl) &&
        Objects.equals(this.recogInvoiceImageUrl, updateInvoiceRequest.recogInvoiceImageUrl) &&
        Objects.equals(this.pdfUrl, updateInvoiceRequest.pdfUrl) &&
        Objects.equals(this.vehicleType, updateInvoiceRequest.vehicleType) &&
        Objects.equals(this.vehicleBrand, updateInvoiceRequest.vehicleBrand) &&
        Objects.equals(this.productionArea, updateInvoiceRequest.productionArea) &&
        Objects.equals(this.certNo, updateInvoiceRequest.certNo) &&
        Objects.equals(this.importCertNo, updateInvoiceRequest.importCertNo) &&
        Objects.equals(this.inspectionNo, updateInvoiceRequest.inspectionNo) &&
        Objects.equals(this.engineNo, updateInvoiceRequest.engineNo) &&
        Objects.equals(this.organizationCode, updateInvoiceRequest.organizationCode) &&
        Objects.equals(this.vin, updateInvoiceRequest.vin) &&
        Objects.equals(this.tonnage, updateInvoiceRequest.tonnage) &&
        Objects.equals(this.taxPaidProof, updateInvoiceRequest.taxPaidProof) &&
        Objects.equals(this.maxCapacity, updateInvoiceRequest.maxCapacity) &&
        Objects.equals(this.taxAuthName, updateInvoiceRequest.taxAuthName) &&
        Objects.equals(this.taxAuthCode, updateInvoiceRequest.taxAuthCode) &&
        Objects.equals(this.remark, updateInvoiceRequest.remark) &&
        Objects.equals(this.invoiceCheckStatus, updateInvoiceRequest.invoiceCheckStatus) &&
        Objects.equals(this.invoiceCheckNote, updateInvoiceRequest.invoiceCheckNote) &&
        Objects.equals(this.invoiceCheckPerson, updateInvoiceRequest.invoiceCheckPerson) &&
        Objects.equals(this.invoiceCheckTime, updateInvoiceRequest.invoiceCheckTime) &&
        Objects.equals(this.smInvoiceCode, updateInvoiceRequest.smInvoiceCode) &&
        Objects.equals(this.smInvoiceNo, updateInvoiceRequest.smInvoiceNo) &&
        Objects.equals(this.smPurchaserTaxNo, updateInvoiceRequest.smPurchaserTaxNo) &&
        Objects.equals(this.smSellerTaxNo, updateInvoiceRequest.smSellerTaxNo) &&
        Objects.equals(this.smPaperDrewDate, updateInvoiceRequest.smPaperDrewDate) &&
        Objects.equals(this.smAmountWithoutTax, updateInvoiceRequest.smAmountWithoutTax) &&
        Objects.equals(this.smTaxAmount, updateInvoiceRequest.smTaxAmount) &&
        Objects.equals(this.smAmountWithTax, updateInvoiceRequest.smAmountWithTax) &&
        Objects.equals(this.smUpdator, updateInvoiceRequest.smUpdator) &&
        Objects.equals(this.smBarcode, updateInvoiceRequest.smBarcode) &&
        Objects.equals(this.smImgUrl, updateInvoiceRequest.smImgUrl) &&
        Objects.equals(this.smInvoiceId, updateInvoiceRequest.smInvoiceId) &&
        Objects.equals(this.smInvoiceSource, updateInvoiceRequest.smInvoiceSource) &&
        Objects.equals(this.enInvoiceCode, updateInvoiceRequest.enInvoiceCode) &&
        Objects.equals(this.enInvoiceNo, updateInvoiceRequest.enInvoiceNo) &&
        Objects.equals(this.enPurchaserTaxNo, updateInvoiceRequest.enPurchaserTaxNo) &&
        Objects.equals(this.enSellerTaxNo, updateInvoiceRequest.enSellerTaxNo) &&
        Objects.equals(this.enPaperDrewDate, updateInvoiceRequest.enPaperDrewDate) &&
        Objects.equals(this.enAmountWithoutTax, updateInvoiceRequest.enAmountWithoutTax) &&
        Objects.equals(this.enTaxAmount, updateInvoiceRequest.enTaxAmount) &&
        Objects.equals(this.enAmountWithTax, updateInvoiceRequest.enAmountWithTax) &&
        Objects.equals(this.enTaxRate, updateInvoiceRequest.enTaxRate) &&
        Objects.equals(this.isPushTask, updateInvoiceRequest.isPushTask) &&
        Objects.equals(this.isObsolete, updateInvoiceRequest.isObsolete) &&
        Objects.equals(this.isResult, updateInvoiceRequest.isResult) &&
        Objects.equals(this.ifRepeat, updateInvoiceRequest.ifRepeat) &&
        Objects.equals(this.ifAuthFlag, updateInvoiceRequest.ifAuthFlag) &&
        Objects.equals(this.isLegalSynergetics, updateInvoiceRequest.isLegalSynergetics) &&
        Objects.equals(this.signStatus, updateInvoiceRequest.signStatus) &&
        Objects.equals(this.ifSendExption, updateInvoiceRequest.ifSendExption) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, invoiceType, invoiceNo, invoiceCode, status, createTime, updateTime, salesbillId, salesbillNo, packageCode, purchaserName, purchaserTaxNo, purchaserAddress, purchaserTel, purchaserAddrTel, purchaserBankName, purchaserBankAccount, purchaserBankNameAccount, purchaserExternalCode, sellerName, sellerTaxNo, sellerAddress, sellerTel, sellerAddrTel, sellerBankName, sellerBankAccount, sellerBankNameAccount, sellerExternalCode, sellerInvoiceId, sellerUserName, sellerViewImageFlag, sellerSyncStatus, sellerSyncTime, taxRate, amountWithoutTax, taxAmount, amountWithTax, amountWithTaxCapital, paperDrewDate, machineCode, checkCode, cipherText, invoiceOrig, dataFromSystem, specialInvoiceFlag, titleOkFlag, saleListFlag, dataOkFlag, recogStatus, recogImageStatus, recogInvoiceId, recogResponseTime, recogUserName, recogUploadNum, veriInvoiceId, veriStatus, veriRequestTime, veriResponseTime, veriUserId, veriUserName, veriRemark, taxInvoiceId, authSyncStatus, authSyncTime, authStatus, authStyle, authBussiDate, authTaxPeriod, authRequestTime, authResponseTime, authRequestUserId, authRequestUserName, authRequestSerialNo, authRemark, authValidTime, authValidResult, authValidRemark, authAmountWithoutTax, authTaxAmount, authCount, authReturnTime, actualAuthWay, redStatus, redTime, redNotificationNo, redUserId, redUserName, originInvoiceNo, originInvoiceCode, redRemark, retreatStatus, retreatTime, retreatUserId, retreatUserName, retreatRemark, originSalesbillId, originSalesbillNo, cashierName, checkerName, invoicerName, provinceCode, provinceName, recogUserId, recogDeductionImageUrl, recogInvoiceImageUrl, pdfUrl, vehicleType, vehicleBrand, productionArea, certNo, importCertNo, inspectionNo, engineNo, organizationCode, vin, tonnage, taxPaidProof, maxCapacity, taxAuthName, taxAuthCode, remark, invoiceCheckStatus, invoiceCheckNote, invoiceCheckPerson, invoiceCheckTime, smInvoiceCode, smInvoiceNo, smPurchaserTaxNo, smSellerTaxNo, smPaperDrewDate, smAmountWithoutTax, smTaxAmount, smAmountWithTax, smUpdator, smBarcode, smImgUrl, smInvoiceId, smInvoiceSource, enInvoiceCode, enInvoiceNo, enPurchaserTaxNo, enSellerTaxNo, enPaperDrewDate, enAmountWithoutTax, enTaxAmount, enAmountWithTax, enTaxRate, isPushTask, isObsolete, isResult, ifRepeat, ifAuthFlag, isLegalSynergetics, signStatus, ifSendExption, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateInvoiceRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    salesbillId: ").append(toIndentedString(salesbillId)).append("\n");
    sb.append("    salesbillNo: ").append(toIndentedString(salesbillNo)).append("\n");
    sb.append("    packageCode: ").append(toIndentedString(packageCode)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    purchaserAddress: ").append(toIndentedString(purchaserAddress)).append("\n");
    sb.append("    purchaserTel: ").append(toIndentedString(purchaserTel)).append("\n");
    sb.append("    purchaserAddrTel: ").append(toIndentedString(purchaserAddrTel)).append("\n");
    sb.append("    purchaserBankName: ").append(toIndentedString(purchaserBankName)).append("\n");
    sb.append("    purchaserBankAccount: ").append(toIndentedString(purchaserBankAccount)).append("\n");
    sb.append("    purchaserBankNameAccount: ").append(toIndentedString(purchaserBankNameAccount)).append("\n");
    sb.append("    purchaserExternalCode: ").append(toIndentedString(purchaserExternalCode)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    sellerAddress: ").append(toIndentedString(sellerAddress)).append("\n");
    sb.append("    sellerTel: ").append(toIndentedString(sellerTel)).append("\n");
    sb.append("    sellerAddrTel: ").append(toIndentedString(sellerAddrTel)).append("\n");
    sb.append("    sellerBankName: ").append(toIndentedString(sellerBankName)).append("\n");
    sb.append("    sellerBankAccount: ").append(toIndentedString(sellerBankAccount)).append("\n");
    sb.append("    sellerBankNameAccount: ").append(toIndentedString(sellerBankNameAccount)).append("\n");
    sb.append("    sellerExternalCode: ").append(toIndentedString(sellerExternalCode)).append("\n");
    sb.append("    sellerInvoiceId: ").append(toIndentedString(sellerInvoiceId)).append("\n");
    sb.append("    sellerUserName: ").append(toIndentedString(sellerUserName)).append("\n");
    sb.append("    sellerViewImageFlag: ").append(toIndentedString(sellerViewImageFlag)).append("\n");
    sb.append("    sellerSyncStatus: ").append(toIndentedString(sellerSyncStatus)).append("\n");
    sb.append("    sellerSyncTime: ").append(toIndentedString(sellerSyncTime)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    amountWithTaxCapital: ").append(toIndentedString(amountWithTaxCapital)).append("\n");
    sb.append("    paperDrewDate: ").append(toIndentedString(paperDrewDate)).append("\n");
    sb.append("    machineCode: ").append(toIndentedString(machineCode)).append("\n");
    sb.append("    checkCode: ").append(toIndentedString(checkCode)).append("\n");
    sb.append("    cipherText: ").append(toIndentedString(cipherText)).append("\n");
    sb.append("    invoiceOrig: ").append(toIndentedString(invoiceOrig)).append("\n");
    sb.append("    dataFromSystem: ").append(toIndentedString(dataFromSystem)).append("\n");
    sb.append("    specialInvoiceFlag: ").append(toIndentedString(specialInvoiceFlag)).append("\n");
    sb.append("    titleOkFlag: ").append(toIndentedString(titleOkFlag)).append("\n");
    sb.append("    saleListFlag: ").append(toIndentedString(saleListFlag)).append("\n");
    sb.append("    dataOkFlag: ").append(toIndentedString(dataOkFlag)).append("\n");
    sb.append("    recogStatus: ").append(toIndentedString(recogStatus)).append("\n");
    sb.append("    recogImageStatus: ").append(toIndentedString(recogImageStatus)).append("\n");
    sb.append("    recogInvoiceId: ").append(toIndentedString(recogInvoiceId)).append("\n");
    sb.append("    recogResponseTime: ").append(toIndentedString(recogResponseTime)).append("\n");
    sb.append("    recogUserName: ").append(toIndentedString(recogUserName)).append("\n");
    sb.append("    recogUploadNum: ").append(toIndentedString(recogUploadNum)).append("\n");
    sb.append("    veriInvoiceId: ").append(toIndentedString(veriInvoiceId)).append("\n");
    sb.append("    veriStatus: ").append(toIndentedString(veriStatus)).append("\n");
    sb.append("    veriRequestTime: ").append(toIndentedString(veriRequestTime)).append("\n");
    sb.append("    veriResponseTime: ").append(toIndentedString(veriResponseTime)).append("\n");
    sb.append("    veriUserId: ").append(toIndentedString(veriUserId)).append("\n");
    sb.append("    veriUserName: ").append(toIndentedString(veriUserName)).append("\n");
    sb.append("    veriRemark: ").append(toIndentedString(veriRemark)).append("\n");
    sb.append("    taxInvoiceId: ").append(toIndentedString(taxInvoiceId)).append("\n");
    sb.append("    authSyncStatus: ").append(toIndentedString(authSyncStatus)).append("\n");
    sb.append("    authSyncTime: ").append(toIndentedString(authSyncTime)).append("\n");
    sb.append("    authStatus: ").append(toIndentedString(authStatus)).append("\n");
    sb.append("    authStyle: ").append(toIndentedString(authStyle)).append("\n");
    sb.append("    authBussiDate: ").append(toIndentedString(authBussiDate)).append("\n");
    sb.append("    authTaxPeriod: ").append(toIndentedString(authTaxPeriod)).append("\n");
    sb.append("    authRequestTime: ").append(toIndentedString(authRequestTime)).append("\n");
    sb.append("    authResponseTime: ").append(toIndentedString(authResponseTime)).append("\n");
    sb.append("    authRequestUserId: ").append(toIndentedString(authRequestUserId)).append("\n");
    sb.append("    authRequestUserName: ").append(toIndentedString(authRequestUserName)).append("\n");
    sb.append("    authRequestSerialNo: ").append(toIndentedString(authRequestSerialNo)).append("\n");
    sb.append("    authRemark: ").append(toIndentedString(authRemark)).append("\n");
    sb.append("    authValidTime: ").append(toIndentedString(authValidTime)).append("\n");
    sb.append("    authValidResult: ").append(toIndentedString(authValidResult)).append("\n");
    sb.append("    authValidRemark: ").append(toIndentedString(authValidRemark)).append("\n");
    sb.append("    authAmountWithoutTax: ").append(toIndentedString(authAmountWithoutTax)).append("\n");
    sb.append("    authTaxAmount: ").append(toIndentedString(authTaxAmount)).append("\n");
    sb.append("    authCount: ").append(toIndentedString(authCount)).append("\n");
    sb.append("    authReturnTime: ").append(toIndentedString(authReturnTime)).append("\n");
    sb.append("    actualAuthWay: ").append(toIndentedString(actualAuthWay)).append("\n");
    sb.append("    redStatus: ").append(toIndentedString(redStatus)).append("\n");
    sb.append("    redTime: ").append(toIndentedString(redTime)).append("\n");
    sb.append("    redNotificationNo: ").append(toIndentedString(redNotificationNo)).append("\n");
    sb.append("    redUserId: ").append(toIndentedString(redUserId)).append("\n");
    sb.append("    redUserName: ").append(toIndentedString(redUserName)).append("\n");
    sb.append("    originInvoiceNo: ").append(toIndentedString(originInvoiceNo)).append("\n");
    sb.append("    originInvoiceCode: ").append(toIndentedString(originInvoiceCode)).append("\n");
    sb.append("    redRemark: ").append(toIndentedString(redRemark)).append("\n");
    sb.append("    retreatStatus: ").append(toIndentedString(retreatStatus)).append("\n");
    sb.append("    retreatTime: ").append(toIndentedString(retreatTime)).append("\n");
    sb.append("    retreatUserId: ").append(toIndentedString(retreatUserId)).append("\n");
    sb.append("    retreatUserName: ").append(toIndentedString(retreatUserName)).append("\n");
    sb.append("    retreatRemark: ").append(toIndentedString(retreatRemark)).append("\n");
    sb.append("    originSalesbillId: ").append(toIndentedString(originSalesbillId)).append("\n");
    sb.append("    originSalesbillNo: ").append(toIndentedString(originSalesbillNo)).append("\n");
    sb.append("    cashierName: ").append(toIndentedString(cashierName)).append("\n");
    sb.append("    checkerName: ").append(toIndentedString(checkerName)).append("\n");
    sb.append("    invoicerName: ").append(toIndentedString(invoicerName)).append("\n");
    sb.append("    provinceCode: ").append(toIndentedString(provinceCode)).append("\n");
    sb.append("    provinceName: ").append(toIndentedString(provinceName)).append("\n");
    sb.append("    recogUserId: ").append(toIndentedString(recogUserId)).append("\n");
    sb.append("    recogDeductionImageUrl: ").append(toIndentedString(recogDeductionImageUrl)).append("\n");
    sb.append("    recogInvoiceImageUrl: ").append(toIndentedString(recogInvoiceImageUrl)).append("\n");
    sb.append("    pdfUrl: ").append(toIndentedString(pdfUrl)).append("\n");
    sb.append("    vehicleType: ").append(toIndentedString(vehicleType)).append("\n");
    sb.append("    vehicleBrand: ").append(toIndentedString(vehicleBrand)).append("\n");
    sb.append("    productionArea: ").append(toIndentedString(productionArea)).append("\n");
    sb.append("    certNo: ").append(toIndentedString(certNo)).append("\n");
    sb.append("    importCertNo: ").append(toIndentedString(importCertNo)).append("\n");
    sb.append("    inspectionNo: ").append(toIndentedString(inspectionNo)).append("\n");
    sb.append("    engineNo: ").append(toIndentedString(engineNo)).append("\n");
    sb.append("    organizationCode: ").append(toIndentedString(organizationCode)).append("\n");
    sb.append("    vin: ").append(toIndentedString(vin)).append("\n");
    sb.append("    tonnage: ").append(toIndentedString(tonnage)).append("\n");
    sb.append("    taxPaidProof: ").append(toIndentedString(taxPaidProof)).append("\n");
    sb.append("    maxCapacity: ").append(toIndentedString(maxCapacity)).append("\n");
    sb.append("    taxAuthName: ").append(toIndentedString(taxAuthName)).append("\n");
    sb.append("    taxAuthCode: ").append(toIndentedString(taxAuthCode)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    invoiceCheckStatus: ").append(toIndentedString(invoiceCheckStatus)).append("\n");
    sb.append("    invoiceCheckNote: ").append(toIndentedString(invoiceCheckNote)).append("\n");
    sb.append("    invoiceCheckPerson: ").append(toIndentedString(invoiceCheckPerson)).append("\n");
    sb.append("    invoiceCheckTime: ").append(toIndentedString(invoiceCheckTime)).append("\n");
    sb.append("    smInvoiceCode: ").append(toIndentedString(smInvoiceCode)).append("\n");
    sb.append("    smInvoiceNo: ").append(toIndentedString(smInvoiceNo)).append("\n");
    sb.append("    smPurchaserTaxNo: ").append(toIndentedString(smPurchaserTaxNo)).append("\n");
    sb.append("    smSellerTaxNo: ").append(toIndentedString(smSellerTaxNo)).append("\n");
    sb.append("    smPaperDrewDate: ").append(toIndentedString(smPaperDrewDate)).append("\n");
    sb.append("    smAmountWithoutTax: ").append(toIndentedString(smAmountWithoutTax)).append("\n");
    sb.append("    smTaxAmount: ").append(toIndentedString(smTaxAmount)).append("\n");
    sb.append("    smAmountWithTax: ").append(toIndentedString(smAmountWithTax)).append("\n");
    sb.append("    smUpdator: ").append(toIndentedString(smUpdator)).append("\n");
    sb.append("    smBarcode: ").append(toIndentedString(smBarcode)).append("\n");
    sb.append("    smImgUrl: ").append(toIndentedString(smImgUrl)).append("\n");
    sb.append("    smInvoiceId: ").append(toIndentedString(smInvoiceId)).append("\n");
    sb.append("    smInvoiceSource: ").append(toIndentedString(smInvoiceSource)).append("\n");
    sb.append("    enInvoiceCode: ").append(toIndentedString(enInvoiceCode)).append("\n");
    sb.append("    enInvoiceNo: ").append(toIndentedString(enInvoiceNo)).append("\n");
    sb.append("    enPurchaserTaxNo: ").append(toIndentedString(enPurchaserTaxNo)).append("\n");
    sb.append("    enSellerTaxNo: ").append(toIndentedString(enSellerTaxNo)).append("\n");
    sb.append("    enPaperDrewDate: ").append(toIndentedString(enPaperDrewDate)).append("\n");
    sb.append("    enAmountWithoutTax: ").append(toIndentedString(enAmountWithoutTax)).append("\n");
    sb.append("    enTaxAmount: ").append(toIndentedString(enTaxAmount)).append("\n");
    sb.append("    enAmountWithTax: ").append(toIndentedString(enAmountWithTax)).append("\n");
    sb.append("    enTaxRate: ").append(toIndentedString(enTaxRate)).append("\n");
    sb.append("    isPushTask: ").append(toIndentedString(isPushTask)).append("\n");
    sb.append("    isObsolete: ").append(toIndentedString(isObsolete)).append("\n");
    sb.append("    isResult: ").append(toIndentedString(isResult)).append("\n");
    sb.append("    ifRepeat: ").append(toIndentedString(ifRepeat)).append("\n");
    sb.append("    ifAuthFlag: ").append(toIndentedString(ifAuthFlag)).append("\n");
    sb.append("    isLegalSynergetics: ").append(toIndentedString(isLegalSynergetics)).append("\n");
    sb.append("    signStatus: ").append(toIndentedString(signStatus)).append("\n");
    sb.append("    ifSendExption: ").append(toIndentedString(ifSendExption)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
