package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.vanke.in.client.model.LogInvoiceDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发票操作履历表Request
 */
@ApiModel(description = "发票操作履历表Request")

@JsonInclude(NON_NULL)
public class UpdateLogInvoiceRequest extends BaseRequest {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("invoiceId")
  private Long invoiceId = null;

  @JsonProperty("actionFrom")
  private Integer actionFrom = null;

  @JsonProperty("content")
  private String content = null;

  @JsonProperty("opTime")
  private Long opTime = null;

  @JsonProperty("opUserId")
  private Long opUserId = null;

  @JsonProperty("opUserName")
  private String opUserName = null;

  @JsonProperty("opRemark")
  private String opRemark = null;

  @JsonIgnore
  public UpdateLogInvoiceRequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public UpdateLogInvoiceRequest invoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
    return this;
  }

   /**
   * 发票ID
   * @return invoiceId
  **/
  @ApiModelProperty(value = "发票ID")
  public Long getInvoiceId() {
    return invoiceId;
  }

  public void setInvoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
  }

  @JsonIgnore
  public UpdateLogInvoiceRequest actionFrom(Integer actionFrom) {
    this.actionFrom = actionFrom;
    return this;
  }

   /**
   * 来源
   * @return actionFrom
  **/
  @ApiModelProperty(value = "来源")
  public Integer getActionFrom() {
    return actionFrom;
  }

  public void setActionFrom(Integer actionFrom) {
    this.actionFrom = actionFrom;
  }

  @JsonIgnore
  public UpdateLogInvoiceRequest content(String content) {
    this.content = content;
    return this;
  }

   /**
   * 内容
   * @return content
  **/
  @ApiModelProperty(value = "内容")
  public String getContent() {
    return content;
  }

  public void setContent(String content) {
    this.content = content;
  }

  @JsonIgnore
  public UpdateLogInvoiceRequest opTime(Long opTime) {
    this.opTime = opTime;
    return this;
  }

   /**
   * 操作时间
   * @return opTime
  **/
  @ApiModelProperty(value = "操作时间")
  public Long getOpTime() {
    return opTime;
  }

  public void setOpTime(Long opTime) {
    this.opTime = opTime;
  }

  @JsonIgnore
  public UpdateLogInvoiceRequest opUserId(Long opUserId) {
    this.opUserId = opUserId;
    return this;
  }

   /**
   * 操作人ID
   * @return opUserId
  **/
  @ApiModelProperty(value = "操作人ID")
  public Long getOpUserId() {
    return opUserId;
  }

  public void setOpUserId(Long opUserId) {
    this.opUserId = opUserId;
  }

  @JsonIgnore
  public UpdateLogInvoiceRequest opUserName(String opUserName) {
    this.opUserName = opUserName;
    return this;
  }

   /**
   * 操作人姓名
   * @return opUserName
  **/
  @ApiModelProperty(value = "操作人姓名")
  public String getOpUserName() {
    return opUserName;
  }

  public void setOpUserName(String opUserName) {
    this.opUserName = opUserName;
  }

  @JsonIgnore
  public UpdateLogInvoiceRequest opRemark(String opRemark) {
    this.opRemark = opRemark;
    return this;
  }

   /**
   * 处理备注
   * @return opRemark
  **/
  @ApiModelProperty(value = "处理备注")
  public String getOpRemark() {
    return opRemark;
  }

  public void setOpRemark(String opRemark) {
    this.opRemark = opRemark;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateLogInvoiceRequest updateLogInvoiceRequest = (UpdateLogInvoiceRequest) o;
    return Objects.equals(this.id, updateLogInvoiceRequest.id) &&
        Objects.equals(this.invoiceId, updateLogInvoiceRequest.invoiceId) &&
        Objects.equals(this.actionFrom, updateLogInvoiceRequest.actionFrom) &&
        Objects.equals(this.content, updateLogInvoiceRequest.content) &&
        Objects.equals(this.opTime, updateLogInvoiceRequest.opTime) &&
        Objects.equals(this.opUserId, updateLogInvoiceRequest.opUserId) &&
        Objects.equals(this.opUserName, updateLogInvoiceRequest.opUserName) &&
        Objects.equals(this.opRemark, updateLogInvoiceRequest.opRemark) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, invoiceId, actionFrom, content, opTime, opUserId, opUserName, opRemark, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateLogInvoiceRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    invoiceId: ").append(toIndentedString(invoiceId)).append("\n");
    sb.append("    actionFrom: ").append(toIndentedString(actionFrom)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    opTime: ").append(toIndentedString(opTime)).append("\n");
    sb.append("    opUserId: ").append(toIndentedString(opUserId)).append("\n");
    sb.append("    opUserName: ").append(toIndentedString(opUserName)).append("\n");
    sb.append("    opRemark: ").append(toIndentedString(opRemark)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
