package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 异常工单表
 */
@ApiModel(description = "异常工单表")

@JsonInclude(NON_NULL)
public class WkExceptionDTO {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("exceptionType")
  private Integer exceptionType = null;

  @JsonProperty("dataFromSystem")
  private String dataFromSystem = null;

  @JsonProperty("packageCode")
  private String packageCode = null;

  @JsonProperty("orderId")
  private Long orderId = null;

  @JsonProperty("orderCode")
  private String orderCode = null;

  @JsonProperty("invoiceId")
  private Long invoiceId = null;

  @JsonProperty("billCode")
  private String billCode = null;

  @JsonProperty("billNumber")
  private String billNumber = null;

  @JsonProperty("handleWay")
  private Integer handleWay = null;

  @JsonProperty("backExpressNumber")
  private String backExpressNumber = null;

  @JsonProperty("exceptionNote")
  private String exceptionNote = null;

  @JsonProperty("handlePerson")
  private String handlePerson = null;

  @JsonProperty("handleTime")
  private Long handleTime = null;

  @JsonProperty("sendPerson")
  private String sendPerson = null;

  @JsonProperty("sendPersonPhone")
  private String sendPersonPhone = null;

  @JsonProperty("createTime")
  private Long createTime = null;

  @JsonProperty("producter")
  private String producter = null;

  @JsonProperty("productTime")
  private Long productTime = null;

  @JsonProperty("handleStatus")
  private Integer handleStatus = null;

  @JsonProperty("handleRemark")
  private String handleRemark = null;

  @JsonProperty("errorType")
  private String errorType = null;

  @JsonProperty("confirmStatus")
  private Integer confirmStatus = null;

  @JsonProperty("holdTime")
  private Long holdTime = null;

  @JsonProperty("creator")
  private String creator = null;

  @JsonProperty("firstExamineEmail")
  private String firstExamineEmail = null;

  @JsonProperty("agentEmail")
  private String agentEmail = null;

  @JsonProperty("recipientPhone")
  private String recipientPhone = null;

  @JsonProperty("recipient")
  private String recipient = null;

  @JsonProperty("recipientCompany")
  private String recipientCompany = null;

  @JsonProperty("returnBatch")
  private Integer returnBatch = null;

  @JsonProperty("returnType")
  private Integer returnType = null;

  @JsonProperty("needExpress")
  private Integer needExpress = null;

  @JsonProperty("documentType")
  private Integer documentType = null;

  @JsonProperty("cooperateFlag")
  private Integer cooperateFlag = null;

  @JsonIgnore
  public WkExceptionDTO id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public WkExceptionDTO exceptionType(Integer exceptionType) {
    this.exceptionType = exceptionType;
    return this;
  }

   /**
   * 异常工单分类：0-无，1-签收异常，2-审核异常，3-发票转异常
   * @return exceptionType
  **/
  @ApiModelProperty(value = "异常工单分类：0-无，1-签收异常，2-审核异常，3-发票转异常")
  public Integer getExceptionType() {
    return exceptionType;
  }

  public void setExceptionType(Integer exceptionType) {
    this.exceptionType = exceptionType;
  }

  @JsonIgnore
  public WkExceptionDTO dataFromSystem(String dataFromSystem) {
    this.dataFromSystem = dataFromSystem;
    return this;
  }

   /**
   * 数据来源
   * @return dataFromSystem
  **/
  @ApiModelProperty(value = "数据来源")
  public String getDataFromSystem() {
    return dataFromSystem;
  }

  public void setDataFromSystem(String dataFromSystem) {
    this.dataFromSystem = dataFromSystem;
  }

  @JsonIgnore
  public WkExceptionDTO packageCode(String packageCode) {
    this.packageCode = packageCode;
    return this;
  }

   /**
   * 邮包快递单号
   * @return packageCode
  **/
  @ApiModelProperty(value = "邮包快递单号")
  public String getPackageCode() {
    return packageCode;
  }

  public void setPackageCode(String packageCode) {
    this.packageCode = packageCode;
  }

  @JsonIgnore
  public WkExceptionDTO orderId(Long orderId) {
    this.orderId = orderId;
    return this;
  }

   /**
   * 结算单id
   * @return orderId
  **/
  @ApiModelProperty(value = "结算单id")
  public Long getOrderId() {
    return orderId;
  }

  public void setOrderId(Long orderId) {
    this.orderId = orderId;
  }

  @JsonIgnore
  public WkExceptionDTO orderCode(String orderCode) {
    this.orderCode = orderCode;
    return this;
  }

   /**
   * 结算单编号
   * @return orderCode
  **/
  @ApiModelProperty(value = "结算单编号")
  public String getOrderCode() {
    return orderCode;
  }

  public void setOrderCode(String orderCode) {
    this.orderCode = orderCode;
  }

  @JsonIgnore
  public WkExceptionDTO invoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
    return this;
  }

   /**
   * 发票id
   * @return invoiceId
  **/
  @ApiModelProperty(value = "发票id")
  public Long getInvoiceId() {
    return invoiceId;
  }

  public void setInvoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
  }

  @JsonIgnore
  public WkExceptionDTO billCode(String billCode) {
    this.billCode = billCode;
    return this;
  }

   /**
   * 发票代码
   * @return billCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getBillCode() {
    return billCode;
  }

  public void setBillCode(String billCode) {
    this.billCode = billCode;
  }

  @JsonIgnore
  public WkExceptionDTO billNumber(String billNumber) {
    this.billNumber = billNumber;
    return this;
  }

   /**
   * 发票号
   * @return billNumber
  **/
  @ApiModelProperty(value = "发票号")
  public String getBillNumber() {
    return billNumber;
  }

  public void setBillNumber(String billNumber) {
    this.billNumber = billNumber;
  }

  @JsonIgnore
  public WkExceptionDTO handleWay(Integer handleWay) {
    this.handleWay = handleWay;
    return this;
  }

   /**
   * 处理方式：1-退回经办人，2-退回供应商，3-转交签收岗，4-关闭
   * @return handleWay
  **/
  @ApiModelProperty(value = "处理方式：1-退回经办人，2-退回供应商，3-转交签收岗，4-关闭")
  public Integer getHandleWay() {
    return handleWay;
  }

  public void setHandleWay(Integer handleWay) {
    this.handleWay = handleWay;
  }

  @JsonIgnore
  public WkExceptionDTO backExpressNumber(String backExpressNumber) {
    this.backExpressNumber = backExpressNumber;
    return this;
  }

   /**
   * 回寄快递单号
   * @return backExpressNumber
  **/
  @ApiModelProperty(value = "回寄快递单号")
  public String getBackExpressNumber() {
    return backExpressNumber;
  }

  public void setBackExpressNumber(String backExpressNumber) {
    this.backExpressNumber = backExpressNumber;
  }

  @JsonIgnore
  public WkExceptionDTO exceptionNote(String exceptionNote) {
    this.exceptionNote = exceptionNote;
    return this;
  }

   /**
   * 异常处理备注
   * @return exceptionNote
  **/
  @ApiModelProperty(value = "异常处理备注")
  public String getExceptionNote() {
    return exceptionNote;
  }

  public void setExceptionNote(String exceptionNote) {
    this.exceptionNote = exceptionNote;
  }

  @JsonIgnore
  public WkExceptionDTO handlePerson(String handlePerson) {
    this.handlePerson = handlePerson;
    return this;
  }

   /**
   * 处理人
   * @return handlePerson
  **/
  @ApiModelProperty(value = "处理人")
  public String getHandlePerson() {
    return handlePerson;
  }

  public void setHandlePerson(String handlePerson) {
    this.handlePerson = handlePerson;
  }

  @JsonIgnore
  public WkExceptionDTO handleTime(Long handleTime) {
    this.handleTime = handleTime;
    return this;
  }

   /**
   * 处理时间
   * @return handleTime
  **/
  @ApiModelProperty(value = "处理时间")
  public Long getHandleTime() {
    return handleTime;
  }

  public void setHandleTime(Long handleTime) {
    this.handleTime = handleTime;
  }

  @JsonIgnore
  public WkExceptionDTO sendPerson(String sendPerson) {
    this.sendPerson = sendPerson;
    return this;
  }

   /**
   * 寄件人
   * @return sendPerson
  **/
  @ApiModelProperty(value = "寄件人")
  public String getSendPerson() {
    return sendPerson;
  }

  public void setSendPerson(String sendPerson) {
    this.sendPerson = sendPerson;
  }

  @JsonIgnore
  public WkExceptionDTO sendPersonPhone(String sendPersonPhone) {
    this.sendPersonPhone = sendPersonPhone;
    return this;
  }

   /**
   * 寄件人联系方式
   * @return sendPersonPhone
  **/
  @ApiModelProperty(value = "寄件人联系方式")
  public String getSendPersonPhone() {
    return sendPersonPhone;
  }

  public void setSendPersonPhone(String sendPersonPhone) {
    this.sendPersonPhone = sendPersonPhone;
  }

  @JsonIgnore
  public WkExceptionDTO createTime(Long createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public Long getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Long createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public WkExceptionDTO producter(String producter) {
    this.producter = producter;
    return this;
  }

   /**
   * 发起人
   * @return producter
  **/
  @ApiModelProperty(value = "发起人")
  public String getProducter() {
    return producter;
  }

  public void setProducter(String producter) {
    this.producter = producter;
  }

  @JsonIgnore
  public WkExceptionDTO productTime(Long productTime) {
    this.productTime = productTime;
    return this;
  }

   /**
   * 发起时间
   * @return productTime
  **/
  @ApiModelProperty(value = "发起时间")
  public Long getProductTime() {
    return productTime;
  }

  public void setProductTime(Long productTime) {
    this.productTime = productTime;
  }

  @JsonIgnore
  public WkExceptionDTO handleStatus(Integer handleStatus) {
    this.handleStatus = handleStatus;
    return this;
  }

   /**
   * 处理状态：0-未处理，1-已处理, 2-暂挂起
   * @return handleStatus
  **/
  @ApiModelProperty(value = "处理状态：0-未处理，1-已处理, 2-暂挂起")
  public Integer getHandleStatus() {
    return handleStatus;
  }

  public void setHandleStatus(Integer handleStatus) {
    this.handleStatus = handleStatus;
  }

  @JsonIgnore
  public WkExceptionDTO handleRemark(String handleRemark) {
    this.handleRemark = handleRemark;
    return this;
  }

   /**
   * 异常工单处理说明
   * @return handleRemark
  **/
  @ApiModelProperty(value = "异常工单处理说明")
  public String getHandleRemark() {
    return handleRemark;
  }

  public void setHandleRemark(String handleRemark) {
    this.handleRemark = handleRemark;
  }

  @JsonIgnore
  public WkExceptionDTO errorType(String errorType) {
    this.errorType = errorType;
    return this;
  }

   /**
   * 异常原因分类：1-发票未盖章，2-发票污损，3-发票打印错位，4-发票无结算单，5-其他，6-审核异常，7-抵扣 8-其他
   * @return errorType
  **/
  @ApiModelProperty(value = "异常原因分类：1-发票未盖章，2-发票污损，3-发票打印错位，4-发票无结算单，5-其他，6-审核异常，7-抵扣 8-其他")
  public String getErrorType() {
    return errorType;
  }

  public void setErrorType(String errorType) {
    this.errorType = errorType;
  }

  @JsonIgnore
  public WkExceptionDTO confirmStatus(Integer confirmStatus) {
    this.confirmStatus = confirmStatus;
    return this;
  }

   /**
   * null
   * @return confirmStatus
  **/
  @ApiModelProperty(value = "null")
  public Integer getConfirmStatus() {
    return confirmStatus;
  }

  public void setConfirmStatus(Integer confirmStatus) {
    this.confirmStatus = confirmStatus;
  }

  @JsonIgnore
  public WkExceptionDTO holdTime(Long holdTime) {
    this.holdTime = holdTime;
    return this;
  }

   /**
   * 暂挂时间
   * @return holdTime
  **/
  @ApiModelProperty(value = "暂挂时间")
  public Long getHoldTime() {
    return holdTime;
  }

  public void setHoldTime(Long holdTime) {
    this.holdTime = holdTime;
  }

  @JsonIgnore
  public WkExceptionDTO creator(String creator) {
    this.creator = creator;
    return this;
  }

   /**
   * 确认人
   * @return creator
  **/
  @ApiModelProperty(value = "确认人")
  public String getCreator() {
    return creator;
  }

  public void setCreator(String creator) {
    this.creator = creator;
  }

  @JsonIgnore
  public WkExceptionDTO firstExamineEmail(String firstExamineEmail) {
    this.firstExamineEmail = firstExamineEmail;
    return this;
  }

   /**
   * 初审岗邮箱
   * @return firstExamineEmail
  **/
  @ApiModelProperty(value = "初审岗邮箱")
  public String getFirstExamineEmail() {
    return firstExamineEmail;
  }

  public void setFirstExamineEmail(String firstExamineEmail) {
    this.firstExamineEmail = firstExamineEmail;
  }

  @JsonIgnore
  public WkExceptionDTO agentEmail(String agentEmail) {
    this.agentEmail = agentEmail;
    return this;
  }

   /**
   * 经办人邮箱
   * @return agentEmail
  **/
  @ApiModelProperty(value = "经办人邮箱")
  public String getAgentEmail() {
    return agentEmail;
  }

  public void setAgentEmail(String agentEmail) {
    this.agentEmail = agentEmail;
  }

  @JsonIgnore
  public WkExceptionDTO recipientPhone(String recipientPhone) {
    this.recipientPhone = recipientPhone;
    return this;
  }

   /**
   * 收件人联系方式
   * @return recipientPhone
  **/
  @ApiModelProperty(value = "收件人联系方式")
  public String getRecipientPhone() {
    return recipientPhone;
  }

  public void setRecipientPhone(String recipientPhone) {
    this.recipientPhone = recipientPhone;
  }

  @JsonIgnore
  public WkExceptionDTO recipient(String recipient) {
    this.recipient = recipient;
    return this;
  }

   /**
   * 收件人
   * @return recipient
  **/
  @ApiModelProperty(value = "收件人")
  public String getRecipient() {
    return recipient;
  }

  public void setRecipient(String recipient) {
    this.recipient = recipient;
  }

  @JsonIgnore
  public WkExceptionDTO recipientCompany(String recipientCompany) {
    this.recipientCompany = recipientCompany;
    return this;
  }

   /**
   * 收件公司
   * @return recipientCompany
  **/
  @ApiModelProperty(value = "收件公司")
  public String getRecipientCompany() {
    return recipientCompany;
  }

  public void setRecipientCompany(String recipientCompany) {
    this.recipientCompany = recipientCompany;
  }

  @JsonIgnore
  public WkExceptionDTO returnBatch(Integer returnBatch) {
    this.returnBatch = returnBatch;
    return this;
  }

   /**
   * 退回联次：0-无，1-发票联及抵扣联，2-发票联，3-抵扣联
   * @return returnBatch
  **/
  @ApiModelProperty(value = "退回联次：0-无，1-发票联及抵扣联，2-发票联，3-抵扣联")
  public Integer getReturnBatch() {
    return returnBatch;
  }

  public void setReturnBatch(Integer returnBatch) {
    this.returnBatch = returnBatch;
  }

  @JsonIgnore
  public WkExceptionDTO returnType(Integer returnType) {
    this.returnType = returnType;
    return this;
  }

   /**
   * 退回类型：0-无，1-发票票面有误，2-发票审核错误，3-产值有误，4-产值 红冲，5-邮寄错误，6-其他
   * @return returnType
  **/
  @ApiModelProperty(value = "退回类型：0-无，1-发票票面有误，2-发票审核错误，3-产值有误，4-产值 红冲，5-邮寄错误，6-其他")
  public Integer getReturnType() {
    return returnType;
  }

  public void setReturnType(Integer returnType) {
    this.returnType = returnType;
  }

  @JsonIgnore
  public WkExceptionDTO needExpress(Integer needExpress) {
    this.needExpress = needExpress;
    return this;
  }

   /**
   * 是否物流：0-不需要，1-需要
   * @return needExpress
  **/
  @ApiModelProperty(value = "是否物流：0-不需要，1-需要")
  public Integer getNeedExpress() {
    return needExpress;
  }

  public void setNeedExpress(Integer needExpress) {
    this.needExpress = needExpress;
  }

  @JsonIgnore
  public WkExceptionDTO documentType(Integer documentType) {
    this.documentType = documentType;
    return this;
  }

   /**
   * 文件类型：0-默认，1-业务单，2-发票
   * @return documentType
  **/
  @ApiModelProperty(value = "文件类型：0-默认，1-业务单，2-发票")
  public Integer getDocumentType() {
    return documentType;
  }

  public void setDocumentType(Integer documentType) {
    this.documentType = documentType;
  }

  @JsonIgnore
  public WkExceptionDTO cooperateFlag(Integer cooperateFlag) {
    this.cooperateFlag = cooperateFlag;
    return this;
  }

   /**
   * 协同标识： 1-协同； 0-不协同
   * @return cooperateFlag
  **/
  @ApiModelProperty(value = "协同标识： 1-协同； 0-不协同")
  public Integer getCooperateFlag() {
    return cooperateFlag;
  }

  public void setCooperateFlag(Integer cooperateFlag) {
    this.cooperateFlag = cooperateFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WkExceptionDTO wkExceptionDTO = (WkExceptionDTO) o;
    return Objects.equals(this.id, wkExceptionDTO.id) &&
        Objects.equals(this.exceptionType, wkExceptionDTO.exceptionType) &&
        Objects.equals(this.dataFromSystem, wkExceptionDTO.dataFromSystem) &&
        Objects.equals(this.packageCode, wkExceptionDTO.packageCode) &&
        Objects.equals(this.orderId, wkExceptionDTO.orderId) &&
        Objects.equals(this.orderCode, wkExceptionDTO.orderCode) &&
        Objects.equals(this.invoiceId, wkExceptionDTO.invoiceId) &&
        Objects.equals(this.billCode, wkExceptionDTO.billCode) &&
        Objects.equals(this.billNumber, wkExceptionDTO.billNumber) &&
        Objects.equals(this.handleWay, wkExceptionDTO.handleWay) &&
        Objects.equals(this.backExpressNumber, wkExceptionDTO.backExpressNumber) &&
        Objects.equals(this.exceptionNote, wkExceptionDTO.exceptionNote) &&
        Objects.equals(this.handlePerson, wkExceptionDTO.handlePerson) &&
        Objects.equals(this.handleTime, wkExceptionDTO.handleTime) &&
        Objects.equals(this.sendPerson, wkExceptionDTO.sendPerson) &&
        Objects.equals(this.sendPersonPhone, wkExceptionDTO.sendPersonPhone) &&
        Objects.equals(this.createTime, wkExceptionDTO.createTime) &&
        Objects.equals(this.producter, wkExceptionDTO.producter) &&
        Objects.equals(this.productTime, wkExceptionDTO.productTime) &&
        Objects.equals(this.handleStatus, wkExceptionDTO.handleStatus) &&
        Objects.equals(this.handleRemark, wkExceptionDTO.handleRemark) &&
        Objects.equals(this.errorType, wkExceptionDTO.errorType) &&
        Objects.equals(this.confirmStatus, wkExceptionDTO.confirmStatus) &&
        Objects.equals(this.holdTime, wkExceptionDTO.holdTime) &&
        Objects.equals(this.creator, wkExceptionDTO.creator) &&
        Objects.equals(this.firstExamineEmail, wkExceptionDTO.firstExamineEmail) &&
        Objects.equals(this.agentEmail, wkExceptionDTO.agentEmail) &&
        Objects.equals(this.recipientPhone, wkExceptionDTO.recipientPhone) &&
        Objects.equals(this.recipient, wkExceptionDTO.recipient) &&
        Objects.equals(this.recipientCompany, wkExceptionDTO.recipientCompany) &&
        Objects.equals(this.returnBatch, wkExceptionDTO.returnBatch) &&
        Objects.equals(this.returnType, wkExceptionDTO.returnType) &&
        Objects.equals(this.needExpress, wkExceptionDTO.needExpress) &&
        Objects.equals(this.documentType, wkExceptionDTO.documentType) &&
        Objects.equals(this.cooperateFlag, wkExceptionDTO.cooperateFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, exceptionType, dataFromSystem, packageCode, orderId, orderCode, invoiceId, billCode, billNumber, handleWay, backExpressNumber, exceptionNote, handlePerson, handleTime, sendPerson, sendPersonPhone, createTime, producter, productTime, handleStatus, handleRemark, errorType, confirmStatus, holdTime, creator, firstExamineEmail, agentEmail, recipientPhone, recipient, recipientCompany, returnBatch, returnType, needExpress, documentType, cooperateFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WkExceptionDTO {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    exceptionType: ").append(toIndentedString(exceptionType)).append("\n");
    sb.append("    dataFromSystem: ").append(toIndentedString(dataFromSystem)).append("\n");
    sb.append("    packageCode: ").append(toIndentedString(packageCode)).append("\n");
    sb.append("    orderId: ").append(toIndentedString(orderId)).append("\n");
    sb.append("    orderCode: ").append(toIndentedString(orderCode)).append("\n");
    sb.append("    invoiceId: ").append(toIndentedString(invoiceId)).append("\n");
    sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
    sb.append("    billNumber: ").append(toIndentedString(billNumber)).append("\n");
    sb.append("    handleWay: ").append(toIndentedString(handleWay)).append("\n");
    sb.append("    backExpressNumber: ").append(toIndentedString(backExpressNumber)).append("\n");
    sb.append("    exceptionNote: ").append(toIndentedString(exceptionNote)).append("\n");
    sb.append("    handlePerson: ").append(toIndentedString(handlePerson)).append("\n");
    sb.append("    handleTime: ").append(toIndentedString(handleTime)).append("\n");
    sb.append("    sendPerson: ").append(toIndentedString(sendPerson)).append("\n");
    sb.append("    sendPersonPhone: ").append(toIndentedString(sendPersonPhone)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    producter: ").append(toIndentedString(producter)).append("\n");
    sb.append("    productTime: ").append(toIndentedString(productTime)).append("\n");
    sb.append("    handleStatus: ").append(toIndentedString(handleStatus)).append("\n");
    sb.append("    handleRemark: ").append(toIndentedString(handleRemark)).append("\n");
    sb.append("    errorType: ").append(toIndentedString(errorType)).append("\n");
    sb.append("    confirmStatus: ").append(toIndentedString(confirmStatus)).append("\n");
    sb.append("    holdTime: ").append(toIndentedString(holdTime)).append("\n");
    sb.append("    creator: ").append(toIndentedString(creator)).append("\n");
    sb.append("    firstExamineEmail: ").append(toIndentedString(firstExamineEmail)).append("\n");
    sb.append("    agentEmail: ").append(toIndentedString(agentEmail)).append("\n");
    sb.append("    recipientPhone: ").append(toIndentedString(recipientPhone)).append("\n");
    sb.append("    recipient: ").append(toIndentedString(recipient)).append("\n");
    sb.append("    recipientCompany: ").append(toIndentedString(recipientCompany)).append("\n");
    sb.append("    returnBatch: ").append(toIndentedString(returnBatch)).append("\n");
    sb.append("    returnType: ").append(toIndentedString(returnType)).append("\n");
    sb.append("    needExpress: ").append(toIndentedString(needExpress)).append("\n");
    sb.append("    documentType: ").append(toIndentedString(documentType)).append("\n");
    sb.append("    cooperateFlag: ").append(toIndentedString(cooperateFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
