package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 月末核对
 */
@ApiModel(description = "月末核对")

@JsonInclude(NON_NULL)
public class WkOrdersEndcheckDTO {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("salesbillNo")
  private String salesbillNo = null;

  @JsonProperty("voucherCreated")
  private Integer voucherCreated = null;

  @JsonProperty("canDeduction")
  private Integer canDeduction = null;

  @JsonProperty("invoiceStatus")
  private String invoiceStatus = null;

  @JsonProperty("intAmountWithoutTax")
  private BigDecimal intAmountWithoutTax = null;

  @JsonProperty("intTaxAmount")
  private BigDecimal intTaxAmount = null;

  @JsonProperty("intAmountWithTax")
  private BigDecimal intAmountWithTax = null;

  @JsonProperty("compareStatus")
  private Integer compareStatus = null;

  @JsonProperty("compareMessage")
  private String compareMessage = null;

  @JsonProperty("createTime")
  private Long createTime = null;

  @JsonProperty("updateTime")
  private Long updateTime = null;

  @JsonIgnore
  public WkOrdersEndcheckDTO id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public WkOrdersEndcheckDTO salesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
    return this;
  }

   /**
   * 单据编号
   * @return salesbillNo
  **/
  @ApiModelProperty(value = "单据编号")
  public String getSalesbillNo() {
    return salesbillNo;
  }

  public void setSalesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
  }

  @JsonIgnore
  public WkOrdersEndcheckDTO voucherCreated(Integer voucherCreated) {
    this.voucherCreated = voucherCreated;
    return this;
  }

   /**
   * 是否生成凭证：0 - 未生成，1 - 已生成
   * @return voucherCreated
  **/
  @ApiModelProperty(value = "是否生成凭证：0 - 未生成，1 - 已生成")
  public Integer getVoucherCreated() {
    return voucherCreated;
  }

  public void setVoucherCreated(Integer voucherCreated) {
    this.voucherCreated = voucherCreated;
  }

  @JsonIgnore
  public WkOrdersEndcheckDTO canDeduction(Integer canDeduction) {
    this.canDeduction = canDeduction;
    return this;
  }

   /**
   * 是否可抵扣：0-不可抵扣，1可抵扣
   * @return canDeduction
  **/
  @ApiModelProperty(value = "是否可抵扣：0-不可抵扣，1可抵扣")
  public Integer getCanDeduction() {
    return canDeduction;
  }

  public void setCanDeduction(Integer canDeduction) {
    this.canDeduction = canDeduction;
  }

  @JsonIgnore
  public WkOrdersEndcheckDTO invoiceStatus(String invoiceStatus) {
    this.invoiceStatus = invoiceStatus;
    return this;
  }

   /**
   * 单据发票状态：UNINVOICED-未开票，PARTIAL-部分开票，COMPLETED-完全开票，S-已审核，V-已认证，SV-已认证
   * @return invoiceStatus
  **/
  @ApiModelProperty(value = "单据发票状态：UNINVOICED-未开票，PARTIAL-部分开票，COMPLETED-完全开票，S-已审核，V-已认证，SV-已认证")
  public String getInvoiceStatus() {
    return invoiceStatus;
  }

  public void setInvoiceStatus(String invoiceStatus) {
    this.invoiceStatus = invoiceStatus;
  }

  @JsonIgnore
  public WkOrdersEndcheckDTO intAmountWithoutTax(BigDecimal intAmountWithoutTax) {
    this.intAmountWithoutTax = intAmountWithoutTax;
    return this;
  }

   /**
   * 不含税金额（接口）
   * @return intAmountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额（接口）")
  public BigDecimal getIntAmountWithoutTax() {
    return intAmountWithoutTax;
  }

  public void setIntAmountWithoutTax(BigDecimal intAmountWithoutTax) {
    this.intAmountWithoutTax = intAmountWithoutTax;
  }

  @JsonIgnore
  public WkOrdersEndcheckDTO intTaxAmount(BigDecimal intTaxAmount) {
    this.intTaxAmount = intTaxAmount;
    return this;
  }

   /**
   * 税额（接口）
   * @return intTaxAmount
  **/
  @ApiModelProperty(value = "税额（接口）")
  public BigDecimal getIntTaxAmount() {
    return intTaxAmount;
  }

  public void setIntTaxAmount(BigDecimal intTaxAmount) {
    this.intTaxAmount = intTaxAmount;
  }

  @JsonIgnore
  public WkOrdersEndcheckDTO intAmountWithTax(BigDecimal intAmountWithTax) {
    this.intAmountWithTax = intAmountWithTax;
    return this;
  }

   /**
   * 含税金额（接口）
   * @return intAmountWithTax
  **/
  @ApiModelProperty(value = "含税金额（接口）")
  public BigDecimal getIntAmountWithTax() {
    return intAmountWithTax;
  }

  public void setIntAmountWithTax(BigDecimal intAmountWithTax) {
    this.intAmountWithTax = intAmountWithTax;
  }

  @JsonIgnore
  public WkOrdersEndcheckDTO compareStatus(Integer compareStatus) {
    this.compareStatus = compareStatus;
    return this;
  }

   /**
   * 比对状态：0-异常，1-一致
   * @return compareStatus
  **/
  @ApiModelProperty(value = "比对状态：0-异常，1-一致")
  public Integer getCompareStatus() {
    return compareStatus;
  }

  public void setCompareStatus(Integer compareStatus) {
    this.compareStatus = compareStatus;
  }

  @JsonIgnore
  public WkOrdersEndcheckDTO compareMessage(String compareMessage) {
    this.compareMessage = compareMessage;
    return this;
  }

   /**
   * 比对结果
   * @return compareMessage
  **/
  @ApiModelProperty(value = "比对结果")
  public String getCompareMessage() {
    return compareMessage;
  }

  public void setCompareMessage(String compareMessage) {
    this.compareMessage = compareMessage;
  }

  @JsonIgnore
  public WkOrdersEndcheckDTO createTime(Long createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public Long getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Long createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public WkOrdersEndcheckDTO updateTime(Long updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public Long getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(Long updateTime) {
    this.updateTime = updateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WkOrdersEndcheckDTO wkOrdersEndcheckDTO = (WkOrdersEndcheckDTO) o;
    return Objects.equals(this.id, wkOrdersEndcheckDTO.id) &&
        Objects.equals(this.salesbillNo, wkOrdersEndcheckDTO.salesbillNo) &&
        Objects.equals(this.voucherCreated, wkOrdersEndcheckDTO.voucherCreated) &&
        Objects.equals(this.canDeduction, wkOrdersEndcheckDTO.canDeduction) &&
        Objects.equals(this.invoiceStatus, wkOrdersEndcheckDTO.invoiceStatus) &&
        Objects.equals(this.intAmountWithoutTax, wkOrdersEndcheckDTO.intAmountWithoutTax) &&
        Objects.equals(this.intTaxAmount, wkOrdersEndcheckDTO.intTaxAmount) &&
        Objects.equals(this.intAmountWithTax, wkOrdersEndcheckDTO.intAmountWithTax) &&
        Objects.equals(this.compareStatus, wkOrdersEndcheckDTO.compareStatus) &&
        Objects.equals(this.compareMessage, wkOrdersEndcheckDTO.compareMessage) &&
        Objects.equals(this.createTime, wkOrdersEndcheckDTO.createTime) &&
        Objects.equals(this.updateTime, wkOrdersEndcheckDTO.updateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, salesbillNo, voucherCreated, canDeduction, invoiceStatus, intAmountWithoutTax, intTaxAmount, intAmountWithTax, compareStatus, compareMessage, createTime, updateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WkOrdersEndcheckDTO {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    salesbillNo: ").append(toIndentedString(salesbillNo)).append("\n");
    sb.append("    voucherCreated: ").append(toIndentedString(voucherCreated)).append("\n");
    sb.append("    canDeduction: ").append(toIndentedString(canDeduction)).append("\n");
    sb.append("    invoiceStatus: ").append(toIndentedString(invoiceStatus)).append("\n");
    sb.append("    intAmountWithoutTax: ").append(toIndentedString(intAmountWithoutTax)).append("\n");
    sb.append("    intTaxAmount: ").append(toIndentedString(intTaxAmount)).append("\n");
    sb.append("    intAmountWithTax: ").append(toIndentedString(intAmountWithTax)).append("\n");
    sb.append("    compareStatus: ").append(toIndentedString(compareStatus)).append("\n");
    sb.append("    compareMessage: ").append(toIndentedString(compareMessage)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
