package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 业务单据表
 */
@ApiModel(description = "业务单据表")

@JsonInclude(NON_NULL)
public class WkOrdersExtDTO {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("salesbillNo")
  private String salesbillNo = null;

  @JsonProperty("sellerNo")
  private String sellerNo = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("sellerTel")
  private String sellerTel = null;

  @JsonProperty("sellerAddress")
  private String sellerAddress = null;

  @JsonProperty("sellerBankName")
  private String sellerBankName = null;

  @JsonProperty("sellerBankAccount")
  private String sellerBankAccount = null;

  @JsonProperty("purchaserNo")
  private String purchaserNo = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("purchaserTel")
  private String purchaserTel = null;

  @JsonProperty("purchaserAddress")
  private String purchaserAddress = null;

  @JsonProperty("purchaserBankName")
  private String purchaserBankName = null;

  @JsonProperty("purchaserBankAccount")
  private String purchaserBankAccount = null;

  @JsonProperty("systemOrig")
  private String systemOrig = null;

  @JsonProperty("salesbillType")
  private List<Integer> salesbillType = new ArrayList<Integer>();

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("amountWithTax")
  private BigDecimal amountWithTax = null;

  @JsonProperty("amountWithoutTax")
  private BigDecimal amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("alreadyMakeAmountWithTax")
  private BigDecimal alreadyMakeAmountWithTax = null;

  @JsonProperty("discountWithTax")
  private BigDecimal discountWithTax = null;

  @JsonProperty("discountWithoutTax")
  private BigDecimal discountWithoutTax = null;

  @JsonProperty("cooperateFlag")
  private Integer cooperateFlag = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("originInvoiceNo")
  private String originInvoiceNo = null;

  @JsonProperty("originInvoiceCode")
  private String originInvoiceCode = null;

  @JsonProperty("redNotification")
  private String redNotification = null;

  @JsonProperty("checkerName")
  private String checkerName = null;

  @JsonProperty("cashierName")
  private String cashierName = null;

  @JsonProperty("invoicerName")
  private String invoicerName = null;

  @JsonProperty("receiveUserEmail")
  private String receiveUserEmail = null;

  @JsonProperty("receiveUserTel")
  private String receiveUserTel = null;

  @JsonProperty("createTime")
  private List<String> createTime = new ArrayList<String>();

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("recipient")
  private String recipient = null;

  @JsonProperty("recipientPhone")
  private String recipientPhone = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("packageCode")
  private String packageCode = null;

  @JsonProperty("businessOrderType")
  private String businessOrderType = null;

  @JsonProperty("specialTicketAmountWithTax")
  private BigDecimal specialTicketAmountWithTax = null;

  @JsonProperty("generalTicketAmountWithTax")
  private BigDecimal generalTicketAmountWithTax = null;

  @JsonProperty("taxRate")
  private BigDecimal taxRate = null;

  @JsonProperty("purchaserCode")
  private String purchaserCode = null;

  @JsonProperty("sellerCode")
  private String sellerCode = null;

  @JsonProperty("mainStatus")
  private Integer mainStatus = null;

  @JsonProperty("signPerson")
  private String signPerson = null;

  @JsonProperty("signTime")
  private Long signTime = null;

  @JsonProperty("signStatus")
  private Integer signStatus = null;

  @JsonProperty("signFailType")
  private Integer signFailType = null;

  @JsonProperty("signFailReason")
  private String signFailReason = null;

  @JsonProperty("handleWay")
  private Integer handleWay = null;

  @JsonProperty("backExpressNumber")
  private String backExpressNumber = null;

  @JsonProperty("exceptionNote")
  private String exceptionNote = null;

  @JsonProperty("exceptionHandlePerson")
  private String exceptionHandlePerson = null;

  @JsonProperty("exceptionHandleTime")
  private Long exceptionHandleTime = null;

  @JsonProperty("sendPerson")
  private String sendPerson = null;

  @JsonProperty("sendPersonPhone")
  private String sendPersonPhone = null;

  @JsonProperty("recordBillCheckStatus")
  private Integer recordBillCheckStatus = null;

  @JsonProperty("recordBillCheckNote")
  private String recordBillCheckNote = null;

  @JsonProperty("recordBillCkeckPerson")
  private String recordBillCkeckPerson = null;

  @JsonProperty("recordBillCkeckTime")
  private Long recordBillCkeckTime = null;

  @JsonProperty("isLock")
  private Integer isLock = null;

  @JsonProperty("autoCheckStatus")
  private Integer autoCheckStatus = null;

  @JsonProperty("autoCheckNote")
  private String autoCheckNote = null;

  @JsonProperty("autoCheckTime")
  private Long autoCheckTime = null;

  @JsonProperty("orderStatus")
  private List<String> orderStatus = new ArrayList<String>();

  @JsonProperty("ifAuthFlag")
  private Integer ifAuthFlag = null;

  @JsonProperty("authStatus")
  private List<Integer> authStatus = new ArrayList<Integer>();

  @JsonProperty("authAmount")
  private BigDecimal authAmount = null;

  @JsonProperty("authNotContaintAmount")
  private BigDecimal authNotContaintAmount = null;

  @JsonProperty("authTaxAmount")
  private BigDecimal authTaxAmount = null;

  @JsonProperty("authUpdateTime")
  private List<String> authUpdateTime = new ArrayList<String>();

  @JsonProperty("syncServiceSystemStatus")
  private Integer syncServiceSystemStatus = null;

  @JsonProperty("syncServiceSystemTime")
  private Long syncServiceSystemTime = null;

  @JsonProperty("syncServiceSystemNote")
  private String syncServiceSystemNote = null;

  @JsonProperty("auditStatus")
  private List<Integer> auditStatus = new ArrayList<Integer>();

  @JsonProperty("auditUpdateTime")
  private List<String> auditUpdateTime = new ArrayList<String>();

  @JsonProperty("synAuditStatus")
  private Integer synAuditStatus = null;

  @JsonProperty("synAuditStatusTime")
  private Long synAuditStatusTime = null;

  @JsonProperty("synAuditStatusNote")
  private String synAuditStatusNote = null;

  @JsonProperty("isPushTask")
  private Integer isPushTask = null;

  @JsonProperty("taxRebateAmount")
  private BigDecimal taxRebateAmount = null;

  @JsonProperty("deductionAmount")
  private BigDecimal deductionAmount = null;

  @JsonProperty("agreementCode")
  private String agreementCode = null;

  @JsonProperty("isCancelXyj")
  private Integer isCancelXyj = null;

  @JsonProperty("cancelDateXyj")
  private Long cancelDateXyj = null;

  @JsonProperty("pushTime")
  private Long pushTime = null;

  @JsonProperty("changeNotes")
  private String changeNotes = null;

  @JsonProperty("deductionsFlag")
  private String deductionsFlag = null;

  @JsonProperty("groupFlag")
  private String groupFlag = null;

  @JsonProperty("changeTime")
  private Long changeTime = null;

  @JsonProperty("changeStatus")
  private Integer changeStatus = null;

  @JsonProperty("changeInfo")
  private String changeInfo = null;

  @JsonProperty("isPushStatus")
  private Integer isPushStatus = null;

  @JsonProperty("pushAuditTime")
  private Long pushAuditTime = null;

  @JsonProperty("synAuditStatusToXyj")
  private Integer synAuditStatusToXyj = null;

  @JsonProperty("isLegalSynergetics")
  private Integer isLegalSynergetics = null;

  @JsonProperty("recipientCompany")
  private String recipientCompany = null;

  @JsonProperty("returnBatch")
  private Integer returnBatch = null;

  @JsonProperty("returnType")
  private Integer returnType = null;

  @JsonProperty("syncTime")
  private List<String> syncTime = new ArrayList<String>();

  @JsonProperty("synergySendTime")
  private Long synergySendTime = null;

  @JsonProperty("synergyUserId")
  private String synergyUserId = null;

  @JsonProperty("synergyFlag")
  private Integer synergyFlag = null;

  @JsonProperty("requestSerialNoToXyj")
  private String requestSerialNoToXyj = null;

  @JsonProperty("synTimeToXyj")
  private Long synTimeToXyj = null;

  @JsonProperty("synResultToXyj")
  private String synResultToXyj = null;

  @JsonProperty("infoFromXyj")
  private String infoFromXyj = null;

  @JsonProperty("processTimeFromXyj")
  private Long processTimeFromXyj = null;

  @JsonProperty("cooperateFlagFromXyj")
  private Integer cooperateFlagFromXyj = null;

  @JsonProperty("groupFlagFromXyj")
  private String groupFlagFromXyj = null;

  @JsonProperty("synResultTimeFromXyj")
  private Long synResultTimeFromXyj = null;

  @JsonProperty("requestDate")
  private Long requestDate = null;

  @JsonProperty("requestUser")
  private String requestUser = null;

  @JsonProperty("operator")
  private String operator = null;

  @JsonProperty("purchaserManageUnit")
  private String purchaserManageUnit = null;

  @JsonProperty("performerFullName")
  private String performerFullName = null;

  @JsonProperty("performerAccount")
  private String performerAccount = null;

  @JsonProperty("orgName")
  private String orgName = null;

  @JsonProperty("billStatus")
  private Integer billStatus = null;

  @JsonProperty("sellerContactNo")
  private String sellerContactNo = null;

  @JsonProperty("sellerExpress")
  private String sellerExpress = null;

  @JsonProperty("outputType")
  private Integer outputType = null;

  @JsonProperty("outputState")
  private Integer outputState = null;

  @JsonProperty("accountSetCode")
  private String accountSetCode = null;

  @JsonProperty("voucherCreated")
  private String voucherCreated = null;

  @JsonProperty("invoiceStatus")
  private String invoiceStatus = null;

  @JsonProperty("startTime")
  private String startTime = null;

  @JsonProperty("endTime")
  private String endTime = null;

  @JsonProperty("syncStartTime")
  private String syncStartTime = null;

  @JsonProperty("syncEndTime")
  private String syncEndTime = null;

  @JsonProperty("authStartTime")
  private String authStartTime = null;

  @JsonProperty("authEndTime")
  private String authEndTime = null;

  @JsonProperty("auditStartTime")
  private String auditStartTime = null;

  @JsonProperty("auditEndTime")
  private String auditEndTime = null;

  @JsonIgnore
  public WkOrdersExtDTO id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * null
   * @return id
  **/
  @ApiModelProperty(value = "null")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public WkOrdersExtDTO salesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
    return this;
  }

   /**
   * 单据编号
   * @return salesbillNo
  **/
  @ApiModelProperty(value = "单据编号")
  public String getSalesbillNo() {
    return salesbillNo;
  }

  public void setSalesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
  }

  @JsonIgnore
  public WkOrdersExtDTO sellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
    return this;
  }

   /**
   * 销方编号
   * @return sellerNo
  **/
  @ApiModelProperty(value = "销方编号")
  public String getSellerNo() {
    return sellerNo;
  }

  public void setSellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
  }

  @JsonIgnore
  public WkOrdersExtDTO sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public WkOrdersExtDTO sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方税号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public WkOrdersExtDTO sellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
    return this;
  }

   /**
   * 销方电话
   * @return sellerTel
  **/
  @ApiModelProperty(value = "销方电话")
  public String getSellerTel() {
    return sellerTel;
  }

  public void setSellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
  }

  @JsonIgnore
  public WkOrdersExtDTO sellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
    return this;
  }

   /**
   * 销方地址
   * @return sellerAddress
  **/
  @ApiModelProperty(value = "销方地址")
  public String getSellerAddress() {
    return sellerAddress;
  }

  public void setSellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
  }

  @JsonIgnore
  public WkOrdersExtDTO sellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
    return this;
  }

   /**
   * 销方银行名称
   * @return sellerBankName
  **/
  @ApiModelProperty(value = "销方银行名称")
  public String getSellerBankName() {
    return sellerBankName;
  }

  public void setSellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
  }

  @JsonIgnore
  public WkOrdersExtDTO sellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
    return this;
  }

   /**
   * 销方银行帐号
   * @return sellerBankAccount
  **/
  @ApiModelProperty(value = "销方银行帐号")
  public String getSellerBankAccount() {
    return sellerBankAccount;
  }

  public void setSellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
  }

  @JsonIgnore
  public WkOrdersExtDTO purchaserNo(String purchaserNo) {
    this.purchaserNo = purchaserNo;
    return this;
  }

   /**
   * 购方公司编号
   * @return purchaserNo
  **/
  @ApiModelProperty(value = "购方公司编号")
  public String getPurchaserNo() {
    return purchaserNo;
  }

  public void setPurchaserNo(String purchaserNo) {
    this.purchaserNo = purchaserNo;
  }

  @JsonIgnore
  public WkOrdersExtDTO purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public WkOrdersExtDTO purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方税号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public WkOrdersExtDTO purchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
    return this;
  }

   /**
   * 购方电话
   * @return purchaserTel
  **/
  @ApiModelProperty(value = "购方电话")
  public String getPurchaserTel() {
    return purchaserTel;
  }

  public void setPurchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
  }

  @JsonIgnore
  public WkOrdersExtDTO purchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
    return this;
  }

   /**
   * 购方地址
   * @return purchaserAddress
  **/
  @ApiModelProperty(value = "购方地址")
  public String getPurchaserAddress() {
    return purchaserAddress;
  }

  public void setPurchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
  }

  @JsonIgnore
  public WkOrdersExtDTO purchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
    return this;
  }

   /**
   * 购方银行名称
   * @return purchaserBankName
  **/
  @ApiModelProperty(value = "购方银行名称")
  public String getPurchaserBankName() {
    return purchaserBankName;
  }

  public void setPurchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
  }

  @JsonIgnore
  public WkOrdersExtDTO purchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
    return this;
  }

   /**
   * 购方银行帐号
   * @return purchaserBankAccount
  **/
  @ApiModelProperty(value = "购方银行帐号")
  public String getPurchaserBankAccount() {
    return purchaserBankAccount;
  }

  public void setPurchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
  }

  @JsonIgnore
  public WkOrdersExtDTO systemOrig(String systemOrig) {
    this.systemOrig = systemOrig;
    return this;
  }

   /**
   * 系统来源(所属业务系统)
   * @return systemOrig
  **/
  @ApiModelProperty(value = "系统来源(所属业务系统)")
  public String getSystemOrig() {
    return systemOrig;
  }

  public void setSystemOrig(String systemOrig) {
    this.systemOrig = systemOrig;
  }

  @JsonIgnore
  public WkOrdersExtDTO salesbillType(List<Integer> salesbillType) {
    this.salesbillType = salesbillType;
    return this;
  }

  public WkOrdersExtDTO addSalesbillTypeItem(Integer salesbillTypeItem) {
    this.salesbillType.add(salesbillTypeItem);
    return this;
  }

   /**
   * 业务单据类型，1-合同、2-订单、3-简易合同
   * @return salesbillType
  **/
  @ApiModelProperty(value = "业务单据类型，1-合同、2-订单、3-简易合同")
  public List<Integer> getSalesbillType() {
    return salesbillType;
  }

  public void setSalesbillType(List<Integer> salesbillType) {
    this.salesbillType = salesbillType;
  }

  @JsonIgnore
  public WkOrdersExtDTO invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型： s-增值税专用发票 c-增值税普通发票 ce-增值税电子普通发票 ju-增值税普通发票（卷票） ct-通行费增值税电子普通发票 v-机动车统一销售发票
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型： s-增值税专用发票 c-增值税普通发票 ce-增值税电子普通发票 ju-增值税普通发票（卷票） ct-通行费增值税电子普通发票 v-机动车统一销售发票")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public WkOrdersExtDTO amountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public BigDecimal getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public WkOrdersExtDTO amountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public WkOrdersExtDTO taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public WkOrdersExtDTO alreadyMakeAmountWithTax(BigDecimal alreadyMakeAmountWithTax) {
    this.alreadyMakeAmountWithTax = alreadyMakeAmountWithTax;
    return this;
  }

   /**
   * 已开含税金额
   * @return alreadyMakeAmountWithTax
  **/
  @ApiModelProperty(value = "已开含税金额")
  public BigDecimal getAlreadyMakeAmountWithTax() {
    return alreadyMakeAmountWithTax;
  }

  public void setAlreadyMakeAmountWithTax(BigDecimal alreadyMakeAmountWithTax) {
    this.alreadyMakeAmountWithTax = alreadyMakeAmountWithTax;
  }

  @JsonIgnore
  public WkOrdersExtDTO discountWithTax(BigDecimal discountWithTax) {
    this.discountWithTax = discountWithTax;
    return this;
  }

   /**
   * 含税折扣
   * @return discountWithTax
  **/
  @ApiModelProperty(value = "含税折扣")
  public BigDecimal getDiscountWithTax() {
    return discountWithTax;
  }

  public void setDiscountWithTax(BigDecimal discountWithTax) {
    this.discountWithTax = discountWithTax;
  }

  @JsonIgnore
  public WkOrdersExtDTO discountWithoutTax(BigDecimal discountWithoutTax) {
    this.discountWithoutTax = discountWithoutTax;
    return this;
  }

   /**
   * 不含税折扣
   * @return discountWithoutTax
  **/
  @ApiModelProperty(value = "不含税折扣")
  public BigDecimal getDiscountWithoutTax() {
    return discountWithoutTax;
  }

  public void setDiscountWithoutTax(BigDecimal discountWithoutTax) {
    this.discountWithoutTax = discountWithoutTax;
  }

  @JsonIgnore
  public WkOrdersExtDTO cooperateFlag(Integer cooperateFlag) {
    this.cooperateFlag = cooperateFlag;
    return this;
  }

   /**
   * 协同标识： 1-协同； 0-不协同
   * @return cooperateFlag
  **/
  @ApiModelProperty(value = "协同标识： 1-协同； 0-不协同")
  public Integer getCooperateFlag() {
    return cooperateFlag;
  }

  public void setCooperateFlag(Integer cooperateFlag) {
    this.cooperateFlag = cooperateFlag;
  }

  @JsonIgnore
  public WkOrdersExtDTO status(String status) {
    this.status = status;
    return this;
  }

   /**
   * C-作废；D-删除；W-撤回
   * @return status
  **/
  @ApiModelProperty(value = "C-作废；D-删除；W-撤回")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  @JsonIgnore
  public WkOrdersExtDTO originInvoiceNo(String originInvoiceNo) {
    this.originInvoiceNo = originInvoiceNo;
    return this;
  }

   /**
   * 原始发票号码
   * @return originInvoiceNo
  **/
  @ApiModelProperty(value = "原始发票号码")
  public String getOriginInvoiceNo() {
    return originInvoiceNo;
  }

  public void setOriginInvoiceNo(String originInvoiceNo) {
    this.originInvoiceNo = originInvoiceNo;
  }

  @JsonIgnore
  public WkOrdersExtDTO originInvoiceCode(String originInvoiceCode) {
    this.originInvoiceCode = originInvoiceCode;
    return this;
  }

   /**
   * 原始发票代码
   * @return originInvoiceCode
  **/
  @ApiModelProperty(value = "原始发票代码")
  public String getOriginInvoiceCode() {
    return originInvoiceCode;
  }

  public void setOriginInvoiceCode(String originInvoiceCode) {
    this.originInvoiceCode = originInvoiceCode;
  }

  @JsonIgnore
  public WkOrdersExtDTO redNotification(String redNotification) {
    this.redNotification = redNotification;
    return this;
  }

   /**
   * 红字信息编号
   * @return redNotification
  **/
  @ApiModelProperty(value = "红字信息编号")
  public String getRedNotification() {
    return redNotification;
  }

  public void setRedNotification(String redNotification) {
    this.redNotification = redNotification;
  }

  @JsonIgnore
  public WkOrdersExtDTO checkerName(String checkerName) {
    this.checkerName = checkerName;
    return this;
  }

   /**
   * 复核人
   * @return checkerName
  **/
  @ApiModelProperty(value = "复核人")
  public String getCheckerName() {
    return checkerName;
  }

  public void setCheckerName(String checkerName) {
    this.checkerName = checkerName;
  }

  @JsonIgnore
  public WkOrdersExtDTO cashierName(String cashierName) {
    this.cashierName = cashierName;
    return this;
  }

   /**
   * 付款人
   * @return cashierName
  **/
  @ApiModelProperty(value = "付款人")
  public String getCashierName() {
    return cashierName;
  }

  public void setCashierName(String cashierName) {
    this.cashierName = cashierName;
  }

  @JsonIgnore
  public WkOrdersExtDTO invoicerName(String invoicerName) {
    this.invoicerName = invoicerName;
    return this;
  }

   /**
   * 开票人
   * @return invoicerName
  **/
  @ApiModelProperty(value = "开票人")
  public String getInvoicerName() {
    return invoicerName;
  }

  public void setInvoicerName(String invoicerName) {
    this.invoicerName = invoicerName;
  }

  @JsonIgnore
  public WkOrdersExtDTO receiveUserEmail(String receiveUserEmail) {
    this.receiveUserEmail = receiveUserEmail;
    return this;
  }

   /**
   * 接收方邮箱
   * @return receiveUserEmail
  **/
  @ApiModelProperty(value = "接收方邮箱")
  public String getReceiveUserEmail() {
    return receiveUserEmail;
  }

  public void setReceiveUserEmail(String receiveUserEmail) {
    this.receiveUserEmail = receiveUserEmail;
  }

  @JsonIgnore
  public WkOrdersExtDTO receiveUserTel(String receiveUserTel) {
    this.receiveUserTel = receiveUserTel;
    return this;
  }

   /**
   * 接收方电话
   * @return receiveUserTel
  **/
  @ApiModelProperty(value = "接收方电话")
  public String getReceiveUserTel() {
    return receiveUserTel;
  }

  public void setReceiveUserTel(String receiveUserTel) {
    this.receiveUserTel = receiveUserTel;
  }

  @JsonIgnore
  public WkOrdersExtDTO createTime(List<String> createTime) {
    this.createTime = createTime;
    return this;
  }

  public WkOrdersExtDTO addCreateTimeItem(String createTimeItem) {
    this.createTime.add(createTimeItem);
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public List<String> getCreateTime() {
    return createTime;
  }

  public void setCreateTime(List<String> createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public WkOrdersExtDTO createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public WkOrdersExtDTO recipient(String recipient) {
    this.recipient = recipient;
    return this;
  }

   /**
   * 收件人
   * @return recipient
  **/
  @ApiModelProperty(value = "收件人")
  public String getRecipient() {
    return recipient;
  }

  public void setRecipient(String recipient) {
    this.recipient = recipient;
  }

  @JsonIgnore
  public WkOrdersExtDTO recipientPhone(String recipientPhone) {
    this.recipientPhone = recipientPhone;
    return this;
  }

   /**
   * 收件人联系方式
   * @return recipientPhone
  **/
  @ApiModelProperty(value = "收件人联系方式")
  public String getRecipientPhone() {
    return recipientPhone;
  }

  public void setRecipientPhone(String recipientPhone) {
    this.recipientPhone = recipientPhone;
  }

  @JsonIgnore
  public WkOrdersExtDTO remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public WkOrdersExtDTO packageCode(String packageCode) {
    this.packageCode = packageCode;
    return this;
  }

   /**
   * 邮包ID，邮包快递单号
   * @return packageCode
  **/
  @ApiModelProperty(value = "邮包ID，邮包快递单号")
  public String getPackageCode() {
    return packageCode;
  }

  public void setPackageCode(String packageCode) {
    this.packageCode = packageCode;
  }

  @JsonIgnore
  public WkOrdersExtDTO businessOrderType(String businessOrderType) {
    this.businessOrderType = businessOrderType;
    return this;
  }

   /**
   * 业务单据类型：S-专票，C-普票
   * @return businessOrderType
  **/
  @ApiModelProperty(value = "业务单据类型：S-专票，C-普票")
  public String getBusinessOrderType() {
    return businessOrderType;
  }

  public void setBusinessOrderType(String businessOrderType) {
    this.businessOrderType = businessOrderType;
  }

  @JsonIgnore
  public WkOrdersExtDTO specialTicketAmountWithTax(BigDecimal specialTicketAmountWithTax) {
    this.specialTicketAmountWithTax = specialTicketAmountWithTax;
    return this;
  }

   /**
   * 增值税专票含税金额
   * @return specialTicketAmountWithTax
  **/
  @ApiModelProperty(value = "增值税专票含税金额")
  public BigDecimal getSpecialTicketAmountWithTax() {
    return specialTicketAmountWithTax;
  }

  public void setSpecialTicketAmountWithTax(BigDecimal specialTicketAmountWithTax) {
    this.specialTicketAmountWithTax = specialTicketAmountWithTax;
  }

  @JsonIgnore
  public WkOrdersExtDTO generalTicketAmountWithTax(BigDecimal generalTicketAmountWithTax) {
    this.generalTicketAmountWithTax = generalTicketAmountWithTax;
    return this;
  }

   /**
   * 增值税普票含税金额
   * @return generalTicketAmountWithTax
  **/
  @ApiModelProperty(value = "增值税普票含税金额")
  public BigDecimal getGeneralTicketAmountWithTax() {
    return generalTicketAmountWithTax;
  }

  public void setGeneralTicketAmountWithTax(BigDecimal generalTicketAmountWithTax) {
    this.generalTicketAmountWithTax = generalTicketAmountWithTax;
  }

  @JsonIgnore
  public WkOrdersExtDTO taxRate(BigDecimal taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率")
  public BigDecimal getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(BigDecimal taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public WkOrdersExtDTO purchaserCode(String purchaserCode) {
    this.purchaserCode = purchaserCode;
    return this;
  }

   /**
   * 购方代码
   * @return purchaserCode
  **/
  @ApiModelProperty(value = "购方代码")
  public String getPurchaserCode() {
    return purchaserCode;
  }

  public void setPurchaserCode(String purchaserCode) {
    this.purchaserCode = purchaserCode;
  }

  @JsonIgnore
  public WkOrdersExtDTO sellerCode(String sellerCode) {
    this.sellerCode = sellerCode;
    return this;
  }

   /**
   * 销方代码
   * @return sellerCode
  **/
  @ApiModelProperty(value = "销方代码")
  public String getSellerCode() {
    return sellerCode;
  }

  public void setSellerCode(String sellerCode) {
    this.sellerCode = sellerCode;
  }

  @JsonIgnore
  public WkOrdersExtDTO mainStatus(Integer mainStatus) {
    this.mainStatus = mainStatus;
    return this;
  }

   /**
   * 主状态：-1 - 删除，10-成功，20-待处理，30-暂挂，40-退回
   * @return mainStatus
  **/
  @ApiModelProperty(value = "主状态：-1 - 删除，10-成功，20-待处理，30-暂挂，40-退回")
  public Integer getMainStatus() {
    return mainStatus;
  }

  public void setMainStatus(Integer mainStatus) {
    this.mainStatus = mainStatus;
  }

  @JsonIgnore
  public WkOrdersExtDTO signPerson(String signPerson) {
    this.signPerson = signPerson;
    return this;
  }

   /**
   * 签收人
   * @return signPerson
  **/
  @ApiModelProperty(value = "签收人")
  public String getSignPerson() {
    return signPerson;
  }

  public void setSignPerson(String signPerson) {
    this.signPerson = signPerson;
  }

  @JsonIgnore
  public WkOrdersExtDTO signTime(Long signTime) {
    this.signTime = signTime;
    return this;
  }

   /**
   * 签收时间
   * @return signTime
  **/
  @ApiModelProperty(value = "签收时间")
  public Long getSignTime() {
    return signTime;
  }

  public void setSignTime(Long signTime) {
    this.signTime = signTime;
  }

  @JsonIgnore
  public WkOrdersExtDTO signStatus(Integer signStatus) {
    this.signStatus = signStatus;
    return this;
  }

   /**
   * 签收状态 ：10-成功 20-失败
   * @return signStatus
  **/
  @ApiModelProperty(value = "签收状态 ：10-成功 20-失败")
  public Integer getSignStatus() {
    return signStatus;
  }

  public void setSignStatus(Integer signStatus) {
    this.signStatus = signStatus;
  }

  @JsonIgnore
  public WkOrdersExtDTO signFailType(Integer signFailType) {
    this.signFailType = signFailType;
    return this;
  }

   /**
   * 签收失败类型
   * @return signFailType
  **/
  @ApiModelProperty(value = "签收失败类型")
  public Integer getSignFailType() {
    return signFailType;
  }

  public void setSignFailType(Integer signFailType) {
    this.signFailType = signFailType;
  }

  @JsonIgnore
  public WkOrdersExtDTO signFailReason(String signFailReason) {
    this.signFailReason = signFailReason;
    return this;
  }

   /**
   * 签收失败原因
   * @return signFailReason
  **/
  @ApiModelProperty(value = "签收失败原因")
  public String getSignFailReason() {
    return signFailReason;
  }

  public void setSignFailReason(String signFailReason) {
    this.signFailReason = signFailReason;
  }

  @JsonIgnore
  public WkOrdersExtDTO handleWay(Integer handleWay) {
    this.handleWay = handleWay;
    return this;
  }

   /**
   * 处理方式：20-回寄，40-报支单共享扫描，50-关闭，60-通知一线处理
   * @return handleWay
  **/
  @ApiModelProperty(value = "处理方式：20-回寄，40-报支单共享扫描，50-关闭，60-通知一线处理")
  public Integer getHandleWay() {
    return handleWay;
  }

  public void setHandleWay(Integer handleWay) {
    this.handleWay = handleWay;
  }

  @JsonIgnore
  public WkOrdersExtDTO backExpressNumber(String backExpressNumber) {
    this.backExpressNumber = backExpressNumber;
    return this;
  }

   /**
   * 回寄快递单号
   * @return backExpressNumber
  **/
  @ApiModelProperty(value = "回寄快递单号")
  public String getBackExpressNumber() {
    return backExpressNumber;
  }

  public void setBackExpressNumber(String backExpressNumber) {
    this.backExpressNumber = backExpressNumber;
  }

  @JsonIgnore
  public WkOrdersExtDTO exceptionNote(String exceptionNote) {
    this.exceptionNote = exceptionNote;
    return this;
  }

   /**
   * 异常处理备注
   * @return exceptionNote
  **/
  @ApiModelProperty(value = "异常处理备注")
  public String getExceptionNote() {
    return exceptionNote;
  }

  public void setExceptionNote(String exceptionNote) {
    this.exceptionNote = exceptionNote;
  }

  @JsonIgnore
  public WkOrdersExtDTO exceptionHandlePerson(String exceptionHandlePerson) {
    this.exceptionHandlePerson = exceptionHandlePerson;
    return this;
  }

   /**
   * 异常处理人
   * @return exceptionHandlePerson
  **/
  @ApiModelProperty(value = "异常处理人")
  public String getExceptionHandlePerson() {
    return exceptionHandlePerson;
  }

  public void setExceptionHandlePerson(String exceptionHandlePerson) {
    this.exceptionHandlePerson = exceptionHandlePerson;
  }

  @JsonIgnore
  public WkOrdersExtDTO exceptionHandleTime(Long exceptionHandleTime) {
    this.exceptionHandleTime = exceptionHandleTime;
    return this;
  }

   /**
   * 异常处理时间
   * @return exceptionHandleTime
  **/
  @ApiModelProperty(value = "异常处理时间")
  public Long getExceptionHandleTime() {
    return exceptionHandleTime;
  }

  public void setExceptionHandleTime(Long exceptionHandleTime) {
    this.exceptionHandleTime = exceptionHandleTime;
  }

  @JsonIgnore
  public WkOrdersExtDTO sendPerson(String sendPerson) {
    this.sendPerson = sendPerson;
    return this;
  }

   /**
   * 寄件人
   * @return sendPerson
  **/
  @ApiModelProperty(value = "寄件人")
  public String getSendPerson() {
    return sendPerson;
  }

  public void setSendPerson(String sendPerson) {
    this.sendPerson = sendPerson;
  }

  @JsonIgnore
  public WkOrdersExtDTO sendPersonPhone(String sendPersonPhone) {
    this.sendPersonPhone = sendPersonPhone;
    return this;
  }

   /**
   * 寄件人联系方式
   * @return sendPersonPhone
  **/
  @ApiModelProperty(value = "寄件人联系方式")
  public String getSendPersonPhone() {
    return sendPersonPhone;
  }

  public void setSendPersonPhone(String sendPersonPhone) {
    this.sendPersonPhone = sendPersonPhone;
  }

  @JsonIgnore
  public WkOrdersExtDTO recordBillCheckStatus(Integer recordBillCheckStatus) {
    this.recordBillCheckStatus = recordBillCheckStatus;
    return this;
  }

   /**
   * 结算单发票审核状态：0-待审核，20-审核成功，30-审核不通过，40-打回
   * @return recordBillCheckStatus
  **/
  @ApiModelProperty(value = "结算单发票审核状态：0-待审核，20-审核成功，30-审核不通过，40-打回")
  public Integer getRecordBillCheckStatus() {
    return recordBillCheckStatus;
  }

  public void setRecordBillCheckStatus(Integer recordBillCheckStatus) {
    this.recordBillCheckStatus = recordBillCheckStatus;
  }

  @JsonIgnore
  public WkOrdersExtDTO recordBillCheckNote(String recordBillCheckNote) {
    this.recordBillCheckNote = recordBillCheckNote;
    return this;
  }

   /**
   * 结算单发票审核说明
   * @return recordBillCheckNote
  **/
  @ApiModelProperty(value = "结算单发票审核说明")
  public String getRecordBillCheckNote() {
    return recordBillCheckNote;
  }

  public void setRecordBillCheckNote(String recordBillCheckNote) {
    this.recordBillCheckNote = recordBillCheckNote;
  }

  @JsonIgnore
  public WkOrdersExtDTO recordBillCkeckPerson(String recordBillCkeckPerson) {
    this.recordBillCkeckPerson = recordBillCkeckPerson;
    return this;
  }

   /**
   * 结算单发票审核人
   * @return recordBillCkeckPerson
  **/
  @ApiModelProperty(value = "结算单发票审核人")
  public String getRecordBillCkeckPerson() {
    return recordBillCkeckPerson;
  }

  public void setRecordBillCkeckPerson(String recordBillCkeckPerson) {
    this.recordBillCkeckPerson = recordBillCkeckPerson;
  }

  @JsonIgnore
  public WkOrdersExtDTO recordBillCkeckTime(Long recordBillCkeckTime) {
    this.recordBillCkeckTime = recordBillCkeckTime;
    return this;
  }

   /**
   * 结算单发票审核时间
   * @return recordBillCkeckTime
  **/
  @ApiModelProperty(value = "结算单发票审核时间")
  public Long getRecordBillCkeckTime() {
    return recordBillCkeckTime;
  }

  public void setRecordBillCkeckTime(Long recordBillCkeckTime) {
    this.recordBillCkeckTime = recordBillCkeckTime;
  }

  @JsonIgnore
  public WkOrdersExtDTO isLock(Integer isLock) {
    this.isLock = isLock;
    return this;
  }

   /**
   * 结算单锁标志：1- 锁定，0-未锁定
   * @return isLock
  **/
  @ApiModelProperty(value = "结算单锁标志：1- 锁定，0-未锁定")
  public Integer getIsLock() {
    return isLock;
  }

  public void setIsLock(Integer isLock) {
    this.isLock = isLock;
  }

  @JsonIgnore
  public WkOrdersExtDTO autoCheckStatus(Integer autoCheckStatus) {
    this.autoCheckStatus = autoCheckStatus;
    return this;
  }

   /**
   * 发票自动校验结果状态： -10 - 异常，10 - 正常
   * @return autoCheckStatus
  **/
  @ApiModelProperty(value = "发票自动校验结果状态： -10 - 异常，10 - 正常")
  public Integer getAutoCheckStatus() {
    return autoCheckStatus;
  }

  public void setAutoCheckStatus(Integer autoCheckStatus) {
    this.autoCheckStatus = autoCheckStatus;
  }

  @JsonIgnore
  public WkOrdersExtDTO autoCheckNote(String autoCheckNote) {
    this.autoCheckNote = autoCheckNote;
    return this;
  }

   /**
   * 发票自动校验结果说明
   * @return autoCheckNote
  **/
  @ApiModelProperty(value = "发票自动校验结果说明")
  public String getAutoCheckNote() {
    return autoCheckNote;
  }

  public void setAutoCheckNote(String autoCheckNote) {
    this.autoCheckNote = autoCheckNote;
  }

  @JsonIgnore
  public WkOrdersExtDTO autoCheckTime(Long autoCheckTime) {
    this.autoCheckTime = autoCheckTime;
    return this;
  }

   /**
   * 发票自动校验时间
   * @return autoCheckTime
  **/
  @ApiModelProperty(value = "发票自动校验时间")
  public Long getAutoCheckTime() {
    return autoCheckTime;
  }

  public void setAutoCheckTime(Long autoCheckTime) {
    this.autoCheckTime = autoCheckTime;
  }

  @JsonIgnore
  public WkOrdersExtDTO orderStatus(List<String> orderStatus) {
    this.orderStatus = orderStatus;
    return this;
  }

  public WkOrdersExtDTO addOrderStatusItem(String orderStatusItem) {
    this.orderStatus.add(orderStatusItem);
    return this;
  }

   /**
   * 业务单状态
   * @return orderStatus
  **/
  @ApiModelProperty(value = "业务单状态")
  public List<String> getOrderStatus() {
    return orderStatus;
  }

  public void setOrderStatus(List<String> orderStatus) {
    this.orderStatus = orderStatus;
  }

  @JsonIgnore
  public WkOrdersExtDTO ifAuthFlag(Integer ifAuthFlag) {
    this.ifAuthFlag = ifAuthFlag;
    return this;
  }

   /**
   * 是否需要认证状态 1：是  0：否
   * @return ifAuthFlag
  **/
  @ApiModelProperty(value = "是否需要认证状态 1：是  0：否")
  public Integer getIfAuthFlag() {
    return ifAuthFlag;
  }

  public void setIfAuthFlag(Integer ifAuthFlag) {
    this.ifAuthFlag = ifAuthFlag;
  }

  @JsonIgnore
  public WkOrdersExtDTO authStatus(List<Integer> authStatus) {
    this.authStatus = authStatus;
    return this;
  }

  public WkOrdersExtDTO addAuthStatusItem(Integer authStatusItem) {
    this.authStatus.add(authStatusItem);
    return this;
  }

   /**
   * 业务单认证状态 0：未认证  1：认证成功 2：部分认证
   * @return authStatus
  **/
  @ApiModelProperty(value = "业务单认证状态 0：未认证  1：认证成功 2：部分认证")
  public List<Integer> getAuthStatus() {
    return authStatus;
  }

  public void setAuthStatus(List<Integer> authStatus) {
    this.authStatus = authStatus;
  }

  @JsonIgnore
  public WkOrdersExtDTO authAmount(BigDecimal authAmount) {
    this.authAmount = authAmount;
    return this;
  }

   /**
   * 认证的含税总金额
   * @return authAmount
  **/
  @ApiModelProperty(value = "认证的含税总金额")
  public BigDecimal getAuthAmount() {
    return authAmount;
  }

  public void setAuthAmount(BigDecimal authAmount) {
    this.authAmount = authAmount;
  }

  @JsonIgnore
  public WkOrdersExtDTO authNotContaintAmount(BigDecimal authNotContaintAmount) {
    this.authNotContaintAmount = authNotContaintAmount;
    return this;
  }

   /**
   * 认证不含税总金额
   * @return authNotContaintAmount
  **/
  @ApiModelProperty(value = "认证不含税总金额")
  public BigDecimal getAuthNotContaintAmount() {
    return authNotContaintAmount;
  }

  public void setAuthNotContaintAmount(BigDecimal authNotContaintAmount) {
    this.authNotContaintAmount = authNotContaintAmount;
  }

  @JsonIgnore
  public WkOrdersExtDTO authTaxAmount(BigDecimal authTaxAmount) {
    this.authTaxAmount = authTaxAmount;
    return this;
  }

   /**
   * 认证总税额
   * @return authTaxAmount
  **/
  @ApiModelProperty(value = "认证总税额")
  public BigDecimal getAuthTaxAmount() {
    return authTaxAmount;
  }

  public void setAuthTaxAmount(BigDecimal authTaxAmount) {
    this.authTaxAmount = authTaxAmount;
  }

  @JsonIgnore
  public WkOrdersExtDTO authUpdateTime(List<String> authUpdateTime) {
    this.authUpdateTime = authUpdateTime;
    return this;
  }

  public WkOrdersExtDTO addAuthUpdateTimeItem(String authUpdateTimeItem) {
    this.authUpdateTime.add(authUpdateTimeItem);
    return this;
  }

   /**
   * 认证更新时间
   * @return authUpdateTime
  **/
  @ApiModelProperty(value = "认证更新时间")
  public List<String> getAuthUpdateTime() {
    return authUpdateTime;
  }

  public void setAuthUpdateTime(List<String> authUpdateTime) {
    this.authUpdateTime = authUpdateTime;
  }

  @JsonIgnore
  public WkOrdersExtDTO syncServiceSystemStatus(Integer syncServiceSystemStatus) {
    this.syncServiceSystemStatus = syncServiceSystemStatus;
    return this;
  }

   /**
   * 同步认证状态至业务系统状态 0：未同步  1：同步返回处理成功 2：同步返回处理失败
   * @return syncServiceSystemStatus
  **/
  @ApiModelProperty(value = "同步认证状态至业务系统状态 0：未同步  1：同步返回处理成功 2：同步返回处理失败")
  public Integer getSyncServiceSystemStatus() {
    return syncServiceSystemStatus;
  }

  public void setSyncServiceSystemStatus(Integer syncServiceSystemStatus) {
    this.syncServiceSystemStatus = syncServiceSystemStatus;
  }

  @JsonIgnore
  public WkOrdersExtDTO syncServiceSystemTime(Long syncServiceSystemTime) {
    this.syncServiceSystemTime = syncServiceSystemTime;
    return this;
  }

   /**
   * 同步至业务系统时间
   * @return syncServiceSystemTime
  **/
  @ApiModelProperty(value = "同步至业务系统时间")
  public Long getSyncServiceSystemTime() {
    return syncServiceSystemTime;
  }

  public void setSyncServiceSystemTime(Long syncServiceSystemTime) {
    this.syncServiceSystemTime = syncServiceSystemTime;
  }

  @JsonIgnore
  public WkOrdersExtDTO syncServiceSystemNote(String syncServiceSystemNote) {
    this.syncServiceSystemNote = syncServiceSystemNote;
    return this;
  }

   /**
   * 同步返回结果说明
   * @return syncServiceSystemNote
  **/
  @ApiModelProperty(value = "同步返回结果说明")
  public String getSyncServiceSystemNote() {
    return syncServiceSystemNote;
  }

  public void setSyncServiceSystemNote(String syncServiceSystemNote) {
    this.syncServiceSystemNote = syncServiceSystemNote;
  }

  @JsonIgnore
  public WkOrdersExtDTO auditStatus(List<Integer> auditStatus) {
    this.auditStatus = auditStatus;
    return this;
  }

  public WkOrdersExtDTO addAuditStatusItem(Integer auditStatusItem) {
    this.auditStatus.add(auditStatusItem);
    return this;
  }

   /**
   * 业务单审核状态 0：未审核  1：审核成功 2：审核不通过 审核状态（0. 待审核 1.审核成功 -1.审核失败）
   * @return auditStatus
  **/
  @ApiModelProperty(value = "业务单审核状态 0：未审核  1：审核成功 2：审核不通过 审核状态（0. 待审核 1.审核成功 -1.审核失败）")
  public List<Integer> getAuditStatus() {
    return auditStatus;
  }

  public void setAuditStatus(List<Integer> auditStatus) {
    this.auditStatus = auditStatus;
  }

  @JsonIgnore
  public WkOrdersExtDTO auditUpdateTime(List<String> auditUpdateTime) {
    this.auditUpdateTime = auditUpdateTime;
    return this;
  }

  public WkOrdersExtDTO addAuditUpdateTimeItem(String auditUpdateTimeItem) {
    this.auditUpdateTime.add(auditUpdateTimeItem);
    return this;
  }

   /**
   * 审核状态更新时间
   * @return auditUpdateTime
  **/
  @ApiModelProperty(value = "审核状态更新时间")
  public List<String> getAuditUpdateTime() {
    return auditUpdateTime;
  }

  public void setAuditUpdateTime(List<String> auditUpdateTime) {
    this.auditUpdateTime = auditUpdateTime;
  }

  @JsonIgnore
  public WkOrdersExtDTO synAuditStatus(Integer synAuditStatus) {
    this.synAuditStatus = synAuditStatus;
    return this;
  }

   /**
   * 审核状态同步至业务系统状态 0：未同步  1：同步返回处理成功 2：同步返回处理失败
   * @return synAuditStatus
  **/
  @ApiModelProperty(value = "审核状态同步至业务系统状态 0：未同步  1：同步返回处理成功 2：同步返回处理失败")
  public Integer getSynAuditStatus() {
    return synAuditStatus;
  }

  public void setSynAuditStatus(Integer synAuditStatus) {
    this.synAuditStatus = synAuditStatus;
  }

  @JsonIgnore
  public WkOrdersExtDTO synAuditStatusTime(Long synAuditStatusTime) {
    this.synAuditStatusTime = synAuditStatusTime;
    return this;
  }

   /**
   * 审核状态同步至业务系统时间
   * @return synAuditStatusTime
  **/
  @ApiModelProperty(value = "审核状态同步至业务系统时间")
  public Long getSynAuditStatusTime() {
    return synAuditStatusTime;
  }

  public void setSynAuditStatusTime(Long synAuditStatusTime) {
    this.synAuditStatusTime = synAuditStatusTime;
  }

  @JsonIgnore
  public WkOrdersExtDTO synAuditStatusNote(String synAuditStatusNote) {
    this.synAuditStatusNote = synAuditStatusNote;
    return this;
  }

   /**
   * 审核状态同步至业务系统返回说明
   * @return synAuditStatusNote
  **/
  @ApiModelProperty(value = "审核状态同步至业务系统返回说明")
  public String getSynAuditStatusNote() {
    return synAuditStatusNote;
  }

  public void setSynAuditStatusNote(String synAuditStatusNote) {
    this.synAuditStatusNote = synAuditStatusNote;
  }

  @JsonIgnore
  public WkOrdersExtDTO isPushTask(Integer isPushTask) {
    this.isPushTask = isPushTask;
    return this;
  }

   /**
   * 是否推送任务平台审核1是，0否
   * @return isPushTask
  **/
  @ApiModelProperty(value = "是否推送任务平台审核1是，0否")
  public Integer getIsPushTask() {
    return isPushTask;
  }

  public void setIsPushTask(Integer isPushTask) {
    this.isPushTask = isPushTask;
  }

  @JsonIgnore
  public WkOrdersExtDTO taxRebateAmount(BigDecimal taxRebateAmount) {
    this.taxRebateAmount = taxRebateAmount;
    return this;
  }

   /**
   * 折扣税额
   * @return taxRebateAmount
  **/
  @ApiModelProperty(value = "折扣税额")
  public BigDecimal getTaxRebateAmount() {
    return taxRebateAmount;
  }

  public void setTaxRebateAmount(BigDecimal taxRebateAmount) {
    this.taxRebateAmount = taxRebateAmount;
  }

  @JsonIgnore
  public WkOrdersExtDTO deductionAmount(BigDecimal deductionAmount) {
    this.deductionAmount = deductionAmount;
    return this;
  }

   /**
   * 可抵扣金额
   * @return deductionAmount
  **/
  @ApiModelProperty(value = "可抵扣金额")
  public BigDecimal getDeductionAmount() {
    return deductionAmount;
  }

  public void setDeductionAmount(BigDecimal deductionAmount) {
    this.deductionAmount = deductionAmount;
  }

  @JsonIgnore
  public WkOrdersExtDTO agreementCode(String agreementCode) {
    this.agreementCode = agreementCode;
    return this;
  }

   /**
   * 合同号
   * @return agreementCode
  **/
  @ApiModelProperty(value = "合同号")
  public String getAgreementCode() {
    return agreementCode;
  }

  public void setAgreementCode(String agreementCode) {
    this.agreementCode = agreementCode;
  }

  @JsonIgnore
  public WkOrdersExtDTO isCancelXyj(Integer isCancelXyj) {
    this.isCancelXyj = isCancelXyj;
    return this;
  }

   /**
   * 1-喜盈佳已经确认作废，0-未确认作废
   * @return isCancelXyj
  **/
  @ApiModelProperty(value = "1-喜盈佳已经确认作废，0-未确认作废")
  public Integer getIsCancelXyj() {
    return isCancelXyj;
  }

  public void setIsCancelXyj(Integer isCancelXyj) {
    this.isCancelXyj = isCancelXyj;
  }

  @JsonIgnore
  public WkOrdersExtDTO cancelDateXyj(Long cancelDateXyj) {
    this.cancelDateXyj = cancelDateXyj;
    return this;
  }

   /**
   * 喜盈佳作废时间
   * @return cancelDateXyj
  **/
  @ApiModelProperty(value = "喜盈佳作废时间")
  public Long getCancelDateXyj() {
    return cancelDateXyj;
  }

  public void setCancelDateXyj(Long cancelDateXyj) {
    this.cancelDateXyj = cancelDateXyj;
  }

  @JsonIgnore
  public WkOrdersExtDTO pushTime(Long pushTime) {
    this.pushTime = pushTime;
    return this;
  }

   /**
   * 推送任务平台的时间
   * @return pushTime
  **/
  @ApiModelProperty(value = "推送任务平台的时间")
  public Long getPushTime() {
    return pushTime;
  }

  public void setPushTime(Long pushTime) {
    this.pushTime = pushTime;
  }

  @JsonIgnore
  public WkOrdersExtDTO changeNotes(String changeNotes) {
    this.changeNotes = changeNotes;
    return this;
  }

   /**
   * 变更记录
   * @return changeNotes
  **/
  @ApiModelProperty(value = "变更记录")
  public String getChangeNotes() {
    return changeNotes;
  }

  public void setChangeNotes(String changeNotes) {
    this.changeNotes = changeNotes;
  }

  @JsonIgnore
  public WkOrdersExtDTO deductionsFlag(String deductionsFlag) {
    this.deductionsFlag = deductionsFlag;
    return this;
  }

   /**
   * 是否认证变更
   * @return deductionsFlag
  **/
  @ApiModelProperty(value = "是否认证变更")
  public String getDeductionsFlag() {
    return deductionsFlag;
  }

  public void setDeductionsFlag(String deductionsFlag) {
    this.deductionsFlag = deductionsFlag;
  }

  @JsonIgnore
  public WkOrdersExtDTO groupFlag(String groupFlag) {
    this.groupFlag = groupFlag;
    return this;
  }

   /**
   * 分组标记
   * @return groupFlag
  **/
  @ApiModelProperty(value = "分组标记")
  public String getGroupFlag() {
    return groupFlag;
  }

  public void setGroupFlag(String groupFlag) {
    this.groupFlag = groupFlag;
  }

  @JsonIgnore
  public WkOrdersExtDTO changeTime(Long changeTime) {
    this.changeTime = changeTime;
    return this;
  }

   /**
   * 可抵扣变更处理时间
   * @return changeTime
  **/
  @ApiModelProperty(value = "可抵扣变更处理时间")
  public Long getChangeTime() {
    return changeTime;
  }

  public void setChangeTime(Long changeTime) {
    this.changeTime = changeTime;
  }

  @JsonIgnore
  public WkOrdersExtDTO changeStatus(Integer changeStatus) {
    this.changeStatus = changeStatus;
    return this;
  }

   /**
   * 可抵扣变更处理状态：0-失败，1-成功，2-无
   * @return changeStatus
  **/
  @ApiModelProperty(value = "可抵扣变更处理状态：0-失败，1-成功，2-无")
  public Integer getChangeStatus() {
    return changeStatus;
  }

  public void setChangeStatus(Integer changeStatus) {
    this.changeStatus = changeStatus;
  }

  @JsonIgnore
  public WkOrdersExtDTO changeInfo(String changeInfo) {
    this.changeInfo = changeInfo;
    return this;
  }

   /**
   * 可抵扣变更处理意见
   * @return changeInfo
  **/
  @ApiModelProperty(value = "可抵扣变更处理意见")
  public String getChangeInfo() {
    return changeInfo;
  }

  public void setChangeInfo(String changeInfo) {
    this.changeInfo = changeInfo;
  }

  @JsonIgnore
  public WkOrdersExtDTO isPushStatus(Integer isPushStatus) {
    this.isPushStatus = isPushStatus;
    return this;
  }

   /**
   * 是否推送费控（0. 未推送 1. 已推送）
   * @return isPushStatus
  **/
  @ApiModelProperty(value = "是否推送费控（0. 未推送 1. 已推送）")
  public Integer getIsPushStatus() {
    return isPushStatus;
  }

  public void setIsPushStatus(Integer isPushStatus) {
    this.isPushStatus = isPushStatus;
  }

  @JsonIgnore
  public WkOrdersExtDTO pushAuditTime(Long pushAuditTime) {
    this.pushAuditTime = pushAuditTime;
    return this;
  }

   /**
   * 发票审核任务推送时间
   * @return pushAuditTime
  **/
  @ApiModelProperty(value = "发票审核任务推送时间")
  public Long getPushAuditTime() {
    return pushAuditTime;
  }

  public void setPushAuditTime(Long pushAuditTime) {
    this.pushAuditTime = pushAuditTime;
  }

  @JsonIgnore
  public WkOrdersExtDTO synAuditStatusToXyj(Integer synAuditStatusToXyj) {
    this.synAuditStatusToXyj = synAuditStatusToXyj;
    return this;
  }

   /**
   * 反馈审核状态到喜盈佳：0-未反馈，1-已反馈
   * @return synAuditStatusToXyj
  **/
  @ApiModelProperty(value = "反馈审核状态到喜盈佳：0-未反馈，1-已反馈")
  public Integer getSynAuditStatusToXyj() {
    return synAuditStatusToXyj;
  }

  public void setSynAuditStatusToXyj(Integer synAuditStatusToXyj) {
    this.synAuditStatusToXyj = synAuditStatusToXyj;
  }

  @JsonIgnore
  public WkOrdersExtDTO isLegalSynergetics(Integer isLegalSynergetics) {
    this.isLegalSynergetics = isLegalSynergetics;
    return this;
  }

   /**
   * 是否法人协同 1.是 0.否
   * @return isLegalSynergetics
  **/
  @ApiModelProperty(value = "是否法人协同 1.是 0.否")
  public Integer getIsLegalSynergetics() {
    return isLegalSynergetics;
  }

  public void setIsLegalSynergetics(Integer isLegalSynergetics) {
    this.isLegalSynergetics = isLegalSynergetics;
  }

  @JsonIgnore
  public WkOrdersExtDTO recipientCompany(String recipientCompany) {
    this.recipientCompany = recipientCompany;
    return this;
  }

   /**
   * 收件公司
   * @return recipientCompany
  **/
  @ApiModelProperty(value = "收件公司")
  public String getRecipientCompany() {
    return recipientCompany;
  }

  public void setRecipientCompany(String recipientCompany) {
    this.recipientCompany = recipientCompany;
  }

  @JsonIgnore
  public WkOrdersExtDTO returnBatch(Integer returnBatch) {
    this.returnBatch = returnBatch;
    return this;
  }

   /**
   * 退回联次 1 发票联及抵扣联、2 发票联、3 抵扣联
   * @return returnBatch
  **/
  @ApiModelProperty(value = "退回联次 1 发票联及抵扣联、2 发票联、3 抵扣联")
  public Integer getReturnBatch() {
    return returnBatch;
  }

  public void setReturnBatch(Integer returnBatch) {
    this.returnBatch = returnBatch;
  }

  @JsonIgnore
  public WkOrdersExtDTO returnType(Integer returnType) {
    this.returnType = returnType;
    return this;
  }

   /**
   * 退回类型 采用枚举值：1、发票票面有误2、发票审核错误3、产值有误4、 产值红冲5、邮寄错误6、其他
   * @return returnType
  **/
  @ApiModelProperty(value = "退回类型 采用枚举值：1、发票票面有误2、发票审核错误3、产值有误4、 产值红冲5、邮寄错误6、其他")
  public Integer getReturnType() {
    return returnType;
  }

  public void setReturnType(Integer returnType) {
    this.returnType = returnType;
  }

  @JsonIgnore
  public WkOrdersExtDTO syncTime(List<String> syncTime) {
    this.syncTime = syncTime;
    return this;
  }

  public WkOrdersExtDTO addSyncTimeItem(String syncTimeItem) {
    this.syncTime.add(syncTimeItem);
    return this;
  }

   /**
   * 同步时间
   * @return syncTime
  **/
  @ApiModelProperty(value = "同步时间")
  public List<String> getSyncTime() {
    return syncTime;
  }

  public void setSyncTime(List<String> syncTime) {
    this.syncTime = syncTime;
  }

  @JsonIgnore
  public WkOrdersExtDTO synergySendTime(Long synergySendTime) {
    this.synergySendTime = synergySendTime;
    return this;
  }

   /**
   * 协同发送时间
   * @return synergySendTime
  **/
  @ApiModelProperty(value = "协同发送时间")
  public Long getSynergySendTime() {
    return synergySendTime;
  }

  public void setSynergySendTime(Long synergySendTime) {
    this.synergySendTime = synergySendTime;
  }

  @JsonIgnore
  public WkOrdersExtDTO synergyUserId(String synergyUserId) {
    this.synergyUserId = synergyUserId;
    return this;
  }

   /**
   * 协同发送人
   * @return synergyUserId
  **/
  @ApiModelProperty(value = "协同发送人")
  public String getSynergyUserId() {
    return synergyUserId;
  }

  public void setSynergyUserId(String synergyUserId) {
    this.synergyUserId = synergyUserId;
  }

  @JsonIgnore
  public WkOrdersExtDTO synergyFlag(Integer synergyFlag) {
    this.synergyFlag = synergyFlag;
    return this;
  }

   /**
   * 协同发送标志 0-未协同 1-协同中 2-协同成功 3-协同失败
   * @return synergyFlag
  **/
  @ApiModelProperty(value = "协同发送标志 0-未协同 1-协同中 2-协同成功 3-协同失败")
  public Integer getSynergyFlag() {
    return synergyFlag;
  }

  public void setSynergyFlag(Integer synergyFlag) {
    this.synergyFlag = synergyFlag;
  }

  @JsonIgnore
  public WkOrdersExtDTO requestSerialNoToXyj(String requestSerialNoToXyj) {
    this.requestSerialNoToXyj = requestSerialNoToXyj;
    return this;
  }

   /**
   * 喜盈佳请求序列号
   * @return requestSerialNoToXyj
  **/
  @ApiModelProperty(value = "喜盈佳请求序列号")
  public String getRequestSerialNoToXyj() {
    return requestSerialNoToXyj;
  }

  public void setRequestSerialNoToXyj(String requestSerialNoToXyj) {
    this.requestSerialNoToXyj = requestSerialNoToXyj;
  }

  @JsonIgnore
  public WkOrdersExtDTO synTimeToXyj(Long synTimeToXyj) {
    this.synTimeToXyj = synTimeToXyj;
    return this;
  }

   /**
   * 喜盈佳同步时间
   * @return synTimeToXyj
  **/
  @ApiModelProperty(value = "喜盈佳同步时间")
  public Long getSynTimeToXyj() {
    return synTimeToXyj;
  }

  public void setSynTimeToXyj(Long synTimeToXyj) {
    this.synTimeToXyj = synTimeToXyj;
  }

  @JsonIgnore
  public WkOrdersExtDTO synResultToXyj(String synResultToXyj) {
    this.synResultToXyj = synResultToXyj;
    return this;
  }

   /**
   * 喜盈佳同步结果
   * @return synResultToXyj
  **/
  @ApiModelProperty(value = "喜盈佳同步结果")
  public String getSynResultToXyj() {
    return synResultToXyj;
  }

  public void setSynResultToXyj(String synResultToXyj) {
    this.synResultToXyj = synResultToXyj;
  }

  @JsonIgnore
  public WkOrdersExtDTO infoFromXyj(String infoFromXyj) {
    this.infoFromXyj = infoFromXyj;
    return this;
  }

   /**
   * 喜盈佳同步说明
   * @return infoFromXyj
  **/
  @ApiModelProperty(value = "喜盈佳同步说明")
  public String getInfoFromXyj() {
    return infoFromXyj;
  }

  public void setInfoFromXyj(String infoFromXyj) {
    this.infoFromXyj = infoFromXyj;
  }

  @JsonIgnore
  public WkOrdersExtDTO processTimeFromXyj(Long processTimeFromXyj) {
    this.processTimeFromXyj = processTimeFromXyj;
    return this;
  }

   /**
   * 喜盈佳同步时间
   * @return processTimeFromXyj
  **/
  @ApiModelProperty(value = "喜盈佳同步时间")
  public Long getProcessTimeFromXyj() {
    return processTimeFromXyj;
  }

  public void setProcessTimeFromXyj(Long processTimeFromXyj) {
    this.processTimeFromXyj = processTimeFromXyj;
  }

  @JsonIgnore
  public WkOrdersExtDTO cooperateFlagFromXyj(Integer cooperateFlagFromXyj) {
    this.cooperateFlagFromXyj = cooperateFlagFromXyj;
    return this;
  }

   /**
   * 喜盈佳协同类型标志 (0-非协同；1-协同）
   * @return cooperateFlagFromXyj
  **/
  @ApiModelProperty(value = "喜盈佳协同类型标志 (0-非协同；1-协同）")
  public Integer getCooperateFlagFromXyj() {
    return cooperateFlagFromXyj;
  }

  public void setCooperateFlagFromXyj(Integer cooperateFlagFromXyj) {
    this.cooperateFlagFromXyj = cooperateFlagFromXyj;
  }

  @JsonIgnore
  public WkOrdersExtDTO groupFlagFromXyj(String groupFlagFromXyj) {
    this.groupFlagFromXyj = groupFlagFromXyj;
    return this;
  }

   /**
   * 喜盈佳分组标记
   * @return groupFlagFromXyj
  **/
  @ApiModelProperty(value = "喜盈佳分组标记")
  public String getGroupFlagFromXyj() {
    return groupFlagFromXyj;
  }

  public void setGroupFlagFromXyj(String groupFlagFromXyj) {
    this.groupFlagFromXyj = groupFlagFromXyj;
  }

  @JsonIgnore
  public WkOrdersExtDTO synResultTimeFromXyj(Long synResultTimeFromXyj) {
    this.synResultTimeFromXyj = synResultTimeFromXyj;
    return this;
  }

   /**
   * 喜盈佳同步结果时间
   * @return synResultTimeFromXyj
  **/
  @ApiModelProperty(value = "喜盈佳同步结果时间")
  public Long getSynResultTimeFromXyj() {
    return synResultTimeFromXyj;
  }

  public void setSynResultTimeFromXyj(Long synResultTimeFromXyj) {
    this.synResultTimeFromXyj = synResultTimeFromXyj;
  }

  @JsonIgnore
  public WkOrdersExtDTO requestDate(Long requestDate) {
    this.requestDate = requestDate;
    return this;
  }

   /**
   * 作废删除时间
   * @return requestDate
  **/
  @ApiModelProperty(value = "作废删除时间")
  public Long getRequestDate() {
    return requestDate;
  }

  public void setRequestDate(Long requestDate) {
    this.requestDate = requestDate;
  }

  @JsonIgnore
  public WkOrdersExtDTO requestUser(String requestUser) {
    this.requestUser = requestUser;
    return this;
  }

   /**
   * 作废删除操作人
   * @return requestUser
  **/
  @ApiModelProperty(value = "作废删除操作人")
  public String getRequestUser() {
    return requestUser;
  }

  public void setRequestUser(String requestUser) {
    this.requestUser = requestUser;
  }

  @JsonIgnore
  public WkOrdersExtDTO operator(String operator) {
    this.operator = operator;
    return this;
  }

   /**
   * 经办人
   * @return operator
  **/
  @ApiModelProperty(value = "经办人")
  public String getOperator() {
    return operator;
  }

  public void setOperator(String operator) {
    this.operator = operator;
  }

  @JsonIgnore
  public WkOrdersExtDTO purchaserManageUnit(String purchaserManageUnit) {
    this.purchaserManageUnit = purchaserManageUnit;
    return this;
  }

   /**
   * 购方管理单元/项目分期
   * @return purchaserManageUnit
  **/
  @ApiModelProperty(value = "购方管理单元/项目分期")
  public String getPurchaserManageUnit() {
    return purchaserManageUnit;
  }

  public void setPurchaserManageUnit(String purchaserManageUnit) {
    this.purchaserManageUnit = purchaserManageUnit;
  }

  @JsonIgnore
  public WkOrdersExtDTO performerFullName(String performerFullName) {
    this.performerFullName = performerFullName;
    return this;
  }

   /**
   * 单据经办人
   * @return performerFullName
  **/
  @ApiModelProperty(value = "单据经办人")
  public String getPerformerFullName() {
    return performerFullName;
  }

  public void setPerformerFullName(String performerFullName) {
    this.performerFullName = performerFullName;
  }

  @JsonIgnore
  public WkOrdersExtDTO performerAccount(String performerAccount) {
    this.performerAccount = performerAccount;
    return this;
  }

   /**
   * 经办人域账号
   * @return performerAccount
  **/
  @ApiModelProperty(value = "经办人域账号")
  public String getPerformerAccount() {
    return performerAccount;
  }

  public void setPerformerAccount(String performerAccount) {
    this.performerAccount = performerAccount;
  }

  @JsonIgnore
  public WkOrdersExtDTO orgName(String orgName) {
    this.orgName = orgName;
    return this;
  }

   /**
   * 城市公司
   * @return orgName
  **/
  @ApiModelProperty(value = "城市公司")
  public String getOrgName() {
    return orgName;
  }

  public void setOrgName(String orgName) {
    this.orgName = orgName;
  }

  @JsonIgnore
  public WkOrdersExtDTO billStatus(Integer billStatus) {
    this.billStatus = billStatus;
    return this;
  }

   /**
   * 开票状态0未开票,1完全开票，2部分开票,
   * @return billStatus
  **/
  @ApiModelProperty(value = "开票状态0未开票,1完全开票，2部分开票,")
  public Integer getBillStatus() {
    return billStatus;
  }

  public void setBillStatus(Integer billStatus) {
    this.billStatus = billStatus;
  }

  @JsonIgnore
  public WkOrdersExtDTO sellerContactNo(String sellerContactNo) {
    this.sellerContactNo = sellerContactNo;
    return this;
  }

   /**
   * 销方合同编码
   * @return sellerContactNo
  **/
  @ApiModelProperty(value = "销方合同编码")
  public String getSellerContactNo() {
    return sellerContactNo;
  }

  public void setSellerContactNo(String sellerContactNo) {
    this.sellerContactNo = sellerContactNo;
  }

  @JsonIgnore
  public WkOrdersExtDTO sellerExpress(String sellerExpress) {
    this.sellerExpress = sellerExpress;
    return this;
  }

   /**
   * 销方发运单号
   * @return sellerExpress
  **/
  @ApiModelProperty(value = "销方发运单号")
  public String getSellerExpress() {
    return sellerExpress;
  }

  public void setSellerExpress(String sellerExpress) {
    this.sellerExpress = sellerExpress;
  }

  @JsonIgnore
  public WkOrdersExtDTO outputType(Integer outputType) {
    this.outputType = outputType;
    return this;
  }

   /**
   * 产值单类型：1-产值确认单、2-结算单、3-红冲产值单
   * @return outputType
  **/
  @ApiModelProperty(value = "产值单类型：1-产值确认单、2-结算单、3-红冲产值单")
  public Integer getOutputType() {
    return outputType;
  }

  public void setOutputType(Integer outputType) {
    this.outputType = outputType;
  }

  @JsonIgnore
  public WkOrdersExtDTO outputState(Integer outputState) {
    this.outputState = outputState;
    return this;
  }

   /**
   * 产值单状态：3-已审核
   * @return outputState
  **/
  @ApiModelProperty(value = "产值单状态：3-已审核")
  public Integer getOutputState() {
    return outputState;
  }

  public void setOutputState(Integer outputState) {
    this.outputState = outputState;
  }

  @JsonIgnore
  public WkOrdersExtDTO accountSetCode(String accountSetCode) {
    this.accountSetCode = accountSetCode;
    return this;
  }

   /**
   * 账套编码
   * @return accountSetCode
  **/
  @ApiModelProperty(value = "账套编码")
  public String getAccountSetCode() {
    return accountSetCode;
  }

  public void setAccountSetCode(String accountSetCode) {
    this.accountSetCode = accountSetCode;
  }

  @JsonIgnore
  public WkOrdersExtDTO voucherCreated(String voucherCreated) {
    this.voucherCreated = voucherCreated;
    return this;
  }

   /**
   * 是否生成凭证（Y/0 - 已生成,N/1 - 未生成）
   * @return voucherCreated
  **/
  @ApiModelProperty(value = "是否生成凭证（Y/0 - 已生成,N/1 - 未生成）")
  public String getVoucherCreated() {
    return voucherCreated;
  }

  public void setVoucherCreated(String voucherCreated) {
    this.voucherCreated = voucherCreated;
  }

  @JsonIgnore
  public WkOrdersExtDTO invoiceStatus(String invoiceStatus) {
    this.invoiceStatus = invoiceStatus;
    return this;
  }

   /**
   * 单据发票状态：UNINVOICED-未开票，PARTIAL-部分开票，COMPLETED-完全开票，S-已审核，V-已认证，SV-已认证
   * @return invoiceStatus
  **/
  @ApiModelProperty(value = "单据发票状态：UNINVOICED-未开票，PARTIAL-部分开票，COMPLETED-完全开票，S-已审核，V-已认证，SV-已认证")
  public String getInvoiceStatus() {
    return invoiceStatus;
  }

  public void setInvoiceStatus(String invoiceStatus) {
    this.invoiceStatus = invoiceStatus;
  }

  @JsonIgnore
  public WkOrdersExtDTO startTime(String startTime) {
    this.startTime = startTime;
    return this;
  }

   /**
   * 开始时间
   * @return startTime
  **/
  @ApiModelProperty(value = "开始时间")
  public String getStartTime() {
    return startTime;
  }

  public void setStartTime(String startTime) {
    this.startTime = startTime;
  }

  @JsonIgnore
  public WkOrdersExtDTO endTime(String endTime) {
    this.endTime = endTime;
    return this;
  }

   /**
   * 结束时间
   * @return endTime
  **/
  @ApiModelProperty(value = "结束时间")
  public String getEndTime() {
    return endTime;
  }

  public void setEndTime(String endTime) {
    this.endTime = endTime;
  }

  @JsonIgnore
  public WkOrdersExtDTO syncStartTime(String syncStartTime) {
    this.syncStartTime = syncStartTime;
    return this;
  }

   /**
   * 同步开始时间
   * @return syncStartTime
  **/
  @ApiModelProperty(value = "同步开始时间")
  public String getSyncStartTime() {
    return syncStartTime;
  }

  public void setSyncStartTime(String syncStartTime) {
    this.syncStartTime = syncStartTime;
  }

  @JsonIgnore
  public WkOrdersExtDTO syncEndTime(String syncEndTime) {
    this.syncEndTime = syncEndTime;
    return this;
  }

   /**
   * 同步结束时间
   * @return syncEndTime
  **/
  @ApiModelProperty(value = "同步结束时间")
  public String getSyncEndTime() {
    return syncEndTime;
  }

  public void setSyncEndTime(String syncEndTime) {
    this.syncEndTime = syncEndTime;
  }

  @JsonIgnore
  public WkOrdersExtDTO authStartTime(String authStartTime) {
    this.authStartTime = authStartTime;
    return this;
  }

   /**
   * 认证开始时间
   * @return authStartTime
  **/
  @ApiModelProperty(value = "认证开始时间")
  public String getAuthStartTime() {
    return authStartTime;
  }

  public void setAuthStartTime(String authStartTime) {
    this.authStartTime = authStartTime;
  }

  @JsonIgnore
  public WkOrdersExtDTO authEndTime(String authEndTime) {
    this.authEndTime = authEndTime;
    return this;
  }

   /**
   * 认证结束时间
   * @return authEndTime
  **/
  @ApiModelProperty(value = "认证结束时间")
  public String getAuthEndTime() {
    return authEndTime;
  }

  public void setAuthEndTime(String authEndTime) {
    this.authEndTime = authEndTime;
  }

  @JsonIgnore
  public WkOrdersExtDTO auditStartTime(String auditStartTime) {
    this.auditStartTime = auditStartTime;
    return this;
  }

   /**
   * 审核开始时间
   * @return auditStartTime
  **/
  @ApiModelProperty(value = "审核开始时间")
  public String getAuditStartTime() {
    return auditStartTime;
  }

  public void setAuditStartTime(String auditStartTime) {
    this.auditStartTime = auditStartTime;
  }

  @JsonIgnore
  public WkOrdersExtDTO auditEndTime(String auditEndTime) {
    this.auditEndTime = auditEndTime;
    return this;
  }

   /**
   * 审核结束时间
   * @return auditEndTime
  **/
  @ApiModelProperty(value = "审核结束时间")
  public String getAuditEndTime() {
    return auditEndTime;
  }

  public void setAuditEndTime(String auditEndTime) {
    this.auditEndTime = auditEndTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WkOrdersExtDTO wkOrdersExtDTO = (WkOrdersExtDTO) o;
    return Objects.equals(this.id, wkOrdersExtDTO.id) &&
        Objects.equals(this.salesbillNo, wkOrdersExtDTO.salesbillNo) &&
        Objects.equals(this.sellerNo, wkOrdersExtDTO.sellerNo) &&
        Objects.equals(this.sellerName, wkOrdersExtDTO.sellerName) &&
        Objects.equals(this.sellerTaxNo, wkOrdersExtDTO.sellerTaxNo) &&
        Objects.equals(this.sellerTel, wkOrdersExtDTO.sellerTel) &&
        Objects.equals(this.sellerAddress, wkOrdersExtDTO.sellerAddress) &&
        Objects.equals(this.sellerBankName, wkOrdersExtDTO.sellerBankName) &&
        Objects.equals(this.sellerBankAccount, wkOrdersExtDTO.sellerBankAccount) &&
        Objects.equals(this.purchaserNo, wkOrdersExtDTO.purchaserNo) &&
        Objects.equals(this.purchaserName, wkOrdersExtDTO.purchaserName) &&
        Objects.equals(this.purchaserTaxNo, wkOrdersExtDTO.purchaserTaxNo) &&
        Objects.equals(this.purchaserTel, wkOrdersExtDTO.purchaserTel) &&
        Objects.equals(this.purchaserAddress, wkOrdersExtDTO.purchaserAddress) &&
        Objects.equals(this.purchaserBankName, wkOrdersExtDTO.purchaserBankName) &&
        Objects.equals(this.purchaserBankAccount, wkOrdersExtDTO.purchaserBankAccount) &&
        Objects.equals(this.systemOrig, wkOrdersExtDTO.systemOrig) &&
        Objects.equals(this.salesbillType, wkOrdersExtDTO.salesbillType) &&
        Objects.equals(this.invoiceType, wkOrdersExtDTO.invoiceType) &&
        Objects.equals(this.amountWithTax, wkOrdersExtDTO.amountWithTax) &&
        Objects.equals(this.amountWithoutTax, wkOrdersExtDTO.amountWithoutTax) &&
        Objects.equals(this.taxAmount, wkOrdersExtDTO.taxAmount) &&
        Objects.equals(this.alreadyMakeAmountWithTax, wkOrdersExtDTO.alreadyMakeAmountWithTax) &&
        Objects.equals(this.discountWithTax, wkOrdersExtDTO.discountWithTax) &&
        Objects.equals(this.discountWithoutTax, wkOrdersExtDTO.discountWithoutTax) &&
        Objects.equals(this.cooperateFlag, wkOrdersExtDTO.cooperateFlag) &&
        Objects.equals(this.status, wkOrdersExtDTO.status) &&
        Objects.equals(this.originInvoiceNo, wkOrdersExtDTO.originInvoiceNo) &&
        Objects.equals(this.originInvoiceCode, wkOrdersExtDTO.originInvoiceCode) &&
        Objects.equals(this.redNotification, wkOrdersExtDTO.redNotification) &&
        Objects.equals(this.checkerName, wkOrdersExtDTO.checkerName) &&
        Objects.equals(this.cashierName, wkOrdersExtDTO.cashierName) &&
        Objects.equals(this.invoicerName, wkOrdersExtDTO.invoicerName) &&
        Objects.equals(this.receiveUserEmail, wkOrdersExtDTO.receiveUserEmail) &&
        Objects.equals(this.receiveUserTel, wkOrdersExtDTO.receiveUserTel) &&
        Objects.equals(this.createTime, wkOrdersExtDTO.createTime) &&
        Objects.equals(this.createUserName, wkOrdersExtDTO.createUserName) &&
        Objects.equals(this.recipient, wkOrdersExtDTO.recipient) &&
        Objects.equals(this.recipientPhone, wkOrdersExtDTO.recipientPhone) &&
        Objects.equals(this.remark, wkOrdersExtDTO.remark) &&
        Objects.equals(this.packageCode, wkOrdersExtDTO.packageCode) &&
        Objects.equals(this.businessOrderType, wkOrdersExtDTO.businessOrderType) &&
        Objects.equals(this.specialTicketAmountWithTax, wkOrdersExtDTO.specialTicketAmountWithTax) &&
        Objects.equals(this.generalTicketAmountWithTax, wkOrdersExtDTO.generalTicketAmountWithTax) &&
        Objects.equals(this.taxRate, wkOrdersExtDTO.taxRate) &&
        Objects.equals(this.purchaserCode, wkOrdersExtDTO.purchaserCode) &&
        Objects.equals(this.sellerCode, wkOrdersExtDTO.sellerCode) &&
        Objects.equals(this.mainStatus, wkOrdersExtDTO.mainStatus) &&
        Objects.equals(this.signPerson, wkOrdersExtDTO.signPerson) &&
        Objects.equals(this.signTime, wkOrdersExtDTO.signTime) &&
        Objects.equals(this.signStatus, wkOrdersExtDTO.signStatus) &&
        Objects.equals(this.signFailType, wkOrdersExtDTO.signFailType) &&
        Objects.equals(this.signFailReason, wkOrdersExtDTO.signFailReason) &&
        Objects.equals(this.handleWay, wkOrdersExtDTO.handleWay) &&
        Objects.equals(this.backExpressNumber, wkOrdersExtDTO.backExpressNumber) &&
        Objects.equals(this.exceptionNote, wkOrdersExtDTO.exceptionNote) &&
        Objects.equals(this.exceptionHandlePerson, wkOrdersExtDTO.exceptionHandlePerson) &&
        Objects.equals(this.exceptionHandleTime, wkOrdersExtDTO.exceptionHandleTime) &&
        Objects.equals(this.sendPerson, wkOrdersExtDTO.sendPerson) &&
        Objects.equals(this.sendPersonPhone, wkOrdersExtDTO.sendPersonPhone) &&
        Objects.equals(this.recordBillCheckStatus, wkOrdersExtDTO.recordBillCheckStatus) &&
        Objects.equals(this.recordBillCheckNote, wkOrdersExtDTO.recordBillCheckNote) &&
        Objects.equals(this.recordBillCkeckPerson, wkOrdersExtDTO.recordBillCkeckPerson) &&
        Objects.equals(this.recordBillCkeckTime, wkOrdersExtDTO.recordBillCkeckTime) &&
        Objects.equals(this.isLock, wkOrdersExtDTO.isLock) &&
        Objects.equals(this.autoCheckStatus, wkOrdersExtDTO.autoCheckStatus) &&
        Objects.equals(this.autoCheckNote, wkOrdersExtDTO.autoCheckNote) &&
        Objects.equals(this.autoCheckTime, wkOrdersExtDTO.autoCheckTime) &&
        Objects.equals(this.orderStatus, wkOrdersExtDTO.orderStatus) &&
        Objects.equals(this.ifAuthFlag, wkOrdersExtDTO.ifAuthFlag) &&
        Objects.equals(this.authStatus, wkOrdersExtDTO.authStatus) &&
        Objects.equals(this.authAmount, wkOrdersExtDTO.authAmount) &&
        Objects.equals(this.authNotContaintAmount, wkOrdersExtDTO.authNotContaintAmount) &&
        Objects.equals(this.authTaxAmount, wkOrdersExtDTO.authTaxAmount) &&
        Objects.equals(this.authUpdateTime, wkOrdersExtDTO.authUpdateTime) &&
        Objects.equals(this.syncServiceSystemStatus, wkOrdersExtDTO.syncServiceSystemStatus) &&
        Objects.equals(this.syncServiceSystemTime, wkOrdersExtDTO.syncServiceSystemTime) &&
        Objects.equals(this.syncServiceSystemNote, wkOrdersExtDTO.syncServiceSystemNote) &&
        Objects.equals(this.auditStatus, wkOrdersExtDTO.auditStatus) &&
        Objects.equals(this.auditUpdateTime, wkOrdersExtDTO.auditUpdateTime) &&
        Objects.equals(this.synAuditStatus, wkOrdersExtDTO.synAuditStatus) &&
        Objects.equals(this.synAuditStatusTime, wkOrdersExtDTO.synAuditStatusTime) &&
        Objects.equals(this.synAuditStatusNote, wkOrdersExtDTO.synAuditStatusNote) &&
        Objects.equals(this.isPushTask, wkOrdersExtDTO.isPushTask) &&
        Objects.equals(this.taxRebateAmount, wkOrdersExtDTO.taxRebateAmount) &&
        Objects.equals(this.deductionAmount, wkOrdersExtDTO.deductionAmount) &&
        Objects.equals(this.agreementCode, wkOrdersExtDTO.agreementCode) &&
        Objects.equals(this.isCancelXyj, wkOrdersExtDTO.isCancelXyj) &&
        Objects.equals(this.cancelDateXyj, wkOrdersExtDTO.cancelDateXyj) &&
        Objects.equals(this.pushTime, wkOrdersExtDTO.pushTime) &&
        Objects.equals(this.changeNotes, wkOrdersExtDTO.changeNotes) &&
        Objects.equals(this.deductionsFlag, wkOrdersExtDTO.deductionsFlag) &&
        Objects.equals(this.groupFlag, wkOrdersExtDTO.groupFlag) &&
        Objects.equals(this.changeTime, wkOrdersExtDTO.changeTime) &&
        Objects.equals(this.changeStatus, wkOrdersExtDTO.changeStatus) &&
        Objects.equals(this.changeInfo, wkOrdersExtDTO.changeInfo) &&
        Objects.equals(this.isPushStatus, wkOrdersExtDTO.isPushStatus) &&
        Objects.equals(this.pushAuditTime, wkOrdersExtDTO.pushAuditTime) &&
        Objects.equals(this.synAuditStatusToXyj, wkOrdersExtDTO.synAuditStatusToXyj) &&
        Objects.equals(this.isLegalSynergetics, wkOrdersExtDTO.isLegalSynergetics) &&
        Objects.equals(this.recipientCompany, wkOrdersExtDTO.recipientCompany) &&
        Objects.equals(this.returnBatch, wkOrdersExtDTO.returnBatch) &&
        Objects.equals(this.returnType, wkOrdersExtDTO.returnType) &&
        Objects.equals(this.syncTime, wkOrdersExtDTO.syncTime) &&
        Objects.equals(this.synergySendTime, wkOrdersExtDTO.synergySendTime) &&
        Objects.equals(this.synergyUserId, wkOrdersExtDTO.synergyUserId) &&
        Objects.equals(this.synergyFlag, wkOrdersExtDTO.synergyFlag) &&
        Objects.equals(this.requestSerialNoToXyj, wkOrdersExtDTO.requestSerialNoToXyj) &&
        Objects.equals(this.synTimeToXyj, wkOrdersExtDTO.synTimeToXyj) &&
        Objects.equals(this.synResultToXyj, wkOrdersExtDTO.synResultToXyj) &&
        Objects.equals(this.infoFromXyj, wkOrdersExtDTO.infoFromXyj) &&
        Objects.equals(this.processTimeFromXyj, wkOrdersExtDTO.processTimeFromXyj) &&
        Objects.equals(this.cooperateFlagFromXyj, wkOrdersExtDTO.cooperateFlagFromXyj) &&
        Objects.equals(this.groupFlagFromXyj, wkOrdersExtDTO.groupFlagFromXyj) &&
        Objects.equals(this.synResultTimeFromXyj, wkOrdersExtDTO.synResultTimeFromXyj) &&
        Objects.equals(this.requestDate, wkOrdersExtDTO.requestDate) &&
        Objects.equals(this.requestUser, wkOrdersExtDTO.requestUser) &&
        Objects.equals(this.operator, wkOrdersExtDTO.operator) &&
        Objects.equals(this.purchaserManageUnit, wkOrdersExtDTO.purchaserManageUnit) &&
        Objects.equals(this.performerFullName, wkOrdersExtDTO.performerFullName) &&
        Objects.equals(this.performerAccount, wkOrdersExtDTO.performerAccount) &&
        Objects.equals(this.orgName, wkOrdersExtDTO.orgName) &&
        Objects.equals(this.billStatus, wkOrdersExtDTO.billStatus) &&
        Objects.equals(this.sellerContactNo, wkOrdersExtDTO.sellerContactNo) &&
        Objects.equals(this.sellerExpress, wkOrdersExtDTO.sellerExpress) &&
        Objects.equals(this.outputType, wkOrdersExtDTO.outputType) &&
        Objects.equals(this.outputState, wkOrdersExtDTO.outputState) &&
        Objects.equals(this.accountSetCode, wkOrdersExtDTO.accountSetCode) &&
        Objects.equals(this.voucherCreated, wkOrdersExtDTO.voucherCreated) &&
        Objects.equals(this.invoiceStatus, wkOrdersExtDTO.invoiceStatus) &&
        Objects.equals(this.startTime, wkOrdersExtDTO.startTime) &&
        Objects.equals(this.endTime, wkOrdersExtDTO.endTime) &&
        Objects.equals(this.syncStartTime, wkOrdersExtDTO.syncStartTime) &&
        Objects.equals(this.syncEndTime, wkOrdersExtDTO.syncEndTime) &&
        Objects.equals(this.authStartTime, wkOrdersExtDTO.authStartTime) &&
        Objects.equals(this.authEndTime, wkOrdersExtDTO.authEndTime) &&
        Objects.equals(this.auditStartTime, wkOrdersExtDTO.auditStartTime) &&
        Objects.equals(this.auditEndTime, wkOrdersExtDTO.auditEndTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, salesbillNo, sellerNo, sellerName, sellerTaxNo, sellerTel, sellerAddress, sellerBankName, sellerBankAccount, purchaserNo, purchaserName, purchaserTaxNo, purchaserTel, purchaserAddress, purchaserBankName, purchaserBankAccount, systemOrig, salesbillType, invoiceType, amountWithTax, amountWithoutTax, taxAmount, alreadyMakeAmountWithTax, discountWithTax, discountWithoutTax, cooperateFlag, status, originInvoiceNo, originInvoiceCode, redNotification, checkerName, cashierName, invoicerName, receiveUserEmail, receiveUserTel, createTime, createUserName, recipient, recipientPhone, remark, packageCode, businessOrderType, specialTicketAmountWithTax, generalTicketAmountWithTax, taxRate, purchaserCode, sellerCode, mainStatus, signPerson, signTime, signStatus, signFailType, signFailReason, handleWay, backExpressNumber, exceptionNote, exceptionHandlePerson, exceptionHandleTime, sendPerson, sendPersonPhone, recordBillCheckStatus, recordBillCheckNote, recordBillCkeckPerson, recordBillCkeckTime, isLock, autoCheckStatus, autoCheckNote, autoCheckTime, orderStatus, ifAuthFlag, authStatus, authAmount, authNotContaintAmount, authTaxAmount, authUpdateTime, syncServiceSystemStatus, syncServiceSystemTime, syncServiceSystemNote, auditStatus, auditUpdateTime, synAuditStatus, synAuditStatusTime, synAuditStatusNote, isPushTask, taxRebateAmount, deductionAmount, agreementCode, isCancelXyj, cancelDateXyj, pushTime, changeNotes, deductionsFlag, groupFlag, changeTime, changeStatus, changeInfo, isPushStatus, pushAuditTime, synAuditStatusToXyj, isLegalSynergetics, recipientCompany, returnBatch, returnType, syncTime, synergySendTime, synergyUserId, synergyFlag, requestSerialNoToXyj, synTimeToXyj, synResultToXyj, infoFromXyj, processTimeFromXyj, cooperateFlagFromXyj, groupFlagFromXyj, synResultTimeFromXyj, requestDate, requestUser, operator, purchaserManageUnit, performerFullName, performerAccount, orgName, billStatus, sellerContactNo, sellerExpress, outputType, outputState, accountSetCode, voucherCreated, invoiceStatus, startTime, endTime, syncStartTime, syncEndTime, authStartTime, authEndTime, auditStartTime, auditEndTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WkOrdersExtDTO {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    salesbillNo: ").append(toIndentedString(salesbillNo)).append("\n");
    sb.append("    sellerNo: ").append(toIndentedString(sellerNo)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    sellerTel: ").append(toIndentedString(sellerTel)).append("\n");
    sb.append("    sellerAddress: ").append(toIndentedString(sellerAddress)).append("\n");
    sb.append("    sellerBankName: ").append(toIndentedString(sellerBankName)).append("\n");
    sb.append("    sellerBankAccount: ").append(toIndentedString(sellerBankAccount)).append("\n");
    sb.append("    purchaserNo: ").append(toIndentedString(purchaserNo)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    purchaserTel: ").append(toIndentedString(purchaserTel)).append("\n");
    sb.append("    purchaserAddress: ").append(toIndentedString(purchaserAddress)).append("\n");
    sb.append("    purchaserBankName: ").append(toIndentedString(purchaserBankName)).append("\n");
    sb.append("    purchaserBankAccount: ").append(toIndentedString(purchaserBankAccount)).append("\n");
    sb.append("    systemOrig: ").append(toIndentedString(systemOrig)).append("\n");
    sb.append("    salesbillType: ").append(toIndentedString(salesbillType)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    alreadyMakeAmountWithTax: ").append(toIndentedString(alreadyMakeAmountWithTax)).append("\n");
    sb.append("    discountWithTax: ").append(toIndentedString(discountWithTax)).append("\n");
    sb.append("    discountWithoutTax: ").append(toIndentedString(discountWithoutTax)).append("\n");
    sb.append("    cooperateFlag: ").append(toIndentedString(cooperateFlag)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    originInvoiceNo: ").append(toIndentedString(originInvoiceNo)).append("\n");
    sb.append("    originInvoiceCode: ").append(toIndentedString(originInvoiceCode)).append("\n");
    sb.append("    redNotification: ").append(toIndentedString(redNotification)).append("\n");
    sb.append("    checkerName: ").append(toIndentedString(checkerName)).append("\n");
    sb.append("    cashierName: ").append(toIndentedString(cashierName)).append("\n");
    sb.append("    invoicerName: ").append(toIndentedString(invoicerName)).append("\n");
    sb.append("    receiveUserEmail: ").append(toIndentedString(receiveUserEmail)).append("\n");
    sb.append("    receiveUserTel: ").append(toIndentedString(receiveUserTel)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    recipient: ").append(toIndentedString(recipient)).append("\n");
    sb.append("    recipientPhone: ").append(toIndentedString(recipientPhone)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    packageCode: ").append(toIndentedString(packageCode)).append("\n");
    sb.append("    businessOrderType: ").append(toIndentedString(businessOrderType)).append("\n");
    sb.append("    specialTicketAmountWithTax: ").append(toIndentedString(specialTicketAmountWithTax)).append("\n");
    sb.append("    generalTicketAmountWithTax: ").append(toIndentedString(generalTicketAmountWithTax)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    purchaserCode: ").append(toIndentedString(purchaserCode)).append("\n");
    sb.append("    sellerCode: ").append(toIndentedString(sellerCode)).append("\n");
    sb.append("    mainStatus: ").append(toIndentedString(mainStatus)).append("\n");
    sb.append("    signPerson: ").append(toIndentedString(signPerson)).append("\n");
    sb.append("    signTime: ").append(toIndentedString(signTime)).append("\n");
    sb.append("    signStatus: ").append(toIndentedString(signStatus)).append("\n");
    sb.append("    signFailType: ").append(toIndentedString(signFailType)).append("\n");
    sb.append("    signFailReason: ").append(toIndentedString(signFailReason)).append("\n");
    sb.append("    handleWay: ").append(toIndentedString(handleWay)).append("\n");
    sb.append("    backExpressNumber: ").append(toIndentedString(backExpressNumber)).append("\n");
    sb.append("    exceptionNote: ").append(toIndentedString(exceptionNote)).append("\n");
    sb.append("    exceptionHandlePerson: ").append(toIndentedString(exceptionHandlePerson)).append("\n");
    sb.append("    exceptionHandleTime: ").append(toIndentedString(exceptionHandleTime)).append("\n");
    sb.append("    sendPerson: ").append(toIndentedString(sendPerson)).append("\n");
    sb.append("    sendPersonPhone: ").append(toIndentedString(sendPersonPhone)).append("\n");
    sb.append("    recordBillCheckStatus: ").append(toIndentedString(recordBillCheckStatus)).append("\n");
    sb.append("    recordBillCheckNote: ").append(toIndentedString(recordBillCheckNote)).append("\n");
    sb.append("    recordBillCkeckPerson: ").append(toIndentedString(recordBillCkeckPerson)).append("\n");
    sb.append("    recordBillCkeckTime: ").append(toIndentedString(recordBillCkeckTime)).append("\n");
    sb.append("    isLock: ").append(toIndentedString(isLock)).append("\n");
    sb.append("    autoCheckStatus: ").append(toIndentedString(autoCheckStatus)).append("\n");
    sb.append("    autoCheckNote: ").append(toIndentedString(autoCheckNote)).append("\n");
    sb.append("    autoCheckTime: ").append(toIndentedString(autoCheckTime)).append("\n");
    sb.append("    orderStatus: ").append(toIndentedString(orderStatus)).append("\n");
    sb.append("    ifAuthFlag: ").append(toIndentedString(ifAuthFlag)).append("\n");
    sb.append("    authStatus: ").append(toIndentedString(authStatus)).append("\n");
    sb.append("    authAmount: ").append(toIndentedString(authAmount)).append("\n");
    sb.append("    authNotContaintAmount: ").append(toIndentedString(authNotContaintAmount)).append("\n");
    sb.append("    authTaxAmount: ").append(toIndentedString(authTaxAmount)).append("\n");
    sb.append("    authUpdateTime: ").append(toIndentedString(authUpdateTime)).append("\n");
    sb.append("    syncServiceSystemStatus: ").append(toIndentedString(syncServiceSystemStatus)).append("\n");
    sb.append("    syncServiceSystemTime: ").append(toIndentedString(syncServiceSystemTime)).append("\n");
    sb.append("    syncServiceSystemNote: ").append(toIndentedString(syncServiceSystemNote)).append("\n");
    sb.append("    auditStatus: ").append(toIndentedString(auditStatus)).append("\n");
    sb.append("    auditUpdateTime: ").append(toIndentedString(auditUpdateTime)).append("\n");
    sb.append("    synAuditStatus: ").append(toIndentedString(synAuditStatus)).append("\n");
    sb.append("    synAuditStatusTime: ").append(toIndentedString(synAuditStatusTime)).append("\n");
    sb.append("    synAuditStatusNote: ").append(toIndentedString(synAuditStatusNote)).append("\n");
    sb.append("    isPushTask: ").append(toIndentedString(isPushTask)).append("\n");
    sb.append("    taxRebateAmount: ").append(toIndentedString(taxRebateAmount)).append("\n");
    sb.append("    deductionAmount: ").append(toIndentedString(deductionAmount)).append("\n");
    sb.append("    agreementCode: ").append(toIndentedString(agreementCode)).append("\n");
    sb.append("    isCancelXyj: ").append(toIndentedString(isCancelXyj)).append("\n");
    sb.append("    cancelDateXyj: ").append(toIndentedString(cancelDateXyj)).append("\n");
    sb.append("    pushTime: ").append(toIndentedString(pushTime)).append("\n");
    sb.append("    changeNotes: ").append(toIndentedString(changeNotes)).append("\n");
    sb.append("    deductionsFlag: ").append(toIndentedString(deductionsFlag)).append("\n");
    sb.append("    groupFlag: ").append(toIndentedString(groupFlag)).append("\n");
    sb.append("    changeTime: ").append(toIndentedString(changeTime)).append("\n");
    sb.append("    changeStatus: ").append(toIndentedString(changeStatus)).append("\n");
    sb.append("    changeInfo: ").append(toIndentedString(changeInfo)).append("\n");
    sb.append("    isPushStatus: ").append(toIndentedString(isPushStatus)).append("\n");
    sb.append("    pushAuditTime: ").append(toIndentedString(pushAuditTime)).append("\n");
    sb.append("    synAuditStatusToXyj: ").append(toIndentedString(synAuditStatusToXyj)).append("\n");
    sb.append("    isLegalSynergetics: ").append(toIndentedString(isLegalSynergetics)).append("\n");
    sb.append("    recipientCompany: ").append(toIndentedString(recipientCompany)).append("\n");
    sb.append("    returnBatch: ").append(toIndentedString(returnBatch)).append("\n");
    sb.append("    returnType: ").append(toIndentedString(returnType)).append("\n");
    sb.append("    syncTime: ").append(toIndentedString(syncTime)).append("\n");
    sb.append("    synergySendTime: ").append(toIndentedString(synergySendTime)).append("\n");
    sb.append("    synergyUserId: ").append(toIndentedString(synergyUserId)).append("\n");
    sb.append("    synergyFlag: ").append(toIndentedString(synergyFlag)).append("\n");
    sb.append("    requestSerialNoToXyj: ").append(toIndentedString(requestSerialNoToXyj)).append("\n");
    sb.append("    synTimeToXyj: ").append(toIndentedString(synTimeToXyj)).append("\n");
    sb.append("    synResultToXyj: ").append(toIndentedString(synResultToXyj)).append("\n");
    sb.append("    infoFromXyj: ").append(toIndentedString(infoFromXyj)).append("\n");
    sb.append("    processTimeFromXyj: ").append(toIndentedString(processTimeFromXyj)).append("\n");
    sb.append("    cooperateFlagFromXyj: ").append(toIndentedString(cooperateFlagFromXyj)).append("\n");
    sb.append("    groupFlagFromXyj: ").append(toIndentedString(groupFlagFromXyj)).append("\n");
    sb.append("    synResultTimeFromXyj: ").append(toIndentedString(synResultTimeFromXyj)).append("\n");
    sb.append("    requestDate: ").append(toIndentedString(requestDate)).append("\n");
    sb.append("    requestUser: ").append(toIndentedString(requestUser)).append("\n");
    sb.append("    operator: ").append(toIndentedString(operator)).append("\n");
    sb.append("    purchaserManageUnit: ").append(toIndentedString(purchaserManageUnit)).append("\n");
    sb.append("    performerFullName: ").append(toIndentedString(performerFullName)).append("\n");
    sb.append("    performerAccount: ").append(toIndentedString(performerAccount)).append("\n");
    sb.append("    orgName: ").append(toIndentedString(orgName)).append("\n");
    sb.append("    billStatus: ").append(toIndentedString(billStatus)).append("\n");
    sb.append("    sellerContactNo: ").append(toIndentedString(sellerContactNo)).append("\n");
    sb.append("    sellerExpress: ").append(toIndentedString(sellerExpress)).append("\n");
    sb.append("    outputType: ").append(toIndentedString(outputType)).append("\n");
    sb.append("    outputState: ").append(toIndentedString(outputState)).append("\n");
    sb.append("    accountSetCode: ").append(toIndentedString(accountSetCode)).append("\n");
    sb.append("    voucherCreated: ").append(toIndentedString(voucherCreated)).append("\n");
    sb.append("    invoiceStatus: ").append(toIndentedString(invoiceStatus)).append("\n");
    sb.append("    startTime: ").append(toIndentedString(startTime)).append("\n");
    sb.append("    endTime: ").append(toIndentedString(endTime)).append("\n");
    sb.append("    syncStartTime: ").append(toIndentedString(syncStartTime)).append("\n");
    sb.append("    syncEndTime: ").append(toIndentedString(syncEndTime)).append("\n");
    sb.append("    authStartTime: ").append(toIndentedString(authStartTime)).append("\n");
    sb.append("    authEndTime: ").append(toIndentedString(authEndTime)).append("\n");
    sb.append("    auditStartTime: ").append(toIndentedString(auditStartTime)).append("\n");
    sb.append("    auditEndTime: ").append(toIndentedString(auditEndTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
