package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 退票包裹表
 */
@ApiModel(description = "退票包裹表")

@JsonInclude(NON_NULL)
public class WkParcelDTO {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("orderNo")
  private String orderNo = null;

  @JsonProperty("waybillNo")
  private String waybillNo = null;

  @JsonProperty("senderRole")
  private Integer senderRole = null;

  @JsonProperty("senderName")
  private String senderName = null;

  @JsonProperty("senderTel")
  private String senderTel = null;

  @JsonProperty("senderCompanyName")
  private String senderCompanyName = null;

  @JsonProperty("senderTaxNo")
  private String senderTaxNo = null;

  @JsonProperty("senderAddr")
  private String senderAddr = null;

  @JsonProperty("senderTime")
  private Long senderTime = null;

  @JsonProperty("receiverName")
  private String receiverName = null;

  @JsonProperty("receiverTel")
  private String receiverTel = null;

  @JsonProperty("receiverCompanyName")
  private String receiverCompanyName = null;

  @JsonProperty("receiverTaxNo")
  private String receiverTaxNo = null;

  @JsonProperty("receiverAddr")
  private String receiverAddr = null;

  @JsonProperty("destinationCode")
  private String destinationCode = null;

  @JsonProperty("parcelStatus")
  private Integer parcelStatus = null;

  @JsonProperty("expressCode")
  private String expressCode = null;

  @JsonProperty("expressName")
  private String expressName = null;

  @JsonProperty("expressLgtStatus")
  private Integer expressLgtStatus = null;

  @JsonProperty("businessLgtStatus")
  private Integer businessLgtStatus = null;

  @JsonProperty("expressSignTime")
  private Long expressSignTime = null;

  @JsonProperty("businessSignTime")
  private Long businessSignTime = null;

  @JsonProperty("expressType")
  private Integer expressType = null;

  @JsonProperty("isExterExpress")
  private Integer isExterExpress = null;

  @JsonProperty("logisticsStatusMsg")
  private String logisticsStatusMsg = null;

  @JsonProperty("expressProduceType")
  private Integer expressProduceType = null;

  @JsonProperty("payMethod")
  private Integer payMethod = null;

  @JsonProperty("custCard")
  private String custCard = null;

  @JsonProperty("receiverAddrLabel")
  private String receiverAddrLabel = null;

  @JsonProperty("senderAddrLabel")
  private String senderAddrLabel = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("createUserId")
  private Long createUserId = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("createTime")
  private Long createTime = null;

  @JsonProperty("updateUserId")
  private Long updateUserId = null;

  @JsonProperty("updateUserName")
  private String updateUserName = null;

  @JsonProperty("updateTime")
  private Long updateTime = null;

  @JsonIgnore
  public WkParcelDTO id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * null
   * @return id
  **/
  @ApiModelProperty(value = "null")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public WkParcelDTO orderNo(String orderNo) {
    this.orderNo = orderNo;
    return this;
  }

   /**
   * 订单号
   * @return orderNo
  **/
  @ApiModelProperty(value = "订单号")
  public String getOrderNo() {
    return orderNo;
  }

  public void setOrderNo(String orderNo) {
    this.orderNo = orderNo;
  }

  @JsonIgnore
  public WkParcelDTO waybillNo(String waybillNo) {
    this.waybillNo = waybillNo;
    return this;
  }

   /**
   * 快递单号
   * @return waybillNo
  **/
  @ApiModelProperty(value = "快递单号")
  public String getWaybillNo() {
    return waybillNo;
  }

  public void setWaybillNo(String waybillNo) {
    this.waybillNo = waybillNo;
  }

  @JsonIgnore
  public WkParcelDTO senderRole(Integer senderRole) {
    this.senderRole = senderRole;
    return this;
  }

   /**
   * 寄件角色：1-销方寄件，2-购方寄件
   * @return senderRole
  **/
  @ApiModelProperty(value = "寄件角色：1-销方寄件，2-购方寄件")
  public Integer getSenderRole() {
    return senderRole;
  }

  public void setSenderRole(Integer senderRole) {
    this.senderRole = senderRole;
  }

  @JsonIgnore
  public WkParcelDTO senderName(String senderName) {
    this.senderName = senderName;
    return this;
  }

   /**
   * 寄件方名称
   * @return senderName
  **/
  @ApiModelProperty(value = "寄件方名称")
  public String getSenderName() {
    return senderName;
  }

  public void setSenderName(String senderName) {
    this.senderName = senderName;
  }

  @JsonIgnore
  public WkParcelDTO senderTel(String senderTel) {
    this.senderTel = senderTel;
    return this;
  }

   /**
   * 寄件方联系电话
   * @return senderTel
  **/
  @ApiModelProperty(value = "寄件方联系电话")
  public String getSenderTel() {
    return senderTel;
  }

  public void setSenderTel(String senderTel) {
    this.senderTel = senderTel;
  }

  @JsonIgnore
  public WkParcelDTO senderCompanyName(String senderCompanyName) {
    this.senderCompanyName = senderCompanyName;
    return this;
  }

   /**
   * 寄件方公司名称
   * @return senderCompanyName
  **/
  @ApiModelProperty(value = "寄件方公司名称")
  public String getSenderCompanyName() {
    return senderCompanyName;
  }

  public void setSenderCompanyName(String senderCompanyName) {
    this.senderCompanyName = senderCompanyName;
  }

  @JsonIgnore
  public WkParcelDTO senderTaxNo(String senderTaxNo) {
    this.senderTaxNo = senderTaxNo;
    return this;
  }

   /**
   * 寄件方纳税人识别号
   * @return senderTaxNo
  **/
  @ApiModelProperty(value = "寄件方纳税人识别号")
  public String getSenderTaxNo() {
    return senderTaxNo;
  }

  public void setSenderTaxNo(String senderTaxNo) {
    this.senderTaxNo = senderTaxNo;
  }

  @JsonIgnore
  public WkParcelDTO senderAddr(String senderAddr) {
    this.senderAddr = senderAddr;
    return this;
  }

   /**
   * 寄件地址
   * @return senderAddr
  **/
  @ApiModelProperty(value = "寄件地址")
  public String getSenderAddr() {
    return senderAddr;
  }

  public void setSenderAddr(String senderAddr) {
    this.senderAddr = senderAddr;
  }

  @JsonIgnore
  public WkParcelDTO senderTime(Long senderTime) {
    this.senderTime = senderTime;
    return this;
  }

   /**
   * 寄件时间
   * @return senderTime
  **/
  @ApiModelProperty(value = "寄件时间")
  public Long getSenderTime() {
    return senderTime;
  }

  public void setSenderTime(Long senderTime) {
    this.senderTime = senderTime;
  }

  @JsonIgnore
  public WkParcelDTO receiverName(String receiverName) {
    this.receiverName = receiverName;
    return this;
  }

   /**
   * 收件方名称
   * @return receiverName
  **/
  @ApiModelProperty(value = "收件方名称")
  public String getReceiverName() {
    return receiverName;
  }

  public void setReceiverName(String receiverName) {
    this.receiverName = receiverName;
  }

  @JsonIgnore
  public WkParcelDTO receiverTel(String receiverTel) {
    this.receiverTel = receiverTel;
    return this;
  }

   /**
   * 收件方联系电话
   * @return receiverTel
  **/
  @ApiModelProperty(value = "收件方联系电话")
  public String getReceiverTel() {
    return receiverTel;
  }

  public void setReceiverTel(String receiverTel) {
    this.receiverTel = receiverTel;
  }

  @JsonIgnore
  public WkParcelDTO receiverCompanyName(String receiverCompanyName) {
    this.receiverCompanyName = receiverCompanyName;
    return this;
  }

   /**
   * 收件方公司名称
   * @return receiverCompanyName
  **/
  @ApiModelProperty(value = "收件方公司名称")
  public String getReceiverCompanyName() {
    return receiverCompanyName;
  }

  public void setReceiverCompanyName(String receiverCompanyName) {
    this.receiverCompanyName = receiverCompanyName;
  }

  @JsonIgnore
  public WkParcelDTO receiverTaxNo(String receiverTaxNo) {
    this.receiverTaxNo = receiverTaxNo;
    return this;
  }

   /**
   * 收件方纳税人识别号
   * @return receiverTaxNo
  **/
  @ApiModelProperty(value = "收件方纳税人识别号")
  public String getReceiverTaxNo() {
    return receiverTaxNo;
  }

  public void setReceiverTaxNo(String receiverTaxNo) {
    this.receiverTaxNo = receiverTaxNo;
  }

  @JsonIgnore
  public WkParcelDTO receiverAddr(String receiverAddr) {
    this.receiverAddr = receiverAddr;
    return this;
  }

   /**
   * 收件地址
   * @return receiverAddr
  **/
  @ApiModelProperty(value = "收件地址")
  public String getReceiverAddr() {
    return receiverAddr;
  }

  public void setReceiverAddr(String receiverAddr) {
    this.receiverAddr = receiverAddr;
  }

  @JsonIgnore
  public WkParcelDTO destinationCode(String destinationCode) {
    this.destinationCode = destinationCode;
    return this;
  }

   /**
   * 目的地代码
   * @return destinationCode
  **/
  @ApiModelProperty(value = "目的地代码")
  public String getDestinationCode() {
    return destinationCode;
  }

  public void setDestinationCode(String destinationCode) {
    this.destinationCode = destinationCode;
  }

  @JsonIgnore
  public WkParcelDTO parcelStatus(Integer parcelStatus) {
    this.parcelStatus = parcelStatus;
    return this;
  }

   /**
   * 包裹状态：1-正常
   * @return parcelStatus
  **/
  @ApiModelProperty(value = "包裹状态：1-正常")
  public Integer getParcelStatus() {
    return parcelStatus;
  }

  public void setParcelStatus(Integer parcelStatus) {
    this.parcelStatus = parcelStatus;
  }

  @JsonIgnore
  public WkParcelDTO expressCode(String expressCode) {
    this.expressCode = expressCode;
    return this;
  }

   /**
   * 快递公司编码
   * @return expressCode
  **/
  @ApiModelProperty(value = "快递公司编码")
  public String getExpressCode() {
    return expressCode;
  }

  public void setExpressCode(String expressCode) {
    this.expressCode = expressCode;
  }

  @JsonIgnore
  public WkParcelDTO expressName(String expressName) {
    this.expressName = expressName;
    return this;
  }

   /**
   * 快递公司名称
   * @return expressName
  **/
  @ApiModelProperty(value = "快递公司名称")
  public String getExpressName() {
    return expressName;
  }

  public void setExpressName(String expressName) {
    this.expressName = expressName;
  }

  @JsonIgnore
  public WkParcelDTO expressLgtStatus(Integer expressLgtStatus) {
    this.expressLgtStatus = expressLgtStatus;
    return this;
  }

   /**
   * 快递公司物流状态：0-空，1-待揽收，2-已揽收，3-干线运输中，4-清关中，5-运输中，6-派送中，7-包裹异常，8-拒签，9-待提货，10-已签收
   * @return expressLgtStatus
  **/
  @ApiModelProperty(value = "快递公司物流状态：0-空，1-待揽收，2-已揽收，3-干线运输中，4-清关中，5-运输中，6-派送中，7-包裹异常，8-拒签，9-待提货，10-已签收")
  public Integer getExpressLgtStatus() {
    return expressLgtStatus;
  }

  public void setExpressLgtStatus(Integer expressLgtStatus) {
    this.expressLgtStatus = expressLgtStatus;
  }

  @JsonIgnore
  public WkParcelDTO businessLgtStatus(Integer businessLgtStatus) {
    this.businessLgtStatus = businessLgtStatus;
    return this;
  }

   /**
   * 业务物流状态1-待寄送，2-无需寄送，3-寄送中，4-异常，5-已签收
   * @return businessLgtStatus
  **/
  @ApiModelProperty(value = "业务物流状态1-待寄送，2-无需寄送，3-寄送中，4-异常，5-已签收")
  public Integer getBusinessLgtStatus() {
    return businessLgtStatus;
  }

  public void setBusinessLgtStatus(Integer businessLgtStatus) {
    this.businessLgtStatus = businessLgtStatus;
  }

  @JsonIgnore
  public WkParcelDTO expressSignTime(Long expressSignTime) {
    this.expressSignTime = expressSignTime;
    return this;
  }

   /**
   * 快递公司物流签收时间
   * @return expressSignTime
  **/
  @ApiModelProperty(value = "快递公司物流签收时间")
  public Long getExpressSignTime() {
    return expressSignTime;
  }

  public void setExpressSignTime(Long expressSignTime) {
    this.expressSignTime = expressSignTime;
  }

  @JsonIgnore
  public WkParcelDTO businessSignTime(Long businessSignTime) {
    this.businessSignTime = businessSignTime;
    return this;
  }

   /**
   * 业务物流签收时间
   * @return businessSignTime
  **/
  @ApiModelProperty(value = "业务物流签收时间")
  public Long getBusinessSignTime() {
    return businessSignTime;
  }

  public void setBusinessSignTime(Long businessSignTime) {
    this.businessSignTime = businessSignTime;
  }

  @JsonIgnore
  public WkParcelDTO expressType(Integer expressType) {
    this.expressType = expressType;
    return this;
  }

   /**
   * 选择的快递类型：1-在线下单，2-自己联系物流
   * @return expressType
  **/
  @ApiModelProperty(value = "选择的快递类型：1-在线下单，2-自己联系物流")
  public Integer getExpressType() {
    return expressType;
  }

  public void setExpressType(Integer expressType) {
    this.expressType = expressType;
  }

  @JsonIgnore
  public WkParcelDTO isExterExpress(Integer isExterExpress) {
    this.isExterExpress = isExterExpress;
    return this;
  }

   /**
   * 是否外部快递： 1-是，2-否
   * @return isExterExpress
  **/
  @ApiModelProperty(value = "是否外部快递： 1-是，2-否")
  public Integer getIsExterExpress() {
    return isExterExpress;
  }

  public void setIsExterExpress(Integer isExterExpress) {
    this.isExterExpress = isExterExpress;
  }

  @JsonIgnore
  public WkParcelDTO logisticsStatusMsg(String logisticsStatusMsg) {
    this.logisticsStatusMsg = logisticsStatusMsg;
    return this;
  }

   /**
   * 物流状态信息
   * @return logisticsStatusMsg
  **/
  @ApiModelProperty(value = "物流状态信息")
  public String getLogisticsStatusMsg() {
    return logisticsStatusMsg;
  }

  public void setLogisticsStatusMsg(String logisticsStatusMsg) {
    this.logisticsStatusMsg = logisticsStatusMsg;
  }

  @JsonIgnore
  public WkParcelDTO expressProduceType(Integer expressProduceType) {
    this.expressProduceType = expressProduceType;
    return this;
  }

   /**
   * 快件产品类别：0-空，1-顺丰标快，2 - 顺丰特惠，3 - 顺丰次 晨，4 - 顺丰即日
   * @return expressProduceType
  **/
  @ApiModelProperty(value = "快件产品类别：0-空，1-顺丰标快，2 - 顺丰特惠，3 - 顺丰次 晨，4 - 顺丰即日")
  public Integer getExpressProduceType() {
    return expressProduceType;
  }

  public void setExpressProduceType(Integer expressProduceType) {
    this.expressProduceType = expressProduceType;
  }

  @JsonIgnore
  public WkParcelDTO payMethod(Integer payMethod) {
    this.payMethod = payMethod;
    return this;
  }

   /**
   * 付款方式：0-空,1-寄方付，2-收方付，3-第三方付
   * @return payMethod
  **/
  @ApiModelProperty(value = "付款方式：0-空,1-寄方付，2-收方付，3-第三方付")
  public Integer getPayMethod() {
    return payMethod;
  }

  public void setPayMethod(Integer payMethod) {
    this.payMethod = payMethod;
  }

  @JsonIgnore
  public WkParcelDTO custCard(String custCard) {
    this.custCard = custCard;
    return this;
  }

   /**
   * 月结卡号
   * @return custCard
  **/
  @ApiModelProperty(value = "月结卡号")
  public String getCustCard() {
    return custCard;
  }

  public void setCustCard(String custCard) {
    this.custCard = custCard;
  }

  @JsonIgnore
  public WkParcelDTO receiverAddrLabel(String receiverAddrLabel) {
    this.receiverAddrLabel = receiverAddrLabel;
    return this;
  }

   /**
   * 收件地址标签
   * @return receiverAddrLabel
  **/
  @ApiModelProperty(value = "收件地址标签")
  public String getReceiverAddrLabel() {
    return receiverAddrLabel;
  }

  public void setReceiverAddrLabel(String receiverAddrLabel) {
    this.receiverAddrLabel = receiverAddrLabel;
  }

  @JsonIgnore
  public WkParcelDTO senderAddrLabel(String senderAddrLabel) {
    this.senderAddrLabel = senderAddrLabel;
    return this;
  }

   /**
   * 寄件地址标签
   * @return senderAddrLabel
  **/
  @ApiModelProperty(value = "寄件地址标签")
  public String getSenderAddrLabel() {
    return senderAddrLabel;
  }

  public void setSenderAddrLabel(String senderAddrLabel) {
    this.senderAddrLabel = senderAddrLabel;
  }

  @JsonIgnore
  public WkParcelDTO remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public WkParcelDTO createUserId(Long createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建人ID
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建人ID")
  public Long getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(Long createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public WkParcelDTO createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public WkParcelDTO createTime(Long createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public Long getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Long createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public WkParcelDTO updateUserId(Long updateUserId) {
    this.updateUserId = updateUserId;
    return this;
  }

   /**
   * 更新人ID
   * @return updateUserId
  **/
  @ApiModelProperty(value = "更新人ID")
  public Long getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(Long updateUserId) {
    this.updateUserId = updateUserId;
  }

  @JsonIgnore
  public WkParcelDTO updateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
    return this;
  }

   /**
   * 更新人姓名
   * @return updateUserName
  **/
  @ApiModelProperty(value = "更新人姓名")
  public String getUpdateUserName() {
    return updateUserName;
  }

  public void setUpdateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
  }

  @JsonIgnore
  public WkParcelDTO updateTime(Long updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public Long getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(Long updateTime) {
    this.updateTime = updateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WkParcelDTO wkParcelDTO = (WkParcelDTO) o;
    return Objects.equals(this.id, wkParcelDTO.id) &&
        Objects.equals(this.orderNo, wkParcelDTO.orderNo) &&
        Objects.equals(this.waybillNo, wkParcelDTO.waybillNo) &&
        Objects.equals(this.senderRole, wkParcelDTO.senderRole) &&
        Objects.equals(this.senderName, wkParcelDTO.senderName) &&
        Objects.equals(this.senderTel, wkParcelDTO.senderTel) &&
        Objects.equals(this.senderCompanyName, wkParcelDTO.senderCompanyName) &&
        Objects.equals(this.senderTaxNo, wkParcelDTO.senderTaxNo) &&
        Objects.equals(this.senderAddr, wkParcelDTO.senderAddr) &&
        Objects.equals(this.senderTime, wkParcelDTO.senderTime) &&
        Objects.equals(this.receiverName, wkParcelDTO.receiverName) &&
        Objects.equals(this.receiverTel, wkParcelDTO.receiverTel) &&
        Objects.equals(this.receiverCompanyName, wkParcelDTO.receiverCompanyName) &&
        Objects.equals(this.receiverTaxNo, wkParcelDTO.receiverTaxNo) &&
        Objects.equals(this.receiverAddr, wkParcelDTO.receiverAddr) &&
        Objects.equals(this.destinationCode, wkParcelDTO.destinationCode) &&
        Objects.equals(this.parcelStatus, wkParcelDTO.parcelStatus) &&
        Objects.equals(this.expressCode, wkParcelDTO.expressCode) &&
        Objects.equals(this.expressName, wkParcelDTO.expressName) &&
        Objects.equals(this.expressLgtStatus, wkParcelDTO.expressLgtStatus) &&
        Objects.equals(this.businessLgtStatus, wkParcelDTO.businessLgtStatus) &&
        Objects.equals(this.expressSignTime, wkParcelDTO.expressSignTime) &&
        Objects.equals(this.businessSignTime, wkParcelDTO.businessSignTime) &&
        Objects.equals(this.expressType, wkParcelDTO.expressType) &&
        Objects.equals(this.isExterExpress, wkParcelDTO.isExterExpress) &&
        Objects.equals(this.logisticsStatusMsg, wkParcelDTO.logisticsStatusMsg) &&
        Objects.equals(this.expressProduceType, wkParcelDTO.expressProduceType) &&
        Objects.equals(this.payMethod, wkParcelDTO.payMethod) &&
        Objects.equals(this.custCard, wkParcelDTO.custCard) &&
        Objects.equals(this.receiverAddrLabel, wkParcelDTO.receiverAddrLabel) &&
        Objects.equals(this.senderAddrLabel, wkParcelDTO.senderAddrLabel) &&
        Objects.equals(this.remark, wkParcelDTO.remark) &&
        Objects.equals(this.createUserId, wkParcelDTO.createUserId) &&
        Objects.equals(this.createUserName, wkParcelDTO.createUserName) &&
        Objects.equals(this.createTime, wkParcelDTO.createTime) &&
        Objects.equals(this.updateUserId, wkParcelDTO.updateUserId) &&
        Objects.equals(this.updateUserName, wkParcelDTO.updateUserName) &&
        Objects.equals(this.updateTime, wkParcelDTO.updateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, orderNo, waybillNo, senderRole, senderName, senderTel, senderCompanyName, senderTaxNo, senderAddr, senderTime, receiverName, receiverTel, receiverCompanyName, receiverTaxNo, receiverAddr, destinationCode, parcelStatus, expressCode, expressName, expressLgtStatus, businessLgtStatus, expressSignTime, businessSignTime, expressType, isExterExpress, logisticsStatusMsg, expressProduceType, payMethod, custCard, receiverAddrLabel, senderAddrLabel, remark, createUserId, createUserName, createTime, updateUserId, updateUserName, updateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WkParcelDTO {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    orderNo: ").append(toIndentedString(orderNo)).append("\n");
    sb.append("    waybillNo: ").append(toIndentedString(waybillNo)).append("\n");
    sb.append("    senderRole: ").append(toIndentedString(senderRole)).append("\n");
    sb.append("    senderName: ").append(toIndentedString(senderName)).append("\n");
    sb.append("    senderTel: ").append(toIndentedString(senderTel)).append("\n");
    sb.append("    senderCompanyName: ").append(toIndentedString(senderCompanyName)).append("\n");
    sb.append("    senderTaxNo: ").append(toIndentedString(senderTaxNo)).append("\n");
    sb.append("    senderAddr: ").append(toIndentedString(senderAddr)).append("\n");
    sb.append("    senderTime: ").append(toIndentedString(senderTime)).append("\n");
    sb.append("    receiverName: ").append(toIndentedString(receiverName)).append("\n");
    sb.append("    receiverTel: ").append(toIndentedString(receiverTel)).append("\n");
    sb.append("    receiverCompanyName: ").append(toIndentedString(receiverCompanyName)).append("\n");
    sb.append("    receiverTaxNo: ").append(toIndentedString(receiverTaxNo)).append("\n");
    sb.append("    receiverAddr: ").append(toIndentedString(receiverAddr)).append("\n");
    sb.append("    destinationCode: ").append(toIndentedString(destinationCode)).append("\n");
    sb.append("    parcelStatus: ").append(toIndentedString(parcelStatus)).append("\n");
    sb.append("    expressCode: ").append(toIndentedString(expressCode)).append("\n");
    sb.append("    expressName: ").append(toIndentedString(expressName)).append("\n");
    sb.append("    expressLgtStatus: ").append(toIndentedString(expressLgtStatus)).append("\n");
    sb.append("    businessLgtStatus: ").append(toIndentedString(businessLgtStatus)).append("\n");
    sb.append("    expressSignTime: ").append(toIndentedString(expressSignTime)).append("\n");
    sb.append("    businessSignTime: ").append(toIndentedString(businessSignTime)).append("\n");
    sb.append("    expressType: ").append(toIndentedString(expressType)).append("\n");
    sb.append("    isExterExpress: ").append(toIndentedString(isExterExpress)).append("\n");
    sb.append("    logisticsStatusMsg: ").append(toIndentedString(logisticsStatusMsg)).append("\n");
    sb.append("    expressProduceType: ").append(toIndentedString(expressProduceType)).append("\n");
    sb.append("    payMethod: ").append(toIndentedString(payMethod)).append("\n");
    sb.append("    custCard: ").append(toIndentedString(custCard)).append("\n");
    sb.append("    receiverAddrLabel: ").append(toIndentedString(receiverAddrLabel)).append("\n");
    sb.append("    senderAddrLabel: ").append(toIndentedString(senderAddrLabel)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
    sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
