/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.exception.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.process.response.ListResult;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.vanke.in.client.model.GetExceptionListRequest;
import com.xforceplus.vanke.in.client.model.WkExceptionBean;
import com.xforceplus.vanke.in.client.model.WkExceptionDTO;
import com.xforceplus.vanke.in.service.exception.ExceptionBusiness;
import com.xforceplus.vanke.in.service.invoice.InvoiceBusiness;
import com.xforceplus.vanke.sc.base.exception.VankeException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetExceptionListProcess
extends AbstractProcess<GetExceptionListRequest, ListResult<WkExceptionBean>> {
    @Autowired
    private ExceptionBusiness exceptionBusiness;
    @Autowired
    private InvoiceBusiness invoiceBusiness;

    protected void check(GetExceptionListRequest request) throws ValidationException {
        super.check((BaseRequest)request);
    }

    protected CommonResponse<ListResult<WkExceptionBean>> process(GetExceptionListRequest request) throws RuntimeException {
        ListResult result = null;
        try {
            result = this.exceptionBusiness.getList(request);
        }
        catch (VankeException e) {
            return CommonResponse.failed((String)e.getMessage());
        }
        List orderCodes = result.getList().stream().filter(entity -> ValidatorUtil.isNotEmpty((String)entity.getOrderCode())).map(WkExceptionDTO::getOrderCode).collect(Collectors.toList());
        if (ValidatorUtil.isEmpty(orderCodes)) {
            return CommonResponse.ok((String)"\u6210\u529f", (Object)result);
        }
        if (ValidatorUtil.isFalse((Boolean)request.getHasInvoice())) {
            return CommonResponse.ok((String)"\u6210\u529f", (Object)result);
        }
        Map orderInvoices = this.invoiceBusiness.getInvoiceListBySalesbillNos(orderCodes, false);
        result.getList().stream().forEach(bean -> bean.setInvoices((List)orderInvoices.get(bean.getOrderCode())));
        return CommonResponse.ok((String)"\u6210\u529f", (Object)result);
    }
}

