/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoice.process;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.DeleteInvoiceImagesRequest;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.in.service.invoice.InvoiceBusiness;
import com.xforceplus.vanke.in.service.orders.OrdersBusiness;
import com.xforceplus.vanke.in.service.smfile.SmInvoiceBusiness;
import com.xforceplus.vanke.sc.base.constdata.Constants;
import com.xforceplus.vanke.sc.base.enums.Business.CooperateFlagEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.AuthStatusEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.AuthSyncStatusEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.RecogStatusEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.SellerSysStatusEnum;
import com.xforceplus.vanke.sc.service.CompanyBusiness;
import com.xforceplus.vanke.sc.service.MenuBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DeleteInvoiceImagesProcess
extends AbstractProcess<DeleteInvoiceImagesRequest, Integer> {
    @Autowired
    private WkInvoiceDao wkInvoiceDao;
    @Autowired
    private InvoiceBusiness invoiceBusiness;
    @Autowired
    private OrdersBusiness ordersBusiness;
    @Autowired
    private CompanyBusiness companyBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private MenuBusiness menuBusiness;
    @Autowired
    private SmInvoiceBusiness smInvoiceBusiness;

    protected void check(DeleteInvoiceImagesRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty(request.getInvoiceIds(), "\u53d1\u7968ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        if (Constants.NUMBER_ONE.equals(request.getIsContinue())) {
            this.checkEmpty((Object)request.getDeleteType(), "\u5220\u9664\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    protected CommonResponse<Integer> process(DeleteInvoiceImagesRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        if (null == userSessionInfo) {
            return CommonResponse.failed((String)"\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List menuList = this.menuBusiness.getSysMenuList(userSessionInfo);
        if (CollectionUtils.isEmpty((Collection)menuList)) {
            return CommonResponse.failed((String)"\u6ca1\u6709\u64cd\u4f5c\u5220\u9664\u5f71\u50cf\u7684\u6743\u9650\uff0c\u8bf7\u68c0\u67e5.");
        }
        long count = menuList.stream().filter(r -> r.getMenuPath().equals("/scan")).count();
        if (count <= 0L) {
            return CommonResponse.failed((String)"\u6ca1\u6709\u64cd\u4f5c\u5220\u9664\u5f71\u50cf\u7684\u6743\u9650\uff0c\u8bf7\u68c0\u67e5.");
        }
        List invoiceEntityList = this.invoiceBusiness.getInvoiceListByParams(request.getInvoiceIds(), null);
        if (CollectionUtils.isEmpty((Collection)invoiceEntityList)) {
            return CommonResponse.failed((String)"\u6ca1\u6709\u627e\u5230\u53ef\u64cd\u4f5c\u6570\u636e");
        }
        ArrayList deleteList = Lists.newArrayList();
        ArrayList clearList = Lists.newArrayList();
        ArrayList reusltList = Lists.newArrayList();
        invoiceEntityList.stream().forEach(r -> {
            if (!RecogStatusEnum.RECOG_OK.getCode().equals(r.getRecogStatus())) {
                return;
            }
            if (AuthStatusEnum.CHECKED.getCode().equals(r.getAuthStatus()) || AuthStatusEnum.CHECK_ABNORMAL.getCode().equals(r.getAuthStatus()) || AuthStatusEnum.SUCCEED.getCode().equals(r.getAuthStatus()) || AuthStatusEnum.ABNORMAL.getCode().equals(r.getAuthStatus()) || AuthStatusEnum.IN_AUTH.getCode().equals(r.getAuthStatus())) {
                return;
            }
            if (CooperateFlagEnum.YES_COORPERATE.getCode().equals(r.getCooperateFlag()) && !this.invoiceBusiness.checkRepeatRelation(r, r.getSalesbillNo(), userSessionInfo).booleanValue()) {
                reusltList.add(r);
                if (!SellerSysStatusEnum.COMING_SALLER_INFO_XT.getCode().equals(r.getSellerSyncStatus()) && AuthSyncStatusEnum.DEFAULT_NO.getCode().equals(r.getAuthSyncStatus())) {
                    deleteList.add(r);
                } else {
                    clearList.add(r);
                }
            }
        });
        if (Constants.NUMBER_ZERO.equals(request.getIsContinue())) {
            return CommonResponse.ok((String)"\u6210\u529f", (Object)reusltList.size());
        }
        if (!CollectionUtils.isEmpty((Collection)deleteList)) {
            this.wkInvoiceDao.deleteByExample(this.invoiceBusiness.setWkInvoiceExampleByIds((List)deleteList));
        }
        if (!CollectionUtils.isEmpty((Collection)clearList)) {
            this.clearRecogInvoiceInfo((List)clearList, true);
        }
        if (!CollectionUtils.isEmpty((Collection)reusltList)) {
            this.invoiceBusiness.deleteRecogInvoice((List)reusltList, userSessionInfo, request.getDeleteType(), true, request.getDeleteMessage());
            List salesbillNoList = reusltList.stream().filter(r -> !StringHelp.safeIsEmpty((Object)r.getSalesbillNo())).map(r -> r.getSalesbillNo()).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(salesbillNoList)) {
                salesbillNoList.stream().forEach(r -> this.invoiceBusiness.deleteImageForOrderCode(r, true));
            }
        }
        return CommonResponse.ok((String)"\u5220\u9664\u6210\u529f", (Object)reusltList.size());
    }

    private Integer clearRecogInvoiceInfo(List<WkInvoiceEntity> entities, boolean isCooperateFlag) {
        WkInvoiceEntity updateEntity = this.invoiceBusiness.clearImageInfo(null, Integer.valueOf(0), false, isCooperateFlag);
        return this.wkInvoiceDao.updateByExampleSelective(updateEntity, this.invoiceBusiness.setWkInvoiceExampleByIds(entities));
    }

    private Map<String, Integer> getCooperateFlagList(List<WkInvoiceEntity> invoiceList) {
        HashMap cooperateFlagMap = Maps.newHashMap();
        ArrayList salesbillList = Lists.newArrayList();
        ArrayList sellerTaxNoList = Lists.newArrayList();
        invoiceList.stream().forEach(r -> {
            if (!StringHelp.safeIsEmpty((Object)r.getSalesbillNo()) && !salesbillList.contains(r.getSalesbillNo())) {
                salesbillList.add(r.getSalesbillNo());
            }
            if (StringHelp.safeIsEmpty((Object)r.getSalesbillNo()) && !StringHelp.safeIsEmpty((Object)r.getSellerTaxNo()) && !sellerTaxNoList.contains(r.getSellerTaxNo())) {
                sellerTaxNoList.add(r.getSellerTaxNo());
            }
        });
        if (!CollectionUtils.isEmpty((Collection)salesbillList)) {
            List orderList = this.ordersBusiness.getOrdersBySalesBillNoList((List)salesbillList);
            orderList.stream().forEach(r -> cooperateFlagMap.put("bill_" + r.getSalesbillNo(), r.getCooperateFlag()));
        }
        if (!CollectionUtils.isEmpty((Collection)sellerTaxNoList)) {
            List companyList = this.companyBusiness.getCompanyByTaxNoList((List)sellerTaxNoList);
            companyList.stream().forEach(r -> cooperateFlagMap.put("seller_" + r.getCompanyTaxNo(), r.getIsSynergetics()));
        }
        return cooperateFlagMap;
    }
}

