/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.orders.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.ModifyIfAuthFlagRequest;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.dao.WkOrdersDao;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.in.repository.model.WkInvoiceExample;
import com.xforceplus.vanke.in.repository.model.WkOrdersEntity;
import com.xforceplus.vanke.in.repository.model.WkOrdersExample;
import com.xforceplus.vanke.sc.base.enums.Business.OpsTypeEnum;
import com.xforceplus.vanke.sc.base.enums.common.IfAuthFlagEnum;
import com.xforceplus.vanke.sc.service.LogOperationsBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModifyIfAuthFlagProcess
extends AbstractProcess<ModifyIfAuthFlagRequest, Boolean> {
    @Autowired
    private WkOrdersDao wkOrdersDao;
    @Autowired
    private WkInvoiceDao wkInvoiceDao;
    @Autowired
    private LogOperationsBusiness logOperationsBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected void check(ModifyIfAuthFlagRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty(request.getSalesbillNo(), "\u4e1a\u52a1\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        this.checkEmpty((Object)request.getIfAuthFlag(), "\u662f\u5426\u53ef\u62b5\u6263\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a!");
    }

    protected CommonResponse<Boolean> process(ModifyIfAuthFlagRequest request) throws RuntimeException {
        WkOrdersExample wkOrdersExample = new WkOrdersExample();
        wkOrdersExample.createCriteria().andSalesbillNoEqualTo(request.getSalesbillNo());
        WkOrdersEntity wkOrdersEntity = new WkOrdersEntity();
        wkOrdersEntity.setIfAuthFlag(request.getIfAuthFlag());
        IfAuthFlagEnum ifAuthFlagEnum = IfAuthFlagEnum.fromCode((Integer)request.getIfAuthFlag());
        int updateOrdersCount = this.wkOrdersDao.updateByExampleSelective(wkOrdersEntity, wkOrdersExample);
        WkInvoiceExample wkInvoiceExample = new WkInvoiceExample();
        wkInvoiceExample.createCriteria().andSalesbillNoEqualTo(request.getSalesbillNo());
        WkInvoiceEntity wkInvoiceEntity = new WkInvoiceEntity();
        wkInvoiceEntity.setIfAuthFlag(request.getIfAuthFlag());
        this.wkInvoiceDao.updateByExampleSelective(wkInvoiceEntity, wkInvoiceExample);
        int updateInvoiceCount = this.wkOrdersDao.updateByExampleSelective(wkOrdersEntity, wkOrdersExample);
        String opsMessage = "\u662f\u5426\u53ef\u62b5\u6263\u4fee\u6539\u4e3a:" + ifAuthFlagEnum.getName();
        String opsName = ((UserContext)this.contextHolder.get()).getUserSessionInfo().getSysUserName();
        this.logOperationsBusiness.saveLogOperations(request.getSalesbillNo(), OpsTypeEnum.MODIFY_IF_AUTH_FLAG.getCode(), opsName, opsMessage, "", "");
        return CommonResponse.ok((String)"\u6210\u529f");
    }
}

