/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.parceldetails.process;

import com.google.common.collect.Lists;
import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.GoodsCountBean;
import com.xforceplus.vanke.in.client.model.MergeSendGoodsBean;
import com.xforceplus.vanke.in.client.model.ParcelDetailsSendRequest;
import com.xforceplus.vanke.in.client.model.WkParcelDetailsDTO;
import com.xforceplus.vanke.in.repository.model.WkParcelDetailsEntity;
import com.xforceplus.vanke.in.service.parcel.ParcelDetailsBusiness;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DivideSendGoodsProcess
extends AbstractProcess<ParcelDetailsSendRequest, List<MergeSendGoodsBean>> {
    @Autowired
    private ParcelDetailsBusiness parcelDetailsBusiness;

    protected void check(ParcelDetailsSendRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty(request.getIdList(), "\u5bc4\u9001id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
    }

    protected CommonResponse<List<MergeSendGoodsBean>> process(ParcelDetailsSendRequest request) throws RuntimeException {
        List detailsList = this.parcelDetailsBusiness.selectInfoByIds(request.getIdList());
        if (CollectionUtils.isEmpty((Collection)detailsList)) {
            return CommonResponse.failed((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u53ef\u64cd\u4f5c\u7684\u6570\u636e.");
        }
        ArrayList resultList = Lists.newArrayList();
        Map<String, List<WkParcelDetailsEntity>> mapCollect = detailsList.stream().collect(Collectors.groupingBy(x -> x.getReceiverCompanyName() + x.getReceiverName() + x.getReceiverTel() + x.getReceiverAddr()));
        mapCollect.entrySet().stream().forEach(item -> {
            MergeSendGoodsBean mergeSendGoodsBean = new MergeSendGoodsBean();
            GoodsCountBean goodsCountBean = new GoodsCountBean();
            Map<String, Long> collect = ((List)item.getValue()).stream().collect(Collectors.groupingBy(x -> x.getInterfaceType().toString() + x.getInvoiceSheet().toString(), Collectors.counting()));
            this.parcelDetailsBusiness.getGoodsCount(collect, goodsCountBean);
            mergeSendGoodsBean.setGoodsCountBean(goodsCountBean);
            List detailsDTOS = ((List)item.getValue()).stream().map(entity -> {
                WkParcelDetailsDTO dto = new WkParcelDetailsDTO();
                BeanUtils.copyProperties((Object)entity, (Object)dto);
                return dto;
            }).collect(Collectors.toList());
            mergeSendGoodsBean.setGoodsItemInfo(detailsDTOS);
            resultList.add(mergeSendGoodsBean);
        });
        return CommonResponse.ok((String)"\u6210\u529f", (Object)resultList);
    }
}

