/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.postcode.process;

import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.BatchDeleteRequest;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.dao.WkOrdersDao;
import com.xforceplus.vanke.in.repository.dao.WkPostcodeDao;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.in.repository.model.WkInvoiceExample;
import com.xforceplus.vanke.in.repository.model.WkOrdersEntity;
import com.xforceplus.vanke.in.repository.model.WkOrdersExample;
import com.xforceplus.vanke.in.repository.model.WkPostcodeEntity;
import com.xforceplus.vanke.in.repository.model.WkPostcodeExample;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeletePostcodeProcess
extends AbstractProcess<BatchDeleteRequest, Boolean> {
    @Autowired
    private WkPostcodeDao wkPostcodeDao;
    @Autowired
    private WkOrdersDao wkOrdersDao;
    @Autowired
    private WkInvoiceDao wkInvoiceDao;

    protected void check(BatchDeleteRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty(request.getIds(), "\u90ae\u5305\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
    }

    protected CommonResponse<Boolean> process(BatchDeleteRequest request) throws RuntimeException {
        WkPostcodeExample postcodeExample = new WkPostcodeExample();
        postcodeExample.createCriteria().andIdIn(request.getIds());
        List postcodes = this.wkPostcodeDao.selectByExample(postcodeExample);
        if (CollectionUtils.isEmpty((Collection)postcodes)) {
            return CommonResponse.failed((String)"\u90ae\u5305\u4e0d\u5b58\u5728");
        }
        List packageCodes = postcodes.stream().map(WkPostcodeEntity::getPackageCode).collect(Collectors.toList());
        WkOrdersExample ordersExample = new WkOrdersExample();
        ordersExample.createCriteria().andPackageCodeIn(packageCodes);
        List orders = this.wkOrdersDao.selectByExample(ordersExample);
        if (orders.size() > 0) {
            StringBuilder sb = new StringBuilder("\u90ae\u5305\u4e0d\u53ef\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664[");
            List exists = orders.stream().map(WkOrdersEntity::getPackageCode).distinct().collect(Collectors.toList());
            sb.append(StringHelp.join(exists, (String)"/"));
            sb.append("]\u90ae\u5305\u4e0b\u5df2\u7b7e\u6536\u7684\u4e1a\u52a1\u5355\u548c\u53d1\u7968");
            return CommonResponse.failed((String)sb.toString());
        }
        WkInvoiceExample invoiceExample = new WkInvoiceExample();
        invoiceExample.createCriteria().andPackageCodeIn(packageCodes);
        List invoices = this.wkInvoiceDao.selectByExample(invoiceExample);
        if (invoices.size() > 0) {
            StringBuilder sb = new StringBuilder("\u90ae\u5305\u4e0d\u53ef\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664[");
            List exists = invoices.stream().map(WkInvoiceEntity::getPackageCode).distinct().collect(Collectors.toList());
            sb.append(StringHelp.join(exists, (String)"/"));
            sb.append("]\u90ae\u5305\u4e0b\u5df2\u7b7e\u6536\u7684\u4e1a\u52a1\u5355\u548c\u53d1\u7968");
            return CommonResponse.failed((String)sb.toString());
        }
        int result = this.wkPostcodeDao.deleteByExample(postcodeExample);
        if (result > 0) {
            return CommonResponse.ok((String)"\u5220\u9664\u6210\u529f", (Object)true);
        }
        return CommonResponse.failed((String)"\u65e0\u8bb0\u5f55\u5220\u9664");
    }
}

