/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.report.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.GetWorkDifferenceRequest;
import com.xforceplus.vanke.in.repository.dao.WkPostcodeDao;
import com.xforceplus.vanke.in.repository.daoext.InvoiceDaoExt;
import com.xforceplus.vanke.in.repository.daoext.WkOrdersDaoExt;
import com.xforceplus.vanke.in.repository.model.WkPostcodeExample;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetWorkDifferenceProcess
extends AbstractProcess<GetWorkDifferenceRequest, Map> {
    @Autowired
    private WkPostcodeDao wkPostcodeDao;
    @Autowired
    private WkOrdersDaoExt wkOrdersDaoExt;
    @Autowired
    private InvoiceDaoExt invoiceDaoExt;

    protected void check(GetWorkDifferenceRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty((Object)request.getWorkTime(), "\u7b5b\u9009\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
    }

    protected CommonResponse<Map> process(GetWorkDifferenceRequest request) throws RuntimeException {
        HashMap allMap = new HashMap();
        Date dateTime = new Date(request.getWorkTime());
        CompletableFuture<Map> ordersFuture = CompletableFuture.supplyAsync(() -> {
            ConcurrentHashMap<String, Long> map = new ConcurrentHashMap<String, Long>();
            WkPostcodeExample wkPostcodeExample = new WkPostcodeExample();
            wkPostcodeExample.createCriteria().andRecieveTimeGreaterThan(dateTime);
            long postcodeAllCount = this.wkPostcodeDao.countByExample(wkPostcodeExample);
            long ordersAllCount = this.wkOrdersDaoExt.getPostCodeAllCount(dateTime);
            long invoiceAllCount = this.invoiceDaoExt.getPostcodeInvoiceCount(dateTime, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
            map.put("postcodeAllCount", postcodeAllCount);
            map.put("ordersAllCount", ordersAllCount);
            map.put("invoiceAllCount", invoiceAllCount);
            map.put("shouldSignOrdersCount", ordersAllCount);
            map.put("shouldSignInvoiceCount", invoiceAllCount);
            map.put("shouldRecogInvoiceCount", invoiceAllCount);
            map.put("shouldAuditInvoiceCount", invoiceAllCount);
            return map;
        });
        CompletableFuture<Map> doneOrdersFuture = CompletableFuture.supplyAsync(() -> {
            ConcurrentHashMap<String, Long> map = new ConcurrentHashMap<String, Long>();
            long doneSignOrdersCount = this.wkOrdersDaoExt.doneSignOrdersCount(dateTime);
            map.put("doneSignOrdersCount", doneSignOrdersCount);
            return map;
        });
        CompletableFuture<Map> doneSignInvoiceFuture = CompletableFuture.supplyAsync(() -> {
            ConcurrentHashMap<String, Long> map = new ConcurrentHashMap<String, Long>();
            long doneSignInvoiceCount = this.invoiceDaoExt.getPostcodeInvoiceCount(dateTime, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
            map.put("doneSignInvoiceCount", doneSignInvoiceCount);
            return map;
        });
        CompletableFuture<Map> doneRecogInvoiceFuture = CompletableFuture.supplyAsync(() -> {
            ConcurrentHashMap<String, Long> map = new ConcurrentHashMap<String, Long>();
            long doneRecogInvoiceCount = this.invoiceDaoExt.getPostcodeInvoiceCount(dateTime, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true));
            map.put("doneRecogInvoiceCount", doneRecogInvoiceCount);
            return map;
        });
        CompletableFuture<Map> doneAuditInvoiceFuture = CompletableFuture.supplyAsync(() -> {
            ConcurrentHashMap<String, Long> map = new ConcurrentHashMap<String, Long>();
            long doneAuditInvoiceCount = this.invoiceDaoExt.getPostcodeInvoiceCount(dateTime, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false));
            map.put("doneAuditInvoiceCount", doneAuditInvoiceCount);
            return map;
        });
        CompletableFuture<Map> doneAuthInvoiceFuture = CompletableFuture.supplyAsync(() -> {
            ConcurrentHashMap<String, Long> map = new ConcurrentHashMap<String, Long>();
            long doneAuthInvoiceCount = this.invoiceDaoExt.getPostcodeInvoiceCount(dateTime, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
            map.put("doneAuthInvoiceCount", doneAuthInvoiceCount);
            return map;
        });
        CompletableFuture<Map> shouldAuthInvoiceFuture = CompletableFuture.supplyAsync(() -> {
            ConcurrentHashMap<String, Long> map = new ConcurrentHashMap<String, Long>();
            long shouldAuthInvoiceCount = this.invoiceDaoExt.getPostcodeInvoiceCount(dateTime, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
            map.put("shouldAuthInvoiceCount", shouldAuthInvoiceCount);
            return map;
        });
        CompletableFuture<Void> allFuture = CompletableFuture.allOf(ordersFuture, doneOrdersFuture, doneSignInvoiceFuture, doneRecogInvoiceFuture, doneAuditInvoiceFuture, doneAuthInvoiceFuture, shouldAuthInvoiceFuture);
        allFuture.join();
        allFuture.thenAccept(v -> Stream.of(ordersFuture, doneOrdersFuture, doneSignInvoiceFuture, doneRecogInvoiceFuture, doneAuditInvoiceFuture, doneAuthInvoiceFuture, shouldAuthInvoiceFuture).forEach(r -> {
            try {
                allMap.putAll((Map)r.get());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }));
        return CommonResponse.ok((String)"", allMap);
    }
}

