/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.smfile.process;

import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.vanke.in.client.model.SaveSmFileRequest;
import com.xforceplus.vanke.in.client.model.SmFileInvoiceDTO;
import com.xforceplus.vanke.in.repository.dao.SmFileInvoiceDao;
import com.xforceplus.vanke.in.repository.model.SmFileInvoiceEntity;
import com.xforceplus.vanke.in.repository.model.SmFileInvoiceExample;
import com.xforceplus.vanke.in.service.smfile.SmFileInvoiceBusiness;
import com.xforceplus.vanke.sc.base.enums.common.FileTypeEnum;
import com.xforceplus.vanke.sc.base.enums.common.UploadTypeEnum;
import com.xforceplus.vanke.sc.base.enums.sm_file.RecStatusEnum;
import com.xforceplus.vanke.sc.base.enums.sm_file.RequireOcrFlagEnum;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaveSmFileProcess
extends AbstractProcess<SaveSmFileRequest, Boolean> {
    @Autowired
    private SmFileInvoiceDao smFileInvoiceDao;
    @Autowired
    private SmFileInvoiceBusiness smFileInvoiceBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected void check(SaveSmFileRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty(request.getEntities(), "\u64cd\u4f5c\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        request.getEntities().forEach(entity -> {
            this.checkEmpty((Object)entity.getBatchId(), "\u626b\u63cf\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty((Object)entity.getSource(), "\u6587\u4ef6\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getFileUrl(), "\u56fe\u7247\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getFileType(), "\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getFileUrlHandle(), "\u5904\u7406\u56fe\u7247\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty(entity.getFileTypeHandle(), "\u5904\u7406\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty((Object)entity.getRequireOcrFlag(), "\u662f\u5426\u9700\u8981\u8bc6\u522b\u4e0d\u80fd\u4e3a\u7a7a");
            if (!UploadTypeEnum.RECOG.validate(entity.getFileTypeHandle())) {
                throw new ValidationException("\u6587\u4ef6\u7c7b\u578b\u4e0d\u5339\u914d");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CommonResponse<Boolean> process(SaveSmFileRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        try {
            SmFileInvoiceExample example;
            if (this.smFileInvoiceBusiness.tryLockByUserId(Long.valueOf(userSessionInfo.getAccountId()))) {
                example = new SmFileInvoiceExample();
                example.createCriteria().andCreateUserIdEqualTo(Long.valueOf(userSessionInfo.getAccountId()));
                long count = this.smFileInvoiceDao.countByExample(example);
                if (count + (long)request.getEntities().size() > 600L) {
                    CommonResponse commonResponse = CommonResponse.failed((String)"\u5f85\u63d0\u4ea4\u5df2\u8fbe\u4e0a\u9650\u3010600\u3011\uff0c\u8bf7\u63d0\u4ea4\u540e\u518d\u6dfb\u52a0");
                    return commonResponse;
                }
                List dtos = request.getEntities();
                ArrayList<Long> ids = new ArrayList<Long>(dtos.size());
                for (int i = 0; i < dtos.size(); ++i) {
                    SmFileInvoiceDTO dto = (SmFileInvoiceDTO)dtos.get(i);
                    SmFileInvoiceEntity entity = new SmFileInvoiceEntity();
                    BeanUtils.copyProperties((Object)dto, (Object)entity);
                    entity.setFileOrder(Integer.valueOf((int)(count + (long)i + 1L)));
                    if (RequireOcrFlagEnum.NOT_NEED.getCode().equals(entity.getRequireOcrFlag())) {
                        entity.setRecStatus(RecStatusEnum.FINISH_REC.getCode());
                        entity.setRecStartTime(new Date());
                        entity.setRecEndTime(new Date());
                    } else {
                        entity.setRecStatus(RecStatusEnum.NOT_REC.getCode());
                    }
                    entity.setCreateUserId(Long.valueOf(userSessionInfo.getAccountId()));
                    entity.setCreateUser(userSessionInfo.getSysUserName());
                    entity.setCreateTime(new Date());
                    String ext = entity.getFileUrl().substring(entity.getFileUrl().lastIndexOf("."));
                    String fileType = FileTypeEnum.getName((String)ext);
                    entity.setFileType(fileType);
                    if (ValidatorUtil.isNotEmpty((String)entity.getOrderCode())) {
                        String orderCode = entity.getOrderCode().replaceAll("^SAPCZ|^PDCST", "");
                        entity.setOrderCode(orderCode);
                    }
                    this.smFileInvoiceDao.insertSelective(entity);
                    ids.add(entity.getId());
                }
                example.setOrderByClause("fileOrder");
                List entities = this.smFileInvoiceDao.selectByExample(example);
                this.smFileInvoiceBusiness.interceptInvoice(entities);
                this.smFileInvoiceBusiness.warningInvoice(entities);
                this.smFileInvoiceBusiness.movie(entities, request.getParentId(), ids);
            }
            example = CommonResponse.ok((String)"\u65b0\u589e\u6210\u529f", (Object)true);
            return example;
        }
        catch (Exception e) {
            this.logger.error("\u65b0\u589e\u626b\u63cf\u5f71\u50cf\u5f02\u5e38", (Throwable)e);
            CommonResponse commonResponse = CommonResponse.failed((String)"\u65b0\u589e\u5931\u8d25\uff01\u8bf7\u91cd\u8bd5");
            return commonResponse;
        }
        finally {
            this.smFileInvoiceBusiness.releaseLockByUserId(Long.valueOf(userSessionInfo.getAccountId()));
        }
    }
}

