/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.exception.process;

import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.process.AbstractKeyProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.UpdateExceptionRequest;
import com.xforceplus.vanke.in.controller.exception.process.UpdateExceptionProcess;
import com.xforceplus.vanke.in.repository.dao.WkExceptionDao;
import com.xforceplus.vanke.in.repository.model.WkExceptionEntity;
import com.xforceplus.vanke.in.service.exception.ExceptionBusiness;
import com.xforceplus.vanke.sc.base.enums.DocumentTypeEnum;
import com.xforceplus.vanke.sc.base.enums.Exception.HandleStatusEnum;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.Arrays;
import java.util.Date;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateExceptionProcess
extends AbstractKeyProcess<Long, UpdateExceptionRequest, Boolean> {
    @Autowired
    private WkExceptionDao wkExceptionDao;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private ExceptionBusiness exceptionBusiness;

    protected void check(Long id, UpdateExceptionRequest request) throws ValidationException {
        super.check((Object)id, (BaseRequest)request);
        this.checkEmpty((Object)request.getHandleWay(), "\u5904\u7406\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty((Object)request.getDocumentType(), "\u6587\u6863\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        switch (1.$SwitchMap$com$xforceplus$vanke$sc$base$enums$DocumentTypeEnum[DocumentTypeEnum.fromCode((Integer)request.getDocumentType()).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                this.checkEmpty(request.getBillCode(), "\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                this.checkEmpty(request.getBillNumber(), "\u53d1\u7968\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                throw new ValidationException("\u672a\u77e5\u6587\u6863\u7c7b\u578b");
            }
        }
    }

    protected CommonResponse<Boolean> process(Long id, UpdateExceptionRequest request) throws RuntimeException {
        int result;
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        WkExceptionEntity entity = new WkExceptionEntity();
        BeanUtils.copyProperties((Object)request, (Object)entity);
        entity.setId(id);
        entity.setHandlePerson(userSessionInfo.getSysUserName());
        entity.setHandleTime(new Date());
        if (HandleStatusEnum.HANG.getCode().equals(request.getHandleStatus())) {
            entity.setHoldTime(new Date());
        }
        if ((result = this.wkExceptionDao.updateByPrimaryKeySelective(entity)) == 0) {
            return CommonResponse.failed((String)"\u65e0\u8bb0\u5f55\u66f4\u65b0");
        }
        entity = this.wkExceptionDao.selectByPrimaryKey(id);
        this.exceptionBusiness.handleException(Arrays.asList(entity), userSessionInfo);
        return CommonResponse.ok((String)"\u66f4\u65b0\u6210\u529f", (Object)true);
    }
}

