/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoice.process;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractKeyProcess;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.GetInvoiceDetailRequest;
import com.xforceplus.vanke.in.client.model.WkInvoiceBean;
import com.xforceplus.vanke.in.client.model.WkInvoiceDetailsDTO;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.in.service.invoice.InvoiceBusiness;
import com.xforceplus.vanke.in.service.invoice.InvoiceDetailsBusiness;
import com.xforceplus.vanke.sc.base.constdata.Constants;
import com.xforceplus.vanke.sc.base.enums.invoice.RecogImageStatusEnum;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetInvoiceDetailProcess
extends AbstractKeyProcess<Long, GetInvoiceDetailRequest, WkInvoiceBean> {
    @Autowired
    private WkInvoiceDao wkInvoiceDao;
    @Autowired
    private InvoiceDetailsBusiness invoiceDetailsBusiness;
    @Autowired
    private InvoiceBusiness invoiceBusiness;

    protected CommonResponse<WkInvoiceBean> process(Long id, GetInvoiceDetailRequest request) throws RuntimeException {
        WkInvoiceEntity entity = this.wkInvoiceDao.selectByPrimaryKey(id);
        if (null == entity) {
            return CommonResponse.failed((String)"\u6ca1\u6709\u67e5\u5230\u53d1\u7968\u4fe1\u606f.");
        }
        WkInvoiceBean bean = new WkInvoiceBean();
        BeanUtils.copyProperties((Object)entity, (Object)bean);
        List<Object> detailsDtoList = Lists.newArrayList();
        if (null != request.getShowDetail() && Constants.NUMBER_ONE.equals(request.getShowDetail())) {
            List detailsEntityList = this.invoiceDetailsBusiness.getInvoiceDetailsListByInvoiceId(id);
            detailsDtoList = detailsEntityList.stream().map(item -> (WkInvoiceDetailsDTO)JSON.parseObject((String)JSON.toJSONString((Object)item), WkInvoiceDetailsDTO.class)).collect(Collectors.toList());
        }
        bean.setDetails((List)detailsDtoList);
        String imgUrl = this.invoiceBusiness.getInvoiceImgUrl(entity, null);
        if (!StringHelp.safeIsEmpty((Object)imgUrl)) {
            if (RecogImageStatusEnum.INVOICE.getCode().equals(entity.getRecogImageStatus())) {
                bean.setRecogInvoiceImageUrl(imgUrl);
            } else if (RecogImageStatusEnum.DEDUCTIBLE.getCode().equals(entity.getRecogImageStatus())) {
                String imgUrl_dk = this.invoiceBusiness.getInvoiceImgUrl_dk(entity);
                imgUrl_dk = StringHelp.safeIsEmpty((Object)imgUrl_dk) ? imgUrl : imgUrl_dk;
                bean.setRecogDeductionImageUrl(imgUrl_dk);
            } else {
                bean.setRecogInvoiceImageUrl(imgUrl);
            }
        }
        return CommonResponse.ok((String)"\u6210\u529f", (Object)bean);
    }
}

