/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoiceauth.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.GetInvoiceListRequest;
import com.xforceplus.vanke.in.client.model.InvoiceAmountBean;
import com.xforceplus.vanke.in.client.model.InvoiceAuthRequest;
import com.xforceplus.vanke.in.repository.daoext.InvoiceDaoExt;
import com.xforceplus.vanke.in.repository.model.WkInvoiceExample;
import com.xforceplus.vanke.in.service.invoice.InvoiceFilterBusiness;
import com.xforceplus.vanke.sc.base.enums.company.AuthTypeEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.InvoiceAuthEnum;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CountAuthAmountProcess
extends AbstractProcess<InvoiceAuthRequest, InvoiceAmountBean> {
    @Autowired
    private InvoiceFilterBusiness invoiceFilterBusiness;
    @Autowired
    private InvoiceDaoExt invoiceDaoExt;

    protected void check(InvoiceAuthRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty((Object)request.getAuthTab(), "\u8ba4\u8bc1\u9875\u9762tab\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
    }

    protected CommonResponse<InvoiceAmountBean> process(InvoiceAuthRequest request) throws RuntimeException {
        Integer authType = null;
        AuthTypeEnum authTypeEnum = AuthTypeEnum.fromAuthTab((Integer)request.getAuthTab());
        if (null != authTypeEnum) {
            authType = authTypeEnum.getCode();
        }
        WkInvoiceExample example = new WkInvoiceExample();
        WkInvoiceExample.Criteria criteria = example.createCriteria();
        this.invoiceFilterBusiness.setAuthConfigCond(request.getAuthTab(), criteria, (GetInvoiceListRequest)request, false);
        Integer authTimeOut = null;
        if (null != request.getAuthDuration()) {
            authTimeOut = request.getAuthDuration() == 0 ? Integer.valueOf(59) : Integer.valueOf(request.getAuthDuration() * 60);
        }
        InvoiceAmountBean invoiceAmountBean = new InvoiceAmountBean();
        invoiceAmountBean = InvoiceAuthEnum.ALL.getCode().equals(request.getAuthTab()) ? this.invoiceDaoExt.countAllAuthAmountByExample(example, authTimeOut) : this.invoiceDaoExt.countAuthAmountByExample(example, authType, authTimeOut, Integer.valueOf(0));
        if (null == invoiceAmountBean) {
            invoiceAmountBean = new InvoiceAmountBean();
        }
        return CommonResponse.ok((String)"\u6210\u529f", (Object)invoiceAmountBean);
    }
}

