/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.invoiceauth.process;

import com.google.common.collect.Lists;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.SendAuthCompanyBean;
import com.xforceplus.vanke.in.client.model.SendAuthInfoBean;
import com.xforceplus.vanke.in.client.model.SendAuthRequest;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.in.service.invoice.InvoiceBusiness;
import com.xforceplus.vanke.in.service.invoice.auth.InvoiceAuthBusiness;
import com.xforceplus.vanke.sc.base.enums.invoice.InvoiceAuthEnum;
import com.xforceplus.vanke.sc.repository.model.WkLegalPersonEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GetAuthInvoiceInfoProcess
extends AbstractProcess<SendAuthRequest, SendAuthInfoBean> {
    @Autowired
    private InvoiceBusiness invoiceBusiness;
    @Autowired
    private InvoiceAuthBusiness invoiceAuthBusiness;

    protected void check(SendAuthRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty((Object)request.getAuthTab(), "\u8ba4\u8bc1\u9875\u9762tab\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty(request.getInvoiceIds(), "\u53d1\u7968id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
    }

    protected CommonResponse<SendAuthInfoBean> process(SendAuthRequest request) throws RuntimeException {
        SendAuthInfoBean sendAuthInfoBean = new SendAuthInfoBean();
        List invoiceList = this.invoiceBusiness.getInvoiceListByParams(request.getInvoiceIds(), null);
        if (CollectionUtils.isEmpty((Collection)invoiceList)) {
            return CommonResponse.failed((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u53d1\u7968\u6570\u636e.");
        }
        Map<String, List<WkInvoiceEntity>> resultMap = invoiceList.stream().collect(Collectors.groupingBy(r -> r.getPurchaserTaxNo()));
        List companyTaxNoList = resultMap.entrySet().stream().map(r -> (String)r.getKey()).collect(Collectors.toList());
        Map periodMap = this.invoiceAuthBusiness.getAuthPeriodMap(companyTaxNoList);
        Map errorInvoiceMap = this.invoiceAuthBusiness.checkElAuth(invoiceList, periodMap, request.getAuthTab());
        int totalAuthNum = 0;
        int totalNoauthNum = 0;
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        ArrayList companyObjList = Lists.newArrayList();
        for (Map.Entry<String, List<WkInvoiceEntity>> item : resultMap.entrySet()) {
            SendAuthCompanyBean companyObj = new SendAuthCompanyBean();
            if (!CollectionUtils.isEmpty((Collection)item.getValue())) {
                List<WkInvoiceEntity> itemList = item.getValue();
                int authNum = 0;
                int noauthNum = 0;
                BigDecimal taxAmount = BigDecimal.ZERO;
                ArrayList authInvoiceList = Lists.newArrayList();
                ArrayList noauthInvoiceList = Lists.newArrayList();
                for (WkInvoiceEntity entity : itemList) {
                    if (errorInvoiceMap.get(entity.getId()) != null) {
                        ++noauthNum;
                        noauthInvoiceList.add(this.invoiceAuthBusiness.setSendAuthInvoiceBean(entity, (String)errorInvoiceMap.get(entity.getId())));
                        continue;
                    }
                    ++authNum;
                    taxAmount = taxAmount.add(entity.getTaxAmount());
                    authInvoiceList.add(this.invoiceAuthBusiness.setSendAuthInvoiceBean(entity, ""));
                }
                companyObj.setCheckInvoiceNum(Integer.valueOf(itemList.size()));
                companyObj.setAuthInvoiceNum(Integer.valueOf(authNum));
                companyObj.setNoauthInvoiceNum(Integer.valueOf(noauthNum));
                companyObj.setAuthTaxAmount(taxAmount);
                companyObj.setAuthInvoiceList((List)authInvoiceList);
                companyObj.setNoauthInvoiceList((List)noauthInvoiceList);
                if (InvoiceAuthEnum.EL_AUTH.getCode().equals(request.getAuthTab())) {
                    if (null != periodMap && null != periodMap.get(item.getKey())) {
                        String tempTaxPeriod = ((WkLegalPersonEntity)periodMap.get(item.getKey())).getPeriodDate();
                        companyObj.setTaxPeriod(tempTaxPeriod);
                    } else {
                        companyObj.setTaxPeriod("");
                    }
                    companyObj.setOnlineStatus(Integer.valueOf(2));
                }
                companyObj.setPurcahserTaxNo(item.getKey());
                if (periodMap.get(item.getKey()) != null) {
                    companyObj.setPurchaserName(((WkLegalPersonEntity)periodMap.get(item.getKey())).getTaxPayer());
                } else {
                    companyObj.setPurchaserName("");
                }
                totalAuthNum += authNum;
                totalNoauthNum += noauthNum;
                totalTaxAmount = totalTaxAmount.add(taxAmount);
                companyObjList.add(companyObj);
            }
            sendAuthInfoBean.setCompanyList((List)companyObjList);
        }
        sendAuthInfoBean.setNoauthInvoiceNum(Integer.valueOf(totalNoauthNum));
        sendAuthInfoBean.setAuthInvoiceNum(Integer.valueOf(totalAuthNum));
        sendAuthInfoBean.setCheckInvoiceNum(Integer.valueOf(invoiceList.size()));
        sendAuthInfoBean.setAuthTaxAmount(totalTaxAmount);
        return CommonResponse.ok((String)"\u6210\u529f", (Object)sendAuthInfoBean);
    }
}

