/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.orders.process;

import com.alibaba.excel.support.ExcelTypeEnum;
import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.help.excel.EasyExcelHelp;
import com.xforceplus.landedestate.basecommon.help.lang.DateHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.phoenix.file.utils.DateUtils;
import com.xforceplus.vanke.in.client.model.GetOrderStatusLifeCycleRequest;
import com.xforceplus.vanke.in.controller.orders.process.GetOrderLifeCycleProcess;
import com.xforceplus.vanke.in.repository.dao.WkOrdersLifecycleDao;
import com.xforceplus.vanke.in.repository.model.WkOrdersLifecycleExample;
import com.xforceplus.vanke.in.repository.param.OrderLifeCycleNewExportParam;
import com.xforceplus.vanke.sc.base.constdata.Constants;
import com.xforceplus.vanke.sc.base.enums.IsOrNo;
import com.xforceplus.vanke.sc.base.enums.Message.MessageTypeEnum;
import com.xforceplus.vanke.sc.base.enums.common.IfAuthFlagEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.InvoiceTypeEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.StatusEnum;
import com.xforceplus.vanke.sc.base.exception.VankeException;
import com.xforceplus.vanke.sc.service.FileBusiness;
import com.xforceplus.vanke.sc.service.MessageBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrdersLifeCycleNewExportProcess
extends AbstractProcess<GetOrderStatusLifeCycleRequest, Boolean> {
    @Autowired
    private WkOrdersLifecycleDao wkOrdersLifecycleDao;
    @Autowired
    private FileBusiness fileBusiness;
    @Autowired
    private MessageBusiness messageBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private GetOrderLifeCycleProcess getOrderLifeCycleProcess;

    protected void check(GetOrderStatusLifeCycleRequest request) throws ValidationException {
        long day;
        super.check((BaseRequest)request);
        boolean isEmpty = false;
        try {
            isEmpty = ValidatorUtil.allFieldEmpty((Object)request);
        }
        catch (Exception e) {
            this.logger.error("\u5224\u65ad\u53c2\u6570\u662f\u5426\u4e3a\u7a7a\u5f02\u5e38!");
        }
        if (isEmpty) {
            throw new VankeException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u90fd\u4e3a\u7a7a!");
        }
        if (ValidatorUtil.isNotEmpty((Collection)request.getCreateTime()) && (day = ((Long)request.getCreateTime().get(1) - (Long)request.getCreateTime().get(0)) / 86400000L) > 365L) {
            throw new VankeException("\u9009\u62e9\u65e5\u671f\u4e0d\u53ef\u5927\u4e8e\u4e00\u5e74\u524d!");
        }
    }

    protected CommonResponse<Boolean> process(GetOrderStatusLifeCycleRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        WkOrdersLifecycleExample wkOrdersExample = this.getOrderLifeCycleProcess.createExample(request);
        List wkOrdersLifecycleEntityList = this.wkOrdersLifecycleDao.selectByExample(wkOrdersExample);
        ArrayList paramList = new ArrayList();
        wkOrdersLifecycleEntityList.stream().forEach(wkOrdersLifecycleEntity -> {
            OrderLifeCycleNewExportParam exportParam = new OrderLifeCycleNewExportParam();
            BeanUtils.copyProperties((Object)wkOrdersLifecycleEntity, (Object)exportParam);
            InvoiceTypeEnum invoiceTypeEnum = InvoiceTypeEnum.fromCode((String)wkOrdersLifecycleEntity.getInvoiceType());
            exportParam.setSalesBillStatus(StatusEnum.fromCode((String)wkOrdersLifecycleEntity.getSalesbillStatus()).getName());
            exportParam.setInvoiceType(invoiceTypeEnum == null ? "" : invoiceTypeEnum.getDesc());
            IfAuthFlagEnum ifAuthFlagEnum = IfAuthFlagEnum.fromCode((Integer)wkOrdersLifecycleEntity.getIfAuthFlag());
            exportParam.setIfAuthFlag(ifAuthFlagEnum == null ? "" : ifAuthFlagEnum.getName());
            exportParam.setSynOrdersTime(wkOrdersLifecycleEntity.getSynOrdersTime().getTime() - Constants.DEFAULT_TIME <= 0L ? "--" : DateHelp.getTimeNormalString((Date)wkOrdersLifecycleEntity.getSynOrdersTime()));
            exportParam.setIsOverdue(IsOrNo.fromCode((Integer)wkOrdersLifecycleEntity.getIsOverdue()).getName());
            exportParam.setSignBeginTime(wkOrdersLifecycleEntity.getSignBeginTime().getTime() - Constants.DEFAULT_TIME <= 0L ? "--" : DateHelp.getTimeNormalString((Date)wkOrdersLifecycleEntity.getSignBeginTime()));
            exportParam.setSignEndTime(wkOrdersLifecycleEntity.getSignEndTime().getTime() - Constants.DEFAULT_TIME <= 0L ? "--" : DateHelp.getTimeNormalString((Date)wkOrdersLifecycleEntity.getSignEndTime()));
            exportParam.setSignActualOperatingTime(ValidatorUtil.isEmpty((String)wkOrdersLifecycleEntity.getSignActualOperatingTime()) ? "-" : wkOrdersLifecycleEntity.getSignActualOperatingTime());
            exportParam.setSignThresholdTime(ValidatorUtil.isEmpty((String)wkOrdersLifecycleEntity.getSignThresholdTime()) ? "-" : wkOrdersLifecycleEntity.getSignThresholdTime());
            exportParam.setSignOverdueTime(ValidatorUtil.isEmpty((String)wkOrdersLifecycleEntity.getSignOverdueTime()) ? "-" : wkOrdersLifecycleEntity.getSignOverdueTime());
            exportParam.setSmBeginTime(wkOrdersLifecycleEntity.getSmBeginTime().getTime() - Constants.DEFAULT_TIME <= 0L ? "--" : DateHelp.getTimeNormalString((Date)wkOrdersLifecycleEntity.getSmBeginTime()));
            exportParam.setSmEndTime(wkOrdersLifecycleEntity.getSmEndTime().getTime() - Constants.DEFAULT_TIME <= 0L ? "--" : DateHelp.getTimeNormalString((Date)wkOrdersLifecycleEntity.getSmEndTime()));
            exportParam.setSmActualOperatingTime(ValidatorUtil.isEmpty((String)wkOrdersLifecycleEntity.getSmActualOperatingTime()) ? "-" : wkOrdersLifecycleEntity.getSmActualOperatingTime());
            exportParam.setSmThresholdTime(ValidatorUtil.isEmpty((String)wkOrdersLifecycleEntity.getSmThresholdTime()) ? "-" : wkOrdersLifecycleEntity.getSmThresholdTime());
            exportParam.setSmOverdueTime(ValidatorUtil.isEmpty((String)wkOrdersLifecycleEntity.getSmOverdueTime()) ? "-" : wkOrdersLifecycleEntity.getSmOverdueTime());
            exportParam.setAuditBeginTime(wkOrdersLifecycleEntity.getAuditBeginTime().getTime() - Constants.DEFAULT_TIME <= 0L ? "--" : DateHelp.getTimeNormalString((Date)wkOrdersLifecycleEntity.getAuditBeginTime()));
            exportParam.setAuditEndTime(wkOrdersLifecycleEntity.getAuditEndTime().getTime() - Constants.DEFAULT_TIME <= 0L ? "--" : DateHelp.getTimeNormalString((Date)wkOrdersLifecycleEntity.getAuditEndTime()));
            exportParam.setAuditActualOperatingTime(ValidatorUtil.isEmpty((String)wkOrdersLifecycleEntity.getAuditActualOperatingTime()) ? "-" : wkOrdersLifecycleEntity.getAuditActualOperatingTime());
            exportParam.setAuditThresholdTime(ValidatorUtil.isEmpty((String)wkOrdersLifecycleEntity.getAuditThresholdTime()) ? "-" : wkOrdersLifecycleEntity.getAuditThresholdTime());
            exportParam.setAuditOverdueTime(ValidatorUtil.isEmpty((String)wkOrdersLifecycleEntity.getAuditOverdueTime()) ? "-" : wkOrdersLifecycleEntity.getAuditOverdueTime());
            exportParam.setAuthBeginTime(wkOrdersLifecycleEntity.getAuthBeginTime().getTime() - Constants.DEFAULT_TIME <= 0L ? "--" : DateHelp.getTimeNormalString((Date)wkOrdersLifecycleEntity.getAuthBeginTime()));
            exportParam.setAuthEndTime(wkOrdersLifecycleEntity.getAuthEndTime().getTime() - Constants.DEFAULT_TIME <= 0L ? "--" : DateHelp.getTimeNormalString((Date)wkOrdersLifecycleEntity.getAuthEndTime()));
            exportParam.setAuthActualOperatingTime(ValidatorUtil.isEmpty((String)wkOrdersLifecycleEntity.getAuthActualOperatingTime()) ? "-" : wkOrdersLifecycleEntity.getAuthActualOperatingTime());
            exportParam.setAuthThresholdTime(ValidatorUtil.isEmpty((String)wkOrdersLifecycleEntity.getAuthThresholdTime()) ? "-" : wkOrdersLifecycleEntity.getAuthThresholdTime());
            exportParam.setAuthOverdueTime(ValidatorUtil.isEmpty((String)wkOrdersLifecycleEntity.getAuthOverdueTime()) ? "-" : wkOrdersLifecycleEntity.getAuthOverdueTime());
            paramList.add(exportParam);
        });
        ByteArrayOutputStream baos = EasyExcelHelp.export(paramList, (String)"\u4e1a\u52a1\u5355\u751f\u547d\u5468\u671f", OrderLifeCycleNewExportParam.class);
        String fileName = String.format("\u4e1a\u52a1\u5355\u751f\u547d\u5468\u671f\u5bfc\u51fa_%s%s", DateUtils.curDateStr((String)"yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2"), ExcelTypeEnum.XLSX.getValue());
        String fileKey = this.fileBusiness.uploadFile(fileName, (InputStream)new ByteArrayInputStream(baos.toByteArray()));
        String messageCount = fileKey == null ? "\u5bfc\u51fa\u5931\u8d25,\u8bf7\u91cd\u8bd5!" : String.format("\u4efb\u52a1\u63d0\u4ea4\u65f6\u95f4\uff1a%s", DateUtils.curDateStr((String)"yyyy.MM.dd HH:mm:ss"));
        this.messageBusiness.insert(Long.valueOf(userSessionInfo.getAccountId()), MessageTypeEnum.BUSINESS_MESSAGE.getCode().intValue(), fileName, messageCount, fileKey, new Date(), Long.valueOf(userSessionInfo.getAccountId()), userSessionInfo.getSysUserName());
        return CommonResponse.ok((String)"\u4e0b\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u53bb\u6d88\u606f\u4e2d\u5fc3\u67e5\u770b");
    }
}

