/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.orders.process;

import com.alibaba.excel.support.ExcelTypeEnum;
import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.help.excel.EasyExcelHelp;
import com.xforceplus.landedestate.basecommon.help.lang.DateHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.phoenix.file.utils.DateUtils;
import com.xforceplus.vanke.in.client.model.GetOrderStatusLifeCycleRequest;
import com.xforceplus.vanke.in.controller.orders.process.GetOrderStatusLifeCycleProcess;
import com.xforceplus.vanke.in.repository.dao.WkOrdersDao;
import com.xforceplus.vanke.in.repository.model.WkOrdersExample;
import com.xforceplus.vanke.in.repository.param.OrderStatusLifeCycleExportParam;
import com.xforceplus.vanke.sc.base.constdata.Constants;
import com.xforceplus.vanke.sc.base.enums.Business.CooperateFlagEnum;
import com.xforceplus.vanke.sc.base.enums.Message.MessageTypeEnum;
import com.xforceplus.vanke.sc.base.enums.common.IfAuthFlagEnum;
import com.xforceplus.vanke.sc.base.enums.company.AuthTypeEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.InvoiceTypeEnum;
import com.xforceplus.vanke.sc.base.exception.VankeException;
import com.xforceplus.vanke.sc.service.FileBusiness;
import com.xforceplus.vanke.sc.service.MessageBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrdersStatusLifeCycleExportProcess
extends AbstractProcess<GetOrderStatusLifeCycleRequest, Boolean> {
    @Autowired
    private WkOrdersDao wkOrdersDao;
    @Autowired
    private FileBusiness fileBusiness;
    @Autowired
    private MessageBusiness messageBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private GetOrderStatusLifeCycleProcess getOrderStatusLifeCycleProcess;

    protected void check(GetOrderStatusLifeCycleRequest request) throws ValidationException {
        long day;
        super.check((BaseRequest)request);
        boolean isEmpty = false;
        try {
            isEmpty = ValidatorUtil.allFieldEmpty((Object)request);
        }
        catch (Exception e) {
            this.logger.error("\u5224\u65ad\u53c2\u6570\u662f\u5426\u4e3a\u7a7a\u5f02\u5e38!");
        }
        if (isEmpty) {
            throw new VankeException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u90fd\u4e3a\u7a7a!");
        }
        if (ValidatorUtil.isNotEmpty((Collection)request.getCreateTime()) && (day = ((Long)request.getCreateTime().get(1) - (Long)request.getCreateTime().get(0)) / 86400000L) > 365L) {
            throw new VankeException("\u9009\u62e9\u65e5\u671f\u4e0d\u53ef\u5927\u4e8e\u4e00\u5e74\u524d!");
        }
    }

    protected CommonResponse<Boolean> process(GetOrderStatusLifeCycleRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        WkOrdersExample wkOrdersExample = this.getOrderStatusLifeCycleProcess.createExample(request);
        List wkOrdersEntityList = this.wkOrdersDao.selectByExample(wkOrdersExample);
        ArrayList paramList = new ArrayList();
        wkOrdersEntityList.stream().forEach(wkOrdersEntity -> {
            OrderStatusLifeCycleExportParam exportParam = new OrderStatusLifeCycleExportParam();
            BeanUtils.copyProperties((Object)wkOrdersEntity, (Object)exportParam);
            String issueTime = DateHelp.getStringTimeDiffAndNegativeStr((long)wkOrdersEntity.getSellerDrawDate().getTime(), (long)wkOrdersEntity.getPostcodeSignTime().getTime());
            String postCodeTime = DateHelp.getStringTimeDiffAndNegativeStr((long)wkOrdersEntity.getPostcodeSignTime().getTime(), (long)wkOrdersEntity.getSignTime().getTime());
            String invoiceSignTime = DateHelp.getStringTimeDiffAndNegativeStr((long)wkOrdersEntity.getSmSyncTime().getTime(), (long)wkOrdersEntity.getAuditUpdateTime().getTime());
            String auditTime = DateHelp.getStringTimeDiffAndNegativeStr((long)wkOrdersEntity.getAuditUpdateTime().getTime(), (long)wkOrdersEntity.getAuthUpdateTime().getTime());
            String smSyncTimeStr = DateHelp.getStringTimeDiffAndNegativeStr((long)wkOrdersEntity.getSmSyncTime().getTime(), (long)wkOrdersEntity.getAuditUpdateTime().getTime());
            InvoiceTypeEnum invoiceTypeEnum = InvoiceTypeEnum.fromCode((String)wkOrdersEntity.getInvoiceType());
            exportParam.setInvoiceType(invoiceTypeEnum == null ? "" : invoiceTypeEnum.getDesc());
            CooperateFlagEnum cooperateFlagEnum = CooperateFlagEnum.fromCode((Integer)wkOrdersEntity.getCooperateFlag());
            String systemOrig = wkOrdersEntity.getSystemOrig();
            systemOrig = systemOrig + (cooperateFlagEnum != null ? cooperateFlagEnum.getName() : "");
            exportParam.setSystemOrig(systemOrig);
            IfAuthFlagEnum ifAuthFlagEnum = IfAuthFlagEnum.fromCode((Integer)wkOrdersEntity.getIfAuthFlag());
            exportParam.setIfAuthFlag(ifAuthFlagEnum == null ? "" : ifAuthFlagEnum.getName());
            AuthTypeEnum authTypeEnum = AuthTypeEnum.fromCode((Integer)wkOrdersEntity.getAuthType());
            exportParam.setSellerDrawDate(wkOrdersEntity.getSellerDrawDate().getTime() - Constants.DEFAULT_TIME <= 0L ? "--" : DateHelp.getTimeNormalString((Date)wkOrdersEntity.getSellerDrawDate()));
            exportParam.setPostcodeSignTime(wkOrdersEntity.getPostcodeSignTime().getTime() - Constants.DEFAULT_TIME <= 0L ? "--" : DateHelp.getTimeNormalString((Date)wkOrdersEntity.getPostcodeSignTime()));
            exportParam.setAuthUpdateTime(wkOrdersEntity.getAuthUpdateTime().getTime() - Constants.DEFAULT_TIME <= 0L ? "--" : DateHelp.getTimeNormalString((Date)wkOrdersEntity.getAuthUpdateTime()));
            exportParam.setSignTime(wkOrdersEntity.getSignTime().getTime() - Constants.DEFAULT_TIME <= 0L ? "--" : DateHelp.getTimeNormalString((Date)wkOrdersEntity.getSignTime()));
            exportParam.setAuditUpdateTime(wkOrdersEntity.getAuditUpdateTime().getTime() - Constants.DEFAULT_TIME <= 0L ? "--" : DateHelp.getTimeNormalString((Date)wkOrdersEntity.getAuditUpdateTime()));
            exportParam.setSmSyncTime(wkOrdersEntity.getSmSyncTime().getTime() - Constants.DEFAULT_TIME <= 0L ? "--" : DateHelp.getTimeNormalString((Date)wkOrdersEntity.getSmSyncTime()));
            exportParam.setAuthType(authTypeEnum == null || AuthTypeEnum.NO_AUTHENTICATION.getCode().equals(wkOrdersEntity.getAuthType()) ? "--" : authTypeEnum.getName());
            exportParam.setIssueTimeStr(ValidatorUtil.isEmpty((String)issueTime) ? "-" : issueTime);
            exportParam.setPostCodeTimeStr(ValidatorUtil.isEmpty((String)postCodeTime) ? "-" : postCodeTime);
            exportParam.setInvoiceSignTimeStr(ValidatorUtil.isEmpty((String)invoiceSignTime) ? "-" : invoiceSignTime);
            exportParam.setAuditTimeStr(ValidatorUtil.isEmpty((String)auditTime) ? "-" : auditTime);
            exportParam.setSmSyncTimeStr(ValidatorUtil.isEmpty((String)smSyncTimeStr) ? "-" : smSyncTimeStr);
            paramList.add(exportParam);
        });
        ByteArrayOutputStream baos = EasyExcelHelp.export(paramList, (String)"\u4e1a\u52a1\u5355\u751f\u547d\u5468\u671f", OrderStatusLifeCycleExportParam.class);
        String fileName = String.format("\u4e1a\u52a1\u5355\u751f\u547d\u5468\u671f\u5bfc\u51fa_%s%s", DateUtils.curDateStr((String)"yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206"), ExcelTypeEnum.XLSX.getValue());
        String fileKey = this.fileBusiness.uploadFile(fileName, (InputStream)new ByteArrayInputStream(baos.toByteArray()));
        String messageCount = fileKey == null ? "\u5bfc\u51fa\u5931\u8d25,\u8bf7\u91cd\u8bd5!" : String.format("\u4efb\u52a1\u63d0\u4ea4\u65f6\u95f4\uff1a%s", DateUtils.curDateStr((String)"yyyy.MM.dd HH:mm:ss"));
        this.messageBusiness.insert(Long.valueOf(userSessionInfo.getAccountId()), MessageTypeEnum.BUSINESS_MESSAGE.getCode().intValue(), fileName, messageCount, fileKey, new Date(), Long.valueOf(userSessionInfo.getAccountId()), userSessionInfo.getSysUserName());
        return CommonResponse.ok((String)"\u4e0b\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u53bb\u6d88\u606f\u4e2d\u5fc3\u67e5\u770b");
    }
}

