/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.orders.process;

import com.alibaba.excel.support.ExcelTypeEnum;
import com.google.common.collect.Lists;
import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.help.excel.EasyExcelHelp;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.phoenix.file.utils.DateUtils;
import com.xforceplus.vanke.in.client.model.GetPostcodeOrdersListRequest;
import com.xforceplus.vanke.in.client.model.WkPostcodeOrdersBean;
import com.xforceplus.vanke.in.controller.postcode.process.GetPostcodeOrdersListProcess;
import com.xforceplus.vanke.in.repository.dao.WkOrdersDao;
import com.xforceplus.vanke.in.repository.model.WkOrdersExample;
import com.xforceplus.vanke.in.repository.model.WkOrdersExcelBean;
import com.xforceplus.vanke.sc.base.enums.LogisticsStatus.LogisticsExpressCodeEnum;
import com.xforceplus.vanke.sc.base.enums.Message.MessageTypeEnum;
import com.xforceplus.vanke.sc.base.enums.PostCode.ErrorTypeEnum;
import com.xforceplus.vanke.sc.base.enums.orders.OrderReceiveStatusEnum;
import com.xforceplus.vanke.sc.base.exception.VankeException;
import com.xforceplus.vanke.sc.service.FileBusiness;
import com.xforceplus.vanke.sc.service.MessageBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PostCodeOrdersExportProcess
extends AbstractProcess<GetPostcodeOrdersListRequest, Boolean> {
    @Autowired
    private WkOrdersDao wkOrdersDao;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private FileBusiness fileBusiness;
    @Autowired
    private MessageBusiness messageBusiness;
    @Autowired
    private GetPostcodeOrdersListProcess getPostcodeOrdersListProcess;

    protected void check(GetPostcodeOrdersListRequest request) throws ValidationException {
        long day;
        super.check((BaseRequest)request);
        boolean isEmpty = false;
        try {
            isEmpty = ValidatorUtil.allFieldEmpty((Object)request);
        }
        catch (Exception e) {
            this.logger.error("\u5224\u65ad\u53c2\u6570\u662f\u5426\u4e3a\u7a7a\u5f02\u5e38!");
        }
        if (isEmpty) {
            throw new VankeException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u90fd\u4e3a\u7a7a!");
        }
        if (ValidatorUtil.isNotEmpty((Collection)request.getRecieveTime()) && (day = ((Long)request.getRecieveTime().get(1) - (Long)request.getRecieveTime().get(0)) / 86400000L) > 365L) {
            throw new VankeException("\u9009\u62e9\u65e5\u671f\u4e0d\u53ef\u5927\u4e8e\u4e00\u5e74\u524d!");
        }
    }

    protected CommonResponse<Boolean> process(GetPostcodeOrdersListRequest request) throws RuntimeException {
        WkOrdersExample wkOrdersExample = this.getPostcodeOrdersListProcess.createExample(request);
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        CompletableFuture.runAsync(() -> {
            try {
                Date date = new Date();
                ArrayList beanList = Lists.newArrayList();
                List wkPostcodeOrdersBeans = this.wkOrdersDao.selectByExample(wkOrdersExample).stream().map(entity -> {
                    WkPostcodeOrdersBean bean = new WkPostcodeOrdersBean();
                    BeanUtils.copyProperties((Object)entity, (Object)bean);
                    return bean;
                }).collect(Collectors.toList());
                this.getPostcodeOrdersListProcess.getPackageCode(wkPostcodeOrdersBeans);
                wkPostcodeOrdersBeans.stream().forEach(wkPostcodeOrdersBean -> {
                    WkOrdersExcelBean wkOrdersExcelBean = new WkOrdersExcelBean();
                    BeanUtils.copyProperties((Object)wkPostcodeOrdersBean, (Object)wkOrdersExcelBean);
                    LogisticsExpressCodeEnum logisticsExpressCodeEnum = LogisticsExpressCodeEnum.fromCode((String)wkPostcodeOrdersBean.getExpressCode());
                    wkOrdersExcelBean.setExpressCode(logisticsExpressCodeEnum == null ? "" : logisticsExpressCodeEnum.getName());
                    OrderReceiveStatusEnum orderReceiveStatusEnum = OrderReceiveStatusEnum.fromCode((Integer)wkPostcodeOrdersBean.getSignStatus());
                    wkOrdersExcelBean.setSignStatus(orderReceiveStatusEnum == null ? "" : orderReceiveStatusEnum.getName());
                    ErrorTypeEnum errorTypeEnum = ErrorTypeEnum.fromCode((String)StringHelp.safeToString((Object)wkPostcodeOrdersBean.getSignFailType()));
                    wkOrdersExcelBean.setSignFailType(errorTypeEnum == null ? "" : errorTypeEnum.getName());
                    beanList.add(wkOrdersExcelBean);
                });
                ByteArrayOutputStream baos = EasyExcelHelp.export((List)beanList, (String)"\u90ae\u5305\u7b7e\u6536-\u4e1a\u52a1\u5355\u5217\u8868", WkOrdersExcelBean.class);
                String fileName = String.format("\u90ae\u5305\u7b7e\u6536-\u4e1a\u52a1\u5355\u6570\u636e\u4e0b\u8f7d_%s%s", DateUtils.curDateStr((String)"yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206"), ExcelTypeEnum.XLSX.getValue());
                String fileKey = this.fileBusiness.uploadFile(fileName, (InputStream)new ByteArrayInputStream(baos.toByteArray()));
                String messageCount = fileKey == null ? "\u5bfc\u51fa\u5931\u8d25,\u8bf7\u91cd\u8bd5!" : String.format("\u4efb\u52a1\u63d0\u4ea4\u65f6\u95f4\uff1a%s", DateUtils.toDateStr((Date)date, (String)"yyyy.MM.dd HH:mm:ss"));
                int i = this.messageBusiness.insert(Long.valueOf(userSessionInfo.getAccountId()), MessageTypeEnum.BUSINESS_MESSAGE.getCode().intValue(), fileName, messageCount, fileKey, new Date(), Long.valueOf(userSessionInfo.getAccountId()), userSessionInfo.getSysUserName());
                if (i > 0) {
                    this.logger.debug("\u6dfb\u52a0\u4e0b\u8f7d\u6d88\u606f\u6210\u529f");
                }
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            }
        });
        return CommonResponse.ok((String)"\u5bfc\u51fa\u6210\u529f,\u8bf7\u5728\u53f3\u4e0a\u89d2\u6d88\u606f\u4e2d\u5fc3\u67e5\u770b!", (Object)true);
    }
}

