/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.parcel.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.GetLogisticsInfoRequest;
import com.xforceplus.vanke.in.client.model.LogisticsInfoBean;
import com.xforceplus.vanke.in.service.parcel.ParcelBusiness;
import com.xforceplus.vanke.sc.outer.api.imsCore.entity.baseinfo.Response;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetLogisticsInfoProcess
extends AbstractProcess<GetLogisticsInfoRequest, LogisticsInfoBean> {
    @Autowired
    private ParcelBusiness parcelBusiness;

    protected void check(GetLogisticsInfoRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty(request.getExpressCode(), "\u7269\u6d41\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty(request.getWaybillNo(), "\u5305\u88f9\u7269\u54c1id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
    }

    protected CommonResponse<LogisticsInfoBean> process(GetLogisticsInfoRequest request) throws RuntimeException {
        String responseStr = this.parcelBusiness.getLogisticsInfo(request.getExpressCode(), request.getWaybillNo());
        Response response = (Response)JSONObject.parseObject((String)responseStr, Response.class);
        if (response == null) {
            return CommonResponse.ok((String)"\u67e5\u8be2\u7269\u6d41\u8f68\u8ff9\u7ed3\u679c\u89e3\u6790\u5931\u8d25.");
        }
        if (!Response.OK.equals(response.getCode())) {
            return CommonResponse.ok((String)response.getMessage());
        }
        LogisticsInfoBean logisticInfo = this.parcelBusiness.transfLogisticInfo(response.getResult().toString());
        if (null == logisticInfo) {
            return CommonResponse.ok((String)"\u6682\u65e0\u7269\u6d41\u4fe1\u606f\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u6216\u68c0\u67e5\u516c\u53f8\u548c\u5355\u53f7\u662f\u5426\u6709\u8bef\u3002");
        }
        return CommonResponse.ok((String)"\u6210\u529f.", (Object)logisticInfo);
    }
}

