/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.parcel.process;

import com.google.common.collect.Lists;
import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.GoodsCountBean;
import com.xforceplus.vanke.in.client.model.SubmitParcelsBean;
import com.xforceplus.vanke.in.client.model.SubmitParcelsItem;
import com.xforceplus.vanke.in.client.model.SubmitParcelsRequest;
import com.xforceplus.vanke.in.client.model.WkParcelDetailsDTO;
import com.xforceplus.vanke.in.repository.model.WkParcelDetailsEntity;
import com.xforceplus.vanke.in.service.parcel.ParcelBusiness;
import com.xforceplus.vanke.in.service.parcel.ParcelDetailsBusiness;
import com.xforceplus.vanke.sc.base.constdata.Constants;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SubmitParcelsProcess
extends AbstractProcess<SubmitParcelsRequest, List<SubmitParcelsBean>> {
    @Autowired
    private ParcelBusiness parcelBusiness;
    @Autowired
    private ParcelDetailsBusiness parcelDetailsBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected void check(SubmitParcelsRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty(request.getItemList(), "\u63d0\u4ea4\u7684\u5305\u88f9\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Transactional(rollbackFor={Exception.class})
    protected CommonResponse<List<SubmitParcelsBean>> process(SubmitParcelsRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        if (null == userSessionInfo) {
            return CommonResponse.failed((String)"\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList waybillNos = Lists.newArrayList();
        ArrayList waybillNosRe = Lists.newArrayList();
        request.getItemList().stream().filter(r -> !StringHelp.safeIsEmpty((Object)r.getWaybillNo())).forEach(r -> {
            if (waybillNos.contains(r.getWaybillNo())) {
                waybillNosRe.add(r.getWaybillNo());
            } else {
                waybillNos.add(r.getWaybillNo());
            }
        });
        if (!CollectionUtils.isEmpty((Collection)waybillNosRe)) {
            return CommonResponse.failed((String)"\u6210\u529f\u8fd0\u5355\u53f7\u586b\u5199\u91cd\u590d\uff01");
        }
        String expressCode = ((SubmitParcelsItem)request.getItemList().get(0)).getExpressCode();
        Long isExist = this.parcelBusiness.checkParcelByWayBillNo((List)waybillNos, expressCode);
        if (isExist > Constants.LONG_ZERO) {
            return CommonResponse.failed((String)"\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u8fd0\u5355\u53f7\uff01");
        }
        ArrayList resultList = Lists.newArrayList();
        request.getItemList().stream().forEach(x -> {
            if (StringHelp.safeIsEmpty((Object)x.getGoodsKey())) {
                return;
            }
            List entityList = this.parcelDetailsBusiness.selectInfoByIds(x.getGoodsKey());
            if (CollectionUtils.isEmpty((Collection)entityList)) {
                return;
            }
            WkParcelDetailsEntity detailsEntity = (WkParcelDetailsEntity)entityList.get(0);
            Long parcelId = this.parcelBusiness.setParcelEntity(x, detailsEntity, userSessionInfo);
            if (null == parcelId) {
                return;
            }
            this.parcelDetailsBusiness.updateInvoiceSendInfo(parcelId, userSessionInfo, x.getGoodsKey());
            SubmitParcelsBean submitParcelsBean = new SubmitParcelsBean();
            submitParcelsBean.setExpressCode(x.getExpressCode());
            submitParcelsBean.setExpressName(x.getExpressName());
            submitParcelsBean.setWaybillNo(x.getWaybillNo());
            GoodsCountBean goodsCountBean = new GoodsCountBean();
            Map<String, Long> collect = entityList.stream().collect(Collectors.groupingBy(l -> l.getInterfaceType().toString() + l.getInvoiceSheet().toString(), Collectors.counting()));
            this.parcelDetailsBusiness.getGoodsCount(collect, goodsCountBean);
            submitParcelsBean.setGoodsCountBean(goodsCountBean);
            List detailsDTOS = entityList.stream().map(entity -> {
                WkParcelDetailsDTO dto = new WkParcelDetailsDTO();
                BeanUtils.copyProperties((Object)entity, (Object)dto);
                return dto;
            }).collect(Collectors.toList());
            submitParcelsBean.setGoodsItemInfo(detailsDTOS);
            resultList.add(submitParcelsBean);
        });
        return CommonResponse.ok((String)"\u6210\u529f", (Object)resultList);
    }
}

