/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.parceldetails.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.ParcelDetailsSendRequest;
import com.xforceplus.vanke.in.service.parcel.ParcelDetailsBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.Collection;
import java.util.List;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class NoNeedSendProcess
extends AbstractProcess<ParcelDetailsSendRequest, Integer> {
    @Autowired
    private ParcelDetailsBusiness parcelDetailsBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected void check(ParcelDetailsSendRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty(request.getIdList(), "\u5bc4\u9001id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
    }

    protected CommonResponse<Integer> process(ParcelDetailsSendRequest request) throws RuntimeException {
        List detailsList = this.parcelDetailsBusiness.selectInfoByIds(request.getIdList());
        if (CollectionUtils.isEmpty((Collection)detailsList)) {
            return CommonResponse.failed((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u53ef\u64cd\u4f5c\u7684\u6570\u636e.");
        }
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        if (null == userSessionInfo) {
            return CommonResponse.failed((String)"\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int row = this.parcelDetailsBusiness.updateNoNeedSend(request.getIdList(), userSessionInfo);
        return CommonResponse.ok((String)"\u6210\u529f", (Object)row);
    }
}

