/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.postcode.process;

import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.process.AbstractKeyProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.WkPostcodeBean;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.dao.WkOrdersDao;
import com.xforceplus.vanke.in.repository.dao.WkPostcodeDao;
import com.xforceplus.vanke.in.repository.daoext.WkOrdersDaoExt;
import com.xforceplus.vanke.in.repository.model.WkInvoiceExample;
import com.xforceplus.vanke.in.repository.model.WkOrdersExample;
import com.xforceplus.vanke.in.repository.model.WkPostcodeEntity;
import com.xforceplus.vanke.in.repository.model.WkPostcodeExample;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetPostcodeDetailProcess
extends AbstractKeyProcess<String, BaseRequest, WkPostcodeBean> {
    @Autowired
    private WkPostcodeDao wkPostcodeDao;
    @Autowired
    private WkOrdersDao wkOrdersDao;
    @Autowired
    private WkOrdersDaoExt wkOrdersDaoExt;
    @Autowired
    private WkInvoiceDao wkInvoiceDao;

    protected CommonResponse<WkPostcodeBean> process(String packageCode, BaseRequest request) throws RuntimeException {
        WkPostcodeExample postcodeExample = new WkPostcodeExample();
        postcodeExample.createCriteria().andPackageCodeEqualTo(packageCode);
        WkPostcodeEntity entity = this.wkPostcodeDao.selectOneByExample(postcodeExample);
        if (entity == null) {
            return CommonResponse.failed((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u90ae\u5305");
        }
        WkPostcodeBean bean = new WkPostcodeBean();
        BeanUtils.copyProperties((Object)entity, (Object)bean);
        BigDecimal sumAmountWithTax = this.wkOrdersDaoExt.sumAmountWithTaxByPackageCode(packageCode);
        bean.setSumAmountWithTax(sumAmountWithTax.toString());
        WkOrdersExample ordersExample = new WkOrdersExample();
        ordersExample.createCriteria().andPackageCodeEqualTo(packageCode);
        long orderCount = this.wkOrdersDao.countByExample(ordersExample);
        bean.setOrderCount(Long.valueOf(orderCount));
        WkInvoiceExample invoiceExample = new WkInvoiceExample();
        invoiceExample.createCriteria().andPackageCodeEqualTo(packageCode);
        long invoiceCount = this.wkInvoiceDao.countByExample(invoiceExample);
        bean.setInvoiceCount(Long.valueOf(invoiceCount));
        return CommonResponse.ok((String)"\u6210\u529f", (Object)bean);
    }
}

