/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.postcode.process;

import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.vanke.in.client.model.SignOrdersRequest;
import com.xforceplus.vanke.in.repository.dao.WkInvoiceDao;
import com.xforceplus.vanke.in.repository.dao.WkOrdersDao;
import com.xforceplus.vanke.in.repository.dao.WkPostcodeDao;
import com.xforceplus.vanke.in.repository.model.WkExceptionEntity;
import com.xforceplus.vanke.in.repository.model.WkInvoiceEntity;
import com.xforceplus.vanke.in.repository.model.WkInvoiceExample;
import com.xforceplus.vanke.in.repository.model.WkOrdersEntity;
import com.xforceplus.vanke.in.repository.model.WkOrdersExample;
import com.xforceplus.vanke.in.repository.model.WkPostcodeEntity;
import com.xforceplus.vanke.in.repository.model.WkPostcodeExample;
import com.xforceplus.vanke.in.service.exception.ExceptionBusiness;
import com.xforceplus.vanke.sc.base.enums.DocumentTypeEnum;
import com.xforceplus.vanke.sc.base.enums.Exception.ExceptionTypeEnum;
import com.xforceplus.vanke.sc.base.enums.IsOrNo;
import com.xforceplus.vanke.sc.base.enums.PostCode.ErrorTypeEnum;
import com.xforceplus.vanke.sc.base.enums.PostCode.ProcessStatusEnum;
import com.xforceplus.vanke.sc.base.enums.invoice.SendExceptionEnum;
import com.xforceplus.vanke.sc.base.enums.orders.OrderReceiveStatusEnum;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SignOrdersProcess
extends AbstractProcess<SignOrdersRequest, Boolean> {
    @Autowired
    private WkPostcodeDao wkPostcodeDao;
    @Autowired
    private WkOrdersDao wkOrdersDao;
    @Autowired
    private WkInvoiceDao wkInvoiceDao;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private ExceptionBusiness exceptionBusiness;

    protected void check(SignOrdersRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        this.checkEmpty((Object)request.getProcessStatus(), "\u662f\u5426\u5408\u683c\u4e0d\u80fd\u4e3a\u7a7a");
        if (ValidatorUtil.isEmpty((Collection)request.getOrderIds())) {
            this.checkEmpty(request.getPackageCode(), "\u5feb\u9012\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            if (!ProcessStatusEnum.UN_QUALIFIED.getCode().equals(request.getProcessStatus())) {
                throw new ValidationException("\u6ca1\u6709\u4e1a\u52a1\u5355\u7684\u7b7e\u6536\u53ea\u80fd\u662f\u4e0d\u5408\u683c\u7b7e\u6536");
            }
        }
        if (ProcessStatusEnum.UN_QUALIFIED.getCode().equals(request.getProcessStatus())) {
            this.checkEmpty(request.getErrorType(), "\u5f02\u5e38\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkEmpty((Object)ErrorTypeEnum.fromCode((String)request.getErrorType()), "\u65e0\u6548\u7684\u5f02\u5e38\u7c7b\u578b");
        }
    }

    protected CommonResponse<Boolean> process(SignOrdersRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        Date postcodeSignTime = null;
        if (ValidatorUtil.isNotEmpty((String)request.getPackageCode())) {
            WkPostcodeExample postcodeExample = new WkPostcodeExample();
            postcodeExample.createCriteria().andPackageCodeEqualTo(request.getPackageCode());
            WkPostcodeEntity postcodeEntity = this.wkPostcodeDao.selectOneByExample(postcodeExample);
            if (postcodeEntity == null) {
                return CommonResponse.failed((String)"\u90ae\u5305\u4e0d\u5b58\u5728");
            }
            postcodeSignTime = postcodeEntity.getRecieveTime();
            postcodeEntity.setIsUnpacking(IsOrNo.YES.getCode());
            this.wkPostcodeDao.updateByPrimaryKeySelective(postcodeEntity);
        }
        if (ValidatorUtil.isEmpty((Collection)request.getOrderIds())) {
            WkExceptionEntity exceptionEntity = new WkExceptionEntity();
            exceptionEntity.setExceptionType(ExceptionTypeEnum.SIGN_EXCEPTION.getCode());
            exceptionEntity.setErrorType(request.getErrorType());
            exceptionEntity.setDocumentType(DocumentTypeEnum.OTHER.getCode());
            exceptionEntity.setPackageCode(request.getPackageCode());
            exceptionEntity.setOrderCode(request.getOrderCode());
            exceptionEntity.setProducter(userSessionInfo.getSysUserName());
            exceptionEntity.setExceptionNote(request.getRemark());
            this.exceptionBusiness.insertByEntity(exceptionEntity);
            return CommonResponse.ok((String)"\u7b7e\u6536\u5b8c\u6210", (Object)true);
        }
        WkOrdersExample ordersExample = new WkOrdersExample();
        ordersExample.createCriteria().andIdIn(request.getOrderIds());
        List orders = this.wkOrdersDao.selectByExample(ordersExample);
        List packageCodes = orders.stream().filter(order -> order.getSignStatus() > 0).map(WkOrdersEntity::getPackageCode).collect(Collectors.toList());
        if (ValidatorUtil.isFalse((Boolean)request.getConfirmCoverage()) && packageCodes.size() > 0) {
            return CommonResponse.from((Integer)9, (String)("\u91cd\u590d\u8fd0\u5355\u53f7\uff1a" + packageCodes));
        }
        List orderNos = orders.stream().map(WkOrdersEntity::getSalesbillNo).collect(Collectors.toList());
        WkInvoiceExample invoiceExample = new WkInvoiceExample();
        invoiceExample.createCriteria().andSalesbillNoIn(orderNos);
        WkOrdersEntity ordersEntity = new WkOrdersEntity();
        if (!StringHelp.safeIsEmpty((Object)request.getPackageCode())) {
            ordersEntity.setPackageCode(request.getPackageCode());
        }
        ordersEntity.setSignPerson(userSessionInfo.getSysUserName());
        ordersEntity.setSignTime(new Date());
        ordersEntity.setSignStatus(OrderReceiveStatusEnum.SUCCESS_RECEIVE.getCode());
        ordersEntity.setSignFailType(Integer.valueOf(0));
        ordersEntity.setSignFailReason("");
        ordersEntity.setPostcodeSignTime(postcodeSignTime);
        WkInvoiceEntity invoiceEntity = new WkInvoiceEntity();
        if (!StringHelp.safeIsEmpty((Object)request.getPackageCode())) {
            invoiceEntity.setPackageCode(request.getPackageCode());
        }
        invoiceEntity.setIfSendException(SendExceptionEnum.CANCEL.getCode());
        invoiceEntity.setSignTime(new Date());
        invoiceEntity.setSignStatus(OrderReceiveStatusEnum.SUCCESS_RECEIVE.getCode());
        if (ProcessStatusEnum.UN_QUALIFIED.getCode().equals(request.getProcessStatus())) {
            ordersEntity.setSignStatus(OrderReceiveStatusEnum.FAIL_RECEIVE.getCode());
            ordersEntity.setSignFailType(Integer.valueOf(Integer.parseInt(request.getErrorType())));
            ordersEntity.setSignFailReason(request.getRemark());
            ordersEntity.setSignTime(new Date());
            invoiceEntity.setSignStatus(OrderReceiveStatusEnum.FAIL_RECEIVE.getCode());
            invoiceEntity.setIfSendException(null);
            orders.forEach(order -> {
                WkExceptionEntity exceptionEntity = new WkExceptionEntity();
                exceptionEntity.setExceptionType(ExceptionTypeEnum.SIGN_EXCEPTION.getCode());
                exceptionEntity.setErrorType(request.getErrorType());
                exceptionEntity.setDocumentType(DocumentTypeEnum.ORDERS.getCode());
                exceptionEntity.setOrderId(order.getId());
                exceptionEntity.setOrderCode(order.getSalesbillNo());
                if (ValidatorUtil.isNotEmpty((String)request.getPackageCode())) {
                    exceptionEntity.setPackageCode(request.getPackageCode());
                }
                exceptionEntity.setProducter(userSessionInfo.getSysUserName());
                exceptionEntity.setDataFromSystem(order.getSystemOrig());
                exceptionEntity.setCooperateFlag(order.getCooperateFlag());
                exceptionEntity.setExceptionNote(request.getRemark());
                this.exceptionBusiness.insertByEntity(exceptionEntity);
            });
        }
        this.wkOrdersDao.updateByExampleSelective(ordersEntity, ordersExample);
        this.wkInvoiceDao.updateByExampleSelective(invoiceEntity, invoiceExample);
        return CommonResponse.ok((String)"\u7b7e\u6536\u5b8c\u6210", (Object)true);
    }
}

