/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.in.controller.smfile.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BatchRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.repository.dao.SmFileInvoiceDao;
import com.xforceplus.vanke.in.repository.model.SmFileInvoiceExample;
import com.xforceplus.vanke.in.service.smfile.SmFileInvoiceBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeleteSmFileProcess
extends AbstractProcess<BatchRequest<Long>, Boolean> {
    @Autowired
    private SmFileInvoiceDao smFileInvoiceDao;
    @Autowired
    private SmFileInvoiceBusiness smFileInvoiceBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    protected CommonResponse<Boolean> process(BatchRequest<Long> request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        if (!this.smFileInvoiceBusiness.tryLockByUserId(Long.valueOf(userSessionInfo.getAccountId()))) {
            return CommonResponse.failed((String)"\u4e1a\u52a1\u7e41\u5fd9\u8bf7\u91cd\u8bd5");
        }
        try {
            SmFileInvoiceExample example = new SmFileInvoiceExample();
            example.createCriteria().andCreateUserIdEqualTo(Long.valueOf(userSessionInfo.getAccountId())).andIdIn(request.getKeys());
            int result = this.smFileInvoiceDao.deleteByExample(example);
            if (result <= 0) {
                CommonResponse commonResponse = CommonResponse.failed((String)"\u65e0\u8bb0\u5f55\u5220\u9664");
                return commonResponse;
            }
            example.clear();
            example.createCriteria().andCreateUserIdEqualTo(Long.valueOf(userSessionInfo.getAccountId()));
            example.setOrderByClause("fileOrder");
            List entities = this.smFileInvoiceDao.selectByExample(example);
            this.smFileInvoiceBusiness.interceptInvoice(entities);
            this.smFileInvoiceBusiness.resetLevel(entities);
        }
        finally {
            this.smFileInvoiceBusiness.releaseLockByUserId(Long.valueOf(userSessionInfo.getAccountId()));
        }
        return CommonResponse.ok((String)"\u5220\u9664\u6210\u529f", (Object)true);
    }
}

